/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.query;

import java.io.IOException;
import oracle.nosql.driver.query.PlanIter;
import oracle.nosql.driver.query.PlanIterState;
import oracle.nosql.driver.query.QueryException;
import oracle.nosql.driver.query.QueryFormatter;
import oracle.nosql.driver.query.RuntimeControlBlock;
import oracle.nosql.driver.util.ByteInputStream;
import oracle.nosql.driver.util.SerializationUtil;
import oracle.nosql.driver.values.FieldValue;
import oracle.nosql.driver.values.MapValue;
import oracle.nosql.driver.values.NullValue;

public class SFWIter
extends PlanIter {
    private final PlanIter theFromIter;
    private final String theFromVarName;
    private final PlanIter[] theColumnIters;
    private final String[] theColumnNames;
    private boolean theIsSelectStar;
    private final int theNumGBColumns;
    private final PlanIter theOffsetIter;
    private final PlanIter theLimitIter;

    SFWIter(ByteInputStream in, short serialVersion) throws IOException {
        super(in, serialVersion);
        this.theColumnNames = SerializationUtil.readStringArray(in);
        this.theNumGBColumns = in.readInt();
        this.theFromVarName = SerializationUtil.readString(in);
        this.theIsSelectStar = in.readBoolean();
        this.theColumnIters = SFWIter.deserializeIters(in, serialVersion);
        this.theFromIter = SFWIter.deserializeIter(in, serialVersion);
        this.theOffsetIter = SFWIter.deserializeIter(in, serialVersion);
        this.theLimitIter = SFWIter.deserializeIter(in, serialVersion);
    }

    @Override
    public PlanIter.PlanIterKind getKind() {
        return PlanIter.PlanIterKind.SFW;
    }

    @Override
    PlanIter getInputIter() {
        return this.theFromIter;
    }

    @Override
    public void open(RuntimeControlBlock rcb) {
        SFWIterState state = new SFWIterState(this);
        rcb.setState(this.theStatePos, state);
        this.theFromIter.open(rcb);
        for (PlanIter columnIter : this.theColumnIters) {
            columnIter.open(rcb);
        }
        this.computeOffsetLimit(rcb);
    }

    @Override
    public boolean next(RuntimeControlBlock rcb) {
        SFWIterState state = (SFWIterState)rcb.getState(this.theStatePos);
        if (state.isDone()) {
            return false;
        }
        if (state.theNumResults >= state.theLimit) {
            state.done();
            return false;
        }
        while (true) {
            boolean more;
            if (!(more = this.computeNextResult(rcb, state))) {
                return false;
            }
            if (state.isDone() && state.theOffset > 0L) {
                return false;
            }
            if (state.theOffset == 0L) break;
            --state.theOffset;
        }
        ++state.theNumResults;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean computeNextResult(RuntimeControlBlock rcb, SFWIterState state) {
        while (true) {
            boolean more;
            if (!(more = this.theFromIter.next(rcb))) {
                if (!rcb.reachedLimit()) {
                    state.done();
                }
                if (this.theNumGBColumns < 0) return false;
                return this.produceLastGroup(rcb, state);
            }
            if (this.theNumGBColumns < 0 && state.theOffset > 0L) {
                return true;
            }
            int numCols = this.theNumGBColumns >= 0 ? this.theNumGBColumns : this.theColumnIters.length;
            int i = 0;
            for (i = 0; i < numCols; ++i) {
                PlanIter columnIter = this.theColumnIters[i];
                more = columnIter.next(rcb);
                if (!more) {
                    if (this.theNumGBColumns > 0) {
                        columnIter.reset(rcb);
                        break;
                    }
                    rcb.setRegVal(columnIter.getResultReg(), NullValue.getInstance());
                } else if (rcb.getTraceLevel() >= 3) {
                    rcb.trace("SFW: Value for SFW column " + i + " = " + rcb.getRegVal(columnIter.getResultReg()));
                }
                columnIter.reset(rcb);
            }
            if (i < numCols) continue;
            if (this.theNumGBColumns < 0) {
                if (this.theIsSelectStar) return true;
                MapValue result = new MapValue();
                rcb.setRegVal(this.theResultReg, result);
                for (i = 0; i < this.theColumnIters.length; ++i) {
                    PlanIter columnIter = this.theColumnIters[i];
                    FieldValue value = rcb.getRegVal(columnIter.getResultReg());
                    result.put(this.theColumnNames[i], value);
                }
                return true;
            }
            if (this.groupInputTuple(rcb, state)) return true;
        }
    }

    boolean groupInputTuple(RuntimeControlBlock rcb, SFWIterState state) {
        int i;
        FieldValue curval;
        FieldValue newval;
        int j;
        int numCols = this.theColumnIters.length;
        if (!state.theHaveGBTuple) {
            int i2;
            for (i2 = 0; i2 < this.theNumGBColumns; ++i2) {
                ((SFWIterState)state).theGBTuple[i2] = rcb.getRegVal(this.theColumnIters[i2].getResultReg());
            }
            for (i2 = this.theNumGBColumns; i2 < numCols; ++i2) {
                this.theColumnIters[i2].next(rcb);
                this.theColumnIters[i2].reset(rcb);
            }
            state.theHaveGBTuple = true;
            if (rcb.getTraceLevel() >= 2) {
                rcb.trace("SFW: Started first group:");
                this.traceCurrentGroup(rcb, state);
            }
            return false;
        }
        for (j = 0; j < this.theNumGBColumns && (newval = rcb.getRegVal(this.theColumnIters[j].getResultReg())).equals(curval = state.theGBTuple[j]); ++j) {
        }
        if (j == this.theNumGBColumns) {
            if (rcb.getTraceLevel() >= 2) {
                rcb.trace("SFW: Input tuple belongs to current group:");
                this.traceCurrentGroup(rcb, state);
            }
            for (int i3 = this.theNumGBColumns; i3 < numCols; ++i3) {
                this.theColumnIters[i3].next(rcb);
                this.theColumnIters[i3].reset(rcb);
            }
            return false;
        }
        for (int i4 = this.theNumGBColumns; i4 < numCols; ++i4) {
            ((SFWIterState)state).theGBTuple[i4] = this.theColumnIters[i4].getAggrValue(rcb, true);
        }
        MapValue result = new MapValue();
        rcb.setRegVal(this.theResultReg, result);
        for (i = 0; i < this.theColumnIters.length; ++i) {
            result.put(this.theColumnNames[i], state.theGBTuple[i]);
        }
        if (rcb.getTraceLevel() >= 2) {
            rcb.trace("SFW: Current group done: " + result);
        }
        for (i = 0; i < this.theNumGBColumns; ++i) {
            PlanIter columnIter = this.theColumnIters[i];
            ((SFWIterState)state).theGBTuple[i] = rcb.getRegVal(columnIter.getResultReg());
        }
        for (i = this.theNumGBColumns; i < numCols; ++i) {
            this.theColumnIters[i].next(rcb);
            this.theColumnIters[i].reset(rcb);
        }
        if (rcb.getTraceLevel() >= 2) {
            rcb.trace("SFW: Started new group:");
            this.traceCurrentGroup(rcb, state);
        }
        return true;
    }

    boolean produceLastGroup(RuntimeControlBlock rcb, SFWIterState state) {
        int i;
        if (rcb.reachedLimit()) {
            return false;
        }
        if (!state.theHaveGBTuple) {
            return false;
        }
        MapValue result = new MapValue();
        rcb.setRegVal(this.theResultReg, result);
        for (i = 0; i < this.theNumGBColumns; ++i) {
            result.put(this.theColumnNames[i], state.theGBTuple[i]);
        }
        for (i = this.theNumGBColumns; i < this.theColumnIters.length; ++i) {
            result.put(this.theColumnNames[i], this.theColumnIters[i].getAggrValue(rcb, true));
        }
        if (rcb.getTraceLevel() >= 2) {
            rcb.trace("SFW: Produced last group : " + result);
        }
        return true;
    }

    @Override
    public void reset(RuntimeControlBlock rcb) {
        this.theFromIter.reset(rcb);
        for (PlanIter columnIter : this.theColumnIters) {
            columnIter.reset(rcb);
        }
        if (this.theOffsetIter != null) {
            this.theOffsetIter.reset(rcb);
        }
        if (this.theLimitIter != null) {
            this.theLimitIter.reset(rcb);
        }
        SFWIterState state = (SFWIterState)rcb.getState(this.theStatePos);
        state.reset(this);
        this.computeOffsetLimit(rcb);
    }

    @Override
    public void close(RuntimeControlBlock rcb) {
        SFWIterState state = (SFWIterState)rcb.getState(this.theStatePos);
        if (state == null) {
            return;
        }
        this.theFromIter.close(rcb);
        for (PlanIter columnIter : this.theColumnIters) {
            columnIter.close(rcb);
        }
        if (this.theOffsetIter != null) {
            this.theOffsetIter.close(rcb);
        }
        if (this.theLimitIter != null) {
            this.theLimitIter.close(rcb);
        }
        state.close();
    }

    private void computeOffsetLimit(RuntimeControlBlock rcb) {
        FieldValue val;
        SFWIterState state = (SFWIterState)rcb.getState(this.theStatePos);
        long offset = 0L;
        long limit = -1L;
        if (this.theOffsetIter != null) {
            this.theOffsetIter.open(rcb);
            this.theOffsetIter.next(rcb);
            val = rcb.getRegVal(this.theOffsetIter.getResultReg());
            offset = val.getLong();
            if (offset < 0L) {
                throw new QueryException("Offset can not be a negative number", this.theOffsetIter.theLocation);
            }
            if (offset > Integer.MAX_VALUE) {
                throw new QueryException("Offset can not be greater than Integer.MAX_VALUE", this.theOffsetIter.theLocation);
            }
        }
        if (this.theLimitIter != null) {
            this.theLimitIter.open(rcb);
            this.theLimitIter.next(rcb);
            val = rcb.getRegVal(this.theLimitIter.getResultReg());
            limit = val.getLong();
            if (limit < 0L) {
                throw new QueryException("Limit can not be a negative number", this.theLimitIter.theLocation);
            }
            if (limit > Integer.MAX_VALUE) {
                throw new QueryException("Limit can not be greater than Integer.MAX_VALUE", this.theOffsetIter.theLocation);
            }
        }
        if (limit < 0L) {
            limit = Long.MAX_VALUE;
        }
        state.theOffset = offset;
        state.theLimit = limit;
    }

    @Override
    protected void displayContent(StringBuilder sb, QueryFormatter formatter) {
        formatter.indent(sb);
        sb.append("FROM:\n");
        this.theFromIter.display(sb, formatter);
        sb.append(" as");
        sb.append(" " + this.theFromVarName);
        sb.append("\n\n");
        if (this.theNumGBColumns >= 0) {
            formatter.indent(sb);
            sb.append("GROUP BY:\n");
            formatter.indent(sb);
            if (this.theNumGBColumns == 0) {
                sb.append("No grouping expressions");
            } else if (this.theNumGBColumns == 1) {
                sb.append("Grouping by the first expression in the SELECT list");
            } else {
                sb.append("Grouping by the first " + this.theNumGBColumns + " expressions in the SELECT list");
            }
            sb.append("\n\n");
        }
        formatter.indent(sb);
        sb.append("SELECT:\n");
        for (int i = 0; i < this.theColumnIters.length; ++i) {
            this.theColumnIters[i].display(sb, formatter);
            if (i >= this.theColumnIters.length - 1) continue;
            sb.append(",\n");
        }
        if (this.theOffsetIter != null) {
            sb.append("\n\n");
            formatter.indent(sb);
            sb.append("OFFSET:\n");
            this.theOffsetIter.display(sb, formatter);
        }
        if (this.theLimitIter != null) {
            sb.append("\n\n");
            formatter.indent(sb);
            sb.append("LIMIT:\n");
            this.theLimitIter.display(sb, formatter);
        }
    }

    void traceCurrentGroup(RuntimeControlBlock rcb, SFWIterState state) {
        int i;
        for (i = 0; i < this.theNumGBColumns; ++i) {
            rcb.trace("SFW: Val " + i + " = " + state.theGBTuple[i]);
        }
        for (i = this.theNumGBColumns; i < this.theColumnIters.length; ++i) {
            rcb.trace("SFW: Val " + i + " = " + this.theColumnIters[i].getAggrValue(rcb, false));
        }
    }

    public static class SFWIterState
    extends PlanIterState {
        private long theOffset;
        private long theLimit;
        private long theNumResults;
        private FieldValue[] theGBTuple;
        private boolean theHaveGBTuple;

        SFWIterState(SFWIter iter) {
            this.theGBTuple = new FieldValue[iter.theColumnIters.length];
        }

        @Override
        public void reset(PlanIter iter) {
            super.reset(iter);
            this.theNumResults = 0L;
            this.theHaveGBTuple = false;
        }
    }
}

