/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.query;

import java.io.IOException;
import java.util.ArrayList;
import oracle.nosql.driver.query.Compare;
import oracle.nosql.driver.query.PlanIter;
import oracle.nosql.driver.query.PlanIterState;
import oracle.nosql.driver.query.QueryException;
import oracle.nosql.driver.query.QueryFormatter;
import oracle.nosql.driver.query.RuntimeControlBlock;
import oracle.nosql.driver.query.SortSpec;
import oracle.nosql.driver.util.ByteInputStream;
import oracle.nosql.driver.util.SerializationUtil;
import oracle.nosql.driver.util.SizeOf;
import oracle.nosql.driver.values.FieldValue;
import oracle.nosql.driver.values.MapValue;

public class SortIter
extends PlanIter {
    private final PlanIter theInput;
    private final String[] theSortFields;
    private final SortSpec[] theSortSpecs;
    private final boolean theCountMemory;

    public SortIter(ByteInputStream in, PlanIter.PlanIterKind kind, short serialVersion) throws IOException {
        super(in, serialVersion);
        this.theInput = SortIter.deserializeIter(in, serialVersion);
        this.theSortFields = SerializationUtil.readStringArray(in);
        this.theSortSpecs = SortIter.readSortSpecs(in);
        this.theCountMemory = kind == PlanIter.PlanIterKind.SORT2 ? in.readBoolean() : true;
    }

    @Override
    public PlanIter.PlanIterKind getKind() {
        return PlanIter.PlanIterKind.SORT;
    }

    @Override
    PlanIter getInputIter() {
        return this.theInput;
    }

    @Override
    public void open(RuntimeControlBlock rcb) {
        SortIterState state = new SortIterState();
        rcb.setState(this.theStatePos, state);
        this.theInput.open(rcb);
    }

    @Override
    public void reset(RuntimeControlBlock rcb) {
        this.theInput.reset(rcb);
        SortIterState state = (SortIterState)rcb.getState(this.theStatePos);
        state.reset(this);
    }

    @Override
    public void close(RuntimeControlBlock rcb) {
        PlanIterState state = rcb.getState(this.theStatePos);
        if (state == null) {
            return;
        }
        this.theInput.close(rcb);
        state.close();
    }

    @Override
    public boolean next(RuntimeControlBlock rcb) {
        SortIterState state = (SortIterState)rcb.getState(this.theStatePos);
        if (state.isDone()) {
            return false;
        }
        if (state.isOpen()) {
            boolean more = this.theInput.next(rcb);
            while (more) {
                MapValue v = (MapValue)rcb.getRegVal(this.theInput.getResultReg());
                for (String field : this.theSortFields) {
                    FieldValue fval = v.get(field);
                    if (fval.isAtomic() || fval.isNull()) continue;
                    throw new QueryException("Sort expression does not return a single atomic value", this.theLocation);
                }
                state.theResults.add(v);
                if (this.theCountMemory) {
                    long sz = v.sizeof() + (long)SizeOf.OBJECT_REF_OVERHEAD;
                    rcb.incMemoryConsumption(sz);
                }
                more = this.theInput.next(rcb);
            }
            if (rcb.reachedLimit()) {
                return false;
            }
            state.theResults.sort((v1, v2) -> Compare.sortResults(rcb, v1, v2, this.theSortFields, this.theSortSpecs));
            state.setState(PlanIterState.StateEnum.RUNNING);
        }
        if (state.theCurrResult < state.theResults.size()) {
            MapValue v = state.theResults.get(state.theCurrResult);
            v.convertEmptyToNull();
            rcb.setRegVal(this.theResultReg, v);
            state.theResults.set(state.theCurrResult, null);
            ++state.theCurrResult;
            return true;
        }
        state.done();
        return false;
    }

    @Override
    protected void displayContent(StringBuilder sb, QueryFormatter formatter) {
        this.theInput.display(sb, formatter);
        formatter.indent(sb);
        sb.append("Sort Fields : ");
        for (int i = 0; i < this.theSortFields.length; ++i) {
            sb.append(this.theSortFields[i]);
            if (i >= this.theSortFields.length - 1) continue;
            sb.append(", ");
        }
        sb.append(",\n");
    }

    private static class SortIterState
    extends PlanIterState {
        final ArrayList<MapValue> theResults = new ArrayList(128);
        int theCurrResult;

        @Override
        public void done() {
            super.done();
            this.theCurrResult = 0;
            this.theResults.clear();
        }

        @Override
        public void reset(PlanIter iter) {
            super.reset(iter);
            this.theCurrResult = 0;
            this.theResults.clear();
        }

        @Override
        public void close() {
            super.close();
            this.theResults.clear();
        }
    }
}

