/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.query;

import java.util.Arrays;

public class TopologyInfo {
    private int theSeqNum = -1;
    private int[] theShardIds;

    public TopologyInfo(int seqNum, int[] shardIds) {
        if (shardIds == null) {
            throw new IllegalArgumentException("TopologyInfo shardIds must not be null");
        }
        this.theSeqNum = seqNum;
        this.theShardIds = shardIds;
    }

    public int getSeqNum() {
        return this.theSeqNum;
    }

    int numShards() {
        return this.theShardIds.length;
    }

    int getShardId(int i) {
        return this.theShardIds[i];
    }

    int getLastShardId() {
        return this.theShardIds[this.theShardIds.length - 1];
    }

    int[] getShardIds() {
        return this.theShardIds;
    }

    public boolean equals(Object o) {
        TopologyInfo other = (TopologyInfo)o;
        return this == other || this.theSeqNum == other.theSeqNum || Arrays.equals(this.theShardIds, other.theShardIds);
    }

    public int hashCode() {
        return this.theSeqNum;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("seqNum = ").append(this.theSeqNum);
        sb.append(" shards ids = [ ");
        for (int sid : this.theShardIds) {
            sb.append(sid).append(" ");
        }
        sb.append("]");
        return sb.toString();
    }
}

