/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.util;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import oracle.nosql.driver.util.ByteOutputStream;

public class NettyByteOutputStream
extends ByteBufOutputStream
implements ByteOutputStream {
    final ByteBuf buffer;
    final boolean releaseBuffer;

    public NettyByteOutputStream(ByteBuf buffer) {
        super(buffer);
        this.buffer = buffer;
        this.releaseBuffer = false;
    }

    public static NettyByteOutputStream createNettyByteOutputStream() {
        return new NettyByteOutputStream(Unpooled.buffer(), true);
    }

    public static NettyByteOutputStream createDirectNettyByteOutputStream() {
        return new NettyByteOutputStream(Unpooled.directBuffer(), true);
    }

    protected NettyByteOutputStream(ByteBuf buffer, boolean release) {
        super(buffer);
        this.buffer = buffer;
        this.releaseBuffer = release;
    }

    @Override
    public void close() {
        if (this.releaseBuffer) {
            this.buffer.release();
        }
        try {
            super.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public ByteBuf getBuffer() {
        return this.buffer;
    }

    @Override
    public int getOffset() {
        return this.buffer.writerIndex();
    }

    @Override
    public boolean isDirect() {
        return this.buffer.isDirect();
    }

    @Override
    public byte[] array() {
        return this.buffer.array();
    }

    @Override
    public void setWriteIndex(int index) {
        this.buffer.writerIndex(index);
    }

    @Override
    public void skip(int numBytes) {
        this.buffer.ensureWritable(numBytes);
        this.buffer.writerIndex(this.buffer.writerIndex() + numBytes);
    }

    @Override
    public void writeIntAtOffset(int offset, int value) throws IOException {
        int currentOffset = this.buffer.writerIndex();
        if (offset > currentOffset) {
            throw new IllegalArgumentException("Invalid offset: " + offset + " must be less than current offset: " + currentOffset);
        }
        this.buffer.writerIndex(offset);
        this.writeInt(value);
        this.buffer.writerIndex(currentOffset);
    }

    @Override
    public void writeBooleanAtOffset(int offset, boolean value) throws IOException {
        int currentOffset = this.buffer.writerIndex();
        if (offset > currentOffset) {
            throw new IllegalArgumentException("Invalid offset: " + offset + " must be less than current offset: " + currentOffset);
        }
        this.buffer.writerIndex(offset);
        this.writeBoolean(value);
        this.buffer.writerIndex(currentOffset);
    }

    @Override
    public void writeArrayAtOffset(int offset, byte[] value) throws IOException {
        int currentOffset = this.buffer.writerIndex();
        if (offset + value.length > currentOffset) {
            throw new IllegalArgumentException("Invalid offset and length: " + (offset + value.length) + " must be less than current offset: " + currentOffset);
        }
        this.buffer.writerIndex(offset);
        this.write(value);
        this.buffer.writerIndex(currentOffset);
    }

    @Override
    public void ensureCapacity(int nbytes) {
        this.buffer.ensureWritable(nbytes);
    }
}

