/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.values;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import oracle.nosql.driver.util.CheckNull;
import oracle.nosql.driver.util.SizeOf;
import oracle.nosql.driver.values.BinaryValue;
import oracle.nosql.driver.values.BooleanValue;
import oracle.nosql.driver.values.DoubleValue;
import oracle.nosql.driver.values.FieldValue;
import oracle.nosql.driver.values.IntegerValue;
import oracle.nosql.driver.values.LongValue;
import oracle.nosql.driver.values.NumberValue;
import oracle.nosql.driver.values.StringValue;

public class ArrayValue
extends FieldValue
implements Iterable<FieldValue> {
    private final ArrayList<FieldValue> array;

    public ArrayValue() {
        this.array = new ArrayList();
    }

    public ArrayValue(int size) {
        this.array = new ArrayList(size);
    }

    @Override
    public FieldValue.Type getType() {
        return FieldValue.Type.ARRAY;
    }

    public ArrayList<FieldValue> getArrayInternal() {
        return this.array;
    }

    public int size() {
        return this.array.size();
    }

    public FieldValue.Type getType(int index) {
        FieldValue val = this.array.get(index);
        return val == null ? null : val.getType();
    }

    public FieldValue get(int index) {
        return this.array.get(index);
    }

    public ArrayValue add(FieldValue value) {
        CheckNull.requireNonNull(value, "ArrayValue.add: value must be non-null");
        this.array.add(value);
        return this;
    }

    public ArrayValue add(int index, FieldValue value) {
        CheckNull.requireNonNull(value, "ArrayValue.add: value must be non-null");
        this.array.add(index, value);
        return this;
    }

    public FieldValue set(int index, FieldValue value) {
        CheckNull.requireNonNull(value, "ArrayValue.set: value must be non-null");
        return this.array.set(index, value);
    }

    public FieldValue remove(int index) {
        return this.array.remove(index);
    }

    public ArrayValue addAll(Stream<? extends FieldValue> stream) {
        CheckNull.requireNonNull(stream, "ArrayValue.addAll: stream must be non-null");
        stream.forEachOrdered(v -> this.array.add((FieldValue)v));
        return this;
    }

    public ArrayValue addAll(final int index, Stream<? extends FieldValue> stream) {
        CheckNull.requireNonNull(stream, "ArrayValue.addAll: stream must be non-null");
        stream.forEachOrdered((Consumer<? extends FieldValue>)new Consumer<FieldValue>(){
            int i = 0;

            @Override
            public void accept(FieldValue v) {
                ArrayValue.this.array.add(index + this.i++, v);
            }
        });
        return this;
    }

    public ArrayValue addAll(Iterator<? extends FieldValue> iter) {
        CheckNull.requireNonNull(iter, "ArrayValue.addAll: iter must be non-null");
        while (iter.hasNext()) {
            this.array.add(iter.next());
        }
        return this;
    }

    public ArrayValue addAll(int index, Iterator<? extends FieldValue> iter) {
        CheckNull.requireNonNull(iter, "ArrayValue.addAll: iter must be non-null");
        int i = 0;
        while (iter.hasNext()) {
            this.array.add(index + i++, iter.next());
        }
        return this;
    }

    public ArrayValue add(int value) {
        return this.add(new IntegerValue(value));
    }

    public ArrayValue add(int index, int value) {
        this.array.add(index, new IntegerValue(value));
        return this;
    }

    public FieldValue set(int index, int value) {
        return this.set(index, new IntegerValue(value));
    }

    public ArrayValue add(long value) {
        return this.add(new LongValue(value));
    }

    public ArrayValue add(int index, long value) {
        this.array.add(index, new LongValue(value));
        return this;
    }

    public FieldValue set(int index, long value) {
        return this.set(index, new LongValue(value));
    }

    public ArrayValue add(double value) {
        return this.add(new DoubleValue(value));
    }

    public ArrayValue add(int index, double value) {
        this.array.add(index, new DoubleValue(value));
        return this;
    }

    public FieldValue set(int index, double value) {
        return this.set(index, new DoubleValue(value));
    }

    public ArrayValue add(BigDecimal value) {
        CheckNull.requireNonNull(value, "ArrayValue.add: value must be non-null");
        return this.add(new NumberValue(value));
    }

    public ArrayValue add(int index, BigDecimal value) {
        CheckNull.requireNonNull(value, "ArrayValue.add: value must be non-null");
        this.array.add(index, new NumberValue(value));
        return this;
    }

    public FieldValue set(int index, BigDecimal value) {
        CheckNull.requireNonNull(value, "ArrayValue.set: value must be non-null");
        return this.set(index, new NumberValue(value));
    }

    public ArrayValue add(boolean value) {
        return this.add(BooleanValue.getInstance(value));
    }

    public ArrayValue add(int index, boolean value) {
        this.array.add(index, BooleanValue.getInstance(value));
        return this;
    }

    public FieldValue set(int index, boolean value) {
        return this.set(index, BooleanValue.getInstance(value));
    }

    public ArrayValue add(String value) {
        CheckNull.requireNonNull(value, "ArrayValue.add: value must be non-null");
        return this.add(new StringValue(value));
    }

    public ArrayValue add(int index, String value) {
        CheckNull.requireNonNull(value, "ArrayValue.add: value must be non-null");
        this.array.add(index, new StringValue(value));
        return this;
    }

    public FieldValue set(int index, String value) {
        CheckNull.requireNonNull(value, "ArrayValue.set: value must be non-null");
        return this.set(index, new StringValue(value));
    }

    public ArrayValue add(byte[] value) {
        return this.add(new BinaryValue(value));
    }

    public ArrayValue add(int index, byte[] value) {
        CheckNull.requireNonNull(value, "ArrayValue.add: value must be non-null");
        this.array.add(index, new BinaryValue(value));
        return this;
    }

    public FieldValue set(int index, byte[] value) {
        CheckNull.requireNonNull(value, "ArrayValue.set: value must be non-null");
        return this.set(index, new BinaryValue(value));
    }

    @Override
    public int compareTo(FieldValue other) {
        CheckNull.requireNonNull(other, "ArrayValue.compareTo: other must be non-null");
        ArrayValue otherImpl = other.asArray();
        int minSize = this.size() <= otherImpl.size() ? this.size() : otherImpl.size();
        for (int i = 0; i < minSize; ++i) {
            FieldValue val = this.get(i);
            int ret = val.compareTo(otherImpl.get(i));
            if (ret == 0) continue;
            return ret;
        }
        if (minSize < otherImpl.size()) {
            return -1;
        }
        if (minSize < this.size()) {
            return 1;
        }
        return 0;
    }

    @Override
    public Iterator<FieldValue> iterator() {
        return this.array.iterator();
    }

    public boolean equals(Object other) {
        if (other instanceof ArrayValue) {
            return this.array.equals(((ArrayValue)other).array);
        }
        return false;
    }

    public int hashCode() {
        return this.array.hashCode();
    }

    @Override
    public long sizeof() {
        long size = SizeOf.OBJECT_OVERHEAD + SizeOf.OBJECT_REF_OVERHEAD + SizeOf.ARRAYLIST_OVERHEAD + SizeOf.objectArraySize(this.array.size());
        for (FieldValue elem : this.array) {
            size += elem.sizeof();
        }
        return size;
    }

    public void sort(Comparator<FieldValue> comparator) {
        CheckNull.requireNonNull(comparator, "Comparator must be non-null");
        this.array.sort(comparator);
    }
}

