/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.values;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Stack;
import oracle.nosql.driver.values.ArrayValue;
import oracle.nosql.driver.values.BinaryValue;
import oracle.nosql.driver.values.BooleanValue;
import oracle.nosql.driver.values.DoubleValue;
import oracle.nosql.driver.values.EmptyValue;
import oracle.nosql.driver.values.FieldValue;
import oracle.nosql.driver.values.FieldValueEventHandler;
import oracle.nosql.driver.values.IntegerValue;
import oracle.nosql.driver.values.JsonNullValue;
import oracle.nosql.driver.values.LongValue;
import oracle.nosql.driver.values.MapValue;
import oracle.nosql.driver.values.NullValue;
import oracle.nosql.driver.values.NumberValue;
import oracle.nosql.driver.values.StringValue;
import oracle.nosql.driver.values.TimestampValue;

public class FieldValueCreator
implements FieldValueEventHandler {
    private Stack<MapValue> mapStack;
    private Stack<ArrayValue> arrayStack;
    private Stack<String> keyStack;
    private MapValue currentMap;
    private ArrayValue currentArray;
    private String currentKey;
    private FieldValue currentValue;

    private void pushMap(MapValue map) {
        if (this.currentMap != null) {
            if (this.mapStack == null) {
                this.mapStack = new Stack();
            }
            this.mapStack.push(this.currentMap);
        }
        this.currentMap = map;
        this.currentValue = map;
    }

    private void pushArray(ArrayValue array) {
        if (this.currentArray != null) {
            if (this.arrayStack == null) {
                this.arrayStack = new Stack();
            }
            this.arrayStack.push(this.currentArray);
        }
        this.currentArray = array;
        this.currentValue = array;
    }

    private void pushKey(String key) {
        if (this.currentKey != null) {
            if (this.keyStack == null) {
                this.keyStack = new Stack();
            }
            this.keyStack.push(this.currentKey);
        }
        this.currentKey = key;
    }

    public FieldValue getCurrentValue() {
        return this.currentValue;
    }

    @Override
    public void startMap(int size) throws IOException {
        this.pushMap(new MapValue(true, size));
    }

    @Override
    public void startArray(int size) throws IOException {
        this.pushArray(new ArrayValue(size));
    }

    @Override
    public void endMap(int size) throws IOException {
        this.currentValue = this.currentMap;
        this.currentMap = this.mapStack != null && !this.mapStack.empty() ? this.mapStack.pop() : null;
    }

    @Override
    public void endArray(int size) throws IOException {
        this.currentValue = this.currentArray;
        this.currentArray = this.arrayStack != null && !this.arrayStack.empty() ? this.arrayStack.pop() : null;
    }

    @Override
    public boolean startMapField(String key) throws IOException {
        this.pushKey(key);
        return false;
    }

    @Override
    public void endMapField(String key) throws IOException {
        if (this.currentKey != null && this.currentMap != null) {
            this.currentMap.put(this.currentKey, this.currentValue);
        }
        this.currentKey = this.keyStack != null && !this.keyStack.empty() ? this.keyStack.pop() : null;
    }

    @Override
    public void endArrayField(int index) throws IOException {
        if (this.currentArray != null) {
            this.currentArray.add(this.currentValue);
        }
    }

    @Override
    public void booleanValue(boolean value) throws IOException {
        this.currentValue = BooleanValue.getInstance(value);
    }

    @Override
    public void binaryValue(byte[] byteArray) throws IOException {
        this.currentValue = new BinaryValue(byteArray);
    }

    @Override
    public void binaryValue(byte[] byteArray, int offset, int length) throws IOException {
        this.currentValue = new BinaryValue(byteArray);
    }

    @Override
    public void stringValue(String value) throws IOException {
        this.currentValue = new StringValue(value);
    }

    @Override
    public void integerValue(int value) throws IOException {
        this.currentValue = new IntegerValue(value);
    }

    @Override
    public void longValue(long value) throws IOException {
        this.currentValue = new LongValue(value);
    }

    @Override
    public void doubleValue(double value) throws IOException {
        this.currentValue = new DoubleValue(value);
    }

    @Override
    public void numberValue(BigDecimal value) throws IOException {
        this.currentValue = new NumberValue(value);
    }

    @Override
    public void timestampValue(TimestampValue timestamp) {
        this.currentValue = timestamp;
    }

    @Override
    public void jsonNullValue() throws IOException {
        this.currentValue = JsonNullValue.getInstance();
    }

    @Override
    public void nullValue() throws IOException {
        this.currentValue = NullValue.getInstance();
    }

    @Override
    public void emptyValue() throws IOException {
        this.currentValue = EmptyValue.getInstance();
    }
}

