/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.values;

import com.fasterxml.jackson.core.io.CharTypes;
import oracle.nosql.driver.values.JsonOptions;
import oracle.nosql.driver.values.JsonSerializer;

public class JsonPrettySerializer
extends JsonSerializer {
    protected static final int DEFAULT_INCR = 2;
    protected static String CR = "\n";
    protected static String SP = " ";
    protected final int incr;
    protected int currentIndent = 0;
    protected String indent;

    public JsonPrettySerializer(JsonOptions options) {
        super(options);
        this.KEY_SEP = " : ";
        this.incr = 2;
    }

    public JsonPrettySerializer(int indentation, JsonOptions options) {
        super(options);
        if (indentation <= 0) {
            throw new IllegalArgumentException("Indentation must be greater than 0");
        }
        this.incr = indentation;
        this.KEY_SEP = " : ";
    }

    private void changeIndent(int num) {
        this.currentIndent += num;
        StringBuilder isb = new StringBuilder();
        for (int i = 0; i < this.currentIndent; ++i) {
            isb.append(" ");
        }
        this.indent = isb.toString();
    }

    @Override
    public void startMap(int size) {
        this.sb.append("{");
        this.changeIndent(this.incr);
    }

    @Override
    public void endMap(int size) {
        int len = this.sb.length() - 1;
        if (len > 0 && this.sb.charAt(len) == ',') {
            this.sb.setLength(len);
        }
        this.changeIndent(-this.incr);
        this.sb.append(CR).append(this.indent).append("}");
    }

    @Override
    public void endArray(int size) {
        int len = this.sb.length() - 2;
        if (len > 0 && this.sb.charAt(len) == ',') {
            this.sb.setLength(len);
        }
        this.sb.append("]");
    }

    @Override
    public boolean startMapField(String key) {
        this.sb.append(CR).append(this.indent).append("\"");
        CharTypes.appendQuoted((StringBuilder)this.sb, (String)key);
        this.sb.append("\"").append(this.KEY_SEP);
        return false;
    }

    @Override
    public void endArrayField(int index) {
        this.sb.append(",");
        this.sb.append(SP);
    }
}

