/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.values;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import oracle.nosql.driver.JsonParseException;
import oracle.nosql.driver.Nson;
import oracle.nosql.driver.util.ByteInputStream;
import oracle.nosql.driver.util.ByteOutputStream;
import oracle.nosql.driver.util.CheckNull;
import oracle.nosql.driver.values.ArrayValue;
import oracle.nosql.driver.values.BooleanValue;
import oracle.nosql.driver.values.DoubleValue;
import oracle.nosql.driver.values.FieldValue;
import oracle.nosql.driver.values.FieldValueEventHandler;
import oracle.nosql.driver.values.IntegerValue;
import oracle.nosql.driver.values.JsonNullValue;
import oracle.nosql.driver.values.JsonOptions;
import oracle.nosql.driver.values.JsonPrettySerializer;
import oracle.nosql.driver.values.JsonSerializer;
import oracle.nosql.driver.values.LongValue;
import oracle.nosql.driver.values.MapValue;
import oracle.nosql.driver.values.NumberValue;
import oracle.nosql.driver.values.StringValue;

public class JsonUtils {
    protected static final JsonFactory factory = new JsonFactory();
    private static final String HEX = "0123456789ABCDEF";

    public static boolean jsonEquals(String s1, String s2) {
        return JsonUtils.jsonEquals(s1, s2, null);
    }

    public static boolean jsonEquals(String s1, String s2, JsonOptions options) {
        FieldValue v1 = JsonUtils.createValueFromJson(s1, options);
        FieldValue v2 = JsonUtils.createValueFromJson(s2, options);
        return v1.equals(v2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static FieldValue createValueFromJson(String jsonInput, JsonOptions options) {
        CheckNull.requireNonNull(jsonInput, "createValueFromJson: jsonInput must be non-null");
        try (JsonParser jp = JsonUtils.createParserWithOptions(jsonInput, options);){
            FieldValue fieldValue = JsonUtils.createValueFromJson(jp, true, options);
            return fieldValue;
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("JSON parse failed: " + ioe);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static FieldValue createValueFromJson(InputStream jsonInput, JsonOptions options) {
        CheckNull.requireNonNull(jsonInput, "createValueFromJson: jsonInput must be non-null");
        try (JsonParser jp = JsonUtils.createParserWithOptions(jsonInput, options);){
            FieldValue fieldValue = JsonUtils.createValueFromJson(jp, true, options);
            return fieldValue;
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("JSON parse failed: " + ioe);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static FieldValue createValueFromJson(Reader jsonInput, JsonOptions options) {
        CheckNull.requireNonNull(jsonInput, "createValueFromJson: jsonInput must be non-null");
        try (JsonParser jp = JsonUtils.createParserWithOptions(jsonInput, options);){
            FieldValue fieldValue = JsonUtils.createValueFromJson(jp, true, options);
            return fieldValue;
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("JSON parse failed: " + ioe);
        }
    }

    static JsonParser createParserWithOptions(File file, JsonOptions options) {
        JsonParser jp = null;
        try {
            jp = factory.createParser(file);
            JsonUtils.addOptions(jp, options);
            return jp;
        }
        catch (IOException ioe) {
            throw JsonUtils.createParseException("Error parsing JSON: " + ioe.getMessage(), jp);
        }
    }

    static JsonParser createParserWithOptions(String jsonInput, JsonOptions options) {
        JsonParser jp = null;
        try {
            jp = factory.createParser(jsonInput);
            JsonUtils.addOptions(jp, options);
            return jp;
        }
        catch (IOException ioe) {
            throw JsonUtils.createParseException("Error parsing JSON: " + ioe.getMessage(), jp);
        }
    }

    static JsonParser createParserWithOptions(Reader jsonInput, JsonOptions options) {
        JsonParser jp = null;
        try {
            jp = factory.createParser(jsonInput);
            JsonUtils.addOptions(jp, options);
            return jp;
        }
        catch (IOException ioe) {
            throw JsonUtils.createParseException("Error parsing JSON: " + ioe.getMessage(), jp);
        }
    }

    static JsonParser createParserWithOptions(InputStream jsonInput, JsonOptions options) {
        JsonParser jp = null;
        try {
            jp = factory.createParser(jsonInput);
            JsonUtils.addOptions(jp, options);
            return jp;
        }
        catch (IOException ioe) {
            throw JsonUtils.createParseException("Error parsing JSON: " + ioe.getMessage(), jp);
        }
    }

    private static void addOptions(JsonParser jp, JsonOptions options) {
        if (options != null) {
            if (options.getAllowComments()) {
                jp.enable(JsonParser.Feature.ALLOW_COMMENTS);
            }
            if (options.getAllowNonNumericNumbers()) {
                jp.enable(JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS);
            }
            if (options.getAllowSingleQuotes()) {
                jp.enable(JsonParser.Feature.ALLOW_SINGLE_QUOTES);
            }
        }
    }

    static FieldValue createValueFromJson(JsonParser jp, boolean getNext, JsonOptions options) {
        try {
            JsonToken token;
            JsonToken jsonToken = token = getNext ? jp.nextToken() : jp.getCurrentToken();
            if (token == null) {
                throw JsonUtils.createParseException("Empty JSON", jp);
            }
            switch (token) {
                case VALUE_STRING: {
                    return new StringValue(jp.getText());
                }
                case VALUE_NUMBER_INT: 
                case VALUE_NUMBER_FLOAT: {
                    if (options != null && options.getNumericAsNumber()) {
                        return new NumberValue(JsonUtils.jsonParserGetDecimalValue(jp));
                    }
                    JsonParser.NumberType numberType = jp.getNumberType();
                    switch (numberType) {
                        case BIG_INTEGER: 
                        case BIG_DECIMAL: {
                            BigDecimal bd = JsonUtils.jsonParserGetDecimalValue(jp);
                            return new NumberValue(bd);
                        }
                        case INT: {
                            return new IntegerValue(jp.getIntValue());
                        }
                        case LONG: {
                            return new LongValue(jp.getLongValue());
                        }
                        case FLOAT: 
                        case DOUBLE: {
                            double dbl = jp.getDoubleValue();
                            if (Double.isInfinite(dbl) || dbl == 0.0) {
                                try {
                                    BigDecimal bd = JsonUtils.jsonParserGetDecimalValue(jp);
                                    if (bd.compareTo(BigDecimal.ZERO) != 0) {
                                        return new NumberValue(bd);
                                    }
                                }
                                catch (JsonParseException jsonParseException) {
                                    // empty catch block
                                }
                            }
                            return new DoubleValue(dbl);
                        }
                    }
                    throw JsonUtils.createParseException("Unexpected numeric type: " + numberType, jp);
                }
                case VALUE_TRUE: {
                    return BooleanValue.trueInstance();
                }
                case VALUE_FALSE: {
                    return BooleanValue.falseInstance();
                }
                case VALUE_NULL: {
                    return JsonNullValue.getInstance();
                }
                case START_OBJECT: {
                    return JsonUtils.parseObject(jp, options);
                }
                case START_ARRAY: {
                    return JsonUtils.parseArray(jp, options);
                }
            }
            throw JsonUtils.createParseException("Unexpected token while parsing JSON: " + token, jp);
        }
        catch (IOException ioe) {
            throw JsonUtils.createParseException("Failed to parse JSON input: " + ioe.getMessage(), jp);
        }
    }

    private static FieldValue parseObject(JsonParser jp, JsonOptions options) throws IOException {
        JsonToken token;
        MapValue map = null;
        map = options != null ? new MapValue(options.getMaintainInsertionOrder(), 16) : new MapValue();
        while ((token = jp.nextToken()) != JsonToken.END_OBJECT) {
            String fieldName = jp.getCurrentName();
            if (token == null || fieldName == null) {
                throw JsonUtils.createParseException("null token or field name parsing JSON object", jp);
            }
            FieldValue field = JsonUtils.createValueFromJson(jp, true, options);
            map.put(fieldName, field);
        }
        return map;
    }

    private static FieldValue parseArray(JsonParser jp, JsonOptions options) throws IOException {
        JsonToken token;
        ArrayValue array = new ArrayValue();
        while ((token = jp.nextToken()) != JsonToken.END_ARRAY) {
            if (token == null) {
                throw JsonUtils.createParseException("null token while parsing JSON array", jp);
            }
            array.add(JsonUtils.createValueFromJson(jp, false, options));
        }
        return array;
    }

    public static BigDecimal jsonParserGetDecimalValue(JsonParser parser) throws IOException {
        assert (parser != null) : "The JsonParser should not be null";
        try {
            return parser.getDecimalValue();
        }
        catch (NumberFormatException nfe) {
            throw JsonUtils.createParseException("Malformed numeric value: '" + parser.getText() + ": " + nfe.getMessage(), parser);
        }
    }

    private static JsonParseException createParseException(String msg, JsonParser jp) {
        return new JsonParseException(msg, jp == null ? null : jp.getCurrentLocation());
    }

    public static String fromNson(ByteInputStream bis, boolean pretty) {
        return JsonUtils.fromNson(bis, pretty ? JsonOptions.PRETTY : null);
    }

    public static String fromNson(ByteInputStream bis, JsonOptions options) {
        JsonSerializer handler = options != null && options.getPrettyPrint() ? new JsonPrettySerializer(options) : new JsonSerializer(options);
        try {
            Nson.generateEventsFromNson(handler, bis, false);
            return ((Object)handler).toString();
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Failed to deserialize NSON into JSON: " + ioe.getMessage());
        }
    }

    public static void createNsonFromJson(ByteOutputStream bos, String jsonInput, JsonOptions options) {
        CheckNull.requireNonNull(jsonInput, "createNsonFromJson: jsonInput must be non-null");
        CheckNull.requireNonNull(bos, "createNsonFromJson: stream must be non-null");
        try (JsonParser jp = JsonUtils.createParserWithOptions(jsonInput, options);){
            JsonUtils.createNsonFromJson(bos, jp, true, options);
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("JSON parse failed: " + ioe);
        }
    }

    public static void createNsonFromJson(ByteOutputStream bos, InputStream jsonInput, JsonOptions options) {
        CheckNull.requireNonNull(jsonInput, "createNsonFromJson: jsonInput must be non-null");
        CheckNull.requireNonNull(bos, "createNsonFromJson: stream must be non-null");
        try (JsonParser jp = JsonUtils.createParserWithOptions(jsonInput, options);){
            JsonUtils.createNsonFromJson(bos, jp, true, options);
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("JSON parse failed: " + ioe);
        }
    }

    public static void createNsonFromJson(ByteOutputStream bos, Reader jsonInput, JsonOptions options) {
        CheckNull.requireNonNull(jsonInput, "createNsonFromJson: jsonInput must be non-null");
        CheckNull.requireNonNull(bos, "createNsonFromJson: stream must be non-null");
        try (JsonParser jp = JsonUtils.createParserWithOptions(jsonInput, options);){
            JsonUtils.createNsonFromJson(bos, jp, true, options);
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("JSON parse failed: " + ioe);
        }
    }

    public static void createNsonFromJson(ByteOutputStream bos, JsonParser jp, boolean getNext, JsonOptions options) {
        CheckNull.requireNonNull(bos, "createNsonFromJson: stream must be non-null");
        CheckNull.requireNonNull(jp, "createNsonFromJson: parser must be non-null");
        Nson.NsonSerializer handler = new Nson.NsonSerializer(bos);
        JsonUtils.generateEventsFromJson(handler, jp, getNext, options);
    }

    public static void generateEventsFromJson(FieldValueEventHandler handler, JsonParser jp, boolean getNext, JsonOptions options) {
        CheckNull.requireNonNull(handler, "generateEventsFromJson: handler must be non-null");
        CheckNull.requireNonNull(jp, "generateEventsFromJson: parser must be non-null");
        try {
            JsonToken token;
            JsonToken jsonToken = token = getNext ? jp.nextToken() : jp.getCurrentToken();
            if (token == null) {
                throw JsonUtils.createParseException("Empty JSON", jp);
            }
            block2 : switch (token) {
                case VALUE_STRING: {
                    handler.stringValue(jp.getText());
                    break;
                }
                case VALUE_NUMBER_INT: 
                case VALUE_NUMBER_FLOAT: {
                    if (options != null && options.getNumericAsNumber()) {
                        handler.numberValue(JsonUtils.jsonParserGetDecimalValue(jp));
                        break;
                    }
                    JsonParser.NumberType numberType = jp.getNumberType();
                    switch (numberType) {
                        case BIG_INTEGER: 
                        case BIG_DECIMAL: {
                            BigDecimal bd = JsonUtils.jsonParserGetDecimalValue(jp);
                            handler.numberValue(bd);
                            break block2;
                        }
                        case INT: {
                            handler.integerValue(jp.getIntValue());
                            break block2;
                        }
                        case LONG: {
                            handler.longValue(jp.getLongValue());
                            break block2;
                        }
                        case FLOAT: 
                        case DOUBLE: {
                            double dbl = jp.getDoubleValue();
                            if (Double.isInfinite(dbl) || dbl == 0.0) {
                                try {
                                    BigDecimal bd = JsonUtils.jsonParserGetDecimalValue(jp);
                                    if (bd.compareTo(BigDecimal.ZERO) != 0) {
                                        handler.numberValue(bd);
                                        break block2;
                                    }
                                }
                                catch (JsonParseException jsonParseException) {
                                    // empty catch block
                                }
                            }
                            handler.doubleValue(dbl);
                            break block2;
                        }
                    }
                    throw JsonUtils.createParseException("Unexpected numeric type: " + numberType, jp);
                }
                case VALUE_TRUE: {
                    handler.booleanValue(true);
                    break;
                }
                case VALUE_FALSE: {
                    handler.booleanValue(false);
                    break;
                }
                case VALUE_NULL: {
                    handler.jsonNullValue();
                    break;
                }
                case START_OBJECT: {
                    JsonUtils.parseObject(handler, jp, options);
                    break;
                }
                case START_ARRAY: {
                    JsonUtils.parseArray(handler, jp, options);
                    break;
                }
                default: {
                    throw JsonUtils.createParseException("Unexpected token while parsing JSON: " + token, jp);
                }
            }
        }
        catch (IOException ioe) {
            throw JsonUtils.createParseException("Failed to parse JSON input: " + ioe.getMessage(), jp);
        }
    }

    private static void parseObject(FieldValueEventHandler handler, JsonParser jp, JsonOptions options) throws IOException {
        JsonToken token;
        int mapSize = 0;
        handler.startMap(mapSize);
        while ((token = jp.nextToken()) != JsonToken.END_OBJECT) {
            String fieldName = jp.getCurrentName();
            if (token == null || fieldName == null) {
                throw JsonUtils.createParseException("null token or field name parsing JSON object", jp);
            }
            handler.startMapField(fieldName);
            JsonUtils.generateEventsFromJson(handler, jp, true, options);
            handler.endMapField(fieldName);
            ++mapSize;
        }
        handler.endMap(mapSize);
    }

    private static void parseArray(FieldValueEventHandler handler, JsonParser jp, JsonOptions options) throws IOException {
        JsonToken token;
        int arraySize = 0;
        handler.startArray(arraySize);
        while ((token = jp.nextToken()) != JsonToken.END_ARRAY) {
            if (token == null) {
                throw JsonUtils.createParseException("null token while parsing JSON array", jp);
            }
            JsonUtils.generateEventsFromJson(handler, jp, false, options);
            handler.endArrayField(arraySize);
            ++arraySize;
        }
        handler.endArray(arraySize);
    }

    public static byte[] convertHexToBytes(String hexString) {
        if (hexString.length() % 2 != 0) {
            throw new IllegalArgumentException("Invalid hex string length");
        }
        byte[] result = new byte[hexString.length() / 2];
        int n = hexString.length();
        for (int i = 0; i < n; i += 2) {
            int hb = HEX.indexOf(hexString.charAt(i));
            int lb = HEX.indexOf(hexString.charAt(i + 1));
            result[i / 2] = (byte)(hb << 4 | lb);
        }
        return result;
    }

    public static String convertBytesToHex(byte[] byteArray) {
        char[] hexValue = new char[byteArray.length * 2];
        char[] hexSymbols = HEX.toCharArray();
        for (int i = 0; i < byteArray.length; ++i) {
            int current = byteArray[i] & 0xFF;
            hexValue[i * 2 + 1] = hexSymbols[current & 0xF];
            hexValue[i * 2] = hexSymbols[current >> 4];
        }
        return new String(hexValue);
    }
}

