/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.values;

import java.io.IOException;
import oracle.nosql.driver.Nson;
import oracle.nosql.driver.util.ByteInputStream;

public class MapWalker {
    private static final int MAX_NUM_ELEMENTS = 1000000000;
    private final ByteInputStream bis;
    private final int numElements;
    private String currentName;
    private int currentIndex = 0;

    public MapWalker(ByteInputStream bis) throws IOException {
        this.bis = bis;
        byte t = bis.readByte();
        if (t != 6) {
            throw new IllegalArgumentException("MapWalker: Stream must point to a MAP, it points to " + Nson.typeString(t));
        }
        bis.readInt();
        this.numElements = bis.readInt();
        if (this.numElements < 0 || this.numElements > 1000000000) {
            throw new IllegalArgumentException("Invalid number of map elements: " + this.numElements);
        }
    }

    public String getCurrentName() {
        return this.currentName;
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public int getStreamOffset() {
        return this.bis.getOffset();
    }

    public void reset(int index, int streamOffset) {
        this.currentIndex = index;
        this.bis.setOffset(streamOffset);
    }

    public int getNumElements() {
        return this.numElements;
    }

    public ByteInputStream getStream() {
        return this.bis;
    }

    public boolean hasNext() {
        return this.currentIndex < this.numElements;
    }

    public void next() throws IOException {
        if (this.currentIndex >= this.numElements) {
            throw new IllegalArgumentException("Cannot call next with no elements remaining");
        }
        this.currentName = Nson.readString(this.bis);
        ++this.currentIndex;
    }

    public void skip() throws IOException {
        Nson.generateEventsFromNson(null, this.bis, true);
    }

    public boolean find(String fieldName, boolean caseSensitive) throws IOException {
        while (this.hasNext()) {
            boolean found;
            this.next();
            boolean bl = found = caseSensitive ? fieldName.equals(this.currentName) : fieldName.equalsIgnoreCase(this.currentName);
            if (found) {
                return true;
            }
            this.skip();
        }
        return false;
    }
}

