/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.values;

import java.math.BigDecimal;
import oracle.nosql.driver.util.CheckNull;
import oracle.nosql.driver.util.SizeOf;
import oracle.nosql.driver.values.FieldValue;
import oracle.nosql.driver.values.JsonOptions;

public class NumberValue
extends FieldValue {
    private BigDecimal value;

    public NumberValue(BigDecimal value) {
        CheckNull.requireNonNull(value, "NumberValue: value must be non-null");
        this.value = value;
    }

    public NumberValue(String value) {
        this.value = new BigDecimal(value);
    }

    @Override
    public FieldValue.Type getType() {
        return FieldValue.Type.NUMBER;
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public void setValue(BigDecimal v) {
        this.value = v;
    }

    @Override
    public double castAsDouble() {
        return this.value.doubleValue();
    }

    @Override
    public int compareTo(FieldValue other) {
        CheckNull.requireNonNull(other, "NumberValue.compareTo: other must be non-null");
        if (other instanceof NumberValue) {
            return this.value.compareTo(((NumberValue)other).value);
        }
        BigDecimal otherVal = null;
        switch (other.getType()) {
            case INTEGER: {
                otherVal = BigDecimal.valueOf(other.getInt());
                break;
            }
            case LONG: {
                otherVal = BigDecimal.valueOf(other.getLong());
                break;
            }
            case DOUBLE: {
                otherVal = BigDecimal.valueOf(other.getDouble());
                break;
            }
            default: {
                throw new ClassCastException("Object is not a numeric type");
            }
        }
        return this.value.compareTo(otherVal);
    }

    @Override
    public String getString() {
        return this.toJson(null);
    }

    @Override
    public String toJson(JsonOptions options) {
        return this.value.toString();
    }

    public boolean equals(Object other) {
        if (other instanceof NumberValue) {
            return this.value.equals(((NumberValue)other).value);
        }
        return false;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public long sizeof() {
        return SizeOf.OBJECT_OVERHEAD + SizeOf.OBJECT_REF_OVERHEAD + this.value.toString().length();
    }
}

