/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class DriverMain {
    private static String libraryVersion = DriverMain.findVersion();
    private static String buildId = DriverMain.findBuildId();

    public static void main(String[] args) throws Exception {
        if (args.length == 0 || args[0].equalsIgnoreCase("-version")) {
            System.out.println(libraryVersion);
            return;
        }
        if (args[0].equalsIgnoreCase("-build")) {
            System.out.println(buildId);
            return;
        }
        DriverMain.usage();
    }

    public static String getLibraryVersion() {
        return libraryVersion;
    }

    private static void usage() {
        StringBuilder builder = new StringBuilder();
        builder.append("java -jar <path-to-driver-jar> [-version|-build]");
        System.err.println(builder);
        DriverMain.usageExit();
    }

    private static void usageExit() {
        System.exit(2);
    }

    private static String findVersion() {
        return "5.4.17";
    }

    private static String findBuildId() {
        Attributes attrs = DriverMain.findAttributes();
        if (attrs != null) {
            return attrs.getValue("Build-Id");
        }
        return null;
    }

    private static Attributes findAttributes() {
        try {
            Enumeration<URL> resources = DriverMain.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (resources.hasMoreElements()) {
                Manifest manifest = new Manifest(resources.nextElement().openStream());
                Attributes attrs = manifest.getMainAttributes();
                String title = attrs.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
                if (title == null || !title.toLowerCase().contains("sdk for java")) continue;
                return attrs;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }
}

