/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver;

public class Durability {
    public static final Durability COMMIT_SYNC = new Durability(SyncPolicy.SYNC, SyncPolicy.NO_SYNC, ReplicaAckPolicy.SIMPLE_MAJORITY);
    public static final Durability COMMIT_NO_SYNC = new Durability(SyncPolicy.NO_SYNC, SyncPolicy.NO_SYNC, ReplicaAckPolicy.SIMPLE_MAJORITY);
    public static final Durability COMMIT_WRITE_NO_SYNC = new Durability(SyncPolicy.WRITE_NO_SYNC, SyncPolicy.NO_SYNC, ReplicaAckPolicy.SIMPLE_MAJORITY);
    private final SyncPolicy masterSync;
    private final SyncPolicy replicaSync;
    private final ReplicaAckPolicy replicaAck;

    public Durability(SyncPolicy masterSync, SyncPolicy replicaSync, ReplicaAckPolicy replicaAck) {
        this.masterSync = masterSync;
        this.replicaSync = replicaSync;
        this.replicaAck = replicaAck;
    }

    public String toString() {
        return this.masterSync.toString() + "," + this.replicaSync.toString() + "," + this.replicaAck.toString();
    }

    public SyncPolicy getMasterSync() {
        return this.masterSync;
    }

    public SyncPolicy getReplicaSync() {
        return this.replicaSync;
    }

    public ReplicaAckPolicy getReplicaAck() {
        return this.replicaAck;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.masterSync.hashCode();
        result = 31 * result + this.replicaAck.hashCode();
        result = 31 * result + this.replicaSync.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Durability)) {
            return false;
        }
        Durability other = (Durability)obj;
        if (!this.masterSync.equals((Object)other.masterSync)) {
            return false;
        }
        if (!this.replicaAck.equals((Object)other.replicaAck)) {
            return false;
        }
        return this.replicaSync.equals((Object)other.replicaSync);
    }

    public static enum SyncPolicy {
        SYNC,
        NO_SYNC,
        WRITE_NO_SYNC;

    }

    public static enum ReplicaAckPolicy {
        ALL,
        NONE,
        SIMPLE_MAJORITY;

    }
}

