/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import oracle.nosql.driver.values.ArrayValue;
import oracle.nosql.driver.values.FieldValue;
import oracle.nosql.driver.values.MapValue;

public class Region {
    private static final String OCI_REGION_METADATA_ENV_VAR_NAME = "OCI_REGION_METADATA";
    private static final String REGIONS_CONFIG_FILE_PATH = System.getProperty("user.home") + File.separator + ".oci" + File.separator + "regions-config.json";
    private static final String svcEndpointFormat = "https://%1$s.%2$s.oci.%3$s";
    private static final String authEndpointFormat = "https://%1$s.%2$s.%3$s";
    private static final Map<String, Region> ALL_REGIONS = new LinkedHashMap<String, Region>();
    private static volatile boolean hasUsedEnvVar = false;
    private static volatile boolean hasUsedConfigFile = false;
    private static volatile boolean visitIMDS = false;
    private static final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private static final Lock readLock = lock.readLock();
    private static final Lock writeLock = lock.writeLock();
    public static final Region AF_JOHANNESBURG_1 = Region.register("af-johannesburg-1", Realm.OC1, "jnb");
    public static final Region AP_CHUNCHEON_1 = Region.register("ap-chuncheon-1", Realm.OC1, "yny");
    public static final Region AP_HYDERABAD_1 = Region.register("ap-hyderabad-1", Realm.OC1, "hyd");
    public static final Region AP_MELBOURNE_1 = Region.register("ap-melbourne-1", Realm.OC1, "mel");
    public static final Region AP_MUMBAI_1 = Region.register("ap-mumbai-1", Realm.OC1, "bom");
    public static final Region AP_OSAKA_1 = Region.register("ap-osaka-1", Realm.OC1, "kix");
    public static final Region AP_SEOUL_1 = Region.register("ap-seoul-1", Realm.OC1, "icn");
    public static final Region AP_SINGAPORE_1 = Region.register("ap-singapore-1", Realm.OC1, "sin");
    public static final Region AP_SINGAPORE_2 = Region.register("ap-singapore-2", Realm.OC1, "xsp");
    public static final Region AP_SYDNEY_1 = Region.register("ap-sydney-1", Realm.OC1, "syd");
    public static final Region AP_TOKYO_1 = Region.register("ap-tokyo-1", Realm.OC1, "nrt");
    public static final Region CA_MONTREAL_1 = Region.register("ca-montreal-1", Realm.OC1, "yul");
    public static final Region CA_TORONTO_1 = Region.register("ca-toronto-1", Realm.OC1, "yyz");
    public static final Region EU_AMSTERDAM_1 = Region.register("eu-amsterdam-1", Realm.OC1, "ams");
    public static final Region EU_FRANKFURT_1 = Region.register("eu-frankfurt-1", Realm.OC1, "fra");
    public static final Region EU_MADRID_1 = Region.register("eu-madrid-1", Realm.OC1, "mad");
    public static final Region EU_MARSEILLE_1 = Region.register("eu-marseille-1", Realm.OC1, "mrs");
    public static final Region EU_MILAN_1 = Region.register("eu-milan-1", Realm.OC1, "lin");
    public static final Region EU_PARIS_1 = Region.register("eu-paris-1", Realm.OC1, "cdg");
    public static final Region EU_STOCKHOLM_1 = Region.register("eu-stockholm-1", Realm.OC1, "arn");
    public static final Region EU_ZURICH_1 = Region.register("eu-zurich-1", Realm.OC1, "zrh");
    public static final Region IL_JERUSALEM_1 = Region.register("il-jerusalem-1", Realm.OC1, "mtz");
    public static final Region ME_ABUDHABI_1 = Region.register("me-abudhabi-1", Realm.OC1, "auh");
    public static final Region ME_DUBAI_1 = Region.register("me-dubai-1", Realm.OC1, "dxb");
    public static final Region ME_JEDDAH_1 = Region.register("me-jeddah-1", Realm.OC1, "jed");
    public static final Region ME_RIYADH_1 = Region.register("me-riyadh-1", Realm.OC1, "ruh");
    public static final Region MX_MONTERREY_1 = Region.register("mx-monterrey-1", Realm.OC1, "mty");
    public static final Region MX_QUERETARO_1 = Region.register("mx-queretaro-1", Realm.OC1, "qro");
    public static final Region SA_BOGOTA_1 = Region.register("sa-bogota-1", Realm.OC1, "bog");
    public static final Region SA_SANTIAGO_1 = Region.register("sa-santiago-1", Realm.OC1, "scl");
    public static final Region SA_SAOPAULO_1 = Region.register("sa-saopaulo-1", Realm.OC1, "gru");
    public static final Region SA_VALPARAISO_1 = Region.register("sa-valparaiso-1", Realm.OC1, "vap");
    public static final Region SA_VINHEDO_1 = Region.register("sa-vinhedo-1", Realm.OC1, "vcp");
    public static final Region UK_LONDON_1 = Region.register("uk-london-1", Realm.OC1, "lhr");
    public static final Region UK_CARDIFF_1 = Region.register("uk-cardiff-1", Realm.OC1, "cwl");
    public static final Region US_PHOENIX_1 = Region.register("us-phoenix-1", Realm.OC1, "phx");
    public static final Region US_ASHBURN_1 = Region.register("us-ashburn-1", Realm.OC1, "iad");
    public static final Region US_SALTLAKE_2 = Region.register("us-saltlake-2", Realm.OC1, "aga");
    public static final Region US_SANJOSE_1 = Region.register("us-sanjose-1", Realm.OC1, "sjc");
    public static final Region US_CHICAGO_1 = Region.register("us-chicago-1", Realm.OC1, "ord");
    public static final Region US_LANGLEY_1 = Region.register("us-langley-1", Realm.OC2, "lfi");
    public static final Region US_LUKE_1 = Region.register("us-luke-1", Realm.OC2, "luf");
    public static final Region US_GOV_ASHBURN_1 = Region.register("us-gov-ashburn-1", Realm.OC3, "ric");
    public static final Region US_GOV_CHICAGO_1 = Region.register("us-gov-chicago-1", Realm.OC3, "pia");
    public static final Region US_GOV_PHOENIX_1 = Region.register("us-gov-phoenix-1", Realm.OC3, "tus");
    public static final Region UK_GOV_LONDON_1 = Region.register("uk-gov-london-1", Realm.OC4, "ltn");
    public static final Region UK_GOV_CARDIFF_1 = Region.register("uk-gov-cardiff-1", Realm.OC4, "brs");
    public static final Region US_TACOMA_1 = Region.register("us-tacoma-1", Realm.OC5, "tiw");
    public static final Region AP_CHIYODA_1 = Region.register("ap-chiyoda-1", Realm.OC8, "nja");
    public static final Region AP_IBARAKI_1 = Region.register("ap-ibaraki-1", Realm.OC8, "ukb");
    public static final Region ME_DCC_MUSCAT_1 = Region.register("me-dcc-muscat-1", Realm.OC9, "mct");
    public static final Region AP_DCC_CANBERRA_1 = Region.register("ap-dcc-canberra-1", Realm.OC10, "wga");
    public static final Region EU_DCC_DUBLIN_1 = Region.register("eu-dcc-dublin-1", Realm.OC14, "ork");
    public static final Region EU_DCC_DUBLIN_2 = Region.register("eu-dcc-dublin-2", Realm.OC14, "snn");
    public static final Region EU_DCC_MILAN_1 = Region.register("eu-dcc-milan-1", Realm.OC14, "bgy");
    public static final Region EU_DCC_MILAN_2 = Region.register("eu-dcc-milan-2", Realm.OC14, "mxp");
    public static final Region EU_DCC_RATING_1 = Region.register("eu-dcc-rating-1", Realm.OC14, "dus");
    public static final Region EU_DCC_RATING_2 = Region.register("eu-dcc-rating-2", Realm.OC14, "dtm");
    public static final Region AP_DCC_GAZIPUR_1 = Region.register("ap-dcc-gazipur-1", Realm.OC15, "dac");
    public static final Region US_WESTJORDAN_1 = Region.register("us-westjordan-1", Realm.OC16, "sgu");
    public static final Region US_DCC_PHOENIX_1 = Region.register("us-dcc-phoenix-1", Realm.OC17, "ifp");
    public static final Region US_DCC_PHOENIX_2 = Region.register("us-dcc-phoenix-2", Realm.OC17, "gcn");
    public static final Region US_DCC_PHOENIX_4 = Region.register("us-dcc-phoenix-4", Realm.OC17, "yum");
    public static final Region EU_FRANKFURT_2 = Region.register("eu-frankfurt-2", Realm.OC19, "str");
    public static final Region EU_MADRID_2 = Region.register("eu-madrid-2", Realm.OC19, "vll");
    public static final Region EU_JOVANOVAC_1 = Region.register("eu-jovanovac-1", Realm.OC20, "beg");
    public static final Region ME_DCC_DOHA_1 = Region.register("me-dcc-doha-1", Realm.OC21, "doh");
    public static final Region EU_DCC_ROME_1 = Region.register("eu-dcc-rome-1", Realm.OC22, "nap");
    public static final Region US_SOMERSET_1 = Region.register("us-somerset-1", Realm.OC23, "ebb");
    public static final Region US_THAMES_1 = Region.register("us-thames-1", Realm.OC23, "ebl");
    public static final Region EU_DCC_ZURICH_1 = Region.register("eu-dcc-zurich-1", Realm.OC24, "avz");
    public static final Region EU_CRISSIER_1 = Region.register("eu-crissier-1", Realm.OC24, "avf");
    public static final Region AP_DCC_OSAKA_1 = Region.register("ap-dcc-osaka-1", Realm.OC25, "uky");
    public static final Region AP_DCC_TOKYO_1 = Region.register("ap-dcc-tokyo-1", Realm.OC25, "tyo");
    public static final Region ME_ABUDHABI_3 = Region.register("me-abudhabi-3", Realm.OC26, "ahu");
    public static final Region ME_ALAIN_1 = Region.register("me-alain-1", Realm.OC26, "rba");
    public static final Region US_DCC_SWJORDAN_1 = Region.register("us-dcc-swjordan-1", Realm.OC27, "ozz");
    public static final Region US_DCC_SWJORDAN_2 = Region.register("us-dcc-swjordan-2", Realm.OC28, "drs");
    public static final Region ME_ABUDHABI_2 = Region.register("me-abudhabi-2", Realm.OC29, "rkt");
    public static final Region ME_ABUDHABI_4 = Region.register("me-abudhabi-4", Realm.OC29, "shj");
    public static final Region AP_HOBSONVILLE_1 = Region.register("ap-hobsonville-1", Realm.OC31, "izq");
    public static final Region AP_SILVERDALE_1 = Region.register("ap-silverdale-1", Realm.OC31, "jjt");
    public static final Region AP_SUWON_1 = Region.register("ap-suwon-1", Realm.OC35, "dln");
    public static final Region AP_SEOUL_2 = Region.register("ap-seoul-2", Realm.OC35, "dtz");
    public static final Region AP_CHUNCHEON_2 = Region.register("ap-chuncheon-2", Realm.OC35, "bno");
    private final String regionId;
    private final String regionCode;
    private final Realm realm;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Region(String regionId, String regionCode, Realm realm) {
        this.regionId = regionId;
        this.regionCode = regionCode;
        this.realm = realm;
        writeLock.lock();
        try {
            ALL_REGIONS.put(regionId, this);
        }
        finally {
            writeLock.unlock();
        }
    }

    public static Region fromRegionId(String regionId) {
        if (regionId == null) {
            throw new IllegalArgumentException("Invalid region id " + regionId);
        }
        Region region = ALL_REGIONS.get(regionId = regionId.toLowerCase());
        if (region == null) {
            Region.registerAllRegions();
            region = ALL_REGIONS.get(regionId);
        }
        return region;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Region fromRegionIdOrCode(String regionIdOrCode) {
        String rCodeOrId = regionIdOrCode.toLowerCase();
        Region region = Region.fromRegionId(rCodeOrId);
        if (region != null) {
            return region;
        }
        readLock.lock();
        try {
            Optional<Region> reg = ALL_REGIONS.values().stream().filter(r -> r.regionCode.equals(rCodeOrId) || r.regionId.equals(rCodeOrId)).findAny();
            if (reg.isPresent()) {
                Region region2 = reg.get();
                return region2;
            }
            Region region3 = null;
            return region3;
        }
        finally {
            readLock.unlock();
        }
    }

    public String getRegionId() {
        return this.regionId;
    }

    public String endpoint() {
        return this.endpointForService("nosql", svcEndpointFormat);
    }

    public String endpointForService(String service, String format) {
        return String.format(format, service, this.regionId, this.realm.getSecondLevelDomain());
    }

    public static String getAuthEndpointFormat() {
        return authEndpointFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Region register(String regionId, Realm realm, String regionCode) {
        Region region;
        if ((regionId = regionId.trim().toLowerCase(Locale.US)).isEmpty()) {
            throw new IllegalArgumentException("Cannot have empty regionId");
        }
        readLock.lock();
        try {
            region = Region.getRegion(regionId, realm);
            if (region != null) {
                Region region2 = region;
                return region2;
            }
        }
        finally {
            readLock.unlock();
        }
        writeLock.lock();
        try {
            region = Region.getRegion(regionId, realm);
            if (region != null) {
                Region region3 = region;
                return region3;
            }
            if (regionCode != null && (regionCode = regionCode.trim().toLowerCase(Locale.US)).isEmpty()) {
                regionCode = null;
            }
            Region region4 = new Region(regionId, regionCode, realm);
            return region4;
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Region getRegion(String regionId, Realm realm) {
        readLock.lock();
        try {
            for (Region region : ALL_REGIONS.values()) {
                if (!region.regionId.equals(regionId)) continue;
                if (!region.realm.equals(realm)) {
                    throw new IllegalArgumentException("Region : " + regionId + " is already registered with " + region.realm + ". It cannot be re-registered with a different realm.");
                }
                Region region2 = region;
                return region2;
            }
        }
        finally {
            readLock.unlock();
        }
        return null;
    }

    static Region[] values() {
        Region.registerAllRegions();
        readLock.lock();
        try {
            Region[] regionArray = ALL_REGIONS.values().toArray(new Region[ALL_REGIONS.size()]);
            return regionArray;
        }
        finally {
            readLock.unlock();
        }
    }

    private static void registerAllRegions() {
        if (!hasUsedConfigFile) {
            Region.readRegionConfigFile();
        }
        if (!hasUsedEnvVar) {
            Region.readEnvVar();
        }
    }

    public static void readEnvVar() {
        String envVar = System.getProperty(OCI_REGION_METADATA_ENV_VAR_NAME);
        hasUsedEnvVar = true;
        if (envVar != null) {
            try {
                MapValue region = FieldValue.createFromJson(envVar, null).asMap();
                Region.addRegion(region);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to add region from environment variable " + envVar + ": " + e.getMessage());
            }
        }
    }

    private static void readRegionConfigFile() {
        hasUsedConfigFile = true;
        Region.readRegionConfigFile(REGIONS_CONFIG_FILE_PATH);
    }

    public static void readRegionConfigFile(String fileName) {
        File file = new File(fileName);
        if (!file.isFile()) {
            return;
        }
        String content = null;
        try {
            content = new String(Files.readAllBytes(Paths.get(fileName, new String[0])), StandardCharsets.UTF_8);
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Unable to read regions file, " + fileName + ": " + ioe);
        }
        if (content == null || content.isEmpty()) {
            return;
        }
        ArrayValue arrayOfRegions = FieldValue.createFromJson(content, null).asArray();
        for (FieldValue val : arrayOfRegions) {
            Region.addRegion(val.asMap());
        }
    }

    private static void addRegion(MapValue region) {
        Region.validateRegion(region);
        Realm realm = Realm.getRealm(region.get("realmKey").getString(), region.get("realmDomainComponent").getString(), true);
        Region.register(region.get("regionIdentifier").getString(), realm, region.get("regionKey").getString());
    }

    private static void validateRegion(MapValue region) {
        String[] fields;
        for (String f : fields = new String[]{"regionKey", "realmDomainComponent", "realmKey", "regionIdentifier"}) {
            try {
                if (region.get(f).isString()) continue;
                throw new IllegalArgumentException("Type of field " + f + " in region must be string: " + region);
            }
            catch (NullPointerException npe) {
                throw new IllegalArgumentException("Missing field " + f + " in region: " + region);
            }
        }
    }

    static class Realm {
        private static final Map<String, Realm> ALL_REALMS = new LinkedHashMap<String, Realm>();
        private static final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        private static final Lock readLock = lock.readLock();
        private static final Lock writeLock = lock.writeLock();
        private final String realmId;
        private final String secondLevelDomain;
        static final Realm OC1 = new Realm("oraclecloud.com", "oc1");
        static final Realm OC2 = new Realm("oraclegovcloud.com", "oc2");
        static final Realm OC3 = new Realm("oraclegovcloud.com", "oc3");
        static final Realm OC4 = new Realm("oraclegovcloud.uk", "oc4");
        static final Realm OC5 = new Realm("oraclecloud5.com", "oc5");
        static final Realm OC8 = new Realm("oraclecloud8.com", "oc8");
        static final Realm OC9 = new Realm("oraclecloud9.com", "oc9");
        static final Realm OC10 = new Realm("oraclecloud10.com", "oc10");
        static final Realm OC14 = new Realm("oraclecloud14.com", "oc14");
        static final Realm OC15 = new Realm("oraclecloud15.com", "oc15");
        static final Realm OC16 = new Realm("oraclecloud16.com", "oc16");
        static final Realm OC17 = new Realm("oraclecloud17.com", "oc17");
        static final Realm OC19 = new Realm("oraclecloud.eu", "oc19");
        static final Realm OC20 = new Realm("oraclecloud20.com", "oc20");
        static final Realm OC21 = new Realm("oraclecloud21.com", "oc21");
        static final Realm OC22 = new Realm("psn-pco.it", "oc22");
        static final Realm OC23 = new Realm("oraclecloud23.com", "oc23");
        static final Realm OC24 = new Realm("oraclecloud24.com", "oc24");
        static final Realm OC25 = new Realm("nricloud.jp", "oc25");
        static final Realm OC26 = new Realm("oraclecloud26.com", "oc26");
        static final Realm OC27 = new Realm("oraclecloud27.com", "oc27");
        static final Realm OC28 = new Realm("oraclecloud28.com", "oc28");
        static final Realm OC29 = new Realm("oraclecloud29.com", "oc29");
        static final Realm OC31 = new Realm("sovereigncloud.nz", "oc31");
        static final Realm OC35 = new Realm("oraclecloud35.com", "oc35");

        private Realm(String secondLevelDomain, String realmId) {
            this.realmId = realmId;
            this.secondLevelDomain = secondLevelDomain;
            writeLock.lock();
            try {
                ALL_REALMS.put(realmId, this);
            }
            finally {
                writeLock.unlock();
            }
        }

        static Realm getRealm(String realmId, String secondLevelDomain, boolean add) {
            Realm realm = ALL_REALMS.get(realmId);
            if (realm == null && add) {
                realm = new Realm(realmId, secondLevelDomain);
            }
            return realm;
        }

        String getRealmId() {
            return this.realmId;
        }

        String getSecondLevelDomain() {
            return this.secondLevelDomain;
        }

        static Realm[] values() {
            readLock.lock();
            try {
                Realm[] realmArray = ALL_REALMS.values().toArray(new Realm[ALL_REALMS.size()]);
                return realmArray;
            }
            finally {
                readLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static Realm register(String realmId, String secondLevelDomain) {
            realmId = realmId.toLowerCase(Locale.US);
            secondLevelDomain = secondLevelDomain.toLowerCase(Locale.US);
            writeLock.lock();
            try {
                for (Realm realm : Realm.values()) {
                    if (!realm.realmId.equals(realmId)) continue;
                    if (!realm.secondLevelDomain.equals(secondLevelDomain)) {
                        throw new IllegalArgumentException("RealmId : " + realmId + " is already registered with " + realm.getSecondLevelDomain() + ". It cannot be re-registered with a different secondLevelDomain");
                    }
                    Realm realm2 = realm;
                    return realm2;
                }
                Realm realm = new Realm(realmId, secondLevelDomain);
                return realm;
            }
            finally {
                writeLock.unlock();
            }
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Realm)) {
                return false;
            }
            Realm other = (Realm)o;
            return this.realmId.equals(other.realmId) && this.secondLevelDomain.equals(other.secondLevelDomain);
        }

        public int hashCode() {
            return this.realmId.hashCode() + this.secondLevelDomain.hashCode();
        }
    }

    public static interface RegionProvider {
        public Region getRegion();
    }
}

