/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.http;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultHttpHeadersFactory;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpHeadersFactory;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.ssl.SslContext;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.nosql.driver.AuthorizationProvider;
import oracle.nosql.driver.DefaultRetryHandler;
import oracle.nosql.driver.InvalidAuthorizationException;
import oracle.nosql.driver.NoSQLException;
import oracle.nosql.driver.NoSQLHandleConfig;
import oracle.nosql.driver.OperationNotSupportedException;
import oracle.nosql.driver.RateLimiter;
import oracle.nosql.driver.ReadThrottlingException;
import oracle.nosql.driver.RequestSizeLimitException;
import oracle.nosql.driver.RequestTimeoutException;
import oracle.nosql.driver.RetryHandler;
import oracle.nosql.driver.RetryableException;
import oracle.nosql.driver.SecurityInfoNotReadyException;
import oracle.nosql.driver.StatsControl;
import oracle.nosql.driver.TableNotFoundException;
import oracle.nosql.driver.UnsupportedProtocolException;
import oracle.nosql.driver.UnsupportedQueryVersionException;
import oracle.nosql.driver.WriteThrottlingException;
import oracle.nosql.driver.http.StatsControlImpl;
import oracle.nosql.driver.httpclient.HttpClient;
import oracle.nosql.driver.httpclient.ResponseHandler;
import oracle.nosql.driver.kv.AuthenticationException;
import oracle.nosql.driver.kv.StoreAccessTokenProvider;
import oracle.nosql.driver.ops.AddReplicaRequest;
import oracle.nosql.driver.ops.DeleteRequest;
import oracle.nosql.driver.ops.DropReplicaRequest;
import oracle.nosql.driver.ops.DurableRequest;
import oracle.nosql.driver.ops.GetRequest;
import oracle.nosql.driver.ops.GetResult;
import oracle.nosql.driver.ops.GetTableRequest;
import oracle.nosql.driver.ops.PrepareRequest;
import oracle.nosql.driver.ops.PutRequest;
import oracle.nosql.driver.ops.QueryRequest;
import oracle.nosql.driver.ops.QueryResult;
import oracle.nosql.driver.ops.Request;
import oracle.nosql.driver.ops.Result;
import oracle.nosql.driver.ops.TableLimits;
import oracle.nosql.driver.ops.TableRequest;
import oracle.nosql.driver.ops.TableResult;
import oracle.nosql.driver.ops.WriteMultipleRequest;
import oracle.nosql.driver.ops.WriteResult;
import oracle.nosql.driver.ops.serde.BinaryProtocol;
import oracle.nosql.driver.ops.serde.BinarySerializerFactory;
import oracle.nosql.driver.ops.serde.Serializer;
import oracle.nosql.driver.ops.serde.SerializerFactory;
import oracle.nosql.driver.ops.serde.nson.NsonSerializerFactory;
import oracle.nosql.driver.query.QueryDriver;
import oracle.nosql.driver.query.TopologyInfo;
import oracle.nosql.driver.util.ByteInputStream;
import oracle.nosql.driver.util.CheckNull;
import oracle.nosql.driver.util.HttpConstants;
import oracle.nosql.driver.util.LogUtil;
import oracle.nosql.driver.util.NettyByteInputStream;
import oracle.nosql.driver.util.NettyByteOutputStream;
import oracle.nosql.driver.util.RateLimiterMap;
import oracle.nosql.driver.util.SerializationUtil;
import oracle.nosql.driver.values.MapValue;

public class Client {
    public static int traceLevel = 0;
    private final NoSQLHandleConfig config;
    private final SerializerFactory v3factory = new BinarySerializerFactory();
    private final SerializerFactory v4factory = new NsonSerializerFactory();
    private final URL url;
    private final String kvRequestURI;
    private final String host;
    private final AtomicInteger maxRequestId = new AtomicInteger(1);
    private final HttpClient httpClient;
    private final AuthorizationProvider authProvider;
    private final boolean useSSL;
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private final Logger logger;
    private RateLimiterMap rateLimiterMap;
    private Map<String, AtomicLong> tableLimitUpdateMap;
    private static long LIMITER_REFRESH_NANOS = 600000000000L;
    private static final int SEC_ERROR_DELAY_MS = 100;
    private ExecutorService threadPool;
    private volatile short serialVersion = (short)4;
    private volatile short queryVersion = (short)5;
    private final HashSet<String> oneTimeMessages;
    private StatsControlImpl statsControl;
    private ConcurrentLinkedQueue<Request> authRefreshRequests;
    private MapValue badValue;
    private volatile String sessionCookie;
    private final String SESSION_COOKIE_FIELD = "session=";
    private String userAgent;
    private volatile TopologyInfo topology;
    private final String prepareFilename;

    public Client(Logger logger, NoSQLHandleConfig httpConfig) {
        this.logger = logger;
        this.config = httpConfig;
        this.url = httpConfig.getServiceURL();
        LogUtil.logFine(logger, "Driver service URL:" + this.url.toString());
        String protocol = httpConfig.getServiceURL().getProtocol();
        if (!"http".equalsIgnoreCase(protocol) && !"https".equalsIgnoreCase(protocol)) {
            throw new IllegalArgumentException("Unknown protocol:" + protocol);
        }
        this.kvRequestURI = httpConfig.getServiceURL().toString() + HttpConstants.NOSQL_DATA_PATH;
        this.host = httpConfig.getServiceURL().getHost();
        this.useSSL = "https".equalsIgnoreCase(protocol);
        SslContext sslCtx = null;
        if (this.useSSL && (sslCtx = this.config.getSslContext()) == null) {
            throw new IllegalArgumentException("Unable to configure https: SslContext is missing from config");
        }
        this.httpClient = new HttpClient(this.url.getHost(), this.url.getPort(), httpConfig.getNumThreads(), httpConfig.getConnectionPoolMinSize(), httpConfig.getConnectionPoolInactivityPeriod(), httpConfig.getMaxContentLength(), httpConfig.getMaxChunkSize(), sslCtx, this.config.getSSLHandshakeTimeout(), "NoSQL Driver", logger);
        if (httpConfig.getProxyHost() != null) {
            this.httpClient.configureProxy(httpConfig);
        }
        this.authProvider = this.config.getAuthorizationProvider();
        if (this.authProvider == null) {
            throw new IllegalArgumentException("Must configure AuthorizationProvider to use HttpClient");
        }
        if (this.config.getRateLimitingEnabled() && !(this.authProvider instanceof StoreAccessTokenProvider)) {
            LogUtil.logFine(logger, "Starting client with rate limiting enabled");
            this.rateLimiterMap = new RateLimiterMap();
            this.tableLimitUpdateMap = new ConcurrentHashMap<String, AtomicLong>();
            this.threadPool = Executors.newSingleThreadExecutor();
        } else {
            LogUtil.logFine(logger, "Starting client with no rate limiting");
            this.rateLimiterMap = null;
            this.tableLimitUpdateMap = null;
            this.threadPool = null;
        }
        this.oneTimeMessages = new HashSet();
        this.statsControl = new StatsControlImpl(this.config, logger, this.httpClient, httpConfig.getRateLimitingEnabled());
        String extensionUserAgent = httpConfig.getExtensionUserAgent();
        this.userAgent = extensionUserAgent != null ? HttpConstants.userAgent + " " + extensionUserAgent : HttpConstants.userAgent;
        this.prepareFilename = System.getProperty("test.preparefilename");
    }

    public void shutdown() {
        LogUtil.logFine(this.logger, "Shutting down driver http client");
        if (!this.shutdown.compareAndSet(false, true)) {
            return;
        }
        this.httpClient.shutdown();
        this.statsControl.shutdown();
        if (this.authProvider != null) {
            this.authProvider.close();
        }
        if (this.threadPool != null) {
            this.threadPool.shutdown();
        }
    }

    public int getAcquiredChannelCount() {
        return this.httpClient.getAcquiredChannelCount();
    }

    public int getTotalChannelCount() {
        return this.httpClient.getTotalChannelCount();
    }

    public int getFreeChannelCount() {
        return this.httpClient.getFreeChannelCount();
    }

    private int nextRequestId() {
        return this.maxRequestId.addAndGet(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result execute(Request kvRequest) {
        String tableName;
        RateLimiter writeLimiter;
        CheckNull.requireNonNull(kvRequest, "NoSQLHandle: request must be non-null");
        kvRequest.setDefaults(this.config);
        kvRequest.validate();
        kvRequest.setRetryStats(null);
        kvRequest.setRateLimitDelayedMs(0);
        if (kvRequest.isQueryRequest()) {
            QueryRequest qreq = (QueryRequest)kvRequest;
            kvRequest.setTopoSeqNum(this.getTopoSeqNum());
            this.statsControl.observeQuery(qreq);
            if (qreq.hasDriver()) {
                Client.trace("QueryRequest has QueryDriver", 2);
                return new QueryResult(qreq, false);
            }
            if (qreq.isPrepared() && !qreq.isSimpleQuery()) {
                Client.trace("QueryRequest has no QueryDriver, but is prepared", 2);
                QueryDriver driver = new QueryDriver(qreq);
                driver.setClient(this);
                return new QueryResult(qreq, false);
            }
            Client.trace("QueryRequest has no QueryDriver and is not prepared", 2);
            qreq.incBatchCounter();
        }
        int timeoutMs = kvRequest.getTimeoutInternal();
        Throwable exception = null;
        if (kvRequest.getCompartment() == null) {
            kvRequest.setCompartmentInternal(this.config.getDefaultCompartment());
        }
        int rateDelayedMs = 0;
        boolean checkReadUnits = false;
        boolean checkWriteUnits = false;
        RateLimiter readLimiter = kvRequest.getReadRateLimiter();
        if (readLimiter != null) {
            checkReadUnits = true;
        }
        if ((writeLimiter = kvRequest.getWriteRateLimiter()) != null) {
            checkWriteUnits = true;
        }
        if (this.rateLimiterMap != null && readLimiter == null && writeLimiter == null && (tableName = kvRequest.getTableName()) != null && tableName.length() > 0) {
            readLimiter = this.rateLimiterMap.getReadLimiter(tableName);
            writeLimiter = this.rateLimiterMap.getWriteLimiter(tableName);
            if (readLimiter == null && writeLimiter == null) {
                if (kvRequest.doesReads() || kvRequest.doesWrites()) {
                    this.backgroundUpdateLimiters(tableName, kvRequest.getCompartment());
                }
            } else {
                checkReadUnits = kvRequest.doesReads();
                kvRequest.setReadRateLimiter(readLimiter);
                checkWriteUnits = kvRequest.doesWrites();
                kvRequest.setWriteRateLimiter(writeLimiter);
            }
        }
        long startNanos = System.nanoTime();
        kvRequest.setStartNanos(startNanos);
        String requestClass = kvRequest.getClass().getSimpleName();
        boolean signContent = this.requireContentSigned(kvRequest);
        String requestId = "";
        int thisIterationTimeoutMs = 0;
        do {
            String name;
            TableLimits limits;
            thisIterationTimeoutMs = this.getIterationTimeoutMs(timeoutMs, startNanos);
            if (readLimiter != null && checkReadUnits) {
                try {
                    rateDelayedMs += readLimiter.consumeUnitsWithTimeout(0L, thisIterationTimeoutMs, false);
                }
                catch (Exception e) {
                    exception = e;
                    break;
                }
            }
            if (writeLimiter != null && checkWriteUnits) {
                try {
                    rateDelayedMs += writeLimiter.consumeUnitsWithTimeout(0L, thisIterationTimeoutMs, false);
                }
                catch (Exception e) {
                    exception = e;
                    break;
                }
            }
            if ((thisIterationTimeoutMs = this.getIterationTimeoutMs(timeoutMs, startNanos)) <= 0) break;
            String authString = this.authProvider.getAuthorizationString(kvRequest);
            this.authProvider.validateAuthString(authString);
            if (kvRequest.getNumRetries() > 0) {
                this.logRetries(kvRequest.getNumRetries(), exception);
            }
            if (this.serialVersion < 3 && kvRequest instanceof DurableRequest && ((DurableRequest)kvRequest).getDurability() != null) {
                this.oneTimeMessage("The requested feature is not supported by the connected server: Durability");
            }
            if (this.serialVersion < 3 && kvRequest instanceof TableRequest && (limits = ((TableRequest)kvRequest).getTableLimits()) != null && limits.getMode() == TableLimits.CapacityMode.ON_DEMAND) {
                this.oneTimeMessage("The requested feature is not supported by the connected server: on demand capacity table");
            }
            ResponseHandler responseHandler = null;
            short serialVersionUsed = this.serialVersion;
            short queryVersionUsed = this.queryVersion;
            ByteBuf buffer = null;
            try {
                Channel channel = this.httpClient.getChannel(thisIterationTimeoutMs);
                thisIterationTimeoutMs = this.getIterationTimeoutMs(timeoutMs, startNanos);
                if (thisIterationTimeoutMs > 0) {
                    String serdeVersion;
                    requestId = Long.toString(this.nextRequestId());
                    responseHandler = new ResponseHandler(this.httpClient, this.logger, channel, requestId, kvRequest.shouldRetry());
                    buffer = channel.alloc().directBuffer();
                    buffer.retain();
                    kvRequest.setCheckRequestSize(false);
                    if (!(kvRequest instanceof QueryRequest) || kvRequest.isQueryRequest()) {
                        kvRequest.setTopoSeqNum(this.getTopoSeqNum());
                    }
                    kvRequest.setTimeoutInternal(thisIterationTimeoutMs);
                    serialVersionUsed = this.writeContent(buffer, kvRequest, queryVersionUsed);
                    kvRequest.setTimeoutInternal(timeoutMs);
                    if (this.authProvider instanceof StoreAccessTokenProvider) {
                        if (buffer.readableBytes() > this.httpClient.getMaxContentLength()) {
                            throw new RequestSizeLimitException("The request size of " + buffer.readableBytes() + " exceeded the limit of " + this.httpClient.getMaxContentLength());
                        }
                    } else {
                        kvRequest.setCheckRequestSize(true);
                        BinaryProtocol.checkRequestSizeLimit(kvRequest, buffer.readableBytes());
                    }
                    DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, this.kvRequestURI, buffer, (HttpHeadersFactory)DefaultHttpHeadersFactory.headersFactory().withValidation(false), (HttpHeadersFactory)DefaultHttpHeadersFactory.trailersFactory().withValidation(false));
                    HttpHeaders headers = request.headers();
                    this.addCommonHeaders(headers);
                    int contentLength = buffer.readableBytes();
                    headers.add((CharSequence)HttpHeaderNames.HOST, (Object)this.host).add("x-nosql-request-id", (Object)requestId).setInt((CharSequence)"Content-Length", contentLength);
                    if (this.sessionCookie != null) {
                        headers.add("Cookie", (Object)this.sessionCookie);
                    }
                    if ((serdeVersion = this.getSerdeVersion(kvRequest)) != null) {
                        headers.add("x-nosql-serde-version", (Object)serdeVersion);
                    }
                    if (kvRequest.getCompartment() == null) {
                        kvRequest.setCompartmentInternal(this.config.getDefaultCompartment());
                    }
                    byte[] content = signContent ? this.getBodyBytes(buffer) : null;
                    this.authProvider.setRequiredHeaders(authString, kvRequest, headers, content);
                    String namespace = kvRequest.getNamespace();
                    if (namespace == null) {
                        namespace = this.config.getDefaultNamespace();
                    }
                    if (namespace != null) {
                        headers.add("x-nosql-default-ns", (Object)namespace);
                    }
                    if (LogUtil.isLoggable(this.logger, Level.FINE) && !kvRequest.getIsRefresh()) {
                        LogUtil.logTrace(this.logger, "Request: " + requestClass + ", requestId=" + requestId);
                    }
                    long latencyNanos = System.nanoTime();
                    this.httpClient.runRequest((HttpRequest)request, responseHandler, channel);
                    boolean isTimeout = responseHandler.await(thisIterationTimeoutMs);
                    if (isTimeout) {
                        throw new TimeoutException("Request timed out after " + timeoutMs + " milliseconds: requestId=" + requestId);
                    }
                    if (LogUtil.isLoggable(this.logger, Level.FINE) && !kvRequest.getIsRefresh()) {
                        LogUtil.logTrace(this.logger, "Response: " + requestClass + ", status=" + responseHandler.getStatus() + ", requestId=" + requestId);
                    }
                    ByteBuf wireContent = responseHandler.getContent();
                    Result res = this.processResponse(responseHandler.getStatus(), responseHandler.getHeaders(), wireContent, kvRequest, serialVersionUsed, queryVersionUsed);
                    rateDelayedMs += this.getRateDelayedFromHeader(responseHandler.getHeaders());
                    int resSize = wireContent.readerIndex();
                    long networkLatency = (System.nanoTime() - latencyNanos) / 1000000L;
                    this.setTopology(res.getTopology());
                    if (serialVersionUsed < 3) {
                        if (res instanceof GetResult) {
                            ((GetResult)res).setClient(this);
                        } else if (res instanceof WriteResult) {
                            ((WriteResult)res).setClient(this);
                        }
                    }
                    if (res instanceof QueryResult && kvRequest.isQueryRequest()) {
                        QueryRequest qreq = (QueryRequest)kvRequest;
                        qreq.addQueryTraces(((QueryResult)res).getQueryTraces());
                    }
                    if (res instanceof TableResult && this.rateLimiterMap != null) {
                        TableLimits tl = ((TableResult)res).getTableLimits();
                        this.updateRateLimiters(((TableResult)res).getTableName(), tl);
                    }
                    if (this.rateLimiterMap != null && readLimiter == null) {
                        readLimiter = this.getQueryRateLimiter(kvRequest, true);
                    }
                    if (this.rateLimiterMap != null && writeLimiter == null) {
                        writeLimiter = this.getQueryRateLimiter(kvRequest, false);
                    }
                    rateDelayedMs += this.consumeLimiterUnits(readLimiter, res.getReadUnitsInternal(), thisIterationTimeoutMs);
                    res.setRateLimitDelayedMs(rateDelayedMs += this.consumeLimiterUnits(writeLimiter, res.getWriteUnitsInternal(), thisIterationTimeoutMs));
                    res.setRetryStats(kvRequest.getRetryStats());
                    kvRequest.setRateLimitDelayedMs(rateDelayedMs);
                    this.statsControl.observe(kvRequest, Math.toIntExact(networkLatency), contentLength, resSize);
                    this.checkAuthRefreshList(kvRequest);
                    Result result = res;
                    return result;
                }
                break;
            }
            catch (AuthenticationException rae) {
                if (this.authProvider instanceof StoreAccessTokenProvider) {
                    StoreAccessTokenProvider satp = (StoreAccessTokenProvider)this.authProvider;
                    satp.bootstrapLogin();
                    kvRequest.addRetryException(rae.getClass());
                    kvRequest.incrementRetries();
                    exception = rae;
                    continue;
                }
                kvRequest.setRateLimitDelayedMs(rateDelayedMs);
                this.statsControl.observeError(kvRequest);
                LogUtil.logInfo(this.logger, "Unexpected authentication exception: " + rae);
                throw new NoSQLException("Unexpected exception: " + rae.getMessage(), rae);
            }
            catch (InvalidAuthorizationException iae) {
                if (kvRequest.getNumRetries() > 0) {
                    kvRequest.setRateLimitDelayedMs(rateDelayedMs);
                    this.statsControl.observeError(kvRequest);
                    LogUtil.logFine(this.logger, "Client execute NoSQLException: " + iae.getMessage());
                    throw iae;
                }
                this.authProvider.flushCache();
                kvRequest.addRetryException(iae.getClass());
                kvRequest.incrementRetries();
                exception = iae;
                LogUtil.logFine(this.logger, "Client retrying on InvalidAuthorizationException: " + iae.getMessage());
            }
            catch (SecurityInfoNotReadyException sinre) {
                kvRequest.addRetryException(sinre.getClass());
                exception = sinre;
                int delayMs = 100;
                if (kvRequest.getNumRetries() > 10 && (delayMs = DefaultRetryHandler.computeBackoffDelay(kvRequest, 0)) <= 0) break;
                try {
                    Thread.sleep(delayMs);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                kvRequest.incrementRetries();
                kvRequest.addRetryDelayMs(delayMs);
            }
            catch (RetryableException re) {
                if (re instanceof WriteThrottlingException && writeLimiter != null) {
                    checkWriteUnits = true;
                    if (writeLimiter.getCurrentRate() < 100.0) {
                        writeLimiter.setCurrentRate(100.0);
                    }
                }
                if (re instanceof ReadThrottlingException && readLimiter != null) {
                    checkReadUnits = true;
                    if (readLimiter.getCurrentRate() < 100.0) {
                        readLimiter.setCurrentRate(100.0);
                    }
                }
                LogUtil.logFine(this.logger, "Retryable exception: " + re.getMessage());
                kvRequest.addRetryException(re.getClass());
                this.handleRetry(re, kvRequest);
                kvRequest.incrementRetries();
                exception = re;
            }
            catch (UnsupportedQueryVersionException uqve) {
                if (this.decrementQueryVersion(queryVersionUsed)) {
                    LogUtil.logFine(this.logger, "Got unsupported query version error from server: decrementing query version to " + this.queryVersion + " and trying again.");
                    continue;
                }
                throw uqve;
            }
            catch (UnsupportedProtocolException upe) {
                if (this.decrementSerialVersion(serialVersionUsed)) {
                    LogUtil.logFine(this.logger, "Got unsupported protocol error from server: decrementing serial version to " + this.serialVersion + " and trying again.");
                    continue;
                }
                throw upe;
            }
            catch (NoSQLException nse) {
                kvRequest.setRateLimitDelayedMs(rateDelayedMs);
                this.statsControl.observeError(kvRequest);
                LogUtil.logFine(this.logger, "Client execute NoSQLException: " + nse.getMessage());
                throw nse;
            }
            catch (RuntimeException e) {
                kvRequest.setRateLimitDelayedMs(rateDelayedMs);
                this.statsControl.observeError(kvRequest);
                if (!kvRequest.getIsRefresh()) {
                    LogUtil.logFine(this.logger, "Client execute runtime exception: " + e.getMessage());
                }
                throw e;
            }
            catch (IOException ioe) {
                name = ioe.getClass().getName();
                LogUtil.logFine(this.logger, "Client execution IOException, name: " + name + ", message: " + ioe.getMessage());
                kvRequest.addRetryException(ioe.getClass());
                kvRequest.incrementRetries();
                exception = ioe;
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            catch (InterruptedException ie) {
                kvRequest.setRateLimitDelayedMs(rateDelayedMs);
                this.statsControl.observeError(kvRequest);
                LogUtil.logInfo(this.logger, "Client interrupted exception: " + ie.getMessage());
                throw new NoSQLException("Request interrupted: " + ie.getMessage());
            }
            catch (ExecutionException ee) {
                name = ee.getCause().getClass().getName();
                LogUtil.logFine(this.logger, "Client ExecutionException, name: " + name + ", message: " + ee.getMessage() + ", retrying");
                kvRequest.addRetryException(ee.getCause().getClass());
                kvRequest.incrementRetries();
                exception = ee.getCause();
            }
            catch (TimeoutException te) {
                exception = te;
                LogUtil.logInfo(this.logger, "Timeout exception: " + te);
                break;
            }
            catch (Throwable t) {
                name = t.getClass().getName();
                LogUtil.logInfo(this.logger, "Client execute Throwable, name: " + name + "message: " + t.getMessage());
                kvRequest.addRetryException(t.getClass());
                kvRequest.incrementRetries();
                exception = t;
            }
            finally {
                if (buffer != null) {
                    buffer.release(buffer.refCnt());
                }
                if (responseHandler != null) {
                    responseHandler.close();
                }
            }
        } while (!this.timeoutRequest(startNanos, timeoutMs, exception));
        kvRequest.setRateLimitDelayedMs(rateDelayedMs);
        this.statsControl.observeError(kvRequest);
        if (timeoutMs == thisIterationTimeoutMs && timeoutMs >= 2000 && rateDelayedMs == 0) {
            this.setSessionCookieValue(null);
        }
        throw new RequestTimeoutException(timeoutMs, requestClass + " timed out:" + (requestId.isEmpty() ? "" : " requestId=" + requestId) + " nextRequestId=" + this.nextRequestId() + " iterationTimeout=" + thisIterationTimeoutMs + "ms " + (kvRequest.getRetryStats() != null ? kvRequest.getRetryStats() : ""), exception);
    }

    private int getIterationTimeoutMs(long timeoutMs, long startNanos) {
        long diffNanos = System.nanoTime() - startNanos;
        return (int)timeoutMs - Math.toIntExact(diffNanos / 1000000L);
    }

    private RateLimiter getQueryRateLimiter(Request request, boolean read) {
        if (this.rateLimiterMap == null || !(request instanceof QueryRequest)) {
            return null;
        }
        if (!read && !((QueryRequest)request).doesWrites()) {
            return null;
        }
        String tableName = ((QueryRequest)request).getTableName();
        if (tableName == null || tableName == "") {
            return null;
        }
        if (read) {
            RateLimiter rl = this.rateLimiterMap.getReadLimiter(tableName);
            if (rl != null) {
                request.setReadRateLimiter(rl);
            }
            return rl;
        }
        RateLimiter rl = this.rateLimiterMap.getWriteLimiter(tableName);
        if (rl != null) {
            request.setWriteRateLimiter(rl);
        }
        return rl;
    }

    private int consumeLimiterUnits(RateLimiter rl, long units, int timeoutMs) {
        if (rl == null || units <= 0L) {
            return 0;
        }
        try {
            return rl.consumeUnitsWithTimeout(units, timeoutMs, false);
        }
        catch (TimeoutException e) {
            return timeoutMs;
        }
    }

    public boolean updateRateLimiters(String tableName, TableLimits limits) {
        if (this.rateLimiterMap == null) {
            return false;
        }
        this.setTableNeedsRefresh(tableName, false);
        if (limits == null || limits.getReadUnits() <= 0 && limits.getWriteUnits() <= 0) {
            this.rateLimiterMap.remove(tableName);
            LogUtil.logFine(this.logger, "removing rate limiting from table " + tableName);
            return false;
        }
        int durationSeconds = Integer.getInteger("test.rldurationsecs", 30);
        double RUs = limits.getReadUnits();
        double WUs = limits.getWriteUnits();
        double rlPercent = this.config.getDefaultRateLimitingPercentage();
        if (rlPercent > 0.0) {
            RUs = RUs * rlPercent / 100.0;
            WUs = WUs * rlPercent / 100.0;
        }
        this.rateLimiterMap.update(tableName, RUs, WUs, durationSeconds);
        if (LogUtil.isLoggable(this.logger, Level.FINE)) {
            String msg = String.format("Updated table '%s' to have RUs=%.1f and WUs=%.1f per second", tableName, RUs, WUs);
            LogUtil.logFine(this.logger, msg);
        }
        return true;
    }

    boolean timeoutRequest(long startNanos, long requestTimeoutMs, Throwable exception) {
        return this.getIterationTimeoutMs(requestTimeoutMs, startNanos) <= 0;
    }

    private short writeContent(ByteBuf content, Request kvRequest, short queryVersion) throws IOException {
        NettyByteOutputStream bos = new NettyByteOutputStream(content);
        short versionUsed = this.serialVersion;
        SerializerFactory factory = this.chooseFactory(kvRequest);
        factory.writeSerialVersion(versionUsed, bos);
        if (kvRequest instanceof QueryRequest || kvRequest instanceof PrepareRequest) {
            kvRequest.createSerializer(factory).serialize(kvRequest, versionUsed, queryVersion, bos);
        } else {
            kvRequest.createSerializer(factory).serialize(kvRequest, versionUsed, bos);
        }
        return versionUsed;
    }

    final Result processResponse(HttpResponseStatus status, HttpHeaders headers, ByteBuf content, Request kvRequest, short serialVersionUsed, short queryVersionUsed) {
        if (!HttpResponseStatus.OK.equals((Object)status)) {
            this.processNotOKResponse(status, content);
            throw new IllegalStateException("Unexpected http response status:" + status);
        }
        this.setSessionCookie(headers);
        Result res = null;
        try (NettyByteInputStream bis = new NettyByteInputStream(content);){
            res = this.processOKResponse(bis, kvRequest, serialVersionUsed, queryVersionUsed);
        }
        String sv = headers.get("x-nosql-serial-version");
        if (sv != null) {
            try {
                res.setServerSerialVersion(Integer.parseInt(sv));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return res;
    }

    Result processOKResponse(ByteInputStream in, Request kvRequest, short serialVersionUsed, short queryVersionUsed) {
        try {
            SerializerFactory factory = this.chooseFactory(kvRequest);
            int code = factory.readErrorCode(in);
            if (code == 0) {
                QueryRequest qreq;
                Result res;
                Serializer ser = kvRequest.createDeserializer(factory);
                if (kvRequest instanceof QueryRequest || kvRequest instanceof PrepareRequest) {
                    this.prepareResponseTestHook(kvRequest, in, serialVersionUsed, queryVersionUsed);
                    res = ser.deserialize(kvRequest, in, serialVersionUsed, queryVersionUsed);
                } else {
                    res = ser.deserialize(kvRequest, in, serialVersionUsed);
                }
                if (kvRequest.isQueryRequest() && !(qreq = (QueryRequest)kvRequest).isSimpleQuery()) {
                    qreq.getDriver().setClient(this);
                }
                return res;
            }
            String err = this.readString(in);
            if (code == 2 && kvRequest instanceof WriteMultipleRequest) {
                throw this.handleWriteMultipleTableNotFound(code, err, (WriteMultipleRequest)kvRequest);
            }
            throw this.handleResponseErrorCode(code, err);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new NoSQLException(e.getMessage());
        }
    }

    private void processNotOKResponse(HttpResponseStatus status, ByteBuf payload) {
        if (HttpResponseStatus.BAD_REQUEST.equals((Object)status)) {
            int len = payload.readableBytes();
            String errMsg = len > 0 ? payload.readCharSequence(len, StandardCharsets.UTF_8).toString() : status.reasonPhrase();
            throw new NoSQLException("Error response: " + errMsg);
        }
        throw new NoSQLException("Error response = " + status + ", reason = " + status.reasonPhrase());
    }

    private void setSessionCookie(HttpHeaders headers) {
        if (headers == null) {
            return;
        }
        String v = headers.get("Set-Cookie");
        if (v == null || !v.startsWith("session=")) {
            return;
        }
        int semi = v.indexOf(";");
        if (semi < 0) {
            this.setSessionCookieValue(v);
        } else {
            this.setSessionCookieValue(v.substring(0, semi));
        }
        if (LogUtil.isLoggable(this.logger, Level.FINE)) {
            LogUtil.logTrace(this.logger, "Set session cookie to \"" + this.sessionCookie + "\"");
        }
    }

    private synchronized void setSessionCookieValue(String pVal) {
        this.sessionCookie = pVal;
    }

    private boolean tableNeedsRefresh(String tableName) {
        if (this.tableLimitUpdateMap == null) {
            return false;
        }
        AtomicLong then = this.tableLimitUpdateMap.get(tableName);
        long nowNanos = System.nanoTime();
        return then == null || then.get() <= nowNanos;
    }

    private void setTableNeedsRefresh(String tableName, boolean needsRefresh) {
        if (this.tableLimitUpdateMap == null) {
            return;
        }
        AtomicLong then = this.tableLimitUpdateMap.get(tableName);
        long nowNanos = System.nanoTime();
        if (then != null) {
            if (!needsRefresh) {
                then.set(nowNanos + LIMITER_REFRESH_NANOS);
            } else {
                then.set(nowNanos - 1L);
            }
            return;
        }
        if (needsRefresh) {
            this.tableLimitUpdateMap.put(tableName, new AtomicLong(nowNanos - 1L));
        } else {
            this.tableLimitUpdateMap.put(tableName, new AtomicLong(nowNanos + LIMITER_REFRESH_NANOS));
        }
    }

    private synchronized void backgroundUpdateLimiters(String tableName, String compartmentId) {
        if (!this.tableNeedsRefresh(tableName)) {
            return;
        }
        this.setTableNeedsRefresh(tableName, false);
        try {
            this.threadPool.execute(() -> this.updateTableLimiters(tableName, compartmentId));
        }
        catch (RejectedExecutionException e) {
            this.setTableNeedsRefresh(tableName, true);
        }
    }

    private void updateTableLimiters(String tableName, String compartmentId) {
        GetTableRequest gtr = new GetTableRequest().setTableName(tableName).setCompartment(compartmentId).setTimeout(1000);
        TableResult res = null;
        try {
            LogUtil.logFine(this.logger, "Starting GetTableRequest for table '" + tableName + "'");
            res = (TableResult)this.execute(gtr);
        }
        catch (Exception e) {
            LogUtil.logFine(this.logger, "GetTableRequest for table '" + tableName + "' returned exception: " + e.getMessage());
        }
        if (res == null) {
            LogUtil.logFine(this.logger, "GetTableRequest for table '" + tableName + "' returned null");
            AtomicLong then = this.tableLimitUpdateMap.get(tableName);
            if (then != null) {
                then.set(System.nanoTime() + 100000000L);
            }
            return;
        }
        LogUtil.logFine(this.logger, "GetTableRequest completed for table '" + tableName + "'");
        if (this.updateRateLimiters(tableName, res.getTableLimits())) {
            LogUtil.logFine(this.logger, "background thread added limiters for table '" + tableName + "'");
        }
    }

    private void handleRetry(RetryableException re, Request kvRequest) {
        int numRetries = kvRequest.getNumRetries();
        String msg = "Retry for request " + kvRequest.getClass().getSimpleName() + ", num retries: " + numRetries + ", exception: " + re.getMessage();
        LogUtil.logFine(this.logger, msg);
        RetryHandler handler = this.config.getRetryHandler();
        if (!handler.doRetry(kvRequest, numRetries, re)) {
            LogUtil.logFine(this.logger, "Too many retries");
            throw re;
        }
        handler.delay(kvRequest, numRetries, re);
    }

    private void logRetries(int numRetries, Throwable exception) {
        Level level = Level.FINE;
        if (this.logger != null) {
            this.logger.log(level, "Client, doing retry: " + numRetries + (exception != null ? ", exception: " + exception : ""));
        }
    }

    private String readString(ByteInputStream in) throws IOException {
        return SerializationUtil.readString(in);
    }

    private RuntimeException handleResponseErrorCode(int code, String msg) {
        RuntimeException exc = BinaryProtocol.mapException(code, msg);
        throw exc;
    }

    private RuntimeException handleWriteMultipleTableNotFound(int code, String msg, WriteMultipleRequest wrRequest) {
        if (code != 2 || wrRequest.isSingleTable() || msg.indexOf(",") < 0 || msg.indexOf("[") >= 0) {
            return this.handleResponseErrorCode(code, msg);
        }
        throw new OperationNotSupportedException("WriteMultiple requests using multiple tables are not supported by the version of the connected server.");
    }

    private void addCommonHeaders(HttpHeaders headers) {
        headers.set("Content-Type", (Object)"application/octet-stream").set("Connection", (Object)"keep-alive").set("Accept", (Object)"application/octet-stream").set("User-Agent", (Object)this.getUserAgent());
    }

    private String getUserAgent() {
        return this.userAgent;
    }

    public static void trace(String msg, int level) {
        if (level <= traceLevel) {
            System.out.println("DRIVER: " + msg);
        }
    }

    public void resetRateLimiters(String tableName) {
        if (this.rateLimiterMap != null) {
            this.rateLimiterMap.reset(tableName);
        }
    }

    public void enableRateLimiting(boolean enable, double usePercent) {
        this.config.setDefaultRateLimitingPercentage(usePercent);
        if (enable && this.rateLimiterMap == null) {
            this.rateLimiterMap = new RateLimiterMap();
            this.tableLimitUpdateMap = new ConcurrentHashMap<String, AtomicLong>();
            this.threadPool = Executors.newSingleThreadExecutor();
        } else if (!enable && this.rateLimiterMap != null) {
            this.rateLimiterMap.clear();
            this.rateLimiterMap = null;
            this.tableLimitUpdateMap.clear();
            this.tableLimitUpdateMap = null;
            if (this.threadPool != null) {
                this.threadPool.shutdown();
                this.threadPool = null;
            }
        }
    }

    StatsControl getStatsControl() {
        return this.statsControl;
    }

    private synchronized boolean decrementSerialVersion(short versionUsed) {
        if (this.serialVersion != versionUsed) {
            return true;
        }
        if (this.serialVersion == 4) {
            this.serialVersion = (short)3;
            return true;
        }
        if (this.serialVersion == 3) {
            this.serialVersion = (short)2;
            return true;
        }
        return false;
    }

    private synchronized boolean decrementQueryVersion(short versionUsed) {
        if (this.queryVersion != versionUsed) {
            return true;
        }
        if (this.queryVersion == QueryDriver.QUERY_V3) {
            return false;
        }
        this.queryVersion = (short)(this.queryVersion - 1);
        return true;
    }

    public short getSerialVersion() {
        return this.serialVersion;
    }

    public void setSerialVersion(short version) {
        this.serialVersion = version;
    }

    void createAuthRefreshList() {
        this.authRefreshRequests = new ConcurrentLinkedQueue();
        this.badValue = new MapValue().put("@bad", 0);
    }

    void doRefresh(long refreshMs) {
        long minMsPerRequest = 20L;
        int numRequests = this.authRefreshRequests.size();
        if (numRequests == 0) {
            return;
        }
        int msPerRequest = (int)(refreshMs / (long)(numRequests * 3));
        if ((long)msPerRequest < 20L) {
            LogUtil.logFine(this.logger, "Not enough time per request to perform auth refresh. numRequests=" + numRequests + " totalMs=" + refreshMs + " msPerRequest=" + msPerRequest);
            return;
        }
        LogUtil.logFine(this.logger, "Performing auth refresh. numRequests=" + numRequests + " refreshMs=" + refreshMs + "ms per request=" + msPerRequest);
        int numCallsPerRequest = this.sessionCookie != null ? 1 : 3;
        Iterator<Request> iter = this.authRefreshRequests.iterator();
        block3: while (iter.hasNext()) {
            Request rq = iter.next();
            rq.setTimeoutInternal(msPerRequest);
            for (int i = 0; i < numCallsPerRequest; ++i) {
                try {
                    this.execute(rq);
                    continue;
                }
                catch (TableNotFoundException tnf) {
                    LogUtil.logFine(this.logger, "Auth refresh table not found, removing: " + rq.getClass().getSimpleName() + " for " + rq.getTableName());
                    iter.remove();
                    continue block3;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    private void checkAuthRefreshList(Request request) {
        if (this.authRefreshRequests != null) {
            if (request.getIsRefresh() || request.getTableName() == null || !request.doesReads() && !request.doesWrites()) {
                return;
            }
            for (Request rq : this.authRefreshRequests) {
                if (!rq.getTableName().equalsIgnoreCase(request.getTableName()) || !this.stringsEqualOrNull(rq.getCompartment(), request.getCompartment())) continue;
                return;
            }
            this.addRequestToRefreshList(request);
        }
    }

    private boolean stringsEqualOrNull(String s1, String s2) {
        if (s1 == null) {
            return s2 == null;
        }
        return s1.equalsIgnoreCase(s2);
    }

    private synchronized void addRequestToRefreshList(Request request) {
        LogUtil.logFine(this.logger, "Adding table to request list: " + request.getCompartment() + ":" + request.getTableName());
        PutRequest pr = new PutRequest().setTableName(request.getTableName());
        pr.setCompartmentInternal(request.getCompartment());
        pr.setValue(this.badValue);
        pr.setIsRefresh(true);
        this.authRefreshRequests.add(pr);
        GetRequest gr = new GetRequest().setTableName(request.getTableName());
        gr.setCompartmentInternal(request.getCompartment());
        gr.setKey(this.badValue);
        gr.setIsRefresh(true);
        this.authRefreshRequests.add(gr);
        DeleteRequest dr = new DeleteRequest().setTableName(request.getTableName());
        dr.setCompartmentInternal(request.getCompartment());
        dr.setKey(this.badValue);
        dr.setIsRefresh(true);
        this.authRefreshRequests.add(dr);
    }

    public synchronized void oneTimeMessage(String msg) {
        if (!this.oneTimeMessages.add(msg)) {
            return;
        }
        LogUtil.logWarning(this.logger, msg);
    }

    private SerializerFactory chooseFactory(Request rq) {
        if (this.serialVersion == 4) {
            return this.v4factory;
        }
        return this.v3factory;
    }

    private String getSerdeVersion(Request rq) {
        return this.chooseFactory(rq).getSerdeVersionString();
    }

    private int getRateDelayedFromHeader(HttpHeaders headers) {
        if (headers == null) {
            return 0;
        }
        String v = headers.get("X-Nosql-RL-Delay-Ms");
        if (v == null || v.isEmpty()) {
            return 0;
        }
        try {
            return Integer.parseInt(v);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    private boolean requireContentSigned(Request request) {
        if (!this.authProvider.forCloud()) {
            return false;
        }
        return request instanceof AddReplicaRequest || request instanceof DropReplicaRequest || request instanceof TableRequest || request.getOboToken() != null;
    }

    private byte[] getBodyBytes(ByteBuf buffer) {
        if (buffer.hasArray()) {
            return buffer.array();
        }
        byte[] bytes = new byte[buffer.readableBytes()];
        buffer.getBytes(buffer.readerIndex(), bytes);
        return bytes;
    }

    public void setDefaultNamespace(String ns) {
        this.config.setDefaultNamespace(ns);
    }

    public TopologyInfo getTopology() {
        return this.topology;
    }

    private synchronized int getTopoSeqNum() {
        return this.topology == null ? -1 : this.topology.getSeqNum();
    }

    private synchronized void setTopology(TopologyInfo topo) {
        if (topo == null) {
            return;
        }
        if (this.topology == null || this.topology.getSeqNum() < topo.getSeqNum()) {
            this.topology = topo;
            Client.trace("New topology: " + topo, 1);
        }
    }

    private void prepareResponseTestHook(Request kvReq, ByteInputStream in, short serialVersion, short queryVersion) throws IOException {
        if (this.prepareFilename == null || !(kvReq instanceof PrepareRequest) || !(in instanceof NettyByteInputStream)) {
            return;
        }
        int offset = in.getOffset();
        try {
            PrepareRequest pReq = (PrepareRequest)kvReq;
            NettyByteInputStream nis = (NettyByteInputStream)in;
            ByteBuf buf = nis.buffer();
            int numBytes = buf.readableBytes();
            byte[] bytes = new byte[numBytes];
            for (int x = 0; x < numBytes; ++x) {
                bytes[x] = in.readByte();
            }
            try (DataOutputStream dos = new DataOutputStream(new FileOutputStream(this.prepareFilename));){
                LogUtil.logFine(this.logger, "Serializing prepare response to " + this.prepareFilename);
                dos.write(bytes, 0, numBytes);
            }
            catch (Exception e) {
                System.err.println("Error writing serialized prepared result: " + e);
            }
            Properties props = new Properties();
            props.setProperty("statement", pReq.getStatement());
            props.setProperty("getplan", String.valueOf(pReq.getQueryPlan()));
            props.setProperty("serialversion", String.valueOf(serialVersion));
            props.setProperty("queryversion", String.valueOf(queryVersion));
            String fName = this.prepareFilename + ".props";
            try (FileOutputStream fos = new FileOutputStream(fName);){
                LogUtil.logFine(this.logger, "Writing property file " + fName);
                props.store(fos, "");
            }
            catch (Exception e) {
                System.err.println("Error writing serialized prepared result: " + e);
            }
        }
        catch (IOException e) {
            System.err.println("Error writing serialized prepared result: " + e);
        }
        in.setOffset(offset);
    }
}

