/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.http;

import io.netty.handler.ssl.SslContextBuilder;
import io.netty.util.internal.logging.InternalLoggerFactory;
import io.netty.util.internal.logging.JdkLoggerFactory;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.net.ssl.SSLException;
import oracle.nosql.driver.AuthorizationProvider;
import oracle.nosql.driver.NoSQLHandle;
import oracle.nosql.driver.NoSQLHandleConfig;
import oracle.nosql.driver.StatsControl;
import oracle.nosql.driver.UserInfo;
import oracle.nosql.driver.http.Client;
import oracle.nosql.driver.iam.SignatureProvider;
import oracle.nosql.driver.kv.StoreAccessTokenProvider;
import oracle.nosql.driver.ops.AddReplicaRequest;
import oracle.nosql.driver.ops.DeleteRequest;
import oracle.nosql.driver.ops.DeleteResult;
import oracle.nosql.driver.ops.DropReplicaRequest;
import oracle.nosql.driver.ops.GetIndexesRequest;
import oracle.nosql.driver.ops.GetIndexesResult;
import oracle.nosql.driver.ops.GetRequest;
import oracle.nosql.driver.ops.GetResult;
import oracle.nosql.driver.ops.GetTableRequest;
import oracle.nosql.driver.ops.ListTablesRequest;
import oracle.nosql.driver.ops.ListTablesResult;
import oracle.nosql.driver.ops.MultiDeleteRequest;
import oracle.nosql.driver.ops.MultiDeleteResult;
import oracle.nosql.driver.ops.PrepareRequest;
import oracle.nosql.driver.ops.PrepareResult;
import oracle.nosql.driver.ops.PutRequest;
import oracle.nosql.driver.ops.PutResult;
import oracle.nosql.driver.ops.QueryIterableResult;
import oracle.nosql.driver.ops.QueryRequest;
import oracle.nosql.driver.ops.QueryResult;
import oracle.nosql.driver.ops.ReplicaStatsRequest;
import oracle.nosql.driver.ops.ReplicaStatsResult;
import oracle.nosql.driver.ops.SystemRequest;
import oracle.nosql.driver.ops.SystemResult;
import oracle.nosql.driver.ops.SystemStatusRequest;
import oracle.nosql.driver.ops.TableRequest;
import oracle.nosql.driver.ops.TableResult;
import oracle.nosql.driver.ops.TableUsageRequest;
import oracle.nosql.driver.ops.TableUsageResult;
import oracle.nosql.driver.ops.WriteMultipleRequest;
import oracle.nosql.driver.ops.WriteMultipleResult;
import oracle.nosql.driver.values.FieldValue;
import oracle.nosql.driver.values.JsonUtils;
import oracle.nosql.driver.values.MapValue;

public class NoSQLHandleImpl
implements NoSQLHandle {
    private Client client;

    public NoSQLHandleImpl(NoSQLHandleConfig config) {
        this.configNettyLogging();
        Logger logger = this.getLogger(config);
        this.configSslContext(config);
        this.client = new Client(logger, config);
        this.configAuthProvider(logger, config);
    }

    private Logger getLogger(NoSQLHandleConfig config) {
        if (config.getLogger() != null) {
            return config.getLogger();
        }
        Logger logger = Logger.getLogger(this.getClass().getName());
        return logger;
    }

    private void configNettyLogging() {
        InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)JdkLoggerFactory.INSTANCE);
    }

    private void configSslContext(NoSQLHandleConfig config) {
        if (config.getSslContext() != null) {
            return;
        }
        if (config.getServiceURL().getProtocol().equalsIgnoreCase("HTTPS")) {
            try {
                SslContextBuilder builder = SslContextBuilder.forClient();
                if (config.getSSLCipherSuites() != null) {
                    builder.ciphers(config.getSSLCipherSuites());
                }
                if (config.getSSLProtocols() != null) {
                    builder.protocols(config.getSSLProtocols());
                }
                builder.sessionTimeout((long)config.getSSLSessionTimeout());
                builder.sessionCacheSize((long)config.getSSLSessionCacheSize());
                config.setSslContext(builder.build());
            }
            catch (SSLException se) {
                throw new IllegalStateException("Unable to start handle with SSL", se);
            }
        }
    }

    private void configAuthProvider(Logger logger, NoSQLHandleConfig config) {
        AuthorizationProvider ap = config.getAuthorizationProvider();
        if (ap instanceof StoreAccessTokenProvider) {
            StoreAccessTokenProvider stProvider = (StoreAccessTokenProvider)ap;
            if (stProvider.getLogger() == null) {
                stProvider.setLogger(logger);
            }
            if (stProvider.isSecure() && stProvider.getEndpoint() == null) {
                String endpoint = config.getServiceURL().toString();
                if (endpoint.endsWith("/")) {
                    endpoint = endpoint.substring(0, endpoint.length() - 1);
                }
                stProvider.setEndpoint(endpoint).setSslContext(config.getSslContext()).setSslHandshakeTimeout(config.getSSLHandshakeTimeout());
            }
        } else if (ap instanceof SignatureProvider) {
            SignatureProvider sigProvider = (SignatureProvider)ap;
            if (sigProvider.getLogger() == null) {
                sigProvider.setLogger(logger);
            }
            sigProvider.prepare(config);
            if (config.getAuthRefresh()) {
                sigProvider.setOnSignatureRefresh(new SigRefresh());
                this.client.createAuthRefreshList();
            }
        }
    }

    @Override
    public DeleteResult delete(DeleteRequest request) {
        this.checkClient();
        return (DeleteResult)this.client.execute(request);
    }

    @Override
    public GetResult get(GetRequest request) {
        this.checkClient();
        return (GetResult)this.client.execute(request);
    }

    @Override
    public PutResult put(PutRequest request) {
        this.checkClient();
        return (PutResult)this.client.execute(request);
    }

    @Override
    public WriteMultipleResult writeMultiple(WriteMultipleRequest request) {
        this.checkClient();
        return (WriteMultipleResult)this.client.execute(request);
    }

    @Override
    public MultiDeleteResult multiDelete(MultiDeleteRequest request) {
        this.checkClient();
        return (MultiDeleteResult)this.client.execute(request);
    }

    @Override
    public QueryResult query(QueryRequest request) {
        this.checkClient();
        return (QueryResult)this.client.execute(request);
    }

    @Override
    public QueryIterableResult queryIterable(QueryRequest request) {
        this.checkClient();
        return new QueryIterableResult(request, this);
    }

    @Override
    public PrepareResult prepare(PrepareRequest request) {
        this.checkClient();
        return (PrepareResult)this.client.execute(request);
    }

    @Override
    public TableResult tableRequest(TableRequest request) {
        this.checkClient();
        TableResult res = (TableResult)this.client.execute(request);
        this.client.updateRateLimiters(res.getTableName(), res.getTableLimits());
        return res;
    }

    @Override
    public TableResult getTable(GetTableRequest request) {
        this.checkClient();
        TableResult res = (TableResult)this.client.execute(request);
        this.client.updateRateLimiters(res.getTableName(), res.getTableLimits());
        return res;
    }

    @Override
    public SystemResult systemRequest(SystemRequest request) {
        this.checkClient();
        return (SystemResult)this.client.execute(request);
    }

    @Override
    public SystemResult systemStatus(SystemStatusRequest request) {
        this.checkClient();
        return (SystemResult)this.client.execute(request);
    }

    @Override
    public TableUsageResult getTableUsage(TableUsageRequest request) {
        this.checkClient();
        return (TableUsageResult)this.client.execute(request);
    }

    @Override
    public ListTablesResult listTables(ListTablesRequest request) {
        this.checkClient();
        return (ListTablesResult)this.client.execute(request);
    }

    @Override
    public GetIndexesResult getIndexes(GetIndexesRequest request) {
        this.checkClient();
        return (GetIndexesResult)this.client.execute(request);
    }

    @Override
    public TableResult addReplica(AddReplicaRequest request) {
        this.checkClient();
        return (TableResult)this.client.execute(request);
    }

    @Override
    public TableResult dropReplica(DropReplicaRequest request) {
        this.checkClient();
        return (TableResult)this.client.execute(request);
    }

    @Override
    public ReplicaStatsResult getReplicaStats(ReplicaStatsRequest request) {
        this.checkClient();
        return (ReplicaStatsResult)this.client.execute(request);
    }

    @Override
    public synchronized void close() {
        this.checkClient();
        this.client.shutdown();
        this.client = null;
    }

    @Override
    public String[] listNamespaces() {
        SystemResult dres = this.doSystemRequest("show as json namespaces");
        String jsonResult = dres.getResultString();
        if (jsonResult == null) {
            return null;
        }
        MapValue root = JsonUtils.createValueFromJson(jsonResult, null).asMap();
        FieldValue namespaces = root.get("namespaces");
        if (namespaces == null) {
            return null;
        }
        ArrayList<String> results = new ArrayList<String>(namespaces.asArray().size());
        for (FieldValue val : namespaces.asArray()) {
            results.add(val.getString());
        }
        return results.toArray(new String[0]);
    }

    @Override
    public UserInfo[] listUsers() {
        SystemResult dres = this.doSystemRequest("show as json users");
        String jsonResult = dres.getResultString();
        if (jsonResult == null) {
            return null;
        }
        MapValue root = JsonUtils.createValueFromJson(jsonResult, null).asMap();
        FieldValue users = root.get("users");
        if (users == null) {
            return null;
        }
        ArrayList<UserInfo> results = new ArrayList<UserInfo>(users.asArray().size());
        for (FieldValue val : users.asArray()) {
            String id = val.asMap().getString("id");
            String name = val.asMap().getString("name");
            results.add(new UserInfo(id, name));
        }
        return results.toArray(new UserInfo[0]);
    }

    @Override
    public String[] listRoles() {
        SystemResult dres = this.doSystemRequest("show as json roles");
        String jsonResult = dres.getResultString();
        if (jsonResult == null) {
            return null;
        }
        MapValue root = JsonUtils.createValueFromJson(jsonResult, null).asMap();
        FieldValue roles = root.get("roles");
        if (roles == null) {
            return null;
        }
        ArrayList<String> results = new ArrayList<String>(roles.asArray().size());
        for (FieldValue val : roles.asArray()) {
            String role = val.asMap().getString("name");
            results.add(role);
        }
        return results.toArray(new String[0]);
    }

    private SystemResult doSystemRequest(String statement) {
        return this.doSystemRequest(statement, 30000, 1000);
    }

    @Override
    public TableResult doTableRequest(TableRequest request, int timeoutMs, int pollIntervalMs) {
        TableResult res = this.tableRequest(request);
        res.waitForCompletion(this, timeoutMs, pollIntervalMs);
        return res;
    }

    @Override
    public SystemResult doSystemRequest(String statement, int timeoutMs, int pollIntervalMs) {
        this.checkClient();
        SystemRequest dreq = new SystemRequest().setStatement(statement.toCharArray());
        SystemResult dres = this.systemRequest(dreq);
        dres.waitForCompletion(this, timeoutMs, pollIntervalMs);
        return dres;
    }

    @Override
    public StatsControl getStatsControl() {
        return this.client.getStatsControl();
    }

    private void checkClient() {
        if (this.client == null) {
            throw new IllegalStateException("NoSQLHandle has been closed");
        }
    }

    public Client getClient() {
        return this.client;
    }

    public short getSerialVersion() {
        return this.client.getSerialVersion();
    }

    public void setDefaultNamespace(String ns) {
        this.client.setDefaultNamespace(ns);
    }

    private class SigRefresh
    implements SignatureProvider.OnSignatureRefresh {
        private SigRefresh() {
        }

        @Override
        public void refresh(long refreshMs) {
            NoSQLHandleImpl.this.client.doRefresh(refreshMs);
        }
    }
}

