/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.http;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Timestamp;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import oracle.nosql.driver.SecurityInfoNotReadyException;
import oracle.nosql.driver.StatsControl;
import oracle.nosql.driver.ThrottlingException;
import oracle.nosql.driver.http.StatsControlImpl;
import oracle.nosql.driver.kv.AuthenticationException;
import oracle.nosql.driver.ops.PreparedStatement;
import oracle.nosql.driver.ops.QueryRequest;
import oracle.nosql.driver.ops.Request;
import oracle.nosql.driver.ops.RetryStats;
import oracle.nosql.driver.values.ArrayValue;
import oracle.nosql.driver.values.JsonOptions;
import oracle.nosql.driver.values.MapValue;
import oracle.nosql.driver.values.StringValue;
import oracle.nosql.driver.values.TimestampValue;

public class Stats {
    private static String[] REQUEST_KEYS = new String[]{"Delete", "Get", "GetIndexes", "GetTable", "ListTables", "MultiDelete", "Prepare", "Put", "Query", "System", "SystemStatus", "Table", "TableUsage", "WriteMultiple", "Write"};
    private ScheduledExecutorService service;
    private StatsControlImpl statsControl;
    private long startTime;
    private long endTime;
    private Map<String, ReqStats> requests = new HashMap<String, ReqStats>();
    private ConnectionStats connectionStats = new ConnectionStats();
    private ExtraQueryStats extraQueryStats;

    Stats(StatsControlImpl statsControl) {
        this.statsControl = statsControl;
        for (String key : REQUEST_KEYS) {
            ReqStats reqStats = new ReqStats();
            this.requests.put(key, reqStats);
            if (statsControl.getProfile().ordinal() < StatsControl.Profile.MORE.ordinal()) continue;
            reqStats.requestLatencyPercentile = new Percentile();
        }
        if (statsControl.getProfile().ordinal() >= StatsControl.Profile.ALL.ordinal()) {
            this.extraQueryStats = new ExtraQueryStats(statsControl);
        }
        Runnable runnable = () -> {
            block2: {
                try {
                    this.logClientStats();
                }
                catch (RuntimeException re) {
                    if (statsControl.getLogger() == null) break block2;
                    StringWriter stackTrace = new StringWriter();
                    re.printStackTrace(new PrintWriter(stackTrace));
                    statsControl.getLogger().log(Level.INFO, "Stats exception: " + re.getMessage() + "\n" + stackTrace);
                }
            }
        };
        LocalTime localTime = LocalTime.now();
        long delay = 1000L * (long)statsControl.getInterval() - (60000L * (long)localTime.getMinute() + 1000L * (long)localTime.getSecond() + (long)localTime.getNano() / 1000000L) % (1000L * (long)statsControl.getInterval());
        this.service = Executors.newSingleThreadScheduledExecutor();
        this.service.scheduleAtFixedRate(runnable, delay, 1000L * (long)statsControl.getInterval(), TimeUnit.MILLISECONDS);
        this.startTime = System.currentTimeMillis();
    }

    private void logClientStats() {
        this.endTime = System.currentTimeMillis();
        MapValue fvStats = this.generateFieldValueStats();
        this.clearStats();
        StatsControl.StatsHandler statsHandler = this.statsControl.getStatsHandler();
        if (statsHandler != null) {
            statsHandler.accept(fvStats);
        }
        if (this.statsControl.getLogger() != null) {
            String json = fvStats.toJson(this.statsControl.getPrettyPrint() ? JsonOptions.PRETTY : null);
            this.statsControl.getLogger().log(Level.INFO, "Client stats|" + json);
        }
    }

    private MapValue generateFieldValueStats() {
        HashSet<Map.Entry<String, ReqStats>> entries;
        MapValue root = new MapValue();
        Timestamp ts = new Timestamp(this.startTime);
        ts.setNanos(0);
        root.put("startTime", new TimestampValue(ts));
        ts = new Timestamp(this.endTime);
        ts.setNanos(0);
        root.put("endTime", new TimestampValue(ts));
        root.put("clientId", new StringValue(this.statsControl.getId()));
        this.connectionStats.toJSON(root);
        if (this.extraQueryStats != null) {
            this.extraQueryStats.toJSON(root);
        }
        if ((entries = new HashSet<Map.Entry<String, ReqStats>>(this.requests.entrySet())).size() > 0) {
            ArrayValue reqArray = new ArrayValue();
            root.put("requests", reqArray);
            entries.forEach(e -> {
                String k = (String)e.getKey();
                ReqStats v = (ReqStats)e.getValue();
                v.toJSON(k, reqArray);
            });
        }
        return root;
    }

    private void clearStats() {
        for (String key : this.requests.keySet()) {
            this.requests.get(key).clear();
        }
        this.connectionStats.clear();
        if (this.extraQueryStats != null) {
            this.extraQueryStats.clear();
        }
        this.startTime = System.currentTimeMillis();
        this.endTime = 0L;
    }

    void observeError(Request kvRequest, int connections) {
        this.observe(kvRequest, true, connections, -1, -1, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void observe(Request kvRequest, boolean error, int connections, int reqSize, int resSize, int requestLatency) {
        int authCount = 0;
        int throttleCount = 0;
        int retries = 0;
        int retryDelay = 0;
        RetryStats retryStats = kvRequest.getRetryStats();
        if (retryStats != null) {
            authCount = retryStats.getNumExceptions(AuthenticationException.class);
            authCount += retryStats.getNumExceptions(SecurityInfoNotReadyException.class);
            throttleCount = retryStats.getNumExceptions(ThrottlingException.class);
            retries = retryStats.getRetries();
            retryDelay = retryStats.getDelayMs();
        }
        int rateLimitDelay = kvRequest.getRateLimitDelayedMs();
        String requestName = kvRequest.getTypeName();
        ReqStats rStat = this.requests.get(requestName);
        if (rStat == null) {
            ReqStats newStat = new ReqStats();
            if (this.statsControl.getProfile().ordinal() >= StatsControl.Profile.MORE.ordinal()) {
                newStat.requestLatencyPercentile = new Percentile();
            }
            Map<String, ReqStats> map = this.requests;
            synchronized (map) {
                rStat = this.requests.get(requestName);
                if (rStat == null) {
                    this.requests.put(requestName, newStat);
                    rStat = newStat;
                }
            }
        }
        rStat.observe(error, retries, retryDelay, rateLimitDelay, authCount, throttleCount, reqSize, resSize, requestLatency);
        this.connectionStats.observe(connections);
        if (this.extraQueryStats == null && this.statsControl.getProfile().ordinal() >= StatsControl.Profile.ALL.ordinal()) {
            this.extraQueryStats = new ExtraQueryStats(this.statsControl);
        }
        if (this.extraQueryStats != null && this.statsControl.getProfile().ordinal() >= StatsControl.Profile.ALL.ordinal() && kvRequest instanceof QueryRequest) {
            QueryRequest queryRequest = (QueryRequest)kvRequest;
            this.extraQueryStats.observeQuery(queryRequest, error, retries, retryDelay, rateLimitDelay, authCount, throttleCount, reqSize, resSize, requestLatency);
        }
    }

    void observeQuery(QueryRequest qreq) {
        if (this.extraQueryStats == null && this.statsControl.getProfile().ordinal() >= StatsControl.Profile.ALL.ordinal()) {
            this.extraQueryStats = new ExtraQueryStats(this.statsControl);
        }
        if (this.extraQueryStats != null && this.statsControl.getProfile().ordinal() >= StatsControl.Profile.ALL.ordinal()) {
            this.extraQueryStats.observeQuery(qreq);
        }
    }

    void shutdown() {
        this.logClientStats();
        this.service.shutdown();
    }

    private static class ConnectionStats {
        private long count;
        private int min = Integer.MAX_VALUE;
        private int max;
        private long sum;

        private ConnectionStats() {
        }

        synchronized void observe(int connections) {
            if (connections < this.min) {
                this.min = connections;
            }
            if (connections > this.max) {
                this.max = connections;
            }
            this.sum += (long)connections;
            ++this.count;
        }

        synchronized void toJSON(MapValue root) {
            if (this.count > 0L) {
                MapValue connections = new MapValue();
                connections.put("min", this.min);
                connections.put("max", this.max);
                connections.put("avg", 1.0 * (double)this.sum / (double)this.count);
                root.put("connections", connections);
            }
        }

        synchronized void clear() {
            this.count = 0L;
            this.min = Integer.MAX_VALUE;
            this.max = 0;
            this.sum = 0L;
        }
    }

    private static class ReqStats {
        private long httpRequestCount = 0L;
        private long errors = 0L;
        private int reqSizeMin = Integer.MAX_VALUE;
        private int reqSizeMax = 0;
        private long reqSizeSum = 0L;
        private int resSizeMin = Integer.MAX_VALUE;
        private int resSizeMax = 0;
        private long resSizeSum = 0L;
        private int retryAuthCount = 0;
        private int retryThrottleCount = 0;
        private int retryCount = 0;
        private int retryDelayMs = 0;
        private int rateLimitDelayMs = 0;
        private int requestLatencyMin = Integer.MAX_VALUE;
        private int requestLatencyMax = 0;
        private long requestLatencySum = 0L;
        private Percentile requestLatencyPercentile;

        private ReqStats() {
        }

        synchronized void observe(boolean error, int retries, int retryDelay, int rateLimitDelay, int authCount, int throttleCount, int reqSize, int resSize, int requestLatency) {
            ++this.httpRequestCount;
            this.retryCount += retries;
            this.retryDelayMs += retryDelay;
            this.retryAuthCount += authCount;
            this.retryThrottleCount += throttleCount;
            this.rateLimitDelayMs += rateLimitDelay;
            if (error) {
                ++this.errors;
            } else {
                this.reqSizeMin = Math.min(this.reqSizeMin, reqSize);
                this.reqSizeMax = Math.max(this.reqSizeMax, reqSize);
                this.reqSizeSum += (long)reqSize;
                this.resSizeMin = Math.min(this.resSizeMin, resSize);
                this.resSizeMax = Math.max(this.resSizeMax, resSize);
                this.resSizeSum += (long)resSize;
                this.requestLatencyMin = Math.min(this.requestLatencyMin, requestLatency);
                this.requestLatencyMax = Math.max(this.requestLatencyMax, requestLatency);
                this.requestLatencySum += (long)requestLatency;
                if (this.requestLatencyPercentile != null) {
                    this.requestLatencyPercentile.addValue(requestLatency);
                }
            }
        }

        synchronized void toJSON(String requestName, ArrayValue reqArray) {
            if (this.httpRequestCount > 0L) {
                MapValue mapValue = new MapValue();
                mapValue.put("name", requestName);
                this.toMapValue(mapValue);
                reqArray.add(mapValue);
            }
        }

        private void toMapValue(MapValue mapValue) {
            mapValue.put("httpRequestCount", this.httpRequestCount);
            mapValue.put("errors", this.errors);
            MapValue retry = new MapValue();
            retry.put("count", this.retryCount);
            retry.put("delayMs", this.retryDelayMs);
            retry.put("authCount", this.retryAuthCount);
            retry.put("throttleCount", this.retryThrottleCount);
            mapValue.put("retry", retry);
            mapValue.put("rateLimitDelayMs", this.rateLimitDelayMs);
            if (this.requestLatencyMax > 0) {
                MapValue latency = new MapValue();
                latency.put("min", this.requestLatencyMin);
                latency.put("max", this.requestLatencyMax);
                latency.put("avg", 1.0 * (double)this.requestLatencySum / (double)(this.httpRequestCount - this.errors));
                if (this.requestLatencyPercentile != null) {
                    latency.put("95th", this.requestLatencyPercentile.get95thPercentile());
                    latency.put("99th", this.requestLatencyPercentile.get99thPercentile());
                }
                mapValue.put("httpRequestLatencyMs", latency);
            }
            if (this.reqSizeMax > 0) {
                MapValue reqSize = new MapValue();
                reqSize.put("min", this.reqSizeMin);
                reqSize.put("max", this.reqSizeMax);
                reqSize.put("avg", 1.0 * (double)this.reqSizeSum / (double)(this.httpRequestCount - this.errors));
                mapValue.put("requestSize", reqSize);
            }
            if (this.resSizeMax > 0) {
                MapValue resSize = new MapValue();
                resSize.put("min", this.resSizeMin);
                resSize.put("max", this.resSizeMax);
                resSize.put("avg", 1.0 * (double)this.resSizeSum / (double)(this.httpRequestCount - this.errors));
                mapValue.put("resultSize", resSize);
            }
        }

        synchronized void clear() {
            this.httpRequestCount = 0L;
            this.errors = 0L;
            this.reqSizeMin = Integer.MAX_VALUE;
            this.reqSizeMax = 0;
            this.reqSizeSum = 0L;
            this.resSizeMin = Integer.MAX_VALUE;
            this.resSizeMax = 0;
            this.resSizeSum = 0L;
            this.retryAuthCount = 0;
            this.retryThrottleCount = 0;
            this.retryCount = 0;
            this.retryDelayMs = 0;
            this.rateLimitDelayMs = 0;
            this.requestLatencyMin = Integer.MAX_VALUE;
            this.requestLatencyMax = 0;
            this.requestLatencySum = 0L;
            if (this.requestLatencyPercentile != null) {
                this.requestLatencyPercentile.clear();
            }
        }
    }

    private static class Percentile {
        private List<Long> values;

        private Percentile() {
        }

        synchronized void addValue(long value) {
            if (this.values == null) {
                this.values = new ArrayList<Long>();
            }
            this.values.add(value);
        }

        synchronized long getPercentile(double percentile) {
            if (this.values == null || this.values.size() == 0) {
                return -1L;
            }
            this.values.sort(Comparator.comparingLong(Long::longValue));
            int index = (int)Math.round(percentile * (double)this.values.size() - 1.0);
            if (index < 0) {
                index = 0;
            }
            if (index >= this.values.size()) {
                index = this.values.size() - 1;
            }
            return this.values.get(index);
        }

        long get95thPercentile() {
            return this.getPercentile(0.95);
        }

        long get99thPercentile() {
            return this.getPercentile(0.99);
        }

        synchronized void clear() {
            if (this.values != null) {
                this.values.clear();
            }
        }
    }

    static class ExtraQueryStats {
        private Map<String, QueryEntryStat> queries = new HashMap<String, QueryEntryStat>();
        private StatsControl statsConfig;

        ExtraQueryStats(StatsControl statsConfig) {
            this.statsConfig = statsConfig;
        }

        synchronized void observeQuery(QueryRequest queryRequest) {
            QueryEntryStat qStat = this.getExtraQueryStat(queryRequest);
            ++qStat.count;
            if (!queryRequest.isPrepared()) {
                ++qStat.unprepared;
            } else {
                qStat.simple = queryRequest.isSimpleQuery();
            }
        }

        synchronized void observeQuery(QueryRequest queryRequest, boolean error, int retries, int retryDelay, int rateLimitDelay, int authCount, int throttleCount, int reqSize, int resSize, int requestLatency) {
            QueryEntryStat qStat = this.getExtraQueryStat(queryRequest);
            qStat.reqStats.httpRequestCount++;
            if (error) {
                qStat.reqStats.errors++;
            }
            qStat.reqStats.retryCount += retries;
            qStat.reqStats.retryDelayMs += retryDelay;
            qStat.reqStats.rateLimitDelayMs += rateLimitDelay;
            qStat.reqStats.retryAuthCount += authCount;
            qStat.reqStats.retryThrottleCount += throttleCount;
            qStat.reqStats.reqSizeSum += reqSize;
            qStat.reqStats.reqSizeMin = Math.min(qStat.reqStats.reqSizeMin, reqSize);
            qStat.reqStats.reqSizeMax = Math.max(qStat.reqStats.reqSizeMax, reqSize);
            qStat.reqStats.resSizeSum += resSize;
            qStat.reqStats.resSizeMin = Math.min(qStat.reqStats.resSizeMin, resSize);
            qStat.reqStats.resSizeMax = Math.max(qStat.reqStats.resSizeMax, resSize);
            qStat.reqStats.requestLatencySum += requestLatency;
            qStat.reqStats.requestLatencyMin = Math.min(qStat.reqStats.requestLatencyMin, requestLatency);
            qStat.reqStats.requestLatencyMax = Math.max(qStat.reqStats.requestLatencyMax, requestLatency);
            if (qStat.reqStats.requestLatencyPercentile != null) {
                qStat.reqStats.requestLatencyPercentile.addValue(requestLatency);
            }
        }

        private QueryEntryStat getExtraQueryStat(QueryRequest queryRequest) {
            PreparedStatement pStmt;
            QueryEntryStat qStat;
            String sql = queryRequest.getStatement();
            if (sql == null && queryRequest.getPreparedStatement() != null) {
                sql = queryRequest.getPreparedStatement().getSQLText();
            }
            if ((qStat = this.queries.get(sql)) == null) {
                qStat = new QueryEntryStat(this.statsConfig, queryRequest);
                this.queries.put(sql, qStat);
            }
            if (qStat.plan == null && (pStmt = queryRequest.getPreparedStatement()) != null) {
                qStat.plan = pStmt.printDriverPlan();
                qStat.doesWrites = pStmt.doesWrites();
            }
            return qStat;
        }

        synchronized void toJSON(MapValue root) {
            if (this.queries.size() > 0) {
                ArrayValue queryArr = new ArrayValue();
                root.put("queries", queryArr);
                this.queries.forEach((key, val) -> {
                    MapValue queryVal = new MapValue();
                    queryArr.add(queryVal);
                    queryVal.put("query", key == null ? "null" : key);
                    queryVal.put("count", val.count);
                    queryVal.put("unprepared", val.unprepared);
                    queryVal.put("simple", val.simple);
                    queryVal.put("doesWrites", val.doesWrites);
                    if (val.plan != null) {
                        queryVal.put("plan", val.plan);
                    }
                    val.reqStats.toMapValue(queryVal);
                });
            }
        }

        synchronized void clear() {
            this.queries.clear();
        }

        static class QueryEntryStat {
            long count;
            long unprepared;
            boolean simple;
            boolean doesWrites;
            ReqStats reqStats = new ReqStats();
            String plan;

            QueryEntryStat(StatsControl statsConfig, QueryRequest queryRequest) {
                PreparedStatement pStmt;
                if (statsConfig.getProfile().ordinal() >= StatsControl.Profile.MORE.ordinal()) {
                    this.reqStats.requestLatencyPercentile = new Percentile();
                }
                if ((pStmt = queryRequest.getPreparedStatement()) != null) {
                    this.plan = pStmt.printDriverPlan();
                    this.doesWrites = pStmt.doesWrites();
                }
            }
        }
    }
}

