/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.http;

import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.nosql.driver.NoSQLHandleConfig;
import oracle.nosql.driver.StatsControl;
import oracle.nosql.driver.http.Stats;
import oracle.nosql.driver.httpclient.HttpClient;
import oracle.nosql.driver.ops.QueryRequest;
import oracle.nosql.driver.ops.Request;

public class StatsControlImpl
implements StatsControl {
    private StatsControl.Profile profile;
    private int interval;
    private boolean prettyPrint;
    private Logger logger;
    private HttpClient httpClient;
    private String id = Integer.toHexString(UUID.randomUUID().hashCode());
    private StatsControl.StatsHandler statsHandler;
    private boolean enableCollection = false;
    private Stats stats;

    StatsControlImpl(NoSQLHandleConfig config, Logger logger, HttpClient httpClient, boolean rateLimitingEnabled) {
        this.logger = logger;
        this.httpClient = httpClient;
        this.interval = config.getStatsInterval();
        this.profile = config.getStatsProfile();
        this.prettyPrint = config.getStatsPrettyPrint();
        this.statsHandler = config.getStatsHandler();
        if (this.profile != StatsControl.Profile.NONE) {
            if (config.getStatsEnableLog() && !logger.isLoggable(Level.INFO)) {
                logger.setLevel(Level.INFO);
            }
            logger.log(Level.INFO, "Client stats|{\"sdkName\" : \"Oracle NoSQL SDK for Java\", \"sdkVersion\" : \"" + NoSQLHandleConfig.getLibraryVersion() + "\", \"clientId\" : \"" + this.id + "\", \"profile\" : \"" + (Object)((Object)this.profile) + "\", \"intervalSec\" : " + this.interval + ", \"prettyPrint\" : " + this.prettyPrint + ", \"rateLimitingEnabled\" : " + rateLimitingEnabled + "}");
            this.start();
        }
    }

    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public int getInterval() {
        return this.interval;
    }

    @Override
    public StatsControl setProfile(StatsControl.Profile profile) {
        this.profile = profile;
        return this;
    }

    @Override
    public StatsControl.Profile getProfile() {
        return this.profile;
    }

    @Override
    public StatsControl setPrettyPrint(boolean enablePrettyPrint) {
        this.prettyPrint = enablePrettyPrint;
        return this;
    }

    @Override
    public boolean getPrettyPrint() {
        return this.prettyPrint;
    }

    @Override
    public StatsControl setStatsHandler(StatsControl.StatsHandler statsHandler) {
        this.statsHandler = statsHandler;
        return this;
    }

    @Override
    public StatsControl.StatsHandler getStatsHandler() {
        return this.statsHandler;
    }

    @Override
    public void start() {
        if (this.profile != StatsControl.Profile.NONE && this.stats == null) {
            this.stats = new Stats(this);
        }
        this.enableCollection = true;
    }

    @Override
    public void stop() {
        this.enableCollection = false;
    }

    @Override
    public boolean isStarted() {
        return this.enableCollection;
    }

    public String getId() {
        return this.id;
    }

    public void shutdown() {
        if (this.stats != null) {
            this.stats.shutdown();
        }
    }

    void observe(Request kvRequest, int networkLatency, int reqSize, int resSize) {
        if (this.stats != null && this.enableCollection) {
            this.stats.observe(kvRequest, false, this.httpClient.getAcquiredChannelCount(), reqSize, resSize, networkLatency);
        }
    }

    void observeError(Request kvRequest) {
        if (this.stats != null && this.enableCollection) {
            this.stats.observeError(kvRequest, this.httpClient.getAcquiredChannelCount());
        }
    }

    public void observeQuery(QueryRequest qreq) {
        if (this.stats != null && this.enableCollection) {
            this.stats.observeQuery(qreq);
        }
    }
}

