/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.iam;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.security.auth.Refreshable;
import oracle.nosql.driver.iam.PrivateKeyProvider;
import oracle.nosql.driver.iam.Utils;

interface CertificateSupplier {
    public X509CertificateKeyPair getCertificateAndKeyPair();

    public static class URLResourceDetails {
        private URL url;
        private Map<String, String> headers;

        URLResourceDetails(URL url) {
            this.url = url;
        }

        URL getURL() {
            return this.url;
        }

        URLResourceDetails addHeader(String name, String value) {
            if (this.headers == null) {
                this.headers = new HashMap<String, String>();
            }
            this.headers.put(name, value);
            return this;
        }

        Map<String, String> getURLHeaders() {
            return this.headers;
        }
    }

    public static class DefaultCertificateSupplier
    implements CertificateSupplier,
    Refreshable {
        private final AtomicReference<X509CertificateKeyPair> keyPair = new AtomicReference<Object>(null);
        private final URLResourceDetails certificateUrl;
        private final URLResourceDetails privateKeyUrl;
        private final char[] keyPass;

        DefaultCertificateSupplier(URLResourceDetails certificateUrl, URLResourceDetails privateKeyUrl, char[] keyPassphrase) {
            this.certificateUrl = certificateUrl;
            this.privateKeyUrl = privateKeyUrl;
            this.keyPass = keyPassphrase;
            this.refresh();
        }

        @Override
        public X509CertificateKeyPair getCertificateAndKeyPair() {
            return this.keyPair.get();
        }

        @Override
        public boolean isCurrent() {
            return false;
        }

        @Override
        public void refresh() {
            String rawCertificate = DefaultCertificateSupplier.readRawCertificate(this.certificateUrl);
            X509Certificate certificate = DefaultCertificateSupplier.readCertificate(rawCertificate);
            RSAPrivateKey key = DefaultCertificateSupplier.readPrivateKey(this.privateKeyUrl, this.keyPass);
            this.keyPair.set(new X509CertificateKeyPair(rawCertificate, certificate, key));
        }

        private static X509Certificate readCertificate(String certificate) {
            try {
                CertificateFactory factory = CertificateFactory.getInstance("X.509");
                return (X509Certificate)factory.generateCertificate(new ByteArrayInputStream(certificate.getBytes()));
            }
            catch (CertificateException e) {
                throw new IllegalArgumentException("Invalid certificate.", e);
            }
        }

        private static String readRawCertificate(URLResourceDetails certURL) {
            String string;
            block8: {
                InputStream is = DefaultCertificateSupplier.getResourceStream(certURL);
                try {
                    string = Utils.readStream(is);
                    if (is == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new IllegalArgumentException("Unable to read certificate from " + certURL.getURL(), e);
                    }
                }
                is.close();
            }
            return string;
        }

        private static RSAPrivateKey readPrivateKey(URLResourceDetails keyURL, char[] keyPassphrase) {
            if (keyURL == null) {
                return null;
            }
            try {
                return new PrivateKeyProvider(DefaultCertificateSupplier.getResourceStream(keyURL), keyPassphrase).getKey();
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unable to read private key from " + keyURL.getURL(), e);
            }
        }

        private static InputStream getResourceStream(URLResourceDetails urd) throws IOException {
            URLConnection urlConnection = urd.getURL().openConnection();
            if (urd.getURLHeaders() != null) {
                urd.getURLHeaders().forEach(urlConnection::setRequestProperty);
            }
            return urlConnection.getInputStream();
        }
    }

    public static class X509CertificateKeyPair {
        private final X509Certificate certificate;
        private final String rawCertificate;
        private final RSAPrivateKey privateKey;

        public X509CertificateKeyPair(String rawCert, X509Certificate cert, RSAPrivateKey key) {
            this.rawCertificate = rawCert;
            this.certificate = cert;
            this.privateKey = key;
        }

        public String getRawCertificate() {
            return this.rawCertificate;
        }

        public X509Certificate getCertificate() {
            return this.certificate;
        }

        public RSAPrivateKey getKey() {
            return this.privateKey;
        }
    }
}

