/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.iam;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import oracle.nosql.driver.Region;
import oracle.nosql.driver.iam.Utils;

public class OCIConfigFileReader {
    public static final String DEFAULT_FILE_PATH = System.getProperty("user.home") + File.separator + ".oci" + File.separator + "config";
    public static final String DEFAULT_PROFILE_NAME = "DEFAULT";
    static final String FINGERPRINT_PROP = "fingerprint";
    static final String TENANCY_PROP = "tenancy";
    static final String USER_PROP = "user";
    static final String KEY_FILE_PROP = "key_file";
    static final String PASSPHRASE_PROP = "pass_phrase";
    static final String REGION_PROP = "region";
    static final String SESSION_TOKEN_FILE_PROP = "security_token_file";
    static final String OCI_REGION_ENV_VAR_NAME = "OCI_REGION";

    public static OCIConfigFile parse(String configFilePath) throws IOException {
        return OCIConfigFileReader.parse(configFilePath, null);
    }

    public static OCIConfigFile parse(String configFilePath, String profile) throws IOException {
        return OCIConfigFileReader.parse(new FileInputStream(new File(Utils.expandUserHome(configFilePath))), profile);
    }

    public static OCIConfigFile parse(InputStream configStream, String profile) throws IOException {
        return OCIConfigFileReader.parse(configStream, profile, StandardCharsets.UTF_8);
    }

    public static OCIConfigFile parse(InputStream configStream, String profile, Charset charset) throws IOException {
        OCIConfigAccumulator accumulator = new OCIConfigAccumulator();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(configStream, charset));){
            String line = null;
            while ((line = reader.readLine()) != null) {
                accumulator.accept(line);
            }
        }
        if (profile != null && !accumulator.configs.containsKey(profile)) {
            throw new IllegalArgumentException("No profile named " + profile + " exists in the OCI configuration file");
        }
        return new OCIConfigFile(accumulator, profile);
    }

    static String missing(String propertyName) {
        return "Required property " + propertyName + " is missing from OCI configuration file. For more information about OCI configuration file and how to get required information, see https://docs.oracle.com/en-us/iaas/Content/API/Concepts/sdkconfig.htm";
    }

    static Region getRegionFromConfigFile(OCIConfigFile configFile) {
        Region region = null;
        String regionId = configFile.get(REGION_PROP);
        if (regionId == null || regionId.isEmpty()) {
            regionId = System.getenv(OCI_REGION_ENV_VAR_NAME);
        }
        if (regionId != null && !regionId.isEmpty()) {
            return Region.fromRegionId(regionId);
        }
        return region;
    }

    private OCIConfigFileReader() {
    }

    public static final class OCIConfigFile {
        private final OCIConfigAccumulator accumulator;
        private final String profile;

        private OCIConfigFile(OCIConfigAccumulator accumulator, String profile) {
            this.accumulator = accumulator;
            this.profile = profile;
        }

        public String get(String key) {
            if (this.profile != null && this.accumulator.configs.get(this.profile).containsKey(key)) {
                return this.accumulator.configs.get(this.profile).get(key);
            }
            return this.accumulator.foundDefaultProfile ? this.accumulator.configs.get(OCIConfigFileReader.DEFAULT_PROFILE_NAME).get(key) : null;
        }
    }

    private static final class OCIConfigAccumulator {
        final Map<String, Map<String, String>> configs = new HashMap<String, Map<String, String>>();
        private String currentProfile = null;
        private boolean foundDefaultProfile = false;

        private OCIConfigAccumulator() {
        }

        private void accept(String line) {
            String msg = "Invalid line in OCI configuration file, expected \"key=value\" or \"[profile-name]\", found ";
            String trimmedLine = line.trim();
            if (trimmedLine.isEmpty()) {
                return;
            }
            if (trimmedLine.charAt(0) == '#') {
                return;
            }
            if (trimmedLine.charAt(0) == '[' && trimmedLine.charAt(trimmedLine.length() - 1) == ']') {
                this.currentProfile = trimmedLine.substring(1, trimmedLine.length() - 1).trim();
                if (this.currentProfile.isEmpty()) {
                    throw new IllegalArgumentException("Invalid line in OCI configuration file, expected \"key=value\" or \"[profile-name]\", found []");
                }
                if (this.currentProfile.equals(OCIConfigFileReader.DEFAULT_PROFILE_NAME)) {
                    this.foundDefaultProfile = true;
                }
                if (!this.configs.containsKey(this.currentProfile)) {
                    this.configs.put(this.currentProfile, new HashMap());
                }
                return;
            }
            int splitIndex = trimmedLine.indexOf(61);
            if (splitIndex == -1) {
                throw new IllegalArgumentException("Invalid line in OCI configuration file, expected \"key=value\" or \"[profile-name]\", found " + line);
            }
            String key = trimmedLine.substring(0, splitIndex).trim();
            String value = trimmedLine.substring(splitIndex + 1).trim();
            if (key.isEmpty()) {
                throw new IllegalArgumentException("Invalid line in OCI configuration file, expected \"key=value\" or \"[profile-name]\", found " + line);
            }
            if (this.currentProfile == null) {
                throw new IllegalArgumentException("Invalid OCI configuration file: no profile specified");
            }
            this.configs.get(this.currentProfile).put(key, value);
        }
    }
}

