/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.iam;

import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.security.PrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.Arrays;
import oracle.nosql.driver.iam.AuthenticationProfileProvider;
import oracle.nosql.driver.iam.pki.Pem;
import oracle.nosql.driver.iam.pki.PemEncryptionException;
import oracle.nosql.driver.iam.pki.PemException;

class PrivateKeyProvider {
    private RSAPrivateKey key = null;

    PrivateKeyProvider(AuthenticationProfileProvider provider) {
        this(provider.getPrivateKey(), provider.getPassphraseCharacters());
    }

    PrivateKeyProvider(InputStream keyInputStream, char[] passphrase) {
        this.getKeyInternal(keyInputStream, passphrase);
    }

    RSAPrivateKey getKey() {
        return this.key;
    }

    void reload(InputStream keyInputStream, char[] passphrase) {
        this.getKeyInternal(keyInputStream, passphrase);
    }

    void getKeyInternal(InputStream keyInputStream, char[] passphrase) {
        block26: {
            try (ReadableByteChannel channel = Channels.newChannel(keyInputStream);
                 Pem.Passphrase pemPassphrase = Pem.Passphrase.of(passphrase);){
                PrivateKey privateKey = Pem.decoder().with(pemPassphrase).decodePrivateKey(channel);
                if (privateKey instanceof RSAPrivateKey) {
                    this.key = (RSAPrivateKey)privateKey;
                    break block26;
                }
                throw new IllegalArgumentException("Must be RSA private key, but " + privateKey.toString());
            }
            catch (PemEncryptionException e) {
                throw new IllegalArgumentException("The provided passphrase is incorrect.", e);
            }
            catch (PemException e) {
                throw new IllegalArgumentException("Private key must be in PEM format", e);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Error reading private key", e);
            }
            finally {
                if (keyInputStream != null) {
                    try {
                        keyInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (passphrase != null) {
                    Arrays.fill(passphrase, ' ');
                }
            }
        }
    }
}

