/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.iam;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import oracle.nosql.driver.iam.PrivateKeyProvider;
import oracle.nosql.driver.iam.Utils;

interface SessionKeyPairSupplier {
    public KeyPair getKeyPair();

    public void refreshKeys();

    public static class FixedKeyPairSupplier
    implements SessionKeyPairSupplier {
        private final KeyPair keyPair;

        FixedKeyPairSupplier(String privateKeyContents, char[] passphrase) {
            RSAPrivateKey privateKey = new PrivateKeyProvider(new ByteArrayInputStream(privateKeyContents.getBytes()), passphrase).getKey();
            try {
                KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                RSAPrivateCrtKeySpec keySpec = keyFactory.getKeySpec(keyFactory.translateKey(privateKey), RSAPrivateCrtKeySpec.class);
                RSAPublicKey publicKey = (RSAPublicKey)keyFactory.generatePublic(new RSAPublicKeySpec(keySpec.getModulus(), keySpec.getPublicExponent()));
                this.keyPair = new KeyPair(publicKey, privateKey);
            }
            catch (InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException e) {
                throw new IllegalStateException("Unable to intercept private key " + privateKeyContents, e);
            }
        }

        @Override
        public KeyPair getKeyPair() {
            return this.keyPair;
        }

        @Override
        public void refreshKeys() {
        }
    }

    public static class FileKeyPairSupplier
    implements SessionKeyPairSupplier {
        private final String privateKeyPath;
        private final Path passphrasePath;
        private KeyPair keyPair = null;

        FileKeyPairSupplier(String privateKeyPath, String passphrasePath) {
            this.privateKeyPath = privateKeyPath;
            this.passphrasePath = passphrasePath != null ? new File(passphrasePath).toPath() : null;
            this.refreshKeys();
        }

        @Override
        public KeyPair getKeyPair() {
            return this.keyPair;
        }

        @Override
        public void refreshKeys() {
            if (this.privateKeyPath == null) {
                throw new IllegalArgumentException("privateKeyPath not set");
            }
            try (FileInputStream in = new FileInputStream(this.privateKeyPath);){
                char[] pass = null;
                if (this.passphrasePath != null) {
                    pass = new String(Files.readAllBytes(this.passphrasePath)).toCharArray();
                }
                RSAPrivateKey privateKey = new PrivateKeyProvider(in, pass).getKey();
                KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                RSAPrivateCrtKeySpec keySpec = keyFactory.getKeySpec(keyFactory.translateKey(privateKey), RSAPrivateCrtKeySpec.class);
                RSAPublicKey publicKey = (RSAPublicKey)keyFactory.generatePublic(new RSAPublicKeySpec(keySpec.getModulus(), keySpec.getPublicExponent()));
                this.keyPair = new KeyPair(publicKey, privateKey);
            }
            catch (FileNotFoundException e) {
                throw new IllegalArgumentException(this.privateKeyPath + " doesn't exist", e);
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to read passphrase from " + this.passphrasePath, e);
            }
            catch (InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException e) {
                throw new IllegalStateException("Unable to intercept private key", e);
            }
        }
    }

    public static class JDKKeyPairSupplier
    implements SessionKeyPairSupplier {
        private static final KeyPairGenerator GENERATOR;
        private KeyPair keyPair = GENERATOR.generateKeyPair();

        protected JDKKeyPairSupplier() {
        }

        @Override
        public KeyPair getKeyPair() {
            return this.keyPair;
        }

        @Override
        public void refreshKeys() {
            this.keyPair = GENERATOR.generateKeyPair();
        }

        static {
            try {
                GENERATOR = KeyPairGenerator.getInstance("RSA");
                GENERATOR.initialize(2048);
            }
            catch (NoSuchAlgorithmException e) {
                throw new Error(e.getMessage());
            }
        }
    }

    public static class DefaultSessionKeySupplier
    implements SessionKeyPairSupplier {
        private final SessionKeyPairSupplier delegate;
        private RSAPrivateKey lastPrivateKey = null;
        private byte[] privateKeyBytes = null;

        protected DefaultSessionKeySupplier(SessionKeyPairSupplier delegate) {
            this.delegate = delegate;
            this.setPrivateKeyBytes((RSAPrivateKey)delegate.getKeyPair().getPrivate());
        }

        @Override
        public KeyPair getKeyPair() {
            return this.delegate.getKeyPair();
        }

        @Override
        public synchronized void refreshKeys() {
            this.delegate.refreshKeys();
        }

        protected synchronized byte[] getPrivateKeyBytes() {
            this.setPrivateKeyBytes((RSAPrivateKey)this.getKeyPair().getPrivate());
            return this.privateKeyBytes;
        }

        private void setPrivateKeyBytes(RSAPrivateKey privateKey) {
            if (privateKey != null && privateKey != this.lastPrivateKey) {
                this.lastPrivateKey = privateKey;
                this.privateKeyBytes = Utils.toByteArray(privateKey);
            }
        }
    }
}

