/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.iam;

import io.netty.handler.codec.http.HttpHeaders;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.nosql.driver.AuthorizationProvider;
import oracle.nosql.driver.NoSQLHandleConfig;
import oracle.nosql.driver.Region;
import oracle.nosql.driver.SecurityInfoNotReadyException;
import oracle.nosql.driver.iam.AuthenticationProfileProvider;
import oracle.nosql.driver.iam.InstancePrincipalsProvider;
import oracle.nosql.driver.iam.OCIConfigFileProvider;
import oracle.nosql.driver.iam.OkeWorkloadIdentityProvider;
import oracle.nosql.driver.iam.PrivateKeyFileSupplier;
import oracle.nosql.driver.iam.PrivateKeyProvider;
import oracle.nosql.driver.iam.PrivateKeyStringSupplier;
import oracle.nosql.driver.iam.ResourcePrincipalProvider;
import oracle.nosql.driver.iam.SecurityTokenSupplier;
import oracle.nosql.driver.iam.SessionTokenProvider;
import oracle.nosql.driver.iam.SimpleProfileProvider;
import oracle.nosql.driver.iam.UserAuthenticationProfileProvider;
import oracle.nosql.driver.iam.Utils;
import oracle.nosql.driver.ops.Request;
import oracle.nosql.driver.util.HttpConstants;

public class SignatureProvider
implements AuthorizationProvider,
Region.RegionProvider {
    private static final String SIGNING_HEADERS = "(request-target) host date";
    private static final String SIGNING_HEADERS_WITH_OBO = "(request-target) host date opc-obo-token";
    private static final String SIGNING_HEADERS_WITH_CONTENT = "(request-target) host date content-length content-type x-content-sha256";
    private static final String SIGNING_HEADERS_WITH_CONTENT_OBO = "(request-target) host date content-length content-type x-content-sha256 opc-obo-token";
    private static final String OBO_TOKEN_HEADER = "opc-obo-token";
    protected static final int MAX_ENTRY_LIFE_TIME = 240;
    protected static final int DEFAULT_REFRESH_AHEAD = 20000;
    private final AuthenticationProfileProvider provider;
    private final PrivateKeyProvider privateKeyProvider;
    private String delegationToken;
    private SignatureDetails currentSigDetails;
    private SignatureDetails refreshSigDetails;
    private volatile Timer refresher;
    private long refreshAheadMs = 20000L;
    private long refreshIntervalMs = 0L;
    private String serviceHost;
    private Region region;
    private Logger logger;
    private OnSignatureRefresh onSigRefresh;

    public SignatureProvider() throws IOException {
        this(new OCIConfigFileProvider());
    }

    public SignatureProvider(String profileName) throws IOException {
        this(new OCIConfigFileProvider(profileName));
    }

    public SignatureProvider(String configFile, String profileName) throws IOException {
        this(new OCIConfigFileProvider(configFile, profileName));
    }

    public SignatureProvider(String tenantId, String userId, String fingerprint, String privateKey, char[] passphrase) {
        this(SimpleProfileProvider.builder().tenantId(tenantId).userId(userId).fingerprint(fingerprint).passphrase(passphrase).privateKeySupplier(new PrivateKeyStringSupplier(privateKey)).build());
    }

    public SignatureProvider(String tenantId, String userId, String fingerprint, File privateKeyFile, char[] passphrase) {
        this(SimpleProfileProvider.builder().tenantId(tenantId).userId(userId).fingerprint(fingerprint).passphrase(passphrase).privateKeySupplier(new PrivateKeyFileSupplier(privateKeyFile)).build());
    }

    public SignatureProvider(String tenantId, String userId, String fingerprint, File privateKeyFile, char[] passphrase, Region region) {
        this(SimpleProfileProvider.builder().tenantId(tenantId).userId(userId).fingerprint(fingerprint).passphrase(passphrase).privateKeySupplier(new PrivateKeyFileSupplier(privateKeyFile)).region(region).build());
    }

    public static SignatureProvider createWithInstancePrincipal() {
        return new SignatureProvider(InstancePrincipalsProvider.builder().build());
    }

    public static SignatureProvider createWithInstancePrincipal(Region region) {
        return new SignatureProvider(InstancePrincipalsProvider.builder().setRegion(region).build());
    }

    public static SignatureProvider createWithInstancePrincipal(String iamAuthUrl) {
        return new SignatureProvider(InstancePrincipalsProvider.builder().setFederationEndpoint(iamAuthUrl).build());
    }

    public static SignatureProvider createWithInstancePrincipal(String iamAuthUrl, Region region, Logger logger) {
        SignatureProvider provider = new SignatureProvider(InstancePrincipalsProvider.builder().setFederationEndpoint(iamAuthUrl).setLogger(logger).setRegion(region).build());
        provider.setLogger(logger);
        return provider;
    }

    public static SignatureProvider createWithInstancePrincipalForDelegation(String delegationToken) {
        SignatureProvider provider = new SignatureProvider(InstancePrincipalsProvider.builder().build());
        provider.setDelegationToken(delegationToken);
        return provider;
    }

    public static SignatureProvider createWithInstancePrincipalForDelegation(String iamAuthUrl, Region region, String delegationToken, Logger logger) {
        SignatureProvider provider = new SignatureProvider(InstancePrincipalsProvider.builder().setFederationEndpoint(iamAuthUrl).setLogger(logger).setRegion(region).build());
        provider.setLogger(logger);
        provider.setDelegationToken(delegationToken);
        return provider;
    }

    public static SignatureProvider createWithInstancePrincipalForDelegation(File delegationTokenFile) {
        String token;
        SignatureProvider provider = new SignatureProvider(InstancePrincipalsProvider.builder().build());
        try {
            token = SignatureProvider.readFile(delegationTokenFile);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to read the token from " + delegationTokenFile, e);
        }
        provider.setDelegationToken(token);
        return provider;
    }

    public static SignatureProvider createWithInstancePrincipalForDelegation(String iamAuthUrl, Region region, File delegationTokenFile, Logger logger) {
        String token;
        SignatureProvider provider = new SignatureProvider(InstancePrincipalsProvider.builder().setFederationEndpoint(iamAuthUrl).setLogger(logger).setRegion(region).build());
        provider.setLogger(logger);
        try {
            token = SignatureProvider.readFile(delegationTokenFile);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to read the token from " + delegationTokenFile, e);
        }
        provider.setDelegationToken(token);
        return provider;
    }

    public static SignatureProvider createWithResourcePrincipal() {
        return SignatureProvider.createWithResourcePrincipal(null);
    }

    public static SignatureProvider createWithResourcePrincipal(Logger logger) {
        SignatureProvider provider = new SignatureProvider(ResourcePrincipalProvider.build(logger));
        provider.setLogger(logger);
        return provider;
    }

    public static SignatureProvider createWithSessionToken() {
        SignatureProvider provider = new SignatureProvider(new SessionTokenProvider());
        return provider;
    }

    public static SignatureProvider createWithSessionToken(String profile) {
        SignatureProvider provider = new SignatureProvider(new SessionTokenProvider(profile));
        return provider;
    }

    public static SignatureProvider createWithSessionToken(String configFilePath, String profile) {
        SignatureProvider provider = new SignatureProvider(new SessionTokenProvider(configFilePath, profile));
        return provider;
    }

    public static SignatureProvider createWithOkeWorkloadIdentity() {
        SignatureProvider provider = new SignatureProvider(new OkeWorkloadIdentityProvider(null, null, null));
        return provider;
    }

    public static SignatureProvider createWithOkeWorkloadIdentity(String serviceAccountToken, Logger logger) {
        SignatureProvider provider = new SignatureProvider(new OkeWorkloadIdentityProvider(serviceAccountToken, null, logger));
        return provider;
    }

    public static SignatureProvider createWithOkeWorkloadIdentity(File serviceAccountTokenFile, Logger logger) {
        SignatureProvider provider = new SignatureProvider(new OkeWorkloadIdentityProvider(null, serviceAccountTokenFile, logger));
        return provider;
    }

    public SignatureProvider(AuthenticationProfileProvider provider) {
        this(provider, 240, 20000);
    }

    public SignatureProvider(AuthenticationProfileProvider profileProvider, int durationSeconds, int refreshAheadMs) {
        if (profileProvider instanceof Region.RegionProvider) {
            this.region = ((Region.RegionProvider)((Object)profileProvider)).getRegion();
        }
        this.provider = profileProvider;
        PrivateKeyProvider privateKeyProvider = this.privateKeyProvider = this.provider == null ? null : new PrivateKeyProvider(this.provider);
        if (durationSeconds > 240) {
            throw new IllegalArgumentException("Signature cannot be cached longer than 240 seconds");
        }
        this.refreshAheadMs = refreshAheadMs;
        long durationMS = durationSeconds * 1000;
        if (durationMS > (long)refreshAheadMs) {
            this.refreshIntervalMs = durationMS - (long)refreshAheadMs;
        }
        if (this.provider instanceof SecurityTokenSupplier.SecurityTokenBasedProvider) {
            ((SecurityTokenSupplier.SecurityTokenBasedProvider)((Object)this.provider)).setMinTokenLifetime(durationMS);
        }
    }

    @Override
    public String getAuthorizationString(Request request) {
        if (this.serviceHost == null) {
            throw new IllegalArgumentException("Unable to find service host, use setServiceHost to load from NoSQLHandleConfig");
        }
        SignatureDetails sigDetails = this.getSignatureDetails(request);
        if (sigDetails != null) {
            return sigDetails.getSignatureHeader();
        }
        return null;
    }

    @Override
    public void setRequiredHeaders(String authString, Request request, HttpHeaders headers, byte[] content) {
        String compartment;
        SignatureDetails sigDetails;
        SignatureDetails signatureDetails = sigDetails = content != null ? this.getSignatureWithContent(request, headers, content) : this.getSignatureDetails(request);
        if (sigDetails == null) {
            return;
        }
        headers.add("Authorization", (Object)sigDetails.getSignatureHeader());
        headers.add("date", (Object)sigDetails.getDate());
        String token = this.getDelegationToken(request);
        if (token != null) {
            headers.add(OBO_TOKEN_HEADER, (Object)token);
        }
        if ((compartment = request.getCompartment()) == null) {
            compartment = this.getTenantOCID();
        }
        if (compartment == null) {
            throw new IllegalArgumentException("Compartment is null. When authenticating using an Instance Principal the compartment for the operation must be specified.");
        }
        headers.add("x-nosql-compartment-id", (Object)compartment);
    }

    @Override
    public synchronized void flushCache() {
        this.currentSigDetails = null;
        this.refreshSigDetails = null;
    }

    private String getTenantOCID() {
        if (this.provider instanceof UserAuthenticationProfileProvider) {
            return ((UserAuthenticationProfileProvider)this.provider).getTenantId();
        }
        if (this.provider instanceof SessionTokenProvider) {
            return ((SessionTokenProvider)this.provider).getTenantId();
        }
        return null;
    }

    @Override
    public void close() {
        if (this.refresher != null) {
            this.refresher.cancel();
            this.refresher = null;
        }
        if (this.provider instanceof SecurityTokenSupplier.SecurityTokenBasedProvider) {
            ((SecurityTokenSupplier.SecurityTokenBasedProvider)((Object)this.provider)).close();
        }
    }

    @Override
    public Region getRegion() {
        return this.region;
    }

    @Override
    public boolean forCloud() {
        return true;
    }

    public SignatureProvider prepare(NoSQLHandleConfig config) {
        URL serviceURL = config.getServiceURL();
        if (serviceURL == null) {
            throw new IllegalArgumentException("Must set service URL first");
        }
        this.serviceHost = serviceURL.getHost();
        if (this.provider instanceof SecurityTokenSupplier.SecurityTokenBasedProvider) {
            ((SecurityTokenSupplier.SecurityTokenBasedProvider)((Object)this.provider)).prepare(config);
        }
        this.getSignatureDetailsForCache(false);
        return this;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public String getResourcePrincipalClaim(String key) {
        if (!(this.provider instanceof ResourcePrincipalProvider)) {
            throw new IllegalArgumentException("Only resource principal support");
        }
        ResourcePrincipalProvider rpp = (ResourcePrincipalProvider)this.provider;
        return rpp.getClaim(key);
    }

    void setDelegationToken(String token) {
        int dot1 = token.indexOf(".");
        int dot2 = token.indexOf(".", dot1 + 1);
        int dot3 = token.indexOf(".", dot2 + 1);
        if (dot1 == -1 || dot2 == -1 || dot3 != -1) {
            throw new IllegalArgumentException("Given string is not in the valid JWT token format\n" + token);
        }
        this.delegationToken = token;
    }

    private void logMessage(Level level, String msg) {
        if (this.logger != null) {
            this.logger.log(level, msg);
        }
    }

    private SignatureDetails getSignatureDetails(Request request) {
        SignatureDetails sigDetails;
        SignatureDetails signatureDetails = sigDetails = request.getIsRefresh() ? this.refreshSigDetails : this.currentSigDetails;
        if (sigDetails != null) {
            return sigDetails;
        }
        if (request.getIsRefresh() && (sigDetails = this.currentSigDetails) != null) {
            return sigDetails;
        }
        return this.getSignatureDetailsForCache(false);
    }

    private SignatureDetails getSignatureWithContent(Request request, HttpHeaders headers, byte[] content) {
        return this.getSignatureDetailsInternal(false, request, headers, content);
    }

    synchronized SignatureDetails getSignatureDetailsForCache(boolean isRefresh) {
        return this.getSignatureDetailsInternal(isRefresh, null, null, null);
    }

    synchronized SignatureDetails getSignatureDetailsInternal(boolean isRefresh, Request request, HttpHeaders headers, byte[] content) {
        String signature;
        long nowPlus = System.currentTimeMillis() + 60000L;
        String date = Utils.createFormatter().format(new Date(nowPlus));
        String keyId = this.provider.getKeyId();
        if (this.provider instanceof SecurityTokenSupplier.SecurityTokenBasedProvider) {
            this.privateKeyProvider.reload(this.provider.getPrivateKey(), this.provider.getPassphraseCharacters());
        }
        try {
            signature = Utils.sign(this.signingContent(date, request, headers, content), this.privateKeyProvider.getKey());
        }
        catch (Exception e) {
            this.logMessage(Level.SEVERE, "Error signing request " + e.getMessage());
            return null;
        }
        String token = this.getDelegationToken(request);
        String signingHeader = content != null ? (token == null ? SIGNING_HEADERS_WITH_CONTENT : SIGNING_HEADERS_WITH_CONTENT_OBO) : (token == null ? SIGNING_HEADERS : SIGNING_HEADERS_WITH_OBO);
        String sigHeader = String.format(Utils.SIGNATURE_HEADER_FORMAT, signingHeader, keyId, "rsa-sha256", signature, 1);
        SignatureDetails sigDetails = new SignatureDetails(sigHeader, date);
        if (content != null) {
            return sigDetails;
        }
        if (!isRefresh) {
            this.currentSigDetails = sigDetails;
            this.scheduleRefresh();
        } else {
            this.refreshSigDetails = sigDetails;
        }
        return sigDetails;
    }

    private String getDelegationToken(Request req) {
        return req != null && req.getOboToken() != null ? req.getOboToken() : this.delegationToken;
    }

    private synchronized void setRefreshKey() {
        if (this.refreshSigDetails != null) {
            this.currentSigDetails = this.refreshSigDetails;
            this.refreshSigDetails = null;
        }
    }

    private String signingContent(String date, Request request, HttpHeaders headers, byte[] content) {
        String token;
        StringBuilder sb = new StringBuilder();
        sb.append("(request-target)").append(": ").append("post /").append(HttpConstants.NOSQL_DATA_PATH).append("\n").append("host").append(": ").append(this.serviceHost).append("\n").append("date").append(": ").append(date);
        if (content != null) {
            sb.append("\n").append("content-length").append(": ").append(headers.get("Content-Length")).append("\n").append("content-type").append(": ").append(headers.get("Content-Type"));
            String sha256 = Utils.computeBodySHA256(content);
            sb.append("\n").append("x-content-sha256").append(": ").append(sha256);
            headers.add("x-content-sha256", (Object)sha256);
        }
        if ((token = this.getDelegationToken(request)) != null) {
            sb.append("\n").append(OBO_TOKEN_HEADER).append(": ").append(token);
        }
        return sb.toString();
    }

    private void scheduleRefresh() {
        if (this.refreshIntervalMs == 0L) {
            return;
        }
        if (this.refresher != null) {
            this.refresher.cancel();
            this.refresher = null;
        }
        this.refresher = new Timer(true);
        this.refresher.schedule((TimerTask)new RefreshTask(), this.refreshIntervalMs);
    }

    private static String readFile(File file) throws IOException {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));){
            String line = null;
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
        }
        return sb.toString();
    }

    public void setOnSignatureRefresh(OnSignatureRefresh onSigRefresh) {
        this.onSigRefresh = onSigRefresh;
    }

    public OnSignatureRefresh getOnSignatureRefresh() {
        return this.onSigRefresh;
    }

    @FunctionalInterface
    public static interface OnSignatureRefresh {
        public void refresh(long var1);
    }

    static class SignatureDetails {
        private String signatureHeader;
        private String date;

        SignatureDetails(String signatureHeader, String date) {
            this.signatureHeader = signatureHeader;
            this.date = date;
        }

        String getDate() {
            return this.date;
        }

        String getSignatureHeader() {
            return this.signatureHeader;
        }
    }

    private class RefreshTask
    extends TimerTask {
        private static final int DELAY_MS = 500;

        private RefreshTask() {
        }

        private void handleRefreshCallback(long refreshMs) {
            if (SignatureProvider.this.refreshSigDetails == null) {
                SignatureProvider.this.logMessage(Level.FINE, "Refresh didn't find cached refresh key");
                return;
            }
            if (SignatureProvider.this.onSigRefresh != null) {
                try {
                    SignatureProvider.this.onSigRefresh.refresh(refreshMs);
                }
                catch (Throwable t) {
                    SignatureProvider.this.logMessage(Level.FINE, "Exception from OnSignatureRefresh: " + t);
                }
            }
            SignatureProvider.this.setRefreshKey();
            SignatureProvider.this.scheduleRefresh();
        }

        @Override
        public void run() {
            Exception lastException;
            long startTime = System.currentTimeMillis();
            do {
                try {
                    SignatureProvider.this.getSignatureDetailsForCache(true);
                    this.handleRefreshCallback(SignatureProvider.this.refreshAheadMs);
                    return;
                }
                catch (SecurityInfoNotReadyException se) {
                    lastException = se;
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                catch (Exception e) {
                    lastException = e;
                    break;
                }
            } while (System.currentTimeMillis() - startTime < SignatureProvider.this.refreshAheadMs);
            SignatureProvider.this.logMessage(Level.WARNING, "Unable to refresh cached request signature, " + lastException.getMessage());
            SignatureProvider.this.refresher.cancel();
            SignatureProvider.this.refresher = null;
        }
    }

    public static class ResourcePrincipalClaimKeys {
        public static final String COMPARTMENT_ID_CLAIM_KEY = "res_compartment";
        public static final String TENANT_ID_CLAIM_KEY = "res_tenant";
    }
}

