/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.iam.pki;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import oracle.nosql.driver.iam.pki.Eraser;
import oracle.nosql.driver.iam.pki.Hex;
import oracle.nosql.driver.iam.pki.PemEncryptedKeyException;
import oracle.nosql.driver.iam.pki.PemEncryptionException;
import oracle.nosql.driver.iam.pki.PemException;
import oracle.nosql.driver.iam.pki.Pkcs1EncryptedPrivateKeyInfo;
import oracle.nosql.driver.iam.pki.Sensitive;
import oracle.nosql.driver.iam.pki.Text;
import oracle.nosql.driver.iam.pki.Utf8;

public abstract class Pem {
    private static final String KEY_PAIR_ALGORITHM = "RSA";
    private static final String CERTIFICATE_TYPE = "X509";
    private static final int PKCS8_PRIVATE_KEY_HEADER_SIZE = 26;
    private static final int X509_PUBLIC_KEY_HEADER_SIZE = 24;
    private static final Encoder ENCODER = new Encoder(Format.DEFAULT, null);
    private static final Decoder DECODER = Pem.decoder("X509", "RSA");

    private Pem() {
    }

    private static Decoder decoder(String certificateType, String keyPairAlgorithm) {
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance(certificateType);
            KeyFactory keyFactory = KeyFactory.getInstance(keyPairAlgorithm);
            return new Decoder(certificateFactory, keyFactory, null);
        }
        catch (NoSuchAlgorithmException | CertificateException e) {
            throw new PemException(e);
        }
    }

    private static void erase(byte[] bytes) {
        Eraser.erase(bytes);
    }

    private static byte[] asPkcs1PrivateKey(byte[] pkcs8) {
        return Arrays.copyOfRange(pkcs8, 26, pkcs8.length);
    }

    private static byte[] asPkcs1PublicKey(byte[] x509) {
        return Arrays.copyOfRange(x509, 24, x509.length);
    }

    private static byte[] join(byte[] first, byte[] second) {
        byte[] bytes = new byte[first.length + second.length];
        System.arraycopy(first, 0, bytes, 0, first.length);
        System.arraycopy(second, 0, bytes, first.length, second.length);
        return bytes;
    }

    private static byte[] adaptPkcs1PublicKey(byte[] pkcs1) {
        int pkcs1Length = pkcs1.length;
        int totalLength = pkcs1Length + 20;
        int contentLength = pkcs1Length + 1;
        byte[] pkcs8Header = new byte[]{48, -126, (byte)(totalLength >> 8 & 0xFF), (byte)(totalLength & 0xFF), 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -126, (byte)(contentLength >> 8 & 0xFF), (byte)(contentLength & 0xFF), 0};
        byte[] pkcs8bytes = Pem.join(pkcs8Header, pkcs1);
        return pkcs8bytes;
    }

    private static byte[] adaptPkcs1PrivateKey(byte[] pkcs1) {
        int pkcs1Length = pkcs1.length;
        int totalLength = pkcs1Length + 22;
        byte[] pkcs8Header = new byte[]{48, -126, (byte)(totalLength >> 8 & 0xFF), (byte)(totalLength & 0xFF), 2, 1, 0, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 4, -126, (byte)(pkcs1Length >> 8 & 0xFF), (byte)(pkcs1Length & 0xFF)};
        byte[] pkcs8bytes = Pem.join(pkcs8Header, pkcs1);
        return pkcs8bytes;
    }

    private static byte[] encryptPkcs1(byte[] der, Encryption encryption) {
        try (Pkcs1EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = Pkcs1EncryptedPrivateKeyInfo.of(encryption);){
            byte[] byArray = Pem.cryptPkcs1(1, der, encryptedPrivateKeyInfo, encryption.passphrase());
            return byArray;
        }
    }

    private static byte[] cryptPkcs1(int mode, byte[] content, Pkcs1EncryptedPrivateKeyInfo encryptedPrivateKeyInfo, Passphrase passphrase) {
        try {
            SecretKey secretKey = passphrase.map(encryptedPrivateKeyInfo::secretKey);
            Cipher cipher = Cipher.getInstance(encryptedPrivateKeyInfo.algorithmName());
            cipher.init(mode, (Key)secretKey, encryptedPrivateKeyInfo.getAlgParameters());
            byte[] result = cipher.doFinal(content);
            return result;
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new PemEncryptionException(e);
        }
    }

    public static Encoder encoder() {
        return ENCODER;
    }

    public static Decoder decoder() {
        return DECODER;
    }

    static /* synthetic */ byte[] access$1400(int x0, byte[] x1, Pkcs1EncryptedPrivateKeyInfo x2, Passphrase x3) {
        return Pem.cryptPkcs1(x0, x1, x2, x3);
    }

    public static interface Passphrase
    extends Sensitive {
        public static Passphrase none() {
            return NoPassphrase.instance();
        }

        public static Passphrase of(char[] content) {
            if (content == null) {
                return Passphrase.none();
            }
            return CharacterPassphrase.of(content);
        }

        @Override
        public void close();

        public <T> T map(Function<char[], T> var1);
    }

    public static class Encryption
    implements Sensitive {
        static final String SUPPORTED_ENCRYPTION_ALGORITHM = "AES";
        private static final Encryption NONE = new Encryption("NONE", 0, null, "NONE", Passphrase.none(), false);
        private static final SecureRandom PRNG = new SecureRandom();
        private final String algorithm;
        private final int keySize;
        private final byte[] iv;
        private final String blockMode;
        private final Passphrase passphrase;
        private final boolean ownsPassphrase;

        private Encryption(Builder builder) {
            this(SUPPORTED_ENCRYPTION_ALGORITHM, builder.keySize, builder.iv, builder.blockMode, builder.passphrase, builder.ownsPassphrase);
        }

        public Encryption(String algorithm, int keySize, byte[] iv, String blockMode, Passphrase passphrase, boolean ownsPassphrase) {
            this.algorithm = algorithm;
            this.keySize = keySize;
            this.iv = iv;
            this.blockMode = blockMode;
            this.passphrase = passphrase;
            this.ownsPassphrase = ownsPassphrase;
        }

        public static Encryption none() {
            return NONE;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Override
        public void close() {
            if (this.ownsPassphrase && this.passphrase != null) {
                this.passphrase.close();
            }
        }

        public String algorithm() {
            return this.algorithm;
        }

        public int keySize() {
            return this.keySize;
        }

        public byte[] iv() {
            return this.iv;
        }

        public String blockMode() {
            return this.blockMode;
        }

        public Passphrase passphrase() {
            return this.passphrase;
        }

        static /* synthetic */ SecureRandom access$1100() {
            return PRNG;
        }

        public static final class Builder {
            private int keySize = 128;
            private byte[] iv;
            private String blockMode = "CBC";
            private Passphrase passphrase;
            private boolean ownsPassphrase;
            private transient SecureRandom entropy = Encryption.access$1100();

            private Builder() {
            }

            public Builder keySize(int keySize) {
                this.keySize = keySize;
                return this;
            }

            public Builder entropy(SecureRandom entropy) {
                Objects.requireNonNull(entropy);
                this.entropy = entropy;
                return this;
            }

            public Builder iv(byte[] iv) {
                this.iv = iv;
                return this;
            }

            public Builder blockMode(String blockMode) {
                this.blockMode = blockMode;
                return this;
            }

            public Builder passphrase(Passphrase passphrase) {
                this.passphrase = passphrase;
                return this;
            }

            public Builder ownsPassphrase(boolean ownsPassphrase) {
                this.ownsPassphrase = ownsPassphrase;
                return this;
            }

            public Builder passphrase(char[] passphrase) {
                return this.passphrase(Passphrase.of(passphrase)).ownsPassphrase(true);
            }

            public Encryption build() {
                if (this.iv == null) {
                    this.iv = new byte[this.keySize / 8];
                    this.entropy.nextBytes(this.iv);
                }
                return new Encryption(this);
            }
        }
    }

    public static class Decoder {
        private final Passphrase passphrase;
        private final CertificateFactory certificateFactory;
        private final KeyFactory keyFactory;

        private Decoder(CertificateFactory certificateFactory, KeyFactory keyFactory, Passphrase passphrase) {
            this.certificateFactory = certificateFactory;
            this.keyFactory = keyFactory;
            this.passphrase = passphrase == Passphrase.none() ? null : passphrase;
        }

        public Decoder with(Passphrase passphrase) {
            return new Decoder(this.certificateFactory, this.keyFactory, passphrase);
        }

        public Certificate decodeCertificate(String contents) {
            Certificate certificate;
            ByteArrayInputStream bytes = new ByteArrayInputStream(contents.getBytes(StandardCharsets.UTF_8));
            try {
                certificate = this.certificateFactory.generateCertificate(bytes);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)bytes).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException | CertificateException e) {
                    throw new PemException(e);
                }
            }
            ((InputStream)bytes).close();
            return certificate;
        }

        public Certificate decodeCertificate(ReadableByteChannel contents) {
            Certificate certificate;
            block8: {
                InputStream bytes = Channels.newInputStream(contents);
                try {
                    certificate = this.certificateFactory.generateCertificate(bytes);
                    if (bytes == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (bytes != null) {
                            try {
                                bytes.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException | CertificateException e) {
                        throw new PemException(e);
                    }
                }
                bytes.close();
            }
            return certificate;
        }

        public Collection<? extends Certificate> decodeCertificateChain(String contents) {
            Collection<? extends Certificate> collection;
            ByteArrayInputStream bytes = new ByteArrayInputStream(contents.getBytes(StandardCharsets.UTF_8));
            try {
                collection = this.certificateFactory.generateCertificates(bytes);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)bytes).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException | CertificateException e) {
                    throw new PemException(e);
                }
            }
            ((InputStream)bytes).close();
            return collection;
        }

        public Collection<? extends Certificate> decodeCertificateChain(ReadableByteChannel contents) {
            Collection<? extends Certificate> collection;
            block8: {
                InputStream bytes = Channels.newInputStream(contents);
                try {
                    collection = this.certificateFactory.generateCertificates(bytes);
                    if (bytes == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (bytes != null) {
                            try {
                                bytes.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException | CertificateException e) {
                        throw new PemException(e.getMessage(), e);
                    }
                }
                bytes.close();
            }
            return collection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private PrivateKey decodeUnencryptedPrivateKey(Type type, Utf8 content) {
            PrivateKey privateKey;
            byte[] der = type.payload(content);
            try {
                PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(der);
                privateKey = this.keyFactory.generatePrivate(spec);
            }
            catch (Throwable throwable) {
                try {
                    Pem.erase(der);
                    throw throwable;
                }
                catch (InvalidKeySpecException e) {
                    throw new PemException(e.getMessage(), e);
                }
            }
            Pem.erase(der);
            return privateKey;
        }

        private PrivateKey decodeEncryptedPrivateKey(Type type, Utf8 content) {
            if (this.passphrase == null) {
                throw new PemEncryptedKeyException();
            }
            if (type == Type.PKCS1_ENCRYPTED_PRIVATE_KEY) {
                return this.decodeEncryptedPkcs1PrivateKey(content);
            }
            return this.decodeEncryptedPkcs8PrivateKey(content);
        }

        private String algorithmName(EncryptedPrivateKeyInfo encryptedPrivateKeyInfo) {
            String pbeAlgName = encryptedPrivateKeyInfo.getAlgName();
            if (pbeAlgName.equals("PBES2") || pbeAlgName.equals("1.2.840.113549.1.5.13")) {
                return encryptedPrivateKeyInfo.getAlgParameters().toString();
            }
            return pbeAlgName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private PrivateKey decodeEncryptedPkcs8PrivateKey(Utf8 content) {
            PrivateKey privateKey;
            byte[] der = Type.PKCS8_ENCRYPTED_PRIVATE_KEY.payload(content);
            try {
                PrivateKey privateKey2;
                EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo(der);
                String algorithmName = this.algorithmName(encryptedPrivateKeyInfo);
                SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(algorithmName);
                SecretKey secretKey = secretKeyFactory.generateSecret(this.passphrase.map(PBEKeySpec::new));
                Cipher cipher = Cipher.getInstance(algorithmName);
                cipher.init(2, (Key)secretKey, encryptedPrivateKeyInfo.getAlgParameters());
                privateKey = privateKey2 = this.keyFactory.generatePrivate(encryptedPrivateKeyInfo.getKeySpec(cipher));
            }
            catch (Throwable throwable) {
                try {
                    Pem.erase(der);
                    throw throwable;
                }
                catch (IOException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException | NoSuchPaddingException e) {
                    throw new PemEncryptionException(e);
                }
            }
            Pem.erase(der);
            return privateKey;
        }

        /*
         * Exception decompiling
         */
        private PrivateKey decodeEncryptedPkcs1PrivateKey(Utf8 content) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public PrivateKey decodePrivateKey(ReadableByteChannel bytes) throws IOException {
            try (Utf8 content = Utf8.of(bytes);){
                PrivateKey privateKey = this.decodePrivateKey(content);
                return privateKey;
            }
        }

        public PrivateKey decodePrivateKey(byte[] contents) {
            try (Utf8 content = Utf8.of(contents);){
                PrivateKey privateKey = this.decodePrivateKey(content);
                return privateKey;
            }
        }

        private PrivateKey decodePrivateKey(Utf8 content) {
            Type type = Type.typeOf(content);
            if (type == null) {
                throw new IllegalArgumentException("Private key must be in PEM format");
            }
            if (type.isEncrypted()) {
                return this.decodeEncryptedPrivateKey(type, content);
            }
            return this.decodeUnencryptedPrivateKey(type, content);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public PublicKey decodePublicKey(String contents) {
            try (Utf8 content = Utf8.of(contents);){
                Type type = Type.typeOf(content);
                if (type == null) throw new IllegalArgumentException();
                byte[] der = type.payload(content);
                X509EncodedKeySpec spec = new X509EncodedKeySpec(der);
                PublicKey publicKey = this.keyFactory.generatePublic(spec);
                return publicKey;
            }
            catch (InvalidKeySpecException e) {
                throw new PemException(e);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public PublicKey decodePublicKey(ReadableByteChannel contents) {
            try (Utf8 content = Utf8.of(contents);){
                Type type = Type.typeOf(content);
                if (type == null) throw new IllegalArgumentException();
                byte[] der = type.payload(content);
                X509EncodedKeySpec spec = new X509EncodedKeySpec(der);
                PublicKey publicKey = this.keyFactory.generatePublic(spec);
                return publicKey;
            }
            catch (IOException | InvalidKeySpecException e) {
                throw new PemException(e);
            }
        }
    }

    public static class Encoder {
        private final Encryption encryption;
        private final Format format;

        private Encoder(Format format, Encryption encryption) {
            this.format = format;
            this.encryption = encryption == Encryption.none() ? null : encryption;
        }

        public Encoder with(Format format) {
            return new Encoder(format, this.encryption);
        }

        public Encoder with(Encryption encryption) {
            return new Encoder(this.format, encryption);
        }

        public Encoder with(Passphrase passphrase) {
            if (passphrase == null) {
                return this.with(Encryption.none());
            }
            Encryption encryption = Encryption.builder().passphrase(passphrase).build();
            return this.with(encryption);
        }

        public String encode(PublicKey publicKey) {
            byte[] der = publicKey.getEncoded();
            if (this.format == Format.DEFAULT) {
                return Text.of(Type.X509_PUBLIC_KEY.encode(der, null));
            }
            byte[] payload = Pem.asPkcs1PublicKey(der);
            return Text.of(Type.PKCS1_PUBLIC_KEY.encode(payload, null));
        }

        public String encode(Certificate certificate) {
            try {
                byte[] payload = certificate.getEncoded();
                return Text.of(Type.X509_CERTIFICATE.encode(payload, null));
            }
            catch (CertificateEncodingException e) {
                throw new PemException(e);
            }
        }

        public String encode(Iterable<? extends Certificate> certificates) {
            StringBuilder text = new StringBuilder();
            Iterator<? extends Certificate> items = certificates.iterator();
            while (items.hasNext()) {
                Certificate certificate = items.next();
                text.append(this.encode(certificate));
                if (!items.hasNext()) continue;
                text.append('\n');
            }
            return text.toString();
        }

        public byte[] encode(PrivateKey privateKey) {
            byte[] der = privateKey.getEncoded();
            if (this.encryption == null) {
                if (this.format == Format.DEFAULT) {
                    return Type.PKCS8_PRIVATE_KEY.encode(der, null);
                }
                byte[] payload = Pem.asPkcs1PrivateKey(der);
                return Type.PKCS1_PRIVATE_KEY.encode(payload, null);
            }
            if (this.format == Format.DEFAULT) {
                return Type.PKCS8_ENCRYPTED_PRIVATE_KEY.encode(der, this.encryption);
            }
            byte[] payload = Pem.asPkcs1PrivateKey(der);
            return Type.PKCS1_ENCRYPTED_PRIVATE_KEY.encode(payload, this.encryption);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public WritableByteChannel write(WritableByteChannel output, PrivateKey privateKey) throws IOException {
            ByteBuffer buffer = ByteBuffer.wrap(this.encode(privateKey));
            try {
                output.write(buffer);
            }
            finally {
                Eraser.erase(buffer);
            }
            return output;
        }

        public WritableByteChannel write(WritableByteChannel output, PublicKey publicKey) throws IOException {
            ByteBuffer buffer = ByteBuffer.wrap(Text.bytes(this.encode(publicKey)));
            output.write(buffer);
            return output;
        }

        public WritableByteChannel write(WritableByteChannel output, Certificate certificate) throws IOException {
            ByteBuffer buffer = ByteBuffer.wrap(Text.bytes(this.encode(certificate)));
            output.write(buffer);
            return output;
        }
    }

    public static enum Format {
        LEGACY,
        DEFAULT;

    }

    private static class CharacterPassphrase
    implements Passphrase {
        private final char[] content;

        private CharacterPassphrase(char[] content) {
            this.content = content;
        }

        static CharacterPassphrase of(char[] content) {
            return new CharacterPassphrase(Arrays.copyOf(content, content.length));
        }

        @Override
        public void close() {
            for (int i = 0; i < this.content.length; ++i) {
                this.content[i] = '\u0000';
            }
        }

        @Override
        public <T> T map(Function<char[], T> mapper) {
            return mapper.apply(this.content);
        }
    }

    private static class NoPassphrase
    implements Passphrase {
        private static final NoPassphrase INSTANCE = new NoPassphrase();

        private NoPassphrase() {
        }

        static NoPassphrase instance() {
            return INSTANCE;
        }

        @Override
        public void close() {
        }

        @Override
        public <T> T map(Function<char[], T> mapper) {
            return null;
        }
    }

    static enum Type {
        PKCS1_PRIVATE_KEY("RSA PRIVATE KEY"),
        PKCS1_ENCRYPTED_PRIVATE_KEY("RSA PRIVATE KEY"),
        PKCS1_PUBLIC_KEY("RSA PUBLIC KEY"),
        PKCS8_ENCRYPTED_PRIVATE_KEY("ENCRYPTED PRIVATE KEY"),
        PKCS8_PRIVATE_KEY("PRIVATE KEY"),
        X509_PUBLIC_KEY("PUBLIC KEY"),
        X509_CERTIFICATE("CERTIFICATE");

        static final Pattern PKCS1_ENCRYPTED_HEADER_PATTERN;
        private final String prefix;
        private final String suffix;

        private Type(String identifier) {
            this.prefix = "-----BEGIN " + identifier + "-----";
            this.suffix = "-----END " + identifier + "-----";
        }

        static Type typeOf(Utf8 text) {
            for (Type type : Type.values()) {
                if (!text.contains(type.prefix) || !text.contains(type.suffix)) continue;
                if (type == PKCS1_PRIVATE_KEY && Type.isEncryptedPkcs1(text)) {
                    return PKCS1_ENCRYPTED_PRIVATE_KEY;
                }
                return type;
            }
            return null;
        }

        private static boolean isEncryptedPkcs1(Utf8 text) {
            Utf8 content = PKCS1_PRIVATE_KEY.content(text);
            Matcher matcher = PKCS1_ENCRYPTED_HEADER_PATTERN.matcher(content);
            return matcher.matches();
        }

        private String algorithmIdentifier(Encryption encryption) {
            return encryption.algorithm() + '-' + encryption.keySize() + '-' + encryption.blockMode();
        }

        private String pemHeader(Encryption encryption) {
            String header = "Proc-Type: 4,ENCRYPTED\nDEK-Info: " + this.algorithmIdentifier(encryption) + "," + Hex.encode(encryption.iv()) + "\n";
            return header;
        }

        byte[] encode(byte[] payload, Encryption encryption) {
            StringBuilder text = new StringBuilder();
            text.append(this.prefix);
            text.append('\n');
            if (PKCS1_ENCRYPTED_PRIVATE_KEY == this) {
                String pemHeader = this.pemHeader(encryption);
                text.append(pemHeader);
                payload = Pem.encryptPkcs1(payload, encryption);
            }
            String encoded = Base64.getEncoder().encodeToString(payload);
            int length = encoded.length();
            int lineLength = 64;
            int start = 0;
            int end = start + 64;
            while (start < length) {
                text.append(encoded, start, Math.min(length, end));
                text.append('\n');
                start = end;
                end = start + 64;
            }
            text.append(this.suffix);
            return text.toString().getBytes(StandardCharsets.UTF_8);
        }

        Utf8 content(Utf8 text) {
            int endDecl;
            int startDecl = text.indexOf(this.prefix);
            if (startDecl != -1 && (endDecl = text.indexOf(this.suffix, startDecl)) != -1) {
                Utf8 content = text.subSequence(startDecl + this.prefix.length(), endDecl);
                return content.trim();
            }
            throw new IllegalArgumentException();
        }

        byte[] payload(Utf8 text) {
            try (Utf8 encodedText = this.content(text);){
                byte[] byArray;
                block20: {
                    byte[] decoded;
                    Utf8 base64;
                    block18: {
                        byte[] byArray2;
                        block19: {
                            block16: {
                                byte[] byArray3;
                                block17: {
                                    base64 = encodedText.removeWhitespace();
                                    try {
                                        decoded = Base64.getDecoder().decode(base64.bytes());
                                        if (this != PKCS1_PRIVATE_KEY) break block16;
                                        byArray3 = Pem.adaptPkcs1PrivateKey(decoded);
                                        if (base64 == null) break block17;
                                    }
                                    catch (Throwable throwable) {
                                        if (base64 != null) {
                                            try {
                                                base64.close();
                                            }
                                            catch (Throwable throwable2) {
                                                throwable.addSuppressed(throwable2);
                                            }
                                        }
                                        throw throwable;
                                    }
                                    base64.close();
                                }
                                return byArray3;
                            }
                            if (this != PKCS1_PUBLIC_KEY) break block18;
                            byArray2 = Pem.adaptPkcs1PublicKey(decoded);
                            if (base64 == null) break block19;
                            base64.close();
                        }
                        return byArray2;
                    }
                    byArray = decoded;
                    if (base64 == null) break block20;
                    base64.close();
                }
                return byArray;
            }
        }

        boolean isEncrypted() {
            return this == PKCS1_ENCRYPTED_PRIVATE_KEY || this == PKCS8_ENCRYPTED_PRIVATE_KEY;
        }

        static {
            PKCS1_ENCRYPTED_HEADER_PATTERN = Pattern.compile("Proc-Type:\\s+\\d+,ENCRYPTED\\nDEK-Info:\\s+([A-Z1-9-]+),([0123456789ABCDEFabcdef]+)\\n(.*)", 40);
        }
    }
}

