/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.iam.pki;

import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Base64;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import oracle.nosql.driver.iam.pki.Eraser;
import oracle.nosql.driver.iam.pki.Hex;
import oracle.nosql.driver.iam.pki.OpenSslPbeSecretKeyFactory;
import oracle.nosql.driver.iam.pki.Pem;
import oracle.nosql.driver.iam.pki.PemException;
import oracle.nosql.driver.iam.pki.Utf8;

class Pkcs1EncryptedPrivateKeyInfo
implements AutoCloseable {
    private static final Pattern PKCS1_ALGORITHM_PATTERN = Pattern.compile("(...)-(...)-(...)");
    private final String transformation;
    private final int keySize;
    private final AlgorithmParameterSpec algParamSpec;
    private final byte[] salt;
    private final byte[] encoded;

    private Pkcs1EncryptedPrivateKeyInfo(Builder builder) {
        this.transformation = builder.transformation;
        this.keySize = builder.keySize;
        this.encoded = builder.encoded;
        byte[] iv = builder.iv;
        this.salt = builder.salt == null ? Arrays.copyOf(iv, 8) : builder.salt;
        this.algParamSpec = new IvParameterSpec(builder.iv);
    }

    static Pkcs1EncryptedPrivateKeyInfo of(Pem.Encryption encryption) {
        String transformation = Pkcs1EncryptedPrivateKeyInfo.transformation(encryption.algorithm(), encryption.blockMode());
        int keySize = encryption.keySize();
        byte[] iv = encryption.iv();
        return Pkcs1EncryptedPrivateKeyInfo.builder().transformation(transformation).keySize(keySize).iv(iv).build();
    }

    private static String transformation(String algorithmName, String algorithmMode) {
        String blockMode = "CBC";
        String padding = "PKCS5Padding";
        if ("CFB".equals(algorithmMode)) {
            blockMode = "CFB";
            padding = "NoPadding";
        }
        if ("ECB".equals(algorithmMode)) {
            blockMode = "ECB";
        }
        if ("OFB".equals(algorithmMode)) {
            blockMode = "OFB";
            padding = "NoPadding";
        }
        String transformation = algorithmName + "/" + blockMode + "/" + padding;
        return transformation;
    }

    static Pkcs1EncryptedPrivateKeyInfo of(Utf8 content) {
        try (Utf8 payload = Pem.Type.PKCS1_ENCRYPTED_PRIVATE_KEY.content(content);){
            Matcher matcher = Pem.Type.PKCS1_ENCRYPTED_HEADER_PATTERN.matcher(payload);
            if (matcher.matches()) {
                String algorithm = matcher.group(1);
                byte[] ivBytes = Hex.decode(matcher.group(2));
                String base64 = matcher.group(3).replaceAll("\\s+", "");
                Matcher algorithmMatcher = PKCS1_ALGORITHM_PATTERN.matcher(algorithm);
                if (algorithmMatcher.matches()) {
                    String algorithmName = algorithmMatcher.group(1);
                    int keySize = Integer.parseInt(algorithmMatcher.group(2));
                    String algorithmMode = algorithmMatcher.group(3);
                    String transformation = Pkcs1EncryptedPrivateKeyInfo.transformation(algorithmName, algorithmMode);
                    byte[] encoded = Base64.getDecoder().decode(base64);
                    Pkcs1EncryptedPrivateKeyInfo pkcs1EncryptedPrivateKeyInfo = Pkcs1EncryptedPrivateKeyInfo.builder().transformation(transformation).keySize(keySize).iv(ivBytes).encoded(encoded).build();
                    return pkcs1EncryptedPrivateKeyInfo;
                }
            }
            throw new PemException(new IllegalArgumentException());
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    SecretKey secretKey(char[] passphrase) {
        try {
            PBEKeySpec spec = new PBEKeySpec(passphrase, this.salt, 1, this.keySize);
            OpenSslPbeSecretKeyFactory keyFactory = new OpenSslPbeSecretKeyFactory();
            byte[] key = keyFactory.generateSecret(spec).getEncoded();
            return new SecretKeySpec(key, "AES");
        }
        catch (InvalidKeySpecException e) {
            throw new PemException(e);
        }
    }

    String algorithmName() {
        return this.transformation;
    }

    AlgorithmParameterSpec getAlgParameters() {
        return this.algParamSpec;
    }

    byte[] encoded() {
        return this.encoded;
    }

    @Override
    public void close() {
        Eraser.erase(this.encoded);
    }

    static final class Builder {
        private String transformation = "AES/CBC/PKCS5Padding";
        private int keySize = 128;
        private byte[] iv;
        private byte[] salt;
        private byte[] encoded;

        private Builder() {
        }

        public Builder transformation(String transformation) {
            this.transformation = transformation;
            return this;
        }

        public Builder keySize(int keySize) {
            this.keySize = keySize;
            return this;
        }

        public Builder salt(byte[] salt) {
            this.salt = salt;
            return this;
        }

        public Builder iv(byte[] iv) {
            this.iv = iv;
            return this;
        }

        public Builder encoded(byte[] encoded) {
            this.encoded = encoded;
            return this;
        }

        public Pkcs1EncryptedPrivateKeyInfo build() {
            return new Pkcs1EncryptedPrivateKeyInfo(this);
        }
    }
}

