/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.kv;

import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.ssl.SslContext;
import java.net.URL;
import java.util.Arrays;
import java.util.Base64;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import oracle.nosql.driver.AuthorizationProvider;
import oracle.nosql.driver.InvalidAuthorizationException;
import oracle.nosql.driver.NoSQLException;
import oracle.nosql.driver.NoSQLHandleConfig;
import oracle.nosql.driver.httpclient.HttpClient;
import oracle.nosql.driver.ops.Request;
import oracle.nosql.driver.util.HttpConstants;
import oracle.nosql.driver.util.HttpRequestUtil;
import oracle.nosql.driver.values.JsonUtils;
import oracle.nosql.driver.values.MapValue;

public class StoreAccessTokenProvider
implements AuthorizationProvider {
    private static final String BASIC_PREFIX = "Basic ";
    private static final String BEARER_PREFIX = "Bearer ";
    private static final String LOGIN_SERVICE = "/login";
    private static final String RENEW_SERVICE = "/renew";
    private static final String LOGOUT_SERVICE = "/logout";
    private static final int HTTP_TIMEOUT_MS = 30000;
    private AtomicReference<String> authString = new AtomicReference();
    private long expirationTime;
    private volatile Timer timer;
    private Logger logger;
    private boolean autoRenew = true;
    private final boolean isSecure;
    private final String userName;
    private final char[] password;
    private String loginHost;
    private int loginPort;
    private String endpoint;
    private static final String basePath = HttpConstants.KV_SECURITY_PATH;
    private boolean isClosed = false;
    private SslContext sslContext;
    private int sslHandshakeTimeoutMs;
    public static boolean disableSSLHook;

    public StoreAccessTokenProvider() {
        this.isSecure = false;
        this.userName = null;
        this.password = null;
        this.loginHost = null;
        this.endpoint = null;
        this.loginPort = 0;
    }

    public StoreAccessTokenProvider(String userName, char[] password) {
        this.isSecure = true;
        this.userName = userName;
        this.password = Arrays.copyOf(password, password.length);
        this.logger = null;
        if (this.userName == null || this.userName.isEmpty() || this.password == null) {
            throw new IllegalArgumentException("Invalid input arguments");
        }
    }

    public synchronized void bootstrapLogin() {
        if (!this.isSecure || this.isClosed || this.authString.get() != null) {
            return;
        }
        try {
            String encoded = Base64.getEncoder().encodeToString((this.userName + ":" + String.valueOf(this.password)).getBytes());
            HttpRequestUtil.HttpResponse response = this.sendRequest(BASIC_PREFIX + encoded, LOGIN_SERVICE);
            if (response.getStatusCode() != HttpResponseStatus.OK.code()) {
                throw new InvalidAuthorizationException("Fail to login to service: " + response.getOutput());
            }
            if (this.isClosed) {
                return;
            }
            this.authString.set(BEARER_PREFIX + this.parseJsonResult(response.getOutput()));
            this.scheduleRefresh();
        }
        catch (InvalidAuthorizationException iae) {
            throw iae;
        }
        catch (Exception e) {
            throw new NoSQLException("Bootstrap login fail", e);
        }
    }

    @Override
    public String getAuthorizationString(Request request) {
        if (!this.isSecure) {
            return null;
        }
        if (this.isClosed) {
            return null;
        }
        if (this.authString.get() == null) {
            this.bootstrapLogin();
        }
        return this.authString.get();
    }

    @Override
    public void validateAuthString(String input) {
        if (this.isSecure() && input == null) {
            throw new IllegalArgumentException("Secured StoreAccessProvider acquired an unexpected null authorization string");
        }
    }

    @Override
    public synchronized void close() {
        block5: {
            if (!this.isSecure || this.isClosed) {
                return;
            }
            try {
                HttpRequestUtil.HttpResponse response = this.sendRequest(this.authString.get(), LOGOUT_SERVICE);
                if (response.getStatusCode() != HttpResponseStatus.OK.code() && this.logger != null) {
                    this.logger.info("Failed to logout user " + this.userName + ": " + response.getOutput());
                }
            }
            catch (Exception e) {
                if (this.logger == null) break block5;
                this.logger.info("Failed to logout user " + this.userName + ": " + e);
            }
        }
        this.isClosed = true;
        this.authString = null;
        this.expirationTime = 0L;
        Arrays.fill(this.password, ' ');
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    public Logger getLogger() {
        return this.logger;
    }

    public StoreAccessTokenProvider setLogger(Logger logger) {
        this.logger = logger;
        return this;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public StoreAccessTokenProvider setEndpoint(String endpoint) {
        this.endpoint = endpoint;
        URL url = NoSQLHandleConfig.createURL(endpoint, "");
        if (!url.getProtocol().toLowerCase().equals("https") && this.isSecure) {
            throw new IllegalArgumentException("StoreAccessTokenProvider requires use of https");
        }
        this.loginHost = url.getHost();
        this.loginPort = url.getPort();
        return this;
    }

    public StoreAccessTokenProvider setSslContext(SslContext sslCtx) {
        this.sslContext = sslCtx;
        return this;
    }

    public StoreAccessTokenProvider setSslHandshakeTimeout(int timeoutMs) {
        this.sslHandshakeTimeoutMs = timeoutMs;
        return this;
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    private void scheduleRefresh() {
        if (!this.isSecure || !this.autoRenew) {
            return;
        }
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        long acquireTime = System.currentTimeMillis();
        if (this.expirationTime <= 0L) {
            return;
        }
        if (this.expirationTime > acquireTime + 10000L) {
            long renewTime = acquireTime + (this.expirationTime - acquireTime) / 2L;
            this.timer = new Timer(true);
            this.timer.schedule((TimerTask)new RefreshTask(), renewTime - acquireTime);
        }
    }

    private String parseJsonResult(String jsonResult) {
        MapValue mapValue = JsonUtils.createValueFromJson(jsonResult, null).asMap();
        this.expirationTime = mapValue.getLong("expireAt");
        return mapValue.getString("token");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpRequestUtil.HttpResponse sendRequest(String authHeader, String serviceName) throws Exception {
        HttpClient client = null;
        try {
            DefaultHttpHeaders headers = new DefaultHttpHeaders();
            headers.set("Authorization", (Object)authHeader);
            client = HttpClient.createMinimalClient(this.loginHost, this.loginPort, this.isSecure && !disableSSLHook ? this.sslContext : null, this.sslHandshakeTimeoutMs, serviceName, this.logger);
            HttpRequestUtil.HttpResponse httpResponse = HttpRequestUtil.doGetRequest(client, NoSQLHandleConfig.createURL(this.endpoint, basePath + serviceName).toString(), (HttpHeaders)headers, 30000, this.logger);
            return httpResponse;
        }
        finally {
            if (client != null) {
                client.shutdown();
            }
        }
    }

    public boolean isAutoRenew() {
        return this.autoRenew;
    }

    public StoreAccessTokenProvider setAutoRenew(boolean autoRenew) {
        this.autoRenew = autoRenew;
        return this;
    }

    private class RefreshTask
    extends TimerTask {
        private RefreshTask() {
        }

        @Override
        public void run() {
            block6: {
                if (!StoreAccessTokenProvider.this.isSecure || !StoreAccessTokenProvider.this.autoRenew || StoreAccessTokenProvider.this.isClosed) {
                    return;
                }
                try {
                    String oldAuth = (String)StoreAccessTokenProvider.this.authString.get();
                    HttpRequestUtil.HttpResponse response = StoreAccessTokenProvider.this.sendRequest(oldAuth, StoreAccessTokenProvider.RENEW_SERVICE);
                    String token = StoreAccessTokenProvider.this.parseJsonResult(response.getOutput());
                    if (response.getStatusCode() != HttpResponseStatus.OK.code()) {
                        throw new InvalidAuthorizationException(token);
                    }
                    if (StoreAccessTokenProvider.this.isClosed) {
                        return;
                    }
                    StoreAccessTokenProvider.this.authString.compareAndSet(oldAuth, StoreAccessTokenProvider.BEARER_PREFIX + token);
                    StoreAccessTokenProvider.this.scheduleRefresh();
                }
                catch (Exception e) {
                    if (StoreAccessTokenProvider.this.logger != null) {
                        StoreAccessTokenProvider.this.logger.info("Failed to renew login token: " + e);
                    }
                    if (StoreAccessTokenProvider.this.timer == null) break block6;
                    StoreAccessTokenProvider.this.timer.cancel();
                    StoreAccessTokenProvider.this.timer = null;
                }
            }
        }
    }
}

