/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.ops;

import oracle.nosql.driver.NoSQLHandleConfig;
import oracle.nosql.driver.ops.Request;
import oracle.nosql.driver.ops.serde.Serializer;
import oracle.nosql.driver.ops.serde.SerializerFactory;

public class AddReplicaRequest
extends Request {
    private String replicaName;
    private int readUnits;
    private int writeUnits;
    private String matchETag;

    public AddReplicaRequest setTableName(String tableName) {
        super.setTableNameInternal(tableName);
        return this;
    }

    public AddReplicaRequest setReplicaName(String replicaName) {
        this.replicaName = replicaName;
        return this;
    }

    public String getReplicaName() {
        return this.replicaName;
    }

    public AddReplicaRequest setReadUnits(int readUnits) {
        this.readUnits = readUnits;
        return this;
    }

    public int getReadUnits() {
        return this.readUnits;
    }

    public AddReplicaRequest setWriteUnits(int writeUnits) {
        this.writeUnits = writeUnits;
        return this;
    }

    public int getWriteUnits() {
        return this.writeUnits;
    }

    public AddReplicaRequest setMatchEtag(String etag) {
        this.matchETag = etag;
        return this;
    }

    public String getMatchETag() {
        return this.matchETag;
    }

    public AddReplicaRequest setCompartment(String compartment) {
        super.setCompartmentInternal(compartment);
        return this;
    }

    public AddReplicaRequest setTimeout(int timeoutMs) {
        super.setTimeoutInternal(timeoutMs);
        return this;
    }

    @Override
    public AddReplicaRequest setDefaults(NoSQLHandleConfig config) {
        if (this.timeoutMs == 0) {
            this.timeoutMs = config.getDefaultTableRequestTimeout();
        }
        return this;
    }

    @Override
    public void validate() {
        if (this.tableName == null || this.replicaName == null) {
            throw new IllegalArgumentException("AddReplicaRequest requires table name and replica name");
        }
    }

    @Override
    public Serializer createSerializer(SerializerFactory factory) {
        return factory.createAddReplicaSerializer();
    }

    @Override
    public Serializer createDeserializer(SerializerFactory factory) {
        return factory.createAddReplicaDeserializer();
    }

    @Override
    public String getTypeName() {
        return "AddReplica";
    }
}

