/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.ops;

import oracle.nosql.driver.Durability;
import oracle.nosql.driver.Version;
import oracle.nosql.driver.ops.WriteRequest;
import oracle.nosql.driver.ops.serde.Serializer;
import oracle.nosql.driver.ops.serde.SerializerFactory;
import oracle.nosql.driver.values.JsonOptions;
import oracle.nosql.driver.values.JsonUtils;
import oracle.nosql.driver.values.MapValue;

public class DeleteRequest
extends WriteRequest {
    private MapValue key;
    private Version matchVersion;

    public MapValue getKey() {
        return this.key;
    }

    public DeleteRequest setKey(MapValue key) {
        this.key = key;
        return this;
    }

    public DeleteRequest setKeyFromJson(String jsonValue, JsonOptions options) {
        if (jsonValue == null) {
            throw new IllegalArgumentException("DeleteRequest: setValueFromJson requires a non-null value");
        }
        this.key = (MapValue)JsonUtils.createValueFromJson(jsonValue, options);
        return this;
    }

    public Version getMatchVersion() {
        return this.matchVersion;
    }

    public DeleteRequest setMatchVersion(Version version) {
        this.matchVersion = version;
        return this;
    }

    public int getTimeout() {
        return super.getTimeoutInternal();
    }

    public boolean getReturnRow() {
        return super.getReturnRowInternal();
    }

    public DeleteRequest setTableName(String tableName) {
        super.setTableNameInternal(tableName);
        return this;
    }

    public DeleteRequest setDurability(Durability durability) {
        this.setDurabilityInternal(durability);
        return this;
    }

    public DeleteRequest setCompartment(String compartment) {
        super.setCompartmentInternal(compartment);
        return this;
    }

    public DeleteRequest setReturnRow(boolean value) {
        super.setReturnRowInternal(value);
        return this;
    }

    public DeleteRequest setTimeout(int timeoutMs) {
        super.setTimeoutInternal(timeoutMs);
        return this;
    }

    public DeleteRequest setNamespace(String namespace) {
        super.setNamespaceInternal(namespace);
        return this;
    }

    @Override
    public void validate() {
        this.validateWriteRequest("DeleteRequest");
        if (this.key == null) {
            throw new IllegalArgumentException("DeleteRequest requires a key");
        }
    }

    @Override
    public Serializer createSerializer(SerializerFactory factory) {
        return factory.createDeleteSerializer();
    }

    @Override
    public Serializer createDeserializer(SerializerFactory factory) {
        return factory.createDeleteDeserializer();
    }

    @Override
    public String getTypeName() {
        return "Delete";
    }

    @Override
    public boolean doesReads() {
        return this.matchVersion != null || this.getReturnRow();
    }
}

