/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.ops;

import oracle.nosql.driver.NoSQLHandleConfig;
import oracle.nosql.driver.ops.Request;
import oracle.nosql.driver.ops.serde.Serializer;
import oracle.nosql.driver.ops.serde.SerializerFactory;

public class DropReplicaRequest
extends Request {
    private String replicaName;
    private String matchETag;

    public DropReplicaRequest setTableName(String tableName) {
        super.setTableNameInternal(tableName);
        return this;
    }

    public DropReplicaRequest setReplicaName(String replicaName) {
        this.replicaName = replicaName;
        return this;
    }

    public String getReplicaName() {
        return this.replicaName;
    }

    public DropReplicaRequest setMatchEtag(String etag) {
        this.matchETag = etag;
        return this;
    }

    public String getMatchETag() {
        return this.matchETag;
    }

    public DropReplicaRequest setCompartment(String compartment) {
        super.setCompartmentInternal(compartment);
        return this;
    }

    public DropReplicaRequest setTimeout(int timeoutMs) {
        super.setTimeoutInternal(timeoutMs);
        return this;
    }

    @Override
    public DropReplicaRequest setDefaults(NoSQLHandleConfig config) {
        if (this.timeoutMs == 0) {
            this.timeoutMs = config.getDefaultTableRequestTimeout();
        }
        return this;
    }

    @Override
    public void validate() {
        if (this.tableName == null || this.replicaName == null) {
            throw new IllegalArgumentException("DropReplicaRequest requires table name and replica name");
        }
    }

    @Override
    public Serializer createSerializer(SerializerFactory factory) {
        return factory.createDropReplicaSerializer();
    }

    @Override
    public Serializer createDeserializer(SerializerFactory factory) {
        return factory.createDropReplicaDeserializer();
    }

    @Override
    public String getTypeName() {
        return "DropReplica";
    }
}

