/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.ops;

import oracle.nosql.driver.ops.Result;

public class GetIndexesResult
extends Result {
    private IndexInfo[] indexes;

    public IndexInfo[] getIndexes() {
        return this.indexes;
    }

    public GetIndexesResult setIndexes(IndexInfo[] indexes) {
        this.indexes = indexes;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < this.indexes.length; ++i) {
            this.indexes[i].toStringBuilder(sb);
            if (i >= this.indexes.length - 1) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    public static class IndexInfo {
        private String indexName;
        private String[] fieldNames;
        private String[] fieldTypes;

        public IndexInfo(String indexName, String[] fieldNames, String[] fieldTypes) {
            this.indexName = indexName;
            this.fieldNames = fieldNames;
            this.fieldTypes = fieldTypes;
        }

        public String getIndexName() {
            return this.indexName;
        }

        public String[] getFieldNames() {
            return this.fieldNames;
        }

        public String[] getFieldTypes() {
            return this.fieldTypes;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.toStringBuilder(sb);
            return sb.toString();
        }

        private void toStringBuilder(StringBuilder sb) {
            sb.append("IndexInfo [indexName=").append(this.indexName);
            sb.append(", fields=[");
            for (int i = 0; i < this.fieldNames.length; ++i) {
                sb.append(this.fieldNames[i]);
                if (this.fieldTypes[i] != null) {
                    sb.append(":").append(this.fieldTypes[i]);
                }
                if (i >= this.fieldNames.length - 1) continue;
                sb.append(", ");
            }
            sb.append("]]");
        }
    }
}

