/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.ops;

import oracle.nosql.driver.ops.Request;
import oracle.nosql.driver.ops.serde.Serializer;
import oracle.nosql.driver.ops.serde.SerializerFactory;

public class ListTablesRequest
extends Request {
    private int startIndex;
    private int limit;
    private String namespace;

    public ListTablesRequest setCompartment(String compartment) {
        super.setCompartmentInternal(compartment);
        return this;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public ListTablesRequest setLimit(int limit) {
        this.limit = limit;
        return this;
    }

    public ListTablesRequest setStartIndex(int startIndex) {
        this.startIndex = startIndex;
        return this;
    }

    public ListTablesRequest setTimeout(int timeoutMs) {
        super.setTimeoutInternal(timeoutMs);
        return this;
    }

    public ListTablesRequest setNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public void validate() {
        if (this.startIndex < 0 || this.limit < 0) {
            throw new IllegalArgumentException("ListTables: start index and number of tables must be non-negative");
        }
    }

    @Override
    public Serializer createSerializer(SerializerFactory factory) {
        return factory.createListTablesSerializer();
    }

    @Override
    public Serializer createDeserializer(SerializerFactory factory) {
        return factory.createListTablesDeserializer();
    }

    @Override
    public String getTypeName() {
        return "ListTables";
    }

    @Override
    public boolean shouldRetry() {
        return false;
    }
}

