/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.ops;

import java.io.PrintStream;
import java.math.MathContext;
import java.util.Map;
import java.util.TreeMap;
import oracle.nosql.driver.Consistency;
import oracle.nosql.driver.Durability;
import oracle.nosql.driver.NoSQLHandleConfig;
import oracle.nosql.driver.ops.DurableRequest;
import oracle.nosql.driver.ops.PrepareResult;
import oracle.nosql.driver.ops.PreparedStatement;
import oracle.nosql.driver.ops.Request;
import oracle.nosql.driver.ops.serde.Serializer;
import oracle.nosql.driver.ops.serde.SerializerFactory;
import oracle.nosql.driver.query.QueryDriver;
import oracle.nosql.driver.query.VirtualScan;

public class QueryRequest
extends DurableRequest
implements AutoCloseable {
    private int traceLevel;
    private int limit;
    private int maxReadKB;
    private int maxWriteKB;
    private long maxMemoryConsumption = 0x40000000L;
    private long maxServerMemoryConsumption = 0xA00000L;
    private MathContext mathContext = MathContext.DECIMAL32;
    private Consistency consistency;
    private String statement;
    private PreparedStatement preparedStatement;
    private byte[] continuationKey;
    private VirtualScan virtualScan;
    private QueryDriver driver;
    private boolean isInternal;
    private int shardId = -1;
    private String queryName;
    private boolean logFileTracing;
    private String driverQueryTrace;
    private Map<String, String> serverQueryTraces;
    private int batchCounter;
    private boolean inTestMode;

    public QueryRequest copyInternal() {
        QueryRequest internalReq = new QueryRequest();
        super.copyTo(internalReq);
        internalReq.traceLevel = this.traceLevel;
        internalReq.logFileTracing = this.logFileTracing;
        internalReq.queryName = this.queryName;
        internalReq.batchCounter = this.batchCounter;
        internalReq.limit = this.limit;
        internalReq.maxReadKB = this.maxReadKB;
        internalReq.maxWriteKB = this.maxWriteKB;
        internalReq.maxMemoryConsumption = this.maxMemoryConsumption;
        internalReq.maxServerMemoryConsumption = this.maxServerMemoryConsumption;
        internalReq.mathContext = this.mathContext;
        internalReq.consistency = this.consistency;
        internalReq.preparedStatement = this.preparedStatement;
        internalReq.isInternal = true;
        internalReq.driver = this.driver;
        internalReq.topoSeqNum = this.topoSeqNum;
        internalReq.inTestMode = this.inTestMode;
        return internalReq;
    }

    public QueryRequest copy() {
        QueryRequest internalReq = this.copyInternal();
        internalReq.statement = this.statement;
        internalReq.isInternal = false;
        internalReq.shardId = -1;
        internalReq.driver = null;
        this.driverQueryTrace = null;
        this.batchCounter = 0;
        return internalReq;
    }

    public QueryDriver getDriver() {
        return this.driver;
    }

    public void setDriver(QueryDriver driver) {
        if (this.driver != null) {
            throw new IllegalArgumentException("QueryRequest is already bound to a QueryDriver");
        }
        this.driver = driver;
    }

    public boolean hasDriver() {
        return this.driver != null;
    }

    public boolean isPrepared() {
        return this.preparedStatement != null;
    }

    public boolean isSimpleQuery() {
        return this.preparedStatement.isSimpleQuery();
    }

    @Override
    public boolean isQueryRequest() {
        return !this.isInternal;
    }

    @Override
    public boolean doesReads() {
        return true;
    }

    @Override
    public boolean doesWrites() {
        if (this.preparedStatement == null) {
            return false;
        }
        return this.preparedStatement.doesWrites();
    }

    public int getShardId() {
        return this.shardId;
    }

    public void setShardId(int id) {
        this.shardId = id;
    }

    public void setVirtualScan(VirtualScan vs) {
        this.virtualScan = vs;
    }

    public VirtualScan getVirtualScan() {
        return this.virtualScan;
    }

    public QueryRequest setTraceLevel(int level) {
        if (level > 32) {
            throw new IllegalArgumentException("trace level must be <= 32");
        }
        this.traceLevel = level;
        return this;
    }

    public int getTraceLevel() {
        return this.traceLevel;
    }

    public QueryRequest setQueryName(String name) {
        this.queryName = name;
        return this;
    }

    public String getQueryName() {
        return this.queryName;
    }

    public QueryRequest setLogFileTracing(boolean value) {
        this.logFileTracing = value;
        return this;
    }

    public boolean getLogFileTracing() {
        return this.logFileTracing;
    }

    public void addQueryTraces(Map<String, String> traces) {
        if (traces == null) {
            return;
        }
        if (this.serverQueryTraces == null) {
            this.serverQueryTraces = new TreeMap<String, String>();
        }
        this.serverQueryTraces.putAll(traces);
    }

    public void printTrace(PrintStream out) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n\n---------------------------------\n");
        sb.append("CLIENT : " + this.queryName);
        sb.append("\n---------------------------------\n\n");
        if (this.driver != null) {
            sb.append(this.driver.getQueryTrace());
        } else if (this.driverQueryTrace != null) {
            sb.append(this.driverQueryTrace);
        }
        sb.append("\n");
        if (this.serverQueryTraces != null) {
            for (Map.Entry<String, String> entry : this.serverQueryTraces.entrySet()) {
                sb.append("\n\n-------------------------------------------\n");
                sb.append(this.queryName);
                sb.append(": ");
                sb.append(entry.getKey());
                sb.append("\n-------------------------------------------\n\n");
                sb.append(entry.getValue());
                sb.append("\n");
            }
        }
        out.println(sb.toString());
    }

    public int getBatchCounter() {
        return this.batchCounter;
    }

    public void incBatchCounter() {
        ++this.batchCounter;
    }

    public QueryRequest setCompartment(String compartment) {
        super.setCompartmentInternal(compartment);
        return this;
    }

    public int getLimit() {
        return this.limit;
    }

    public QueryRequest setLimit(int limit) {
        if (limit < 0) {
            throw new IllegalArgumentException("limit must be >= 0");
        }
        this.limit = limit;
        return this;
    }

    public int getMaxReadKB() {
        return this.maxReadKB;
    }

    public QueryRequest setMaxReadKB(int maxReadKB) {
        if (maxReadKB < 0) {
            throw new IllegalArgumentException("maxReadKB must be >= 0");
        }
        this.maxReadKB = maxReadKB;
        return this;
    }

    public int getMaxWriteKB() {
        return this.maxWriteKB;
    }

    public QueryRequest setMaxWriteKB(int maxWriteKB) {
        if (maxWriteKB < 0) {
            throw new IllegalArgumentException("maxWriteKB must be >= 0");
        }
        this.maxWriteKB = maxWriteKB;
        return this;
    }

    public QueryRequest setMaxMemoryConsumption(long maxBytes) {
        if (maxBytes < 0L) {
            throw new IllegalArgumentException("maxBytes must be >= 0");
        }
        this.maxMemoryConsumption = maxBytes;
        return this;
    }

    public long getMaxMemoryConsumption() {
        return this.maxMemoryConsumption;
    }

    public QueryRequest setMaxServerMemoryConsumption(long maxBytes) {
        if (maxBytes < 0L) {
            throw new IllegalArgumentException("maxBytes must be >= 0");
        }
        this.maxServerMemoryConsumption = maxBytes;
        return this;
    }

    public long getMaxServerMemoryConsumption() {
        return this.maxServerMemoryConsumption;
    }

    public MathContext getMathContext() {
        return this.mathContext;
    }

    public QueryRequest setMathContext(MathContext mathContext) {
        if (mathContext == null) {
            throw new IllegalArgumentException("mathContext can not be null");
        }
        this.mathContext = mathContext;
        return this;
    }

    public String getStatement() {
        return this.statement;
    }

    public QueryRequest setStatement(String statement) {
        if (statement != null && this.preparedStatement != null && !statement.equals(this.preparedStatement.getSQLText())) {
            throw new IllegalArgumentException("The query text is not equal to the prepared one");
        }
        this.statement = statement;
        return this;
    }

    public PreparedStatement getPreparedStatement() {
        return this.preparedStatement;
    }

    public QueryRequest setPreparedStatement(PreparedStatement preparedStatement) {
        if (this.statement != null && preparedStatement != null && !this.statement.equals(preparedStatement.getSQLText())) {
            throw new IllegalArgumentException("The query text is not equal to the prepared one");
        }
        this.preparedStatement = preparedStatement;
        return this;
    }

    public QueryRequest setPreparedStatement(PrepareResult prepareResult) {
        this.preparedStatement = prepareResult.getPreparedStatement();
        return this;
    }

    @Deprecated
    public byte[] getContinuationKey() {
        return this.continuationKey;
    }

    @Deprecated
    public QueryRequest setContinuationKey(byte[] continuationKey) {
        return this.setContKey(continuationKey);
    }

    public byte[] getContKey() {
        return this.continuationKey;
    }

    public QueryRequest setContKey(byte[] continuationKey) {
        this.continuationKey = continuationKey;
        if (this.driver != null && !this.isInternal && continuationKey == null) {
            this.driverQueryTrace = this.driver.getQueryTrace();
            this.driver.close();
            this.driver = null;
        }
        return this;
    }

    public boolean isDone() {
        return this.continuationKey == null;
    }

    @Override
    public void close() {
        this.setContinuationKey(null);
    }

    public QueryRequest setConsistency(Consistency consistency) {
        this.consistency = consistency;
        return this;
    }

    public QueryRequest setDurability(Durability durability) {
        this.setDurabilityInternal(durability);
        return this;
    }

    public Consistency getConsistency() {
        return this.consistency;
    }

    public QueryRequest setTimeout(int timeoutMs) {
        super.setTimeoutInternal(timeoutMs);
        return this;
    }

    public QueryRequest setNamespace(String namespace) {
        super.setNamespaceInternal(namespace);
        return this;
    }

    public int getTimeout() {
        return super.getTimeoutInternal();
    }

    @Override
    public Serializer createSerializer(SerializerFactory factory) {
        return factory.createQuerySerializer();
    }

    @Override
    public Serializer createDeserializer(SerializerFactory factory) {
        return factory.createQueryDeserializer();
    }

    @Override
    public String getTypeName() {
        return "Query";
    }

    @Override
    public Request setDefaults(NoSQLHandleConfig config) {
        super.setDefaults(config);
        if (this.consistency == null) {
            this.consistency = config.getDefaultConsistency();
        }
        return this;
    }

    @Override
    public void validate() {
        if (this.statement == null && this.preparedStatement == null) {
            throw new IllegalArgumentException("Either statement or prepared statement should be set");
        }
    }

    @Override
    public String getTableName() {
        if (this.preparedStatement == null) {
            return null;
        }
        return this.preparedStatement.getTableName();
    }

    @Override
    public boolean shouldRetry() {
        return false;
    }

    public void setInTestMode(boolean v) {
        this.inTestMode = v;
    }

    public boolean inTestMode() {
        return this.inTestMode;
    }
}

