/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.ops;

import oracle.nosql.driver.ops.Request;
import oracle.nosql.driver.ops.serde.Serializer;
import oracle.nosql.driver.ops.serde.SerializerFactory;
import oracle.nosql.driver.values.TimestampValue;

public class ReplicaStatsRequest
extends Request {
    private String replicaName;
    private long startTime;
    private int limit;

    public ReplicaStatsRequest setTableName(String tableName) {
        super.setTableNameInternal(tableName);
        return this;
    }

    public ReplicaStatsRequest setReplicaName(String replicaName) {
        this.replicaName = replicaName;
        return this;
    }

    public String getReplicaName() {
        return this.replicaName;
    }

    public ReplicaStatsRequest setStartTime(long startTime) {
        if (startTime < 0L) {
            throw new IllegalArgumentException("startTime must be >= 0");
        }
        this.startTime = startTime;
        return this;
    }

    public ReplicaStatsRequest setStartTime(String startTime) {
        this.startTime = new TimestampValue(startTime).getLong();
        return this;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public String getStartTimeString() {
        if (this.startTime == 0L) {
            return null;
        }
        return new TimestampValue(this.startTime).getString();
    }

    public ReplicaStatsRequest setLimit(int limit) {
        if (limit < 0) {
            throw new IllegalArgumentException("limit must be >= 0");
        }
        this.limit = limit;
        return this;
    }

    public int getLimit() {
        return this.limit;
    }

    public ReplicaStatsRequest setCompartment(String compartment) {
        super.setCompartmentInternal(compartment);
        return this;
    }

    public ReplicaStatsRequest setTimeout(int timeoutMs) {
        super.setTimeoutInternal(timeoutMs);
        return this;
    }

    @Override
    public void validate() {
        if (this.tableName == null) {
            throw new IllegalArgumentException("ReplicaStatsRequest requires table name");
        }
    }

    @Override
    public Serializer createSerializer(SerializerFactory factory) {
        return factory.createGetReplicaStatsSerializer();
    }

    @Override
    public Serializer createDeserializer(SerializerFactory factory) {
        return factory.createGetReplicaStatsDeserializer();
    }

    @Override
    public String getTypeName() {
        return "ReplicaStats";
    }

    @Override
    public boolean shouldRetry() {
        return false;
    }
}

