/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.ops;

import oracle.nosql.driver.NoSQLHandleConfig;
import oracle.nosql.driver.RateLimiter;
import oracle.nosql.driver.ops.RetryStats;
import oracle.nosql.driver.ops.serde.Serializer;
import oracle.nosql.driver.ops.serde.SerializerFactory;

public abstract class Request {
    protected int timeoutMs;
    protected String tableName;
    protected String compartment;
    protected String namespace;
    private boolean checkRequestSize = true;
    private RetryStats retryStats;
    private long startNanos;
    private RateLimiter readRateLimiter;
    private RateLimiter writeRateLimiter;
    private int rateLimitDelayedMs;
    private boolean preferThrottling;
    private boolean drlOptIn;
    private boolean isRefresh;
    protected int topoSeqNum = -1;
    private String oboToken;

    protected Request() {
    }

    public int getTimeoutInternal() {
        return this.timeoutMs;
    }

    public void setTimeoutInternal(int timeoutMs) {
        if (timeoutMs <= 0) {
            throw new IllegalArgumentException("timeout must be > 0");
        }
        this.timeoutMs = timeoutMs;
    }

    public Request setDefaults(NoSQLHandleConfig config) {
        if (this.timeoutMs == 0) {
            this.timeoutMs = config.getDefaultRequestTimeout();
        }
        return this;
    }

    public boolean shouldRetry() {
        return true;
    }

    public boolean isQueryRequest() {
        return false;
    }

    public boolean doesReads() {
        return false;
    }

    public boolean doesWrites() {
        return false;
    }

    public void setCompartmentInternal(String compartment) {
        this.compartment = compartment;
    }

    public String getCompartment() {
        return this.compartment;
    }

    protected void setTableNameInternal(String tableName) {
        this.tableName = tableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    protected void setNamespaceInternal(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setReadRateLimiter(RateLimiter rl) {
        this.readRateLimiter = rl;
    }

    public void setWriteRateLimiter(RateLimiter rl) {
        this.writeRateLimiter = rl;
    }

    public RateLimiter getReadRateLimiter() {
        return this.readRateLimiter;
    }

    public RateLimiter getWriteRateLimiter() {
        return this.writeRateLimiter;
    }

    public abstract void validate();

    public abstract Serializer createSerializer(SerializerFactory var1);

    public abstract Serializer createDeserializer(SerializerFactory var1);

    public boolean getCheckRequestSize() {
        return this.checkRequestSize;
    }

    public Request setCheckRequestSize(boolean value) {
        this.checkRequestSize = value;
        return this;
    }

    public RetryStats getRetryStats() {
        return this.retryStats;
    }

    public void setRetryStats(RetryStats rs) {
        this.retryStats = rs;
    }

    public void addRetryException(Class<? extends Throwable> re) {
        if (this.retryStats == null) {
            this.retryStats = new RetryStats();
        }
        this.retryStats.addException(re);
    }

    public void addRetryDelayMs(int millis) {
        if (this.retryStats == null) {
            this.retryStats = new RetryStats();
        }
        this.retryStats.addDelayMs(millis);
    }

    public int getRetryDelayMs() {
        if (this.retryStats == null) {
            return 0;
        }
        return this.retryStats.getDelayMs();
    }

    public void incrementRetries() {
        if (this.retryStats == null) {
            this.retryStats = new RetryStats();
        }
        this.retryStats.incrementRetries();
    }

    public int getNumRetries() {
        if (this.retryStats == null) {
            return 0;
        }
        return this.retryStats.getRetries();
    }

    public void setStartNanos(long nanos) {
        this.startNanos = nanos;
    }

    public long getStartNanos() {
        return this.startNanos;
    }

    public void setRateLimitDelayedMs(int rateLimitDelayedMs) {
        this.rateLimitDelayedMs = rateLimitDelayedMs;
    }

    public int getRateLimitDelayedMs() {
        return this.rateLimitDelayedMs;
    }

    public void setIsRefresh(boolean value) {
        this.isRefresh = value;
    }

    public boolean getIsRefresh() {
        return this.isRefresh;
    }

    public int topoSeqNum() {
        return this.topoSeqNum;
    }

    public void setTopoSeqNum(int n) {
        if (this.topoSeqNum < 0) {
            this.topoSeqNum = n;
        }
    }

    public abstract String getTypeName();

    public void setPreferThrottling(boolean preferThrottling) {
        this.preferThrottling = preferThrottling;
    }

    public boolean getPreferThrottling() {
        return this.preferThrottling;
    }

    public void setDRLOptIn(boolean drlOptIn) {
        this.drlOptIn = drlOptIn;
    }

    public boolean getDRLOptIn() {
        return this.drlOptIn;
    }

    public void setOboTokenInternal(String token) {
        this.oboToken = token;
    }

    public String getOboToken() {
        return this.oboToken;
    }

    public void copyTo(Request other) {
        other.timeoutMs = this.timeoutMs;
        other.checkRequestSize = this.checkRequestSize;
        other.compartment = this.compartment;
        other.tableName = this.tableName;
        other.namespace = this.namespace;
        other.startNanos = this.startNanos;
        other.retryStats = this.retryStats;
        other.readRateLimiter = this.readRateLimiter;
        other.writeRateLimiter = this.writeRateLimiter;
        other.rateLimitDelayedMs = this.rateLimitDelayedMs;
        other.preferThrottling = this.preferThrottling;
        other.drlOptIn = this.drlOptIn;
    }
}

