/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.ops;

import oracle.nosql.driver.DefinedTags;
import oracle.nosql.driver.FreeFormTags;
import oracle.nosql.driver.NoSQLException;
import oracle.nosql.driver.NoSQLHandle;
import oracle.nosql.driver.RequestTimeoutException;
import oracle.nosql.driver.ops.GetTableRequest;
import oracle.nosql.driver.ops.Result;
import oracle.nosql.driver.ops.TableLimits;

public class TableResult
extends Result {
    private String compartmentOrNamespace;
    private String tableOcid;
    private String tableName;
    private State state;
    private TableLimits limits;
    private String schema;
    private String ddl;
    private String operationId;
    private FreeFormTags freeFormTags;
    private DefinedTags definedTags;
    private String matchETag;
    private boolean isFrozen;
    private boolean isLocalReplicaInitialized;
    private Replica[] replicas;

    public State getTableState() {
        return this.state;
    }

    public String getDdl() {
        return this.ddl;
    }

    public String getTableId() {
        return this.tableOcid;
    }

    public String getCompartmentId() {
        return this.compartmentOrNamespace;
    }

    public String getNamespace() {
        return this.compartmentOrNamespace;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getSchema() {
        return this.schema;
    }

    public TableLimits getTableLimits() {
        return this.limits;
    }

    public FreeFormTags getFreeFormTags() {
        return this.freeFormTags;
    }

    public DefinedTags getDefinedTags() {
        return this.definedTags;
    }

    public String getMatchETag() {
        return this.matchETag;
    }

    public String getOperationId() {
        return this.operationId;
    }

    public boolean isFrozen() {
        return this.isFrozen;
    }

    public boolean isReplicated() {
        return this.replicas != null;
    }

    public boolean isLocalReplicaInitialized() {
        return this.isLocalReplicaInitialized;
    }

    public Replica[] getReplicas() {
        return this.replicas;
    }

    public TableResult setOperationId(String operationId) {
        this.operationId = operationId;
        return this;
    }

    public TableResult setState(State state) {
        this.state = state;
        return this;
    }

    public TableResult setCompartmentId(String value) {
        this.compartmentOrNamespace = value;
        return this;
    }

    public TableResult setNamespace(String value) {
        this.compartmentOrNamespace = value;
        return this;
    }

    public TableResult setTableId(String value) {
        this.tableOcid = value;
        return this;
    }

    public TableResult setTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public TableResult setSchema(String schema) {
        this.schema = schema;
        return this;
    }

    public TableResult setDdl(String ddl) {
        this.ddl = ddl;
        return this;
    }

    public TableResult setTableLimits(TableLimits limits) {
        this.limits = limits;
        return this;
    }

    public TableResult setFreeFormTags(FreeFormTags tags) {
        this.freeFormTags = tags;
        return this;
    }

    public TableResult setDefinedTags(DefinedTags tags) {
        this.definedTags = tags;
        return this;
    }

    public TableResult setMatchETag(String matchETag) {
        this.matchETag = matchETag;
        return this;
    }

    public TableResult setIsFrozen(boolean frozen) {
        this.isFrozen = frozen;
        return this;
    }

    public TableResult setLocalReplicaInitialized(boolean initialized) {
        this.isLocalReplicaInitialized = initialized;
        return this;
    }

    public TableResult setReplicas(Replica[] replicas) {
        this.replicas = replicas;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("table ");
        sb.append(this.tableName).append("state=[").append((Object)this.state).append("] ");
        if (this.limits != null) {
            sb.append("\nlimits=").append(this.limits);
        }
        if (this.schema != null) {
            sb.append("\nschema=[" + this.schema + "]");
        }
        if (this.ddl != null) {
            sb.append("\nddl=[" + this.ddl + "]");
        }
        if (this.operationId != null) {
            sb.append("\noperationId=").append(this.operationId);
        }
        if (this.matchETag != null) {
            sb.append("\nmatchETag=").append(this.matchETag);
        }
        if (this.isFrozen) {
            sb.append("\nisFrozen=").append(this.isFrozen);
        }
        if (this.isReplicated()) {
            sb.append("\nisLocalReplicaInitialized=").append(this.isLocalReplicaInitialized);
            sb.append("\nreplicas=[");
            boolean first = true;
            for (Replica rep : this.replicas) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(rep.toString());
            }
            sb.append("]");
        }
        return sb.toString();
    }

    @Deprecated
    public static TableResult waitForState(NoSQLHandle handle, TableResult result, State state, int waitMillis, int delayMillis) {
        return TableResult.waitForState(handle, result.getTableName(), result.getCompartmentId(), result.getOperationId(), state, waitMillis, delayMillis);
    }

    @Deprecated
    public static TableResult waitForState(NoSQLHandle handle, String tableName, State state, int waitMillis, int delayMillis) {
        return TableResult.waitForState(handle, tableName, null, null, state, waitMillis, delayMillis);
    }

    @Deprecated
    public static TableResult waitForState(NoSQLHandle handle, String tableName, String operationId, State state, int waitMillis, int delayMillis) {
        return TableResult.waitForState(handle, tableName, null, operationId, state, waitMillis, delayMillis);
    }

    private static TableResult waitForState(NoSQLHandle handle, String tableName, String compartment, String operationId, State state, int waitMillis, int delayMillis) {
        int delayMS;
        int DELAY_MS = 500;
        int n = delayMS = delayMillis != 0 ? delayMillis : 500;
        if (waitMillis < delayMillis) {
            throw new IllegalArgumentException("Wait milliseconds must be a mininum of 500 and greater than delay milliseconds");
        }
        long startTime = System.currentTimeMillis();
        GetTableRequest getTable = new GetTableRequest().setTableName(tableName).setOperationId(operationId).setCompartment(compartment);
        TableResult res = null;
        do {
            long curTime;
            if ((curTime = System.currentTimeMillis()) - startTime > (long)waitMillis) {
                throw new RequestTimeoutException(waitMillis, "Expected table state (" + (Object)((Object)state) + ") for table " + tableName + " not reached ");
            }
            try {
                if (res != null) {
                    Thread.sleep(delayMS);
                }
                res = handle.getTable(getTable);
            }
            catch (InterruptedException ie) {
                throw new NoSQLException("waitForState interrupted: " + ie.getMessage());
            }
        } while (!res.getTableState().equals((Object)state));
        return res;
    }

    public void waitForCompletion(NoSQLHandle handle, int waitMillis, int delayMillis) {
        int delayMS;
        if (this.isTerminal()) {
            return;
        }
        if (this.operationId == null) {
            throw new IllegalArgumentException("Operation state must not be null");
        }
        int DELAY_MS = 500;
        int n = delayMS = delayMillis != 0 ? delayMillis : 500;
        if (waitMillis < delayMillis) {
            throw new IllegalArgumentException("Wait milliseconds must be a mininum of 500 and greater than delay milliseconds");
        }
        long startTime = System.currentTimeMillis();
        GetTableRequest getTable = new GetTableRequest().setTableName(this.tableName).setOperationId(this.operationId).setCompartment(this.compartmentOrNamespace);
        TableResult res = null;
        while (!this.isTerminal()) {
            long curTime = System.currentTimeMillis();
            if (curTime - startTime > (long)waitMillis) {
                throw new RequestTimeoutException(waitMillis, "Operation not completed in expected time");
            }
            try {
                if (res != null) {
                    Thread.sleep(delayMS);
                }
                res = handle.getTable(getTable);
                this.state = res.getTableState();
                this.limits = res.getTableLimits();
                this.schema = res.getSchema();
                this.matchETag = res.getMatchETag();
                this.ddl = res.getDdl();
                this.isFrozen = res.isFrozen();
                this.isLocalReplicaInitialized = res.isLocalReplicaInitialized();
                this.replicas = res.getReplicas();
            }
            catch (InterruptedException ie) {
                throw new NoSQLException("waitForCompletion interrupted: " + ie.getMessage());
            }
        }
    }

    private boolean isTerminal() {
        return this.state == State.ACTIVE || this.state == State.DROPPED;
    }

    public static enum State {
        ACTIVE,
        CREATING,
        DROPPED,
        DROPPING,
        UPDATING;

    }

    public static class Replica {
        private String replicaName;
        private String tableOcid;
        private int writeUnits;
        private TableLimits.CapacityMode mode;
        private State state;

        public String getReplicaName() {
            return this.replicaName;
        }

        public String getTableId() {
            return this.tableOcid;
        }

        public int getWriteUnits() {
            return this.writeUnits;
        }

        public TableLimits.CapacityMode getCapacityMode() {
            return this.mode;
        }

        public State getState() {
            return this.state;
        }

        public Replica setReplicaName(String replicaName) {
            this.replicaName = replicaName;
            return this;
        }

        public Replica setTableId(String tableOcid) {
            this.tableOcid = tableOcid;
            return this;
        }

        public Replica setWriteUnits(int writeUnits) {
            this.writeUnits = writeUnits;
            return this;
        }

        public Replica setCapacityMode(TableLimits.CapacityMode mode) {
            this.mode = mode;
            return this;
        }

        public Replica setState(State state) {
            this.state = state;
            return this;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Replica[replicaName=").append(this.replicaName);
            sb.append(", state=").append((Object)this.state);
            if (this.tableOcid != null) {
                sb.append(", tableId=").append(this.tableOcid);
            }
            if (this.writeUnits > 0) {
                sb.append(", writeUnits=").append(this.writeUnits);
            }
            if (this.mode != null) {
                sb.append(", mode=").append((Object)this.mode);
            }
            sb.append("]");
            return sb.toString();
        }
    }
}

