/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.ops.serde;

import java.io.IOException;
import oracle.nosql.driver.BatchOperationNumberLimitException;
import oracle.nosql.driver.Consistency;
import oracle.nosql.driver.DeploymentException;
import oracle.nosql.driver.Durability;
import oracle.nosql.driver.EvolutionLimitException;
import oracle.nosql.driver.FieldRange;
import oracle.nosql.driver.IndexExistsException;
import oracle.nosql.driver.IndexLimitException;
import oracle.nosql.driver.IndexNotFoundException;
import oracle.nosql.driver.InvalidAuthorizationException;
import oracle.nosql.driver.KeySizeLimitException;
import oracle.nosql.driver.NoSQLException;
import oracle.nosql.driver.Nson;
import oracle.nosql.driver.OperationNotSupportedException;
import oracle.nosql.driver.OperationThrottlingException;
import oracle.nosql.driver.PrepareQueryException;
import oracle.nosql.driver.ReadThrottlingException;
import oracle.nosql.driver.RequestSizeLimitException;
import oracle.nosql.driver.RequestTimeoutException;
import oracle.nosql.driver.ResourceExistsException;
import oracle.nosql.driver.ResourceNotFoundException;
import oracle.nosql.driver.RowSizeLimitException;
import oracle.nosql.driver.SecurityInfoNotReadyException;
import oracle.nosql.driver.SystemException;
import oracle.nosql.driver.TableExistsException;
import oracle.nosql.driver.TableLimitException;
import oracle.nosql.driver.TableNotFoundException;
import oracle.nosql.driver.TableNotReadyException;
import oracle.nosql.driver.TableSizeException;
import oracle.nosql.driver.TimeToLive;
import oracle.nosql.driver.UnauthorizedException;
import oracle.nosql.driver.UnsupportedProtocolException;
import oracle.nosql.driver.UnsupportedQueryVersionException;
import oracle.nosql.driver.Version;
import oracle.nosql.driver.WriteThrottlingException;
import oracle.nosql.driver.http.Client;
import oracle.nosql.driver.kv.AuthenticationException;
import oracle.nosql.driver.ops.PutResult;
import oracle.nosql.driver.ops.ReadRequest;
import oracle.nosql.driver.ops.Request;
import oracle.nosql.driver.ops.Result;
import oracle.nosql.driver.ops.SystemResult;
import oracle.nosql.driver.ops.TableLimits;
import oracle.nosql.driver.ops.TableResult;
import oracle.nosql.driver.ops.WriteMultipleRequest;
import oracle.nosql.driver.ops.WriteRequest;
import oracle.nosql.driver.ops.WriteResult;
import oracle.nosql.driver.query.TopologyInfo;
import oracle.nosql.driver.util.BinaryProtocol;
import oracle.nosql.driver.util.ByteInputStream;
import oracle.nosql.driver.util.ByteOutputStream;
import oracle.nosql.driver.util.SerializationUtil;

public class BinaryProtocol
extends Nson {
    static void writeTimeout(ByteOutputStream out, int timeout) throws IOException {
        SerializationUtil.writePackedInt(out, timeout);
    }

    static void writeConsistency(ByteOutputStream out, Consistency consistency) throws IOException {
        out.writeByte(BinaryProtocol.getConsistency(consistency));
    }

    static void writeDurability(ByteOutputStream out, Durability durability, short serialVersion) throws IOException {
        if (serialVersion > 2) {
            out.writeByte(BinaryProtocol.getDurability(durability));
        }
    }

    static void writeTTL(ByteOutputStream out, TimeToLive ttl) throws IOException {
        if (ttl == null) {
            BinaryProtocol.writeLong(out, -1L);
            return;
        }
        BinaryProtocol.writeLong(out, ttl.getValue());
        if (ttl.unitIsDays()) {
            out.writeByte(2);
        } else if (ttl.unitIsHours()) {
            out.writeByte(1);
        } else {
            throw new IllegalStateException("Invalid TTL unit in ttl " + ttl);
        }
    }

    static void writeOpCode(ByteOutputStream out, BinaryProtocol.OpCode op) throws IOException {
        out.writeByte(op.ordinal());
    }

    static void writeCapacityMode(ByteOutputStream out, TableLimits.CapacityMode mode, short serialVersion) throws IOException {
        if (serialVersion < 3) {
            return;
        }
        switch (mode) {
            case PROVISIONED: {
                out.writeByte(1);
                break;
            }
            case ON_DEMAND: {
                out.writeByte(2);
            }
        }
    }

    static void writeFieldRange(ByteOutputStream out, FieldRange range) throws IOException {
        if (range == null) {
            out.writeBoolean(false);
            return;
        }
        out.writeBoolean(true);
        BinaryProtocol.writeString(out, range.getFieldPath());
        if (range.getStart() != null) {
            out.writeBoolean(true);
            BinaryProtocol.writeFieldValue(out, range.getStart());
            out.writeBoolean(range.getStartInclusive());
        } else {
            out.writeBoolean(false);
        }
        if (range.getEnd() != null) {
            out.writeBoolean(true);
            BinaryProtocol.writeFieldValue(out, range.getEnd());
            out.writeBoolean(range.getEndInclusive());
        } else {
            out.writeBoolean(false);
        }
    }

    public static void writeVersion(ByteOutputStream out, Version version) throws IOException {
        SerializationUtil.writeNonNullByteArray(out, version.getBytes());
    }

    static void serializeReadRequest(ReadRequest readRq, ByteOutputStream out) throws IOException {
        BinaryProtocol.serializeRequest(readRq, out);
        BinaryProtocol.writeString(out, readRq.getTableName());
        BinaryProtocol.writeConsistency(out, readRq.getConsistencyInternal());
    }

    static void serializeWriteRequest(WriteRequest writeRq, ByteOutputStream out, short serialVersion) throws IOException {
        BinaryProtocol.serializeRequest(writeRq, out);
        BinaryProtocol.writeString(out, writeRq.getTableName());
        out.writeBoolean(writeRq.getReturnRowInternal());
        BinaryProtocol.writeDurability(out, writeRq.getDurability(), serialVersion);
    }

    protected static void serializeRequest(Request rq, ByteOutputStream out) throws IOException {
        BinaryProtocol.writeTimeout(out, rq.getTimeoutInternal());
    }

    static Version readVersion(ByteInputStream in) throws IOException {
        return Version.createVersion(BinaryProtocol.readByteArray(in));
    }

    static void deserializeConsumedCapacity(ByteInputStream in, Result result) throws IOException {
        result.setReadUnits(SerializationUtil.readPackedInt(in));
        result.setReadKB(SerializationUtil.readPackedInt(in));
        result.setWriteKB(SerializationUtil.readPackedInt(in));
    }

    static void deserializeWriteResponse(ByteInputStream in, WriteResult result, short serialVersion) throws IOException {
        boolean returnInfo = in.readBoolean();
        if (!returnInfo) {
            return;
        }
        result.setExistingValue(BinaryProtocol.readFieldValue(in).asMap());
        result.setExistingVersion(BinaryProtocol.readVersion(in));
        if (serialVersion > 2) {
            result.setExistingModificationTime(BinaryProtocol.readLong(in));
        } else {
            result.setExistingModificationTime(-1L);
        }
    }

    static void deserializeGeneratedValue(ByteInputStream in, PutResult result) throws IOException {
        boolean hasGeneratedValue = in.readBoolean();
        if (!hasGeneratedValue) {
            return;
        }
        result.setGeneratedValue(BinaryProtocol.readFieldValue(in));
    }

    static TableResult deserializeTableResult(ByteInputStream in, short serialVersion) throws IOException {
        TableResult result = new TableResult();
        boolean hasInfo = in.readBoolean();
        if (hasInfo) {
            result.setCompartmentId(BinaryProtocol.readString(in));
            result.setTableName(BinaryProtocol.readString(in));
            result.setState(BinaryProtocol.getTableState(in.readByte()));
            boolean hasStaticState = in.readBoolean();
            if (hasStaticState) {
                int readKb = BinaryProtocol.readInt(in);
                int writeKb = BinaryProtocol.readInt(in);
                int storageGB = BinaryProtocol.readInt(in);
                TableLimits.CapacityMode mode = serialVersion > 2 ? BinaryProtocol.getCapacityMode(in.readByte()) : TableLimits.CapacityMode.PROVISIONED;
                if (readKb != 0 || writeKb != 0 || storageGB != 0) {
                    result.setTableLimits(new TableLimits(readKb, writeKb, storageGB, mode));
                }
                result.setSchema(BinaryProtocol.readString(in));
            }
            result.setOperationId(BinaryProtocol.readString(in));
        }
        return result;
    }

    static SystemResult deserializeSystemResult(ByteInputStream in) throws IOException {
        SystemResult result = new SystemResult();
        result.setState(BinaryProtocol.getOperationState(in.readByte()));
        result.setOperationId(BinaryProtocol.readString(in));
        result.setStatement(BinaryProtocol.readString(in));
        result.setResultString(BinaryProtocol.readString(in));
        return result;
    }

    public static TopologyInfo readTopologyInfo(ByteInputStream in) throws IOException {
        int seqNum = SerializationUtil.readPackedInt(in);
        Client.trace("readTopologyInfo: seqNum =  " + seqNum, 4);
        if (seqNum < -1) {
            throw new IOException("Invalid topology sequence number: " + seqNum);
        }
        if (seqNum == -1) {
            return null;
        }
        int[] shardIds = SerializationUtil.readPackedIntArray(in);
        return new TopologyInfo(seqNum, shardIds);
    }

    public static RuntimeException mapException(int code, String msg) {
        switch (code) {
            case 1: 
            case 125: {
                return new NoSQLException("Unknown error: " + msg);
            }
            case 2: {
                return new TableNotFoundException(msg);
            }
            case 16: {
                return new IndexLimitException(msg);
            }
            case 15: {
                return new TableLimitException(msg);
            }
            case 18: {
                return new EvolutionLimitException(msg);
            }
            case 3: {
                return new IndexNotFoundException(msg);
            }
            case 4: {
                return new IllegalArgumentException(msg);
            }
            case 50: {
                return new ReadThrottlingException(msg);
            }
            case 51: {
                return new WriteThrottlingException(msg);
            }
            case 52: {
                return new TableSizeException(msg);
            }
            case 5: {
                return new RowSizeLimitException(msg);
            }
            case 6: {
                return new KeySizeLimitException(msg);
            }
            case 7: {
                return new BatchOperationNumberLimitException(msg);
            }
            case 8: {
                return new RequestSizeLimitException(msg);
            }
            case 9: {
                return new TableExistsException(msg);
            }
            case 10: {
                return new IndexExistsException(msg);
            }
            case 19: 
            case 20: {
                return new DeploymentException(msg);
            }
            case 126: {
                return new IllegalStateException(msg);
            }
            case 101: 
            case 102: {
                return new SystemException(msg);
            }
            case 17: {
                if (msg.contains("Invalid driver serial version")) {
                    return new UnsupportedProtocolException(msg);
                }
                if (msg.contains("Invalid query version")) {
                    return new UnsupportedQueryVersionException(msg);
                }
                return new IllegalArgumentException("Bad protocol message: " + msg);
            }
            case 24: {
                return new UnsupportedProtocolException(msg);
            }
            case 27: {
                return new UnsupportedQueryVersionException(msg);
            }
            case 100: {
                return new RequestTimeoutException(msg);
            }
            case 11: {
                return new InvalidAuthorizationException(msg);
            }
            case 12: {
                return new UnauthorizedException(msg);
            }
            case 104: {
                return new SecurityInfoNotReadyException(msg);
            }
            case 105: {
                return new AuthenticationException(msg);
            }
            case 53: {
                return new OperationThrottlingException(msg);
            }
            case 13: {
                return new ResourceExistsException(msg);
            }
            case 14: {
                return new ResourceNotFoundException(msg);
            }
            case 21: {
                return new OperationNotSupportedException(msg);
            }
            case 26: {
                return new TableNotReadyException(msg);
            }
            case 22: {
                return new IllegalArgumentException(msg);
            }
            case 28: {
                return new PrepareQueryException(msg);
            }
        }
        return new NoSQLException("Unknown error code " + code + ": " + msg);
    }

    private static int getConsistency(Consistency consistency) {
        if (consistency == Consistency.ABSOLUTE) {
            return 0;
        }
        return 1;
    }

    private static int getDurability(Durability durability) {
        if (durability == null) {
            return 0;
        }
        int dur = 0;
        switch (durability.getMasterSync()) {
            case NO_SYNC: {
                dur = 2;
                break;
            }
            case SYNC: {
                dur = 1;
                break;
            }
            case WRITE_NO_SYNC: {
                dur = 3;
            }
        }
        switch (durability.getReplicaSync()) {
            case NO_SYNC: {
                dur |= 8;
                break;
            }
            case SYNC: {
                dur |= 4;
                break;
            }
            case WRITE_NO_SYNC: {
                dur |= 0xC;
            }
        }
        switch (durability.getReplicaAck()) {
            case ALL: {
                dur |= 0x10;
                break;
            }
            case NONE: {
                dur |= 0x20;
                break;
            }
            case SIMPLE_MAJORITY: {
                dur |= 0x30;
            }
        }
        return dur;
    }

    public static TableResult.State getTableState(int state) {
        switch (state) {
            case 0: {
                return TableResult.State.ACTIVE;
            }
            case 1: {
                return TableResult.State.CREATING;
            }
            case 2: {
                return TableResult.State.DROPPED;
            }
            case 3: {
                return TableResult.State.DROPPING;
            }
            case 4: {
                return TableResult.State.UPDATING;
            }
        }
        throw new IllegalStateException("Unknown table state " + state);
    }

    static TableLimits.CapacityMode getCapacityMode(int mode) {
        switch (mode) {
            case 1: {
                return TableLimits.CapacityMode.PROVISIONED;
            }
            case 2: {
                return TableLimits.CapacityMode.ON_DEMAND;
            }
        }
        throw new IllegalStateException("Unknown capacity mode " + mode);
    }

    static SystemResult.State getOperationState(int state) {
        switch (state) {
            case 0: {
                return SystemResult.State.COMPLETE;
            }
            case 1: {
                return SystemResult.State.WORKING;
            }
        }
        throw new IllegalStateException("Unknown operation state " + state);
    }

    public static void checkRequestSizeLimit(Request request, int requestSize) {
        int requestSizeLimit;
        if (!request.getCheckRequestSize()) {
            return;
        }
        int n = requestSizeLimit = request instanceof WriteMultipleRequest ? 0x1900000 : 0x200000;
        if (requestSize > requestSizeLimit) {
            throw new RequestSizeLimitException("The request size of " + requestSize + " exceeded the limit of " + requestSizeLimit);
        }
    }
}

