/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.ops.serde.nson;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.nosql.driver.Consistency;
import oracle.nosql.driver.DefinedTags;
import oracle.nosql.driver.Durability;
import oracle.nosql.driver.FieldRange;
import oracle.nosql.driver.FreeFormTags;
import oracle.nosql.driver.NoSQLException;
import oracle.nosql.driver.Nson;
import oracle.nosql.driver.UnsupportedProtocolException;
import oracle.nosql.driver.Version;
import oracle.nosql.driver.ops.AddReplicaRequest;
import oracle.nosql.driver.ops.DeleteRequest;
import oracle.nosql.driver.ops.DeleteResult;
import oracle.nosql.driver.ops.DropReplicaRequest;
import oracle.nosql.driver.ops.GetIndexesRequest;
import oracle.nosql.driver.ops.GetIndexesResult;
import oracle.nosql.driver.ops.GetRequest;
import oracle.nosql.driver.ops.GetResult;
import oracle.nosql.driver.ops.GetTableRequest;
import oracle.nosql.driver.ops.ListTablesRequest;
import oracle.nosql.driver.ops.ListTablesResult;
import oracle.nosql.driver.ops.MultiDeleteRequest;
import oracle.nosql.driver.ops.MultiDeleteResult;
import oracle.nosql.driver.ops.PrepareRequest;
import oracle.nosql.driver.ops.PrepareResult;
import oracle.nosql.driver.ops.PreparedStatement;
import oracle.nosql.driver.ops.PutRequest;
import oracle.nosql.driver.ops.PutResult;
import oracle.nosql.driver.ops.QueryRequest;
import oracle.nosql.driver.ops.QueryResult;
import oracle.nosql.driver.ops.ReplicaStatsRequest;
import oracle.nosql.driver.ops.ReplicaStatsResult;
import oracle.nosql.driver.ops.Request;
import oracle.nosql.driver.ops.Result;
import oracle.nosql.driver.ops.SystemRequest;
import oracle.nosql.driver.ops.SystemResult;
import oracle.nosql.driver.ops.SystemStatusRequest;
import oracle.nosql.driver.ops.TableLimits;
import oracle.nosql.driver.ops.TableRequest;
import oracle.nosql.driver.ops.TableResult;
import oracle.nosql.driver.ops.TableUsageRequest;
import oracle.nosql.driver.ops.TableUsageResult;
import oracle.nosql.driver.ops.WriteMultipleRequest;
import oracle.nosql.driver.ops.WriteMultipleResult;
import oracle.nosql.driver.ops.WriteRequest;
import oracle.nosql.driver.ops.WriteResult;
import oracle.nosql.driver.ops.serde.BinaryProtocol;
import oracle.nosql.driver.ops.serde.Serializer;
import oracle.nosql.driver.ops.serde.SerializerFactory;
import oracle.nosql.driver.ops.serde.nson.NsonProtocol;
import oracle.nosql.driver.query.PlanIter;
import oracle.nosql.driver.query.QueryDriver;
import oracle.nosql.driver.query.TopologyInfo;
import oracle.nosql.driver.query.VirtualScan;
import oracle.nosql.driver.util.BinaryProtocol;
import oracle.nosql.driver.util.ByteInputStream;
import oracle.nosql.driver.util.ByteOutputStream;
import oracle.nosql.driver.util.NettyByteInputStream;
import oracle.nosql.driver.values.FieldValue;
import oracle.nosql.driver.values.JsonUtils;
import oracle.nosql.driver.values.MapValue;
import oracle.nosql.driver.values.MapWalker;
import oracle.nosql.driver.values.TimestampValue;

public class NsonSerializerFactory
implements SerializerFactory {
    private static NsonSerializerFactory factory = new NsonSerializerFactory();
    static final Serializer delSerializer = new DeleteRequestSerializer();
    static final Serializer getSerializer = new GetRequestSerializer();
    static final Serializer putSerializer = new PutRequestSerializer();
    static final Serializer tableSerializer = new TableRequestSerializer();
    static final Serializer getTableSerializer = new GetTableRequestSerializer();
    static final Serializer querySerializer = new QueryRequestSerializer();
    static final Serializer prepareSerializer = new PrepareRequestSerializer();
    static final Serializer getTableUsageSerializer = new TableUsageRequestSerializer();
    static final Serializer systemSerializer = new SystemRequestSerializer();
    static final Serializer systemStatusSerializer = new SystemStatusRequestSerializer();
    static final Serializer listTablesSerializer = new ListTablesRequestSerializer();
    static final Serializer getIndexesSerializer = new GetIndexesRequestSerializer();
    static final Serializer writeMultipleSerializer = new WriteMultipleRequestSerializer();
    static final Serializer multiDeleteSerializer = new MultiDeleteRequestSerializer();
    static final Serializer addReplicaSerializer = new AddReplicaRequestSerializer();
    static final Serializer dropReplicaSerializer = new DropReplicaRequestSerializer();
    static final Serializer getReplicaStatsSerializer = new GetReplicaStatsRequestSerializer();

    public static SerializerFactory getFactory() {
        return factory;
    }

    @Override
    public Serializer createDeleteSerializer() {
        return delSerializer;
    }

    @Override
    public Serializer createGetSerializer() {
        return getSerializer;
    }

    @Override
    public Serializer createPutSerializer() {
        return putSerializer;
    }

    @Override
    public Serializer createQuerySerializer() {
        return querySerializer;
    }

    @Override
    public Serializer createPrepareSerializer() {
        return prepareSerializer;
    }

    @Override
    public Serializer createGetTableSerializer() {
        return getTableSerializer;
    }

    @Override
    public Serializer createGetTableUsageSerializer() {
        return getTableUsageSerializer;
    }

    @Override
    public Serializer createListTablesSerializer() {
        return listTablesSerializer;
    }

    @Override
    public Serializer createGetIndexesSerializer() {
        return getIndexesSerializer;
    }

    @Override
    public Serializer createTableOpSerializer() {
        return tableSerializer;
    }

    @Override
    public Serializer createSystemOpSerializer() {
        return systemSerializer;
    }

    @Override
    public Serializer createSystemStatusSerializer() {
        return systemStatusSerializer;
    }

    @Override
    public Serializer createWriteMultipleSerializer() {
        return writeMultipleSerializer;
    }

    @Override
    public Serializer createMultiDeleteSerializer() {
        return multiDeleteSerializer;
    }

    @Override
    public Serializer createAddReplicaSerializer() {
        return addReplicaSerializer;
    }

    @Override
    public Serializer createDropReplicaSerializer() {
        return dropReplicaSerializer;
    }

    @Override
    public Serializer createGetReplicaStatsSerializer() {
        return getReplicaStatsSerializer;
    }

    @Override
    public Serializer createDeleteDeserializer() {
        return delSerializer;
    }

    @Override
    public Serializer createGetDeserializer() {
        return getSerializer;
    }

    @Override
    public Serializer createPutDeserializer() {
        return putSerializer;
    }

    @Override
    public Serializer createQueryDeserializer() {
        return querySerializer;
    }

    @Override
    public Serializer createPrepareDeserializer() {
        return prepareSerializer;
    }

    @Override
    public Serializer createGetTableDeserializer() {
        return tableSerializer;
    }

    @Override
    public Serializer createGetTableUsageDeserializer() {
        return getTableUsageSerializer;
    }

    @Override
    public Serializer createListTablesDeserializer() {
        return listTablesSerializer;
    }

    @Override
    public Serializer createGetIndexesDeserializer() {
        return getIndexesSerializer;
    }

    @Override
    public Serializer createTableOpDeserializer() {
        return tableSerializer;
    }

    @Override
    public Serializer createSystemOpDeserializer() {
        return systemSerializer;
    }

    @Override
    public Serializer createSystemStatusDeserializer() {
        return systemStatusSerializer;
    }

    @Override
    public Serializer createWriteMultipleDeserializer() {
        return writeMultipleSerializer;
    }

    @Override
    public Serializer createMultiDeleteDeserializer() {
        return multiDeleteSerializer;
    }

    @Override
    public Serializer createAddReplicaDeserializer() {
        return addReplicaSerializer;
    }

    @Override
    public Serializer createDropReplicaDeserializer() {
        return dropReplicaSerializer;
    }

    @Override
    public Serializer createGetReplicaStatsDeserializer() {
        return getReplicaStatsSerializer;
    }

    @Override
    public String getSerdeVersionString() {
        return "v4";
    }

    @Override
    public void writeSerialVersion(short serialVersion, ByteOutputStream bos) throws IOException {
        bos.writeShort(serialVersion);
    }

    static String printNson(ByteInputStream in, boolean pretty) {
        int offset = in.getOffset();
        String ret = JsonUtils.fromNson(in, pretty);
        in.setOffset(offset);
        return ret;
    }

    public static class DeleteRequestSerializer
    extends NsonSerializerBase {
        @Override
        public void serialize(Request request, short serialVersion, ByteOutputStream out) throws IOException {
            DeleteRequest rq = (DeleteRequest)request;
            Version matchVersion = rq.getMatchVersion();
            BinaryProtocol.OpCode opCode = matchVersion != null ? BinaryProtocol.OpCode.DELETE_IF_VERSION : BinaryProtocol.OpCode.DELETE;
            Nson.NsonSerializer ns = new Nson.NsonSerializer(out);
            ns.startMap(0);
            DeleteRequestSerializer.startMap(ns, NsonProtocol.HEADER);
            DeleteRequestSerializer.writeHeader(ns, opCode.ordinal(), rq);
            DeleteRequestSerializer.endMap(ns, NsonProtocol.HEADER);
            DeleteRequestSerializer.startMap(ns, NsonProtocol.PAYLOAD);
            DeleteRequestSerializer.writeWriteRequest(ns, rq);
            this.serializeInternal(rq, ns);
            DeleteRequestSerializer.endMap(ns, NsonProtocol.PAYLOAD);
            ns.endMap(0);
        }

        @Override
        public Result deserialize(Request request, ByteInputStream in, short serialVersion) throws IOException {
            DeleteResult result = new DeleteResult();
            in.setOffset(0);
            MapWalker walker = DeleteRequestSerializer.getMapWalker(in);
            while (walker.hasNext()) {
                walker.next();
                String name = walker.getCurrentName();
                if (name.equals(NsonProtocol.ERROR_CODE)) {
                    DeleteRequestSerializer.handleErrorCode(walker);
                    continue;
                }
                if (name.equals(NsonProtocol.CONSUMED)) {
                    DeleteRequestSerializer.readConsumedCapacity(in, result);
                    continue;
                }
                if (name.equals(NsonProtocol.SUCCESS)) {
                    result.setSuccess(Nson.readNsonBoolean(in));
                    continue;
                }
                if (name.equals(NsonProtocol.RETURN_INFO)) {
                    DeleteRequestSerializer.readReturnInfo(in, result);
                    continue;
                }
                if (name.equals(NsonProtocol.TOPOLOGY_INFO)) {
                    DeleteRequestSerializer.readTopologyInfo(in, result);
                    continue;
                }
                DeleteRequestSerializer.skipUnknownField(walker, name);
            }
            return result;
        }

        void serializeInternal(DeleteRequest rq, Nson.NsonSerializer ns) throws IOException {
            if (rq.getMatchVersion() != null) {
                DeleteRequestSerializer.writeMapField(ns, NsonProtocol.ROW_VERSION, rq.getMatchVersion().getBytes());
            }
            DeleteRequestSerializer.writeKey(ns, rq);
        }
    }

    public static class GetRequestSerializer
    extends NsonSerializerBase {
        @Override
        public void serialize(Request request, short serialVersion, ByteOutputStream out) throws IOException {
            GetRequest rq = (GetRequest)request;
            Nson.NsonSerializer ns = new Nson.NsonSerializer(out);
            ns.startMap(0);
            GetRequestSerializer.startMap(ns, NsonProtocol.HEADER);
            GetRequestSerializer.writeHeader(ns, BinaryProtocol.OpCode.GET.ordinal(), rq);
            GetRequestSerializer.endMap(ns, NsonProtocol.HEADER);
            GetRequestSerializer.startMap(ns, NsonProtocol.PAYLOAD);
            GetRequestSerializer.writeConsistency(ns, rq.getConsistencyInternal());
            GetRequestSerializer.writeKey(ns, rq);
            GetRequestSerializer.endMap(ns, NsonProtocol.PAYLOAD);
            ns.endMap(0);
        }

        @Override
        public Result deserialize(Request request, ByteInputStream in, short serialVersion) throws IOException {
            GetResult result = new GetResult();
            MapWalker walker = GetRequestSerializer.getMapWalker(in);
            while (walker.hasNext()) {
                walker.next();
                String name = walker.getCurrentName();
                if (name.equals(NsonProtocol.ERROR_CODE)) {
                    GetRequestSerializer.handleErrorCode(walker);
                    continue;
                }
                if (name.equals(NsonProtocol.CONSUMED)) {
                    GetRequestSerializer.readConsumedCapacity(in, result);
                    continue;
                }
                if (name.equals(NsonProtocol.ROW)) {
                    GetRequestSerializer.readRow(in, result);
                    continue;
                }
                if (name.equals(NsonProtocol.TOPOLOGY_INFO)) {
                    GetRequestSerializer.readTopologyInfo(in, result);
                    continue;
                }
                GetRequestSerializer.skipUnknownField(walker, name);
            }
            return result;
        }
    }

    public static class PutRequestSerializer
    extends NsonSerializerBase {
        @Override
        public void serialize(Request request, short serialVersion, ByteOutputStream out) throws IOException {
            PutRequest rq = (PutRequest)request;
            Nson.NsonSerializer ns = new Nson.NsonSerializer(out);
            ns.startMap(0);
            PutRequestSerializer.startMap(ns, NsonProtocol.HEADER);
            PutRequestSerializer.writeHeader(ns, PutRequestSerializer.getOpCode(rq).ordinal(), rq);
            PutRequestSerializer.endMap(ns, NsonProtocol.HEADER);
            PutRequestSerializer.startMap(ns, NsonProtocol.PAYLOAD);
            PutRequestSerializer.writeWriteRequest(ns, rq);
            this.serializeInternal(rq, ns);
            PutRequestSerializer.endMap(ns, NsonProtocol.PAYLOAD);
            ns.endMap(0);
        }

        @Override
        public Result deserialize(Request request, ByteInputStream in, short serialVersion) throws IOException {
            PutResult result = new PutResult();
            in.setOffset(0);
            MapWalker walker = PutRequestSerializer.getMapWalker(in);
            while (walker.hasNext()) {
                walker.next();
                String name = walker.getCurrentName();
                if (name.equals(NsonProtocol.ERROR_CODE)) {
                    PutRequestSerializer.handleErrorCode(walker);
                    continue;
                }
                if (name.equals(NsonProtocol.CONSUMED)) {
                    PutRequestSerializer.readConsumedCapacity(in, result);
                    continue;
                }
                if (name.equals(NsonProtocol.ROW_VERSION)) {
                    result.setVersion(Version.createVersion(Nson.readNsonBinary(in)));
                    continue;
                }
                if (name.equals(NsonProtocol.RETURN_INFO)) {
                    PutRequestSerializer.readReturnInfo(in, result);
                    continue;
                }
                if (name.equals(NsonProtocol.GENERATED)) {
                    result.setGeneratedValue(Nson.readFieldValue(in));
                    continue;
                }
                if (name.equals(NsonProtocol.TOPOLOGY_INFO)) {
                    PutRequestSerializer.readTopologyInfo(in, result);
                    continue;
                }
                PutRequestSerializer.skipUnknownField(walker, name);
            }
            return result;
        }

        public void serializeInternal(PutRequest rq, Nson.NsonSerializer ns) throws IOException {
            if (rq.getExactMatch()) {
                PutRequestSerializer.writeMapField(ns, NsonProtocol.EXACT_MATCH, true);
            }
            if (rq.getUpdateTTL()) {
                PutRequestSerializer.writeMapField(ns, NsonProtocol.UPDATE_TTL, true);
            }
            if (rq.getTTL() != null) {
                PutRequestSerializer.writeMapField(ns, NsonProtocol.TTL, rq.getTTL().toString());
            }
            if (rq.getIdentityCacheSize() != 0) {
                PutRequestSerializer.writeMapField(ns, NsonProtocol.IDENTITY_CACHE_SIZE, rq.getIdentityCacheSize());
            }
            if (rq.getMatchVersion() != null) {
                PutRequestSerializer.writeMapField(ns, NsonProtocol.ROW_VERSION, rq.getMatchVersion().getBytes());
            }
            PutRequestSerializer.writeValue(ns, rq.getValue());
        }
    }

    public static class TableRequestSerializer
    extends NsonSerializerBase {
        @Override
        public void serialize(Request request, short serialVersion, ByteOutputStream out) throws IOException {
            TableRequest rq = (TableRequest)request;
            Nson.NsonSerializer ns = new Nson.NsonSerializer(out);
            ns.startMap(0);
            TableRequestSerializer.startMap(ns, NsonProtocol.HEADER);
            TableRequestSerializer.writeHeader(ns, BinaryProtocol.OpCode.TABLE_REQUEST.ordinal(), request);
            TableRequestSerializer.endMap(ns, NsonProtocol.HEADER);
            TableRequestSerializer.startMap(ns, NsonProtocol.PAYLOAD);
            TableRequestSerializer.writeMapField(ns, NsonProtocol.STATEMENT, rq.getStatement());
            TableRequestSerializer.writeLimits(ns, rq.getTableLimits());
            TableRequestSerializer.writeTags(ns, rq);
            if (rq.getMatchETag() != null) {
                TableRequestSerializer.writeMapField(ns, NsonProtocol.ETAG, rq.getMatchETag());
            }
            TableRequestSerializer.endMap(ns, NsonProtocol.PAYLOAD);
            ns.endMap(0);
        }

        @Override
        public Result deserialize(Request request, ByteInputStream in, short serialVersion) throws IOException {
            return TableRequestSerializer.deserializeTableResult(request, in);
        }
    }

    public static class GetTableRequestSerializer
    extends NsonSerializerBase {
        @Override
        public void serialize(Request request, short serialVersion, ByteOutputStream out) throws IOException {
            GetTableRequest rq = (GetTableRequest)request;
            Nson.NsonSerializer ns = new Nson.NsonSerializer(out);
            ns.startMap(0);
            GetTableRequestSerializer.startMap(ns, NsonProtocol.HEADER);
            GetTableRequestSerializer.writeHeader(ns, BinaryProtocol.OpCode.GET_TABLE.ordinal(), request);
            GetTableRequestSerializer.endMap(ns, NsonProtocol.HEADER);
            GetTableRequestSerializer.startMap(ns, NsonProtocol.PAYLOAD);
            GetTableRequestSerializer.writeMapField(ns, NsonProtocol.OPERATION_ID, rq.getOperationId());
            GetTableRequestSerializer.endMap(ns, NsonProtocol.PAYLOAD);
            ns.endMap(0);
        }

        @Override
        public Result deserialize(Request request, ByteInputStream in, short serialVersion) throws IOException {
            return GetTableRequestSerializer.deserializeTableResult(request, in);
        }
    }

    public static class QueryRequestSerializer
    extends NsonSerializerBase {
        @Override
        public void serialize(Request request, short serialVersion, ByteOutputStream out) throws IOException {
            throw new IllegalArgumentException("Missing query version in query request serializer");
        }

        @Override
        public void serialize(Request request, short serialVersion, short queryVersion, ByteOutputStream out) throws IOException {
            QueryRequest rq = (QueryRequest)request;
            Nson.NsonSerializer ns = new Nson.NsonSerializer(out);
            ns.startMap(0);
            QueryRequestSerializer.startMap(ns, NsonProtocol.HEADER);
            QueryRequestSerializer.writeHeader(ns, BinaryProtocol.OpCode.QUERY.ordinal(), rq);
            QueryRequestSerializer.endMap(ns, NsonProtocol.HEADER);
            QueryRequestSerializer.startMap(ns, NsonProtocol.PAYLOAD);
            QueryRequestSerializer.writeConsistency(ns, rq.getConsistency());
            if (rq.getDurability() != null) {
                QueryRequestSerializer.writeMapField(ns, NsonProtocol.DURABILITY, QueryRequestSerializer.getDurability(rq.getDurability()));
            }
            QueryRequestSerializer.writeMapFieldNZ(ns, NsonProtocol.MAX_READ_KB, rq.getMaxReadKB());
            QueryRequestSerializer.writeMapFieldNZ(ns, NsonProtocol.MAX_WRITE_KB, rq.getMaxWriteKB());
            QueryRequestSerializer.writeMapFieldNZ(ns, NsonProtocol.NUMBER_LIMIT, rq.getLimit());
            QueryRequestSerializer.writeMapFieldNZ(ns, NsonProtocol.TRACE_LEVEL, rq.getTraceLevel());
            if (rq.getTraceLevel() > 0) {
                QueryRequestSerializer.writeMapField(ns, NsonProtocol.TRACE_AT_LOG_FILES, rq.getLogFileTracing());
                QueryRequestSerializer.writeMapField(ns, NsonProtocol.BATCH_COUNTER, rq.getBatchCounter());
            }
            QueryRequestSerializer.writeMapField(ns, NsonProtocol.QUERY_VERSION, queryVersion);
            boolean isPrepared = rq.isPrepared();
            if (isPrepared) {
                QueryRequestSerializer.writeMapField(ns, NsonProtocol.IS_PREPARED, isPrepared);
                QueryRequestSerializer.writeMapField(ns, NsonProtocol.IS_SIMPLE_QUERY, rq.isSimpleQuery());
                QueryRequestSerializer.writeMapField(ns, NsonProtocol.PREPARED_QUERY, rq.getPreparedStatement().getStatement());
                this.writeBindVariables(ns, out, rq.getPreparedStatement().getVariables());
            } else {
                QueryRequestSerializer.writeMapField(ns, NsonProtocol.STATEMENT, rq.getStatement());
            }
            if (rq.getContinuationKey() != null) {
                QueryRequestSerializer.writeMapField(ns, NsonProtocol.CONTINUATION_KEY, rq.getContinuationKey());
            }
            QueryRequestSerializer.writeLongMapFieldNZ(ns, NsonProtocol.SERVER_MEMORY_CONSUMPTION, rq.getMaxServerMemoryConsumption());
            this.writeMathContext(ns, rq.getMathContext());
            if (rq.getShardId() != -1) {
                QueryRequestSerializer.writeMapField(ns, NsonProtocol.SHARD_ID, rq.getShardId());
            }
            if (queryVersion >= QueryDriver.QUERY_V4) {
                if (rq.getQueryName() != null) {
                    QueryRequestSerializer.writeMapField(ns, NsonProtocol.QUERY_NAME, rq.getQueryName());
                }
                if (rq.getVirtualScan() != null) {
                    QueryRequestSerializer.writeVirtualScan(ns, rq.getVirtualScan(), queryVersion);
                }
            }
            QueryRequestSerializer.endMap(ns, NsonProtocol.PAYLOAD);
            ns.endMap(0);
        }

        private static void writeVirtualScan(Nson.NsonSerializer ns, VirtualScan vs, short queryVersion) throws IOException {
            QueryRequestSerializer.startMap(ns, NsonProtocol.VIRTUAL_SCAN);
            QueryRequestSerializer.writeMapField(ns, NsonProtocol.VIRTUAL_SCAN_SID, vs.sid());
            QueryRequestSerializer.writeMapField(ns, NsonProtocol.VIRTUAL_SCAN_PID, vs.pid());
            if (vs.isFirstBatch()) {
                int numTables = 1;
                if (queryVersion >= 5) {
                    numTables = vs.numTables();
                    QueryRequestSerializer.writeMapField(ns, NsonProtocol.VIRTUAL_SCAN_NUM_TABLES, numTables);
                }
                for (int t = 0; t < numTables; ++t) {
                    QueryRequestSerializer.writeMapField(ns, NsonProtocol.VIRTUAL_SCAN_CURRENT_INDEX_RANGE, vs.currentIndexRange(t));
                    QueryRequestSerializer.writeMapField(ns, NsonProtocol.VIRTUAL_SCAN_PRIM_KEY, vs.primKey(t));
                    QueryRequestSerializer.writeMapField(ns, NsonProtocol.VIRTUAL_SCAN_SEC_KEY, vs.secKey(t));
                    QueryRequestSerializer.writeMapField(ns, NsonProtocol.VIRTUAL_SCAN_MOVE_AFTER, vs.moveAfterResumeKey(t));
                    QueryRequestSerializer.writeMapField(ns, NsonProtocol.VIRTUAL_SCAN_JOIN_DESC_RESUME_KEY, vs.descResumeKey(t));
                    QueryRequestSerializer.writeMapField(ns, NsonProtocol.VIRTUAL_SCAN_JOIN_PATH_TABLES, vs.joinPathTables(t));
                    QueryRequestSerializer.writeMapField(ns, NsonProtocol.VIRTUAL_SCAN_JOIN_PATH_KEY, vs.joinPathKey(t));
                    QueryRequestSerializer.writeMapField(ns, NsonProtocol.VIRTUAL_SCAN_JOIN_PATH_SEC_KEY, vs.joinPathSecKey(t));
                    QueryRequestSerializer.writeMapField(ns, NsonProtocol.VIRTUAL_SCAN_JOIN_PATH_MATCHED, vs.joinPathMatched(t));
                }
            }
            QueryRequestSerializer.endMap(ns, NsonProtocol.VIRTUAL_SCAN);
        }

        @Override
        public Result deserialize(Request request, ByteInputStream in, short serialVersion) throws IOException {
            throw new IllegalArgumentException("Missing query version in query request deserializer");
        }

        @Override
        public Result deserialize(Request request, ByteInputStream in, short serialVersion, short queryVersion) throws IOException {
            QueryRequest qreq = (QueryRequest)request;
            QueryResult result = new QueryResult(qreq);
            QueryRequestSerializer.deserializePrepareOrQuery(qreq, result, null, null, in, serialVersion, queryVersion);
            return result;
        }

        private static void deserializePrepareOrQuery(QueryRequest qreq, QueryResult qres, PrepareRequest preq, PrepareResult pres, ByteInputStream in, short serialVersion, short queryVersion) throws IOException {
            Result res;
            PreparedStatement prep = null;
            if (qreq != null) {
                prep = qreq.getPreparedStatement();
            }
            boolean isPreparedRequest = prep != null;
            byte[] proxyPreparedQuery = null;
            DriverPlanInfo dpi = null;
            String queryPlan = null;
            String tableName = null;
            String namespace = null;
            String querySchema = null;
            byte operation = 0;
            int proxyTopoSeqNum = -1;
            int[] shardIds = null;
            byte[] contKey = null;
            VirtualScan[] virtualScans = null;
            TreeMap<String, String> queryTraces = null;
            MapWalker walker = QueryRequestSerializer.getMapWalker(in);
            while (walker.hasNext()) {
                int i;
                walker.next();
                String name = walker.getCurrentName();
                if (name.equals(NsonProtocol.ERROR_CODE)) {
                    QueryRequestSerializer.handleErrorCode(walker);
                    continue;
                }
                if (name.equals(NsonProtocol.CONSUMED)) {
                    QueryRequestSerializer.readConsumedCapacity(in, qres != null ? qres : pres);
                    continue;
                }
                if (name.equals(NsonProtocol.QUERY_RESULTS) && qres != null) {
                    qres.setResults(QueryRequestSerializer.readQueryResults(in));
                    continue;
                }
                if (name.equals(NsonProtocol.CONTINUATION_KEY)) {
                    contKey = Nson.readNsonBinary(in);
                    continue;
                }
                if (name.equals(NsonProtocol.SORT_PHASE1_RESULTS) && qres != null) {
                    byte[] arr = Nson.readNsonBinary(in);
                    QueryRequestSerializer.readPhase1Results(arr, qres);
                    continue;
                }
                if (name.equals(NsonProtocol.PREPARED_QUERY)) {
                    proxyPreparedQuery = Nson.readNsonBinary(in);
                    continue;
                }
                if (name.equals(NsonProtocol.DRIVER_QUERY_PLAN)) {
                    dpi = QueryRequestSerializer.getDriverPlanInfo(Nson.readNsonBinary(in), serialVersion);
                    continue;
                }
                if (name.equals(NsonProtocol.REACHED_LIMIT) && qres != null) {
                    qres.setReachedLimit(Nson.readNsonBoolean(in));
                    continue;
                }
                if (name.equals(NsonProtocol.TABLE_NAME)) {
                    tableName = Nson.readNsonString(in);
                    continue;
                }
                if (name.equals(NsonProtocol.NAMESPACE)) {
                    namespace = Nson.readNsonString(in);
                    continue;
                }
                if (name.equals(NsonProtocol.QUERY_PLAN_STRING)) {
                    queryPlan = Nson.readNsonString(in);
                    continue;
                }
                if (name.equals(NsonProtocol.QUERY_RESULT_SCHEMA)) {
                    querySchema = Nson.readNsonString(in);
                    continue;
                }
                if (name.equals(NsonProtocol.QUERY_OPERATION)) {
                    operation = (byte)Nson.readNsonInt(in);
                    continue;
                }
                if (name.equals(NsonProtocol.TOPOLOGY_INFO)) {
                    QueryRequestSerializer.readTopologyInfo(in, qres != null ? qres : pres);
                    continue;
                }
                if (name.equals(NsonProtocol.PROXY_TOPO_SEQNUM)) {
                    proxyTopoSeqNum = Nson.readNsonInt(in);
                    continue;
                }
                if (name.equals(NsonProtocol.SHARD_IDS)) {
                    shardIds = QueryRequestSerializer.readNsonIntArray(in);
                    continue;
                }
                if (name.equals(NsonProtocol.VIRTUAL_SCANS)) {
                    QueryRequestSerializer.readType(in, 0);
                    in.readInt();
                    int numScans = in.readInt();
                    virtualScans = new VirtualScan[numScans];
                    for (i = 0; i < numScans; ++i) {
                        virtualScans[i] = QueryRequestSerializer.readVirtualScan(in);
                    }
                    continue;
                }
                if (name.equals(NsonProtocol.QUERY_BATCH_TRACES)) {
                    QueryRequestSerializer.readType(in, 0);
                    in.readInt();
                    int numTraces = in.readInt() / 2;
                    queryTraces = new TreeMap<String, String>();
                    for (i = 0; i < numTraces; ++i) {
                        String batchName = Nson.readNsonString(in);
                        String batchTrace = Nson.readNsonString(in);
                        queryTraces.put(batchName, batchTrace);
                    }
                    continue;
                }
                walker.skip();
            }
            Result result = res = qres != null ? qres : pres;
            if (res.getTopology() == null && proxyTopoSeqNum >= 0) {
                res.setTopology(new TopologyInfo(proxyTopoSeqNum, shardIds));
            }
            if (qres != null) {
                qres.setContinuationKey(contKey);
                qreq.setContKey(qres.getContinuationKey());
                qres.setVirtualScans(virtualScans);
                qres.setQueryTraces(queryTraces);
            }
            if (isPreparedRequest) {
                return;
            }
            String statement = qreq != null ? qreq.getStatement() : preq.getStatement();
            prep = new PreparedStatement(statement, queryPlan, querySchema, proxyPreparedQuery, dpi != null ? dpi.driverQueryPlan : null, dpi != null ? dpi.numIterators : 0, dpi != null ? dpi.numRegisters : 0, dpi != null ? dpi.externalVars : null, namespace, tableName, operation);
            if (pres != null) {
                pres.setPreparedStatement(prep);
            } else if (qreq != null) {
                qreq.setPreparedStatement(prep);
                if (!prep.isSimpleQuery()) {
                    QueryDriver driver = new QueryDriver(qreq);
                    driver.setPrepCost(qres.getReadKB());
                    qres.setComputed(false);
                }
            }
        }

        private static VirtualScan readVirtualScan(ByteInputStream in) throws IOException {
            int sid = -1;
            int pid = -1;
            byte[] primKey = null;
            byte[] secKey = null;
            boolean moveAfter = true;
            byte[] descResumeKey = null;
            int[] joinPathTables = null;
            byte[] joinPathKey = null;
            byte[] joinPathSecKey = null;
            boolean joinPathMatched = false;
            int currentIndexRange = 0;
            int numTables = 1;
            int currTable = 0;
            VirtualScan.TableResumeInfo[] tableRIs = new VirtualScan.TableResumeInfo[1];
            MapWalker walker = QueryRequestSerializer.getMapWalker(in);
            while (walker.hasNext()) {
                walker.next();
                String name = walker.getCurrentName();
                if (name.equals(NsonProtocol.VIRTUAL_SCAN_SID)) {
                    sid = Nson.readNsonInt(in);
                    continue;
                }
                if (name.equals(NsonProtocol.VIRTUAL_SCAN_PID)) {
                    pid = Nson.readNsonInt(in);
                    continue;
                }
                if (name.equals(NsonProtocol.VIRTUAL_SCAN_NUM_TABLES)) {
                    numTables = Nson.readNsonInt(in);
                    tableRIs = new VirtualScan.TableResumeInfo[numTables];
                    continue;
                }
                if (name.equals(NsonProtocol.VIRTUAL_SCAN_CURRENT_INDEX_RANGE)) {
                    currentIndexRange = Nson.readNsonInt(in);
                    continue;
                }
                if (name.equals(NsonProtocol.VIRTUAL_SCAN_PRIM_KEY)) {
                    primKey = Nson.readNsonBinary(in);
                    continue;
                }
                if (name.equals(NsonProtocol.VIRTUAL_SCAN_SEC_KEY)) {
                    secKey = Nson.readNsonBinary(in);
                    continue;
                }
                if (name.equals(NsonProtocol.VIRTUAL_SCAN_MOVE_AFTER)) {
                    moveAfter = Nson.readNsonBoolean(in);
                    continue;
                }
                if (name.equals(NsonProtocol.VIRTUAL_SCAN_JOIN_DESC_RESUME_KEY)) {
                    descResumeKey = Nson.readNsonBinary(in);
                    continue;
                }
                if (name.equals(NsonProtocol.VIRTUAL_SCAN_JOIN_PATH_TABLES)) {
                    joinPathTables = Nson.readIntArray(in);
                    continue;
                }
                if (name.equals(NsonProtocol.VIRTUAL_SCAN_JOIN_PATH_KEY)) {
                    joinPathKey = Nson.readNsonBinary(in);
                    continue;
                }
                if (name.equals(NsonProtocol.VIRTUAL_SCAN_JOIN_PATH_SEC_KEY)) {
                    joinPathSecKey = Nson.readNsonBinary(in);
                    continue;
                }
                if (name.equals(NsonProtocol.VIRTUAL_SCAN_JOIN_PATH_MATCHED)) {
                    joinPathMatched = Nson.readNsonBoolean(in);
                    tableRIs[currTable] = new VirtualScan.TableResumeInfo(currentIndexRange, primKey, secKey, moveAfter, descResumeKey, joinPathTables, joinPathKey, joinPathSecKey, joinPathMatched);
                    ++currTable;
                    continue;
                }
                QueryRequestSerializer.skipUnknownField(walker, name);
            }
            return new VirtualScan(pid, sid, tableRIs);
        }

        private static void readPhase1Results(byte[] arr, QueryResult result) throws IOException {
            ByteBuf buf = Unpooled.wrappedBuffer((byte[])arr);
            NettyByteInputStream bis = new NettyByteInputStream(buf);
            result.setIsInPhase1(bis.readBoolean());
            int[] pids = Nson.readIntArray(bis);
            if (pids != null) {
                result.setPids(pids);
                result.setNumResultsPerPid(Nson.readIntArray(bis));
                byte[][] contKeys = new byte[pids.length][];
                for (int i = 0; i < pids.length; ++i) {
                    contKeys[i] = Nson.readByteArray(bis);
                }
                result.setPartitionContKeys(contKeys);
            }
        }

        private static DriverPlanInfo getDriverPlanInfo(byte[] arr, short serialVersion) throws IOException {
            if (arr == null || arr.length == 0) {
                return null;
            }
            ByteBuf buf = Unpooled.wrappedBuffer((byte[])arr);
            NettyByteInputStream bis = new NettyByteInputStream(buf);
            DriverPlanInfo dpi = new DriverPlanInfo();
            dpi.driverQueryPlan = PlanIter.deserializeIter(bis, serialVersion);
            if (dpi.driverQueryPlan == null) {
                return null;
            }
            dpi.numIterators = bis.readInt();
            dpi.numRegisters = bis.readInt();
            int len = bis.readInt();
            if (len <= 0) {
                return dpi;
            }
            dpi.externalVars = new HashMap<String, Integer>(len);
            for (int i = 0; i < len; ++i) {
                String varName = Nson.readString(bis);
                int varId = bis.readInt();
                dpi.externalVars.put(varName, varId);
            }
            return dpi;
        }

        private static List<MapValue> readQueryResults(ByteInputStream bis) throws IOException {
            byte t = bis.readByte();
            if (t != 0) {
                throw new IllegalArgumentException("Bad type in queryResults: " + Nson.typeString(t) + ", should be ARRAY");
            }
            bis.readInt();
            int numElements = bis.readInt();
            ArrayList<MapValue> results = new ArrayList<MapValue>(numElements);
            for (int i = 0; i < numElements; ++i) {
                results.add(Nson.readNsonMap(bis));
            }
            return results;
        }

        private void writeBindVariables(Nson.NsonSerializer ns, ByteOutputStream bos, Map<String, FieldValue> vars) throws IOException {
            if (vars == null || vars.size() == 0) {
                return;
            }
            QueryRequestSerializer.startArray(ns, NsonProtocol.BIND_VARIABLES);
            for (Map.Entry<String, FieldValue> entry : vars.entrySet()) {
                ns.startMap(0);
                QueryRequestSerializer.writeMapField(ns, NsonProtocol.NAME, entry.getKey());
                ns.startMapField(NsonProtocol.VALUE);
                Nson.writeFieldValue(bos, entry.getValue());
                ns.endMapField(NsonProtocol.VALUE);
                ns.endMap(0);
                ns.incrSize(1);
            }
            QueryRequestSerializer.endArray(ns, NsonProtocol.BIND_VARIABLES);
        }

        private static class DriverPlanInfo {
            PlanIter driverQueryPlan;
            int numIterators;
            int numRegisters;
            Map<String, Integer> externalVars;

            private DriverPlanInfo() {
            }
        }
    }

    public static class PrepareRequestSerializer
    extends NsonSerializerBase {
        @Override
        public void serialize(Request request, short serialVersion, ByteOutputStream out) throws IOException {
            throw new IllegalArgumentException("Missing query version in prepare request serializer");
        }

        @Override
        public void serialize(Request request, short serialVersion, short queryVersion, ByteOutputStream out) throws IOException {
            PrepareRequest rq = (PrepareRequest)request;
            Nson.NsonSerializer ns = new Nson.NsonSerializer(out);
            ns.startMap(0);
            PrepareRequestSerializer.startMap(ns, NsonProtocol.HEADER);
            PrepareRequestSerializer.writeHeader(ns, BinaryProtocol.OpCode.PREPARE.ordinal(), rq);
            PrepareRequestSerializer.endMap(ns, NsonProtocol.HEADER);
            PrepareRequestSerializer.startMap(ns, NsonProtocol.PAYLOAD);
            PrepareRequestSerializer.writeMapField(ns, NsonProtocol.QUERY_VERSION, queryVersion);
            PrepareRequestSerializer.writeMapField(ns, NsonProtocol.STATEMENT, rq.getStatement());
            if (rq.getQueryPlan()) {
                PrepareRequestSerializer.writeMapField(ns, NsonProtocol.GET_QUERY_PLAN, true);
            }
            if (rq.getQuerySchema()) {
                PrepareRequestSerializer.writeMapField(ns, NsonProtocol.GET_QUERY_SCHEMA, true);
            }
            PrepareRequestSerializer.endMap(ns, NsonProtocol.PAYLOAD);
            ns.endMap(0);
        }

        @Override
        public Result deserialize(Request request, ByteInputStream in, short serialVersion) throws IOException {
            throw new IllegalArgumentException("Missing query version in prepare request deserializer");
        }

        @Override
        public Result deserialize(Request request, ByteInputStream in, short serialVersion, short queryVersion) throws IOException {
            PrepareRequest prepRq = (PrepareRequest)request;
            PrepareResult result = new PrepareResult();
            QueryRequestSerializer.deserializePrepareOrQuery(null, null, prepRq, result, in, serialVersion, queryVersion);
            return result;
        }
    }

    public static class TableUsageRequestSerializer
    extends NsonSerializerBase {
        @Override
        public void serialize(Request request, short serialVersion, ByteOutputStream out) throws IOException {
            TableUsageRequest rq = (TableUsageRequest)request;
            Nson.NsonSerializer ns = new Nson.NsonSerializer(out);
            ns.startMap(0);
            TableUsageRequestSerializer.startMap(ns, NsonProtocol.HEADER);
            TableUsageRequestSerializer.writeHeader(ns, BinaryProtocol.OpCode.GET_TABLE_USAGE.ordinal(), request);
            TableUsageRequestSerializer.endMap(ns, NsonProtocol.HEADER);
            TableUsageRequestSerializer.startMap(ns, NsonProtocol.PAYLOAD);
            TableUsageRequestSerializer.writeMapField(ns, NsonProtocol.START, rq.getStartTimeString());
            TableUsageRequestSerializer.writeMapField(ns, NsonProtocol.END, rq.getEndTimeString());
            TableUsageRequestSerializer.writeMapField(ns, NsonProtocol.LIST_MAX_TO_READ, rq.getLimit());
            TableUsageRequestSerializer.writeMapField(ns, NsonProtocol.LIST_START_INDEX, rq.getStartIndex());
            TableUsageRequestSerializer.endMap(ns, NsonProtocol.PAYLOAD);
            ns.endMap(0);
        }

        @Override
        public Result deserialize(Request request, ByteInputStream in, short serialVersion) throws IOException {
            TableUsageResult result = new TableUsageResult();
            MapWalker walker = TableUsageRequestSerializer.getMapWalker(in);
            while (walker.hasNext()) {
                walker.next();
                String name = walker.getCurrentName();
                if (name.equals(NsonProtocol.ERROR_CODE)) {
                    TableUsageRequestSerializer.handleErrorCode(walker);
                    continue;
                }
                if (name.equals(NsonProtocol.TABLE_NAME)) {
                    result.setTableName(Nson.readNsonString(in));
                    continue;
                }
                if (name.equals(NsonProtocol.TABLE_USAGE)) {
                    byte t = in.readByte();
                    if (t != 0) {
                        throw new IllegalStateException("Operations: bad type in table usage result: " + Nson.typeString(t) + ", should be ARRAY");
                    }
                    in.readInt();
                    int numElements = in.readInt();
                    TableUsageResult.TableUsage[] usageRecords = new TableUsageResult.TableUsage[numElements];
                    for (int i = 0; i < numElements; ++i) {
                        usageRecords[i] = this.readUsageRecord(in);
                    }
                    result.setUsageRecords(usageRecords);
                    continue;
                }
                if (name.equals(NsonProtocol.LAST_INDEX)) {
                    result.setLastIndexReturned(Nson.readNsonInt(in));
                    continue;
                }
                TableUsageRequestSerializer.skipUnknownField(walker, name);
            }
            if (result.getUsageRecords() == null) {
                result.setUsageRecords(new TableUsageResult.TableUsage[0]);
            }
            return result;
        }

        private TableUsageResult.TableUsage readUsageRecord(ByteInputStream in) throws IOException {
            MapWalker walker = new MapWalker(in);
            TableUsageResult.TableUsage usage = new TableUsageResult.TableUsage();
            while (walker.hasNext()) {
                walker.next();
                String name = walker.getCurrentName();
                if (name.equals(NsonProtocol.START)) {
                    usage.startTimeMillis = TableUsageRequestSerializer.timeToLong(Nson.readNsonString(in));
                    continue;
                }
                if (name.equals(NsonProtocol.TABLE_USAGE_PERIOD)) {
                    usage.secondsInPeriod = Nson.readNsonInt(in);
                    continue;
                }
                if (name.equals(NsonProtocol.READ_UNITS)) {
                    usage.readUnits = Nson.readNsonInt(in);
                    continue;
                }
                if (name.equals(NsonProtocol.WRITE_UNITS)) {
                    usage.writeUnits = Nson.readNsonInt(in);
                    continue;
                }
                if (name.equals(NsonProtocol.STORAGE_GB)) {
                    usage.storageGB = Nson.readNsonInt(in);
                    continue;
                }
                if (name.equals(NsonProtocol.READ_THROTTLE_COUNT)) {
                    usage.readThrottleCount = Nson.readNsonInt(in);
                    continue;
                }
                if (name.equals(NsonProtocol.WRITE_THROTTLE_COUNT)) {
                    usage.writeThrottleCount = Nson.readNsonInt(in);
                    continue;
                }
                if (name.equals(NsonProtocol.STORAGE_THROTTLE_COUNT)) {
                    usage.storageThrottleCount = Nson.readNsonInt(in);
                    continue;
                }
                if (name.equals(NsonProtocol.MAX_SHARD_USAGE_PERCENT)) {
                    usage.maxShardUsagePercent = Nson.readNsonInt(in);
                    continue;
                }
                TableUsageRequestSerializer.skipUnknownField(walker, name);
            }
            return usage;
        }
    }

    public static class SystemRequestSerializer
    extends NsonSerializerBase {
        @Override
        public void serialize(Request request, short serialVersion, ByteOutputStream out) throws IOException {
            SystemRequest rq = (SystemRequest)request;
            Nson.NsonSerializer ns = new Nson.NsonSerializer(out);
            ns.startMap(0);
            SystemRequestSerializer.startMap(ns, NsonProtocol.HEADER);
            SystemRequestSerializer.writeHeader(ns, BinaryProtocol.OpCode.SYSTEM_REQUEST.ordinal(), request);
            SystemRequestSerializer.endMap(ns, NsonProtocol.HEADER);
            SystemRequestSerializer.startMap(ns, NsonProtocol.PAYLOAD);
            SystemRequestSerializer.writeMapField(ns, NsonProtocol.STATEMENT, Nson.getCharArrayAsUTF8(rq.getStatement()));
            SystemRequestSerializer.endMap(ns, NsonProtocol.PAYLOAD);
            ns.endMap(0);
        }

        @Override
        public Result deserialize(Request request, ByteInputStream in, short serialVersion) throws IOException {
            return SystemRequestSerializer.deserializeSystemResult(request, in);
        }
    }

    public static class SystemStatusRequestSerializer
    extends NsonSerializerBase {
        @Override
        public void serialize(Request request, short serialVersion, ByteOutputStream out) throws IOException {
            SystemStatusRequest rq = (SystemStatusRequest)request;
            Nson.NsonSerializer ns = new Nson.NsonSerializer(out);
            ns.startMap(0);
            SystemStatusRequestSerializer.startMap(ns, NsonProtocol.HEADER);
            SystemStatusRequestSerializer.writeHeader(ns, BinaryProtocol.OpCode.SYSTEM_STATUS_REQUEST.ordinal(), request);
            SystemStatusRequestSerializer.endMap(ns, NsonProtocol.HEADER);
            SystemStatusRequestSerializer.startMap(ns, NsonProtocol.PAYLOAD);
            SystemStatusRequestSerializer.writeMapField(ns, NsonProtocol.OPERATION_ID, rq.getOperationId());
            SystemStatusRequestSerializer.writeMapField(ns, NsonProtocol.STATEMENT, rq.getStatement());
            SystemStatusRequestSerializer.endMap(ns, NsonProtocol.PAYLOAD);
            ns.endMap(0);
        }

        @Override
        public Result deserialize(Request request, ByteInputStream in, short serialVersion) throws IOException {
            return SystemStatusRequestSerializer.deserializeSystemResult(request, in);
        }
    }

    public static class ListTablesRequestSerializer
    extends NsonSerializerBase {
        @Override
        public void serialize(Request request, short serialVersion, ByteOutputStream out) throws IOException {
            ListTablesRequest rq = (ListTablesRequest)request;
            Nson.NsonSerializer ns = new Nson.NsonSerializer(out);
            ns.startMap(0);
            ListTablesRequestSerializer.startMap(ns, NsonProtocol.HEADER);
            ListTablesRequestSerializer.writeHeader(ns, BinaryProtocol.OpCode.LIST_TABLES.ordinal(), request);
            ListTablesRequestSerializer.endMap(ns, NsonProtocol.HEADER);
            ListTablesRequestSerializer.startMap(ns, NsonProtocol.PAYLOAD);
            ListTablesRequestSerializer.writeMapField(ns, NsonProtocol.LIST_START_INDEX, rq.getStartIndex());
            ListTablesRequestSerializer.writeMapField(ns, NsonProtocol.LIST_MAX_TO_READ, rq.getLimit());
            ListTablesRequestSerializer.writeMapField(ns, NsonProtocol.NAMESPACE, rq.getNamespace());
            ListTablesRequestSerializer.endMap(ns, NsonProtocol.PAYLOAD);
            ns.endMap(0);
        }

        @Override
        public Result deserialize(Request request, ByteInputStream in, short serialVersion) throws IOException {
            ListTablesResult result = new ListTablesResult();
            MapWalker walker = ListTablesRequestSerializer.getMapWalker(in);
            while (walker.hasNext()) {
                walker.next();
                String name = walker.getCurrentName();
                if (name.equals(NsonProtocol.ERROR_CODE)) {
                    ListTablesRequestSerializer.handleErrorCode(walker);
                    continue;
                }
                if (name.equals(NsonProtocol.TABLES)) {
                    byte t = in.readByte();
                    if (t != 0) {
                        throw new IllegalStateException("Operations: bad type in list tables result: " + Nson.typeString(t) + ", should be ARRAY");
                    }
                    in.readInt();
                    int numElements = in.readInt();
                    String[] tables = new String[numElements];
                    for (int i = 0; i < numElements; ++i) {
                        tables[i] = Nson.readNsonString(in);
                    }
                    result.setTables(tables);
                    continue;
                }
                if (name.equals(NsonProtocol.LAST_INDEX)) {
                    result.setLastIndexReturned(Nson.readNsonInt(in));
                    continue;
                }
                ListTablesRequestSerializer.skipUnknownField(walker, name);
            }
            if (result.getTables() == null) {
                result.setTables(new String[0]);
            }
            return result;
        }
    }

    public static class GetIndexesRequestSerializer
    extends NsonSerializerBase {
        @Override
        public void serialize(Request request, short serialVersion, ByteOutputStream out) throws IOException {
            GetIndexesRequest rq = (GetIndexesRequest)request;
            Nson.NsonSerializer ns = new Nson.NsonSerializer(out);
            ns.startMap(0);
            GetIndexesRequestSerializer.startMap(ns, NsonProtocol.HEADER);
            GetIndexesRequestSerializer.writeHeader(ns, BinaryProtocol.OpCode.GET_INDEXES.ordinal(), request);
            GetIndexesRequestSerializer.endMap(ns, NsonProtocol.HEADER);
            GetIndexesRequestSerializer.startMap(ns, NsonProtocol.PAYLOAD);
            GetIndexesRequestSerializer.writeMapField(ns, NsonProtocol.INDEX, rq.getIndexName());
            GetIndexesRequestSerializer.endMap(ns, NsonProtocol.PAYLOAD);
            ns.endMap(0);
        }

        @Override
        public Result deserialize(Request request, ByteInputStream in, short serialVersion) throws IOException {
            GetIndexesResult result = new GetIndexesResult();
            MapWalker walker = GetIndexesRequestSerializer.getMapWalker(in);
            while (walker.hasNext()) {
                walker.next();
                String name = walker.getCurrentName();
                if (name.equals(NsonProtocol.ERROR_CODE)) {
                    GetIndexesRequestSerializer.handleErrorCode(walker);
                    continue;
                }
                if (name.equals(NsonProtocol.INDEXES)) {
                    byte t = in.readByte();
                    if (t != 0) {
                        throw new IllegalStateException("Operations: bad type in get indexes result: " + Nson.typeString(t) + ", should be ARRAY");
                    }
                    in.readInt();
                    int numElements = in.readInt();
                    GetIndexesResult.IndexInfo[] indexes = new GetIndexesResult.IndexInfo[numElements];
                    for (int i = 0; i < numElements; ++i) {
                        indexes[i] = this.readIndexInfo(in);
                    }
                    result.setIndexes(indexes);
                    continue;
                }
                GetIndexesRequestSerializer.skipUnknownField(walker, name);
            }
            if (result.getIndexes() == null) {
                result.setIndexes(new GetIndexesResult.IndexInfo[0]);
            }
            return result;
        }

        private GetIndexesResult.IndexInfo readIndexInfo(ByteInputStream in) throws IOException {
            MapWalker walker = new MapWalker(in);
            String indexName = null;
            String[] fields = null;
            String[] types = null;
            while (walker.hasNext()) {
                walker.next();
                String name = walker.getCurrentName();
                if (name.equals(NsonProtocol.NAME)) {
                    indexName = Nson.readNsonString(in);
                    continue;
                }
                if (name.equals(NsonProtocol.FIELDS)) {
                    byte t = in.readByte();
                    if (t != 0) {
                        throw new IllegalStateException("Operations: bad type in get indexes result: " + Nson.typeString(t) + ", should be ARRAY");
                    }
                    in.readInt();
                    int numElements = in.readInt();
                    fields = new String[numElements];
                    types = new String[numElements];
                    for (int i = 0; i < numElements; ++i) {
                        MapWalker infoWalker = new MapWalker(in);
                        while (infoWalker.hasNext()) {
                            infoWalker.next();
                            String fname = infoWalker.getCurrentName();
                            if (fname.equals(NsonProtocol.PATH)) {
                                fields[i] = Nson.readNsonString(in);
                                continue;
                            }
                            if (fname.equals(NsonProtocol.TYPE)) {
                                types[i] = Nson.readNsonString(in);
                                continue;
                            }
                            GetIndexesRequestSerializer.skipUnknownField(infoWalker, fname);
                        }
                        if (fields[i] != null) continue;
                        throw new IllegalStateException("Bad GetIndexes result, missing path");
                    }
                    continue;
                }
                GetIndexesRequestSerializer.skipUnknownField(walker, name);
            }
            if (indexName == null || fields == null) {
                throw new IllegalStateException("Bad GetIndexes result, missing name or fields");
            }
            return new GetIndexesResult.IndexInfo(indexName, fields, types);
        }
    }

    public static class WriteMultipleRequestSerializer
    extends NsonSerializerBase {
        @Override
        public void serialize(Request request, short serialVersion, ByteOutputStream out) throws IOException {
            WriteMultipleRequest rq = (WriteMultipleRequest)request;
            Nson.NsonSerializer ns = new Nson.NsonSerializer(out);
            ns.startMap(0);
            WriteMultipleRequestSerializer.startMap(ns, NsonProtocol.HEADER);
            WriteMultipleRequestSerializer.writeMapField(ns, NsonProtocol.VERSION, NsonProtocol.V4_VERSION);
            if (rq.isSingleTable()) {
                WriteMultipleRequestSerializer.writeMapField(ns, NsonProtocol.TABLE_NAME, rq.getTableName());
            }
            WriteMultipleRequestSerializer.writeMapField(ns, NsonProtocol.OP_CODE, BinaryProtocol.OpCode.WRITE_MULTIPLE.ordinal());
            WriteMultipleRequestSerializer.writeMapField(ns, NsonProtocol.TIMEOUT, rq.getTimeoutInternal());
            WriteMultipleRequestSerializer.endMap(ns, NsonProtocol.HEADER);
            WriteMultipleRequestSerializer.startMap(ns, NsonProtocol.PAYLOAD);
            WriteMultipleRequestSerializer.writeMapField(ns, NsonProtocol.DURABILITY, WriteMultipleRequestSerializer.getDurability(rq.getDurability()));
            WriteMultipleRequestSerializer.writeMapField(ns, NsonProtocol.NUM_OPERATIONS, rq.getOperations().size());
            WriteMultipleRequestSerializer.startArray(ns, NsonProtocol.OPERATIONS);
            for (WriteMultipleRequest.OperationRequest op : rq.getOperations()) {
                ns.startMap(0);
                WriteRequest wr = op.getRequest();
                if (wr instanceof PutRequest) {
                    PutRequest prq = (PutRequest)wr;
                    if (!rq.isSingleTable()) {
                        WriteMultipleRequestSerializer.writeMapField(ns, NsonProtocol.TABLE_NAME, prq.getTableName());
                    }
                    WriteMultipleRequestSerializer.writeMapField(ns, NsonProtocol.OP_CODE, WriteMultipleRequestSerializer.getOpCode(prq).ordinal());
                    ((PutRequestSerializer)putSerializer).serializeInternal(prq, ns);
                } else {
                    DeleteRequest drq = (DeleteRequest)wr;
                    if (!rq.isSingleTable()) {
                        WriteMultipleRequestSerializer.writeMapField(ns, NsonProtocol.TABLE_NAME, drq.getTableName());
                    }
                    BinaryProtocol.OpCode opCode = drq.getMatchVersion() != null ? BinaryProtocol.OpCode.DELETE_IF_VERSION : BinaryProtocol.OpCode.DELETE;
                    WriteMultipleRequestSerializer.writeMapField(ns, NsonProtocol.OP_CODE, opCode.ordinal());
                    ((DeleteRequestSerializer)delSerializer).serializeInternal(drq, ns);
                }
                WriteMultipleRequestSerializer.writeMapField(ns, NsonProtocol.RETURN_ROW, wr.getReturnRowInternal());
                if (op.isAbortIfUnsuccessful()) {
                    WriteMultipleRequestSerializer.writeMapField(ns, NsonProtocol.ABORT_ON_FAIL, op.isAbortIfUnsuccessful());
                }
                ns.endMap(0);
                ns.endArrayField(0);
            }
            WriteMultipleRequestSerializer.endArray(ns, NsonProtocol.OPERATIONS);
            WriteMultipleRequestSerializer.endMap(ns, NsonProtocol.PAYLOAD);
            ns.endMap(0);
        }

        @Override
        public Result deserialize(Request request, ByteInputStream in, short serialVersion) throws IOException {
            WriteMultipleResult result = new WriteMultipleResult();
            MapWalker walker = WriteMultipleRequestSerializer.getMapWalker(in);
            while (walker.hasNext()) {
                walker.next();
                String name = walker.getCurrentName();
                if (name.equals(NsonProtocol.ERROR_CODE)) {
                    WriteMultipleRequestSerializer.handleErrorCode(walker);
                    continue;
                }
                if (name.equals(NsonProtocol.CONSUMED)) {
                    WriteMultipleRequestSerializer.readConsumedCapacity(in, result);
                    continue;
                }
                if (name.equals(NsonProtocol.WM_SUCCESS)) {
                    byte t = in.readByte();
                    if (t != 0) {
                        throw new IllegalStateException("Operations: bad type in writemultiple: " + Nson.typeString(t) + ", should be ARRAY");
                    }
                    in.readInt();
                    int numElements = in.readInt();
                    for (int i = 0; i < numElements; ++i) {
                        result.addResult(WriteMultipleRequestSerializer.createOperationResult(in));
                    }
                    continue;
                }
                if (name.equals(NsonProtocol.WM_FAILURE)) {
                    MapWalker fw = new MapWalker(in);
                    while (fw.hasNext()) {
                        fw.next();
                        String fname = fw.getCurrentName();
                        if (fname.equals(NsonProtocol.WM_FAIL_INDEX)) {
                            result.setFailedOperationIndex(Nson.readNsonInt(in));
                            continue;
                        }
                        if (fname.equals(NsonProtocol.WM_FAIL_RESULT)) {
                            result.addResult(WriteMultipleRequestSerializer.createOperationResult(in));
                            continue;
                        }
                        WriteMultipleRequestSerializer.skipUnknownField(fw, name);
                    }
                    continue;
                }
                if (name.equals(NsonProtocol.TOPOLOGY_INFO)) {
                    WriteMultipleRequestSerializer.readTopologyInfo(in, result);
                    continue;
                }
                WriteMultipleRequestSerializer.skipUnknownField(walker, name);
            }
            return result;
        }

        private static WriteMultipleResult.OperationResult createOperationResult(ByteInputStream in) throws IOException {
            WriteMultipleResult.OperationResult opResult = new WriteMultipleResult.OperationResult();
            MapWalker walker = new MapWalker(in);
            while (walker.hasNext()) {
                walker.next();
                String name = walker.getCurrentName();
                if (name.equals(NsonProtocol.SUCCESS)) {
                    opResult.setSuccess(Nson.readNsonBoolean(in));
                    continue;
                }
                if (name.equals(NsonProtocol.ROW_VERSION)) {
                    opResult.setVersion(Version.createVersion(Nson.readNsonBinary(in)));
                    continue;
                }
                if (name.equals(NsonProtocol.GENERATED)) {
                    opResult.setGeneratedValue(Nson.readFieldValue(in));
                    continue;
                }
                if (name.equals(NsonProtocol.RETURN_INFO)) {
                    WriteMultipleRequestSerializer.readReturnInfo(in, opResult);
                    continue;
                }
                WriteMultipleRequestSerializer.skipUnknownField(walker, name);
            }
            return opResult;
        }
    }

    public static class MultiDeleteRequestSerializer
    extends NsonSerializerBase {
        @Override
        public void serialize(Request request, short serialVersion, ByteOutputStream out) throws IOException {
            MultiDeleteRequest rq = (MultiDeleteRequest)request;
            Nson.NsonSerializer ns = new Nson.NsonSerializer(out);
            ns.startMap(0);
            MultiDeleteRequestSerializer.startMap(ns, NsonProtocol.HEADER);
            MultiDeleteRequestSerializer.writeHeader(ns, BinaryProtocol.OpCode.MULTI_DELETE.ordinal(), rq);
            MultiDeleteRequestSerializer.endMap(ns, NsonProtocol.HEADER);
            MultiDeleteRequestSerializer.startMap(ns, NsonProtocol.PAYLOAD);
            MultiDeleteRequestSerializer.writeMapField(ns, NsonProtocol.DURABILITY, MultiDeleteRequestSerializer.getDurability(rq.getDurability()));
            MultiDeleteRequestSerializer.writeMapField(ns, NsonProtocol.MAX_WRITE_KB, rq.getMaxWriteKB());
            MultiDeleteRequestSerializer.writeContinuationKey(ns, rq.getContinuationKey());
            MultiDeleteRequestSerializer.writeFieldRange(ns, rq.getRange());
            MultiDeleteRequestSerializer.writeKey(ns, rq);
            MultiDeleteRequestSerializer.endMap(ns, NsonProtocol.PAYLOAD);
            ns.endMap(0);
        }

        @Override
        public Result deserialize(Request request, ByteInputStream in, short serialVersion) throws IOException {
            MultiDeleteResult result = new MultiDeleteResult();
            in.setOffset(0);
            MapWalker walker = MultiDeleteRequestSerializer.getMapWalker(in);
            while (walker.hasNext()) {
                walker.next();
                String name = walker.getCurrentName();
                if (name.equals(NsonProtocol.ERROR_CODE)) {
                    MultiDeleteRequestSerializer.handleErrorCode(walker);
                    continue;
                }
                if (name.equals(NsonProtocol.CONSUMED)) {
                    MultiDeleteRequestSerializer.readConsumedCapacity(in, result);
                    continue;
                }
                if (name.equals(NsonProtocol.NUM_DELETIONS)) {
                    result.setNumDeletions(Nson.readNsonInt(in));
                    continue;
                }
                if (name.equals(NsonProtocol.CONTINUATION_KEY)) {
                    result.setContinuationKey(Nson.readNsonBinary(in));
                    continue;
                }
                if (name.equals(NsonProtocol.TOPOLOGY_INFO)) {
                    MultiDeleteRequestSerializer.readTopologyInfo(in, result);
                    continue;
                }
                MultiDeleteRequestSerializer.skipUnknownField(walker, name);
            }
            return result;
        }
    }

    public static class AddReplicaRequestSerializer
    extends NsonSerializerBase {
        @Override
        public void serialize(Request request, short serialVersion, ByteOutputStream out) throws IOException {
            AddReplicaRequest req = (AddReplicaRequest)request;
            Nson.NsonSerializer ns = new Nson.NsonSerializer(out);
            ns.startMap(0);
            AddReplicaRequestSerializer.startMap(ns, NsonProtocol.HEADER);
            AddReplicaRequestSerializer.writeHeader(ns, BinaryProtocol.OpCode.ADD_REPLICA.ordinal(), req);
            AddReplicaRequestSerializer.endMap(ns, NsonProtocol.HEADER);
            AddReplicaRequestSerializer.startMap(ns, NsonProtocol.PAYLOAD);
            AddReplicaRequestSerializer.writeMapField(ns, NsonProtocol.REGION, req.getReplicaName());
            AddReplicaRequestSerializer.writeMapFieldNZ(ns, NsonProtocol.READ_UNITS, req.getReadUnits());
            AddReplicaRequestSerializer.writeMapFieldNZ(ns, NsonProtocol.WRITE_UNITS, req.getWriteUnits());
            if (req.getMatchETag() != null) {
                AddReplicaRequestSerializer.writeMapField(ns, NsonProtocol.ETAG, req.getMatchETag());
            }
            AddReplicaRequestSerializer.endMap(ns, NsonProtocol.PAYLOAD);
            ns.endMap(0);
        }

        @Override
        public Result deserialize(Request request, ByteInputStream in, short serialVersion) throws IOException {
            return AddReplicaRequestSerializer.deserializeTableResult(request, in);
        }
    }

    public static class DropReplicaRequestSerializer
    extends NsonSerializerBase {
        @Override
        public void serialize(Request request, short serialVersion, ByteOutputStream out) throws IOException {
            DropReplicaRequest req = (DropReplicaRequest)request;
            Nson.NsonSerializer ns = new Nson.NsonSerializer(out);
            ns.startMap(0);
            DropReplicaRequestSerializer.startMap(ns, NsonProtocol.HEADER);
            DropReplicaRequestSerializer.writeHeader(ns, BinaryProtocol.OpCode.DROP_REPLICA.ordinal(), req);
            DropReplicaRequestSerializer.endMap(ns, NsonProtocol.HEADER);
            DropReplicaRequestSerializer.startMap(ns, NsonProtocol.PAYLOAD);
            DropReplicaRequestSerializer.writeMapField(ns, NsonProtocol.REGION, req.getReplicaName());
            if (req.getMatchETag() != null) {
                DropReplicaRequestSerializer.writeMapField(ns, NsonProtocol.ETAG, req.getMatchETag());
            }
            DropReplicaRequestSerializer.endMap(ns, NsonProtocol.PAYLOAD);
            ns.endMap(0);
        }

        @Override
        public Result deserialize(Request request, ByteInputStream in, short serialVersion) throws IOException {
            return DropReplicaRequestSerializer.deserializeTableResult(request, in);
        }
    }

    public static class GetReplicaStatsRequestSerializer
    extends NsonSerializerBase {
        @Override
        public void serialize(Request request, short serialVersion, ByteOutputStream out) throws IOException {
            ReplicaStatsRequest req = (ReplicaStatsRequest)request;
            Nson.NsonSerializer ns = new Nson.NsonSerializer(out);
            ns.startMap(0);
            GetReplicaStatsRequestSerializer.startMap(ns, NsonProtocol.HEADER);
            GetReplicaStatsRequestSerializer.writeHeader(ns, BinaryProtocol.OpCode.GET_REPLICA_STATS.ordinal(), req);
            GetReplicaStatsRequestSerializer.endMap(ns, NsonProtocol.HEADER);
            GetReplicaStatsRequestSerializer.startMap(ns, NsonProtocol.PAYLOAD);
            GetReplicaStatsRequestSerializer.writeMapField(ns, NsonProtocol.REGION, req.getReplicaName());
            GetReplicaStatsRequestSerializer.writeMapField(ns, NsonProtocol.START, req.getStartTimeString());
            GetReplicaStatsRequestSerializer.writeMapFieldNZ(ns, NsonProtocol.LIST_MAX_TO_READ, req.getLimit());
            GetReplicaStatsRequestSerializer.endMap(ns, NsonProtocol.PAYLOAD);
            ns.endMap(0);
        }

        @Override
        public Result deserialize(Request request, ByteInputStream in, short serialVersion) throws IOException {
            ReplicaStatsResult result = new ReplicaStatsResult();
            in.setOffset(0);
            MapWalker walker = GetReplicaStatsRequestSerializer.getMapWalker(in);
            while (walker.hasNext()) {
                walker.next();
                String name = walker.getCurrentName();
                if (name.equals(NsonProtocol.ERROR_CODE)) {
                    GetReplicaStatsRequestSerializer.handleErrorCode(walker);
                    continue;
                }
                if (name.equals(NsonProtocol.TABLE_NAME)) {
                    result.setTableName(Nson.readNsonString(in));
                    continue;
                }
                if (name.equals(NsonProtocol.REPLICA_STATS)) {
                    this.readReplicasStatsRecord(in, result);
                    continue;
                }
                if (name.equals(NsonProtocol.NEXT_START_TIME)) {
                    result.setNextStartTime(Nson.readNsonLong(in));
                    continue;
                }
                GetReplicaStatsRequestSerializer.skipUnknownField(walker, name);
            }
            return result;
        }

        private void readReplicasStatsRecord(ByteInputStream in, ReplicaStatsResult result) throws IOException {
            MapWalker walker = new MapWalker(in);
            HashMap<String, ReplicaStatsResult.ReplicaStats[]> repRecords = new HashMap<String, ReplicaStatsResult.ReplicaStats[]>();
            while (walker.hasNext()) {
                walker.next();
                String replicaName = walker.getCurrentName();
                byte t = in.readByte();
                if (t != 0) {
                    throw new IllegalStateException("Operations: bad type in replica stats: " + Nson.typeString(t) + ", should be ARRAY");
                }
                in.readInt();
                int numElements = in.readInt();
                ReplicaStatsResult.ReplicaStats[] records = new ReplicaStatsResult.ReplicaStats[numElements];
                for (int i = 0; i < numElements; ++i) {
                    ReplicaStatsResult.ReplicaStats stats = new ReplicaStatsResult.ReplicaStats();
                    this.readReplicaStats(in, stats);
                    records[i] = stats;
                }
                repRecords.put(replicaName, records);
            }
            result.setStatsRecords(repRecords);
        }

        private void readReplicaStats(ByteInputStream in, ReplicaStatsResult.ReplicaStats stats) throws IOException {
            MapWalker walker = new MapWalker(in);
            while (walker.hasNext()) {
                walker.next();
                String name = walker.getCurrentName();
                if (name.equals(NsonProtocol.TIME)) {
                    stats.collectionTimeMillis = Nson.readNsonLong(in);
                    continue;
                }
                if (name.equals(NsonProtocol.REPLICA_LAG)) {
                    stats.replicaLag = Nson.readNsonInt(in);
                    continue;
                }
                GetReplicaStatsRequestSerializer.skipUnknownField(walker, name);
            }
        }
    }

    public static abstract class NsonSerializerBase
    implements Serializer {
        public static void readType(ByteInputStream in, int expected) throws IOException {
            byte type = in.readByte();
            if (type != expected) {
                NsonSerializerBase.throwTypeMismatch(expected, type);
            }
        }

        private static void throwTypeMismatch(int expected, int found) {
            throw new IllegalArgumentException("Expected type not found, expected type: " + Nson.typeString(expected) + ", found type: " + Nson.typeString(found));
        }

        protected static void writeHeader(Nson.NsonSerializer ns, int op, Request rq) throws IOException {
            NsonSerializerBase.writeMapField(ns, NsonProtocol.VERSION, NsonProtocol.V4_VERSION);
            if (rq.getTableName() != null) {
                NsonSerializerBase.writeMapField(ns, NsonProtocol.TABLE_NAME, rq.getTableName());
            }
            NsonSerializerBase.writeMapField(ns, NsonProtocol.OP_CODE, op);
            NsonSerializerBase.writeMapField(ns, NsonProtocol.TOPO_SEQ_NUM, rq.topoSeqNum());
            NsonSerializerBase.writeMapField(ns, NsonProtocol.TIMEOUT, rq.getTimeoutInternal());
            if (rq.getPreferThrottling()) {
                NsonSerializerBase.writeMapField(ns, NsonProtocol.PREFER_THROTTLING, true);
            }
            if (rq.getDRLOptIn()) {
                NsonSerializerBase.writeMapField(ns, NsonProtocol.DRL_OPTIN, true);
            }
        }

        protected static void writeConsistency(Nson.NsonSerializer ns, Consistency consistency) throws IOException {
            NsonSerializerBase.startMap(ns, NsonProtocol.CONSISTENCY);
            NsonSerializerBase.writeMapField(ns, NsonProtocol.TYPE, NsonSerializerBase.getConsistencyType(consistency));
            NsonSerializerBase.endMap(ns, NsonProtocol.CONSISTENCY);
        }

        protected static void writeWriteRequest(Nson.NsonSerializer ns, WriteRequest rq) throws IOException {
            NsonSerializerBase.writeMapField(ns, NsonProtocol.DURABILITY, NsonSerializerBase.getDurability(rq.getDurability()));
            NsonSerializerBase.writeMapField(ns, NsonProtocol.RETURN_ROW, rq.getReturnRowInternal());
        }

        protected static void writeKey(Nson.NsonSerializer ns, Request rq) throws IOException {
            MapValue key;
            MapValue mapValue = rq instanceof GetRequest ? ((GetRequest)rq).getKey() : (key = rq instanceof DeleteRequest ? ((DeleteRequest)rq).getKey() : ((MultiDeleteRequest)rq).getKey());
            if (key == null) {
                throw new IllegalArgumentException("Key cannot be null");
            }
            ns.startMapField(NsonProtocol.KEY);
            Nson.writeFieldValue(ns.getStream(), key);
            ns.endMapField(NsonProtocol.KEY);
        }

        protected void writeMathContext(Nson.NsonSerializer ns, MathContext mathContext) throws IOException {
            int val = 0;
            if (mathContext == null) {
                return;
            }
            if (MathContext.DECIMAL32.equals(mathContext)) {
                return;
            }
            if (MathContext.DECIMAL64.equals(mathContext)) {
                val = 2;
            } else if (MathContext.DECIMAL128.equals(mathContext)) {
                val = 3;
            } else if (MathContext.UNLIMITED.equals(mathContext)) {
                val = 4;
            } else {
                val = 5;
                NsonSerializerBase.writeMapField(ns, NsonProtocol.MATH_CONTEXT_PRECISION, mathContext.getPrecision());
                NsonSerializerBase.writeMapField(ns, NsonProtocol.MATH_CONTEXT_ROUNDING_MODE, mathContext.getRoundingMode().ordinal());
            }
            NsonSerializerBase.writeMapField(ns, NsonProtocol.MATH_CONTEXT_CODE, val);
        }

        protected static void writeValue(Nson.NsonSerializer ns, FieldValue value) throws IOException {
            ns.startMapField(NsonProtocol.VALUE);
            Nson.writeFieldValue(ns.getStream(), value);
            ns.endMapField(NsonProtocol.VALUE);
        }

        protected static void writeMapField(Nson.NsonSerializer ns, String fieldName, int value) throws IOException {
            ns.startMapField(fieldName);
            ns.integerValue(value);
            ns.endMapField(fieldName);
        }

        protected static void writeMapFieldNZ(Nson.NsonSerializer ns, String fieldName, int value) throws IOException {
            if (value != 0) {
                NsonSerializerBase.writeMapField(ns, fieldName, value);
            }
        }

        protected static void writeLongMapField(Nson.NsonSerializer ns, String fieldName, long value) throws IOException {
            ns.startMapField(fieldName);
            ns.longValue(value);
            ns.endMapField(fieldName);
        }

        protected static void writeLongMapFieldNZ(Nson.NsonSerializer ns, String fieldName, long value) throws IOException {
            if (value != 0L) {
                NsonSerializerBase.writeLongMapField(ns, fieldName, value);
            }
        }

        protected static void writeMapField(Nson.NsonSerializer ns, String fieldName, String value) throws IOException {
            if (value != null) {
                ns.startMapField(fieldName);
                ns.stringValue(value);
                ns.endMapField(fieldName);
            }
        }

        protected static void writeMapField(Nson.NsonSerializer ns, String fieldName, boolean value) throws IOException {
            ns.startMapField(fieldName);
            ns.booleanValue(value);
            ns.endMapField(fieldName);
        }

        protected static void writeMapField(Nson.NsonSerializer ns, String fieldName, byte[] value) throws IOException {
            ns.startMapField(fieldName);
            ns.binaryValue(value);
            ns.endMapField(fieldName);
        }

        public static void writeMapField(Nson.NsonSerializer ns, String fieldName, int[] value) throws IOException {
            if (value == null || value.length == 0) {
                return;
            }
            ns.startMapField(fieldName);
            ns.startArray(0);
            for (int i : value) {
                ns.integerValue(i);
                ns.incrSize(1);
            }
            ns.endArray(0);
            ns.endMapField(fieldName);
        }

        protected static void startMap(Nson.NsonSerializer ns, String name) throws IOException {
            ns.startMapField(name);
            ns.startMap(0);
        }

        protected static void endMap(Nson.NsonSerializer ns, String name) throws IOException {
            ns.endMap(0);
            ns.endMapField(name);
        }

        protected static void startArray(Nson.NsonSerializer ns, String name) throws IOException {
            ns.startMapField(name);
            ns.startArray(0);
        }

        protected static void endArray(Nson.NsonSerializer ns, String name) throws IOException {
            ns.endArray(0);
            ns.endMapField(name);
        }

        protected static void writeLimits(Nson.NsonSerializer ns, TableLimits limits) throws IOException {
            if (limits != null) {
                NsonSerializerBase.startMap(ns, NsonProtocol.LIMITS);
                NsonSerializerBase.writeMapField(ns, NsonProtocol.READ_UNITS, limits.getReadUnits());
                NsonSerializerBase.writeMapField(ns, NsonProtocol.WRITE_UNITS, limits.getWriteUnits());
                NsonSerializerBase.writeMapField(ns, NsonProtocol.STORAGE_GB, limits.getStorageGB());
                TableLimits.CapacityMode mode = limits.getMode();
                int intMode = mode == TableLimits.CapacityMode.PROVISIONED ? 1 : 2;
                NsonSerializerBase.writeMapField(ns, NsonProtocol.LIMITS_MODE, intMode);
                NsonSerializerBase.endMap(ns, NsonProtocol.LIMITS);
            }
        }

        protected static void writeTags(Nson.NsonSerializer ns, TableRequest rq) throws IOException {
            DefinedTags dtags = rq.getDefinedTags();
            FreeFormTags ftags = rq.getFreeFormTags();
            if (dtags != null) {
                NsonSerializerBase.writeMapField(ns, NsonProtocol.DEFINED_TAGS, dtags.toString());
            }
            if (ftags != null) {
                NsonSerializerBase.writeMapField(ns, NsonProtocol.FREE_FORM_TAGS, ftags.toString());
            }
        }

        protected static int getConsistencyType(Consistency consistency) {
            if (consistency == null || consistency.isEventual()) {
                return 1;
            }
            if (consistency.isAbsolute()) {
                return 0;
            }
            throw new IllegalArgumentException("Unknown Consistency " + consistency);
        }

        public static int getDurability(Durability durability) {
            if (durability == null) {
                return 0;
            }
            int dur = 0;
            switch (durability.getMasterSync()) {
                case NO_SYNC: {
                    dur = 2;
                    break;
                }
                case SYNC: {
                    dur = 1;
                    break;
                }
                case WRITE_NO_SYNC: {
                    dur = 3;
                }
            }
            switch (durability.getReplicaSync()) {
                case NO_SYNC: {
                    dur |= 8;
                    break;
                }
                case SYNC: {
                    dur |= 4;
                    break;
                }
                case WRITE_NO_SYNC: {
                    dur |= 0xC;
                }
            }
            switch (durability.getReplicaAck()) {
                case ALL: {
                    dur |= 0x10;
                    break;
                }
                case NONE: {
                    dur |= 0x20;
                    break;
                }
                case SIMPLE_MAJORITY: {
                    dur |= 0x30;
                }
            }
            return dur;
        }

        protected static int handleErrorCode(MapWalker walker) throws IOException {
            ByteInputStream in = walker.getStream();
            int code = Nson.readNsonInt(in);
            if (code == 0) {
                return 0;
            }
            String message = null;
            RuntimeException re = null;
            while (walker.hasNext()) {
                walker.next();
                String name = walker.getCurrentName();
                if (NsonProtocol.EXCEPTION.equals(name)) {
                    message = Nson.readNsonString(in);
                    re = BinaryProtocol.mapException(code, message);
                    continue;
                }
                if (NsonProtocol.CONSUMED.equals(name)) {
                    if (re == null || re instanceof NoSQLException) {
                        // empty if block
                    }
                    walker.skip();
                    continue;
                }
                NsonSerializerBase.skipUnknownField(walker, name);
            }
            if (re == null) {
                re = BinaryProtocol.mapException(code, null);
            }
            throw re;
        }

        static void readConsumedCapacity(ByteInputStream in, Result result) throws IOException {
            MapWalker walker = new MapWalker(in);
            while (walker.hasNext()) {
                walker.next();
                String name = walker.getCurrentName();
                if (name.equals(NsonProtocol.READ_UNITS)) {
                    result.setReadUnits(Nson.readNsonInt(in));
                    continue;
                }
                if (name.equals(NsonProtocol.READ_KB)) {
                    result.setReadKB(Nson.readNsonInt(in));
                    continue;
                }
                if (name.equals(NsonProtocol.WRITE_KB)) {
                    result.setWriteKB(Nson.readNsonInt(in));
                    continue;
                }
                NsonSerializerBase.skipUnknownField(walker, name);
            }
        }

        static void readTopologyInfo(ByteInputStream in, Result result) throws IOException {
            int proxyTopoSeqNum = -1;
            int[] shardIds = null;
            MapWalker walker = new MapWalker(in);
            while (walker.hasNext()) {
                walker.next();
                String name = walker.getCurrentName();
                if (name.equals(NsonProtocol.PROXY_TOPO_SEQNUM)) {
                    proxyTopoSeqNum = Nson.readNsonInt(in);
                    continue;
                }
                if (name.equals(NsonProtocol.SHARD_IDS)) {
                    shardIds = NsonSerializerBase.readNsonIntArray(in);
                    continue;
                }
                NsonSerializerBase.skipUnknownField(walker, name);
            }
            TopologyInfo ti = null;
            if (proxyTopoSeqNum >= 0) {
                ti = new TopologyInfo(proxyTopoSeqNum, shardIds);
                result.setTopology(ti);
            }
        }

        static int[] readNsonIntArray(ByteInputStream bis) throws IOException {
            byte t = bis.readByte();
            if (t != 0) {
                throw new IllegalArgumentException("Bad type in integer array: " + Nson.typeString(t) + ", should be ARRAY");
            }
            bis.readInt();
            int numElements = bis.readInt();
            int[] arr = new int[numElements];
            for (int i = 0; i < numElements; ++i) {
                arr[i] = Nson.readNsonInt(bis);
            }
            return arr;
        }

        static void readRow(ByteInputStream in, GetResult result) throws IOException {
            MapWalker walker = new MapWalker(in);
            while (walker.hasNext()) {
                walker.next();
                String name = walker.getCurrentName();
                if (name.equals(NsonProtocol.MODIFIED)) {
                    result.setModificationTime(Nson.readNsonLong(in));
                    continue;
                }
                if (name.equals(NsonProtocol.EXPIRATION)) {
                    result.setExpirationTime(Nson.readNsonLong(in));
                    continue;
                }
                if (name.equals(NsonProtocol.ROW_VERSION)) {
                    result.setVersion(Version.createVersion(Nson.readNsonBinary(in)));
                    continue;
                }
                if (name.equals(NsonProtocol.VALUE)) {
                    result.setValue((MapValue)Nson.readFieldValue(in));
                    continue;
                }
                NsonSerializerBase.skipUnknownField(walker, name);
            }
        }

        static void readReturnInfo(ByteInputStream in, WriteResult result) throws IOException {
            MapWalker walker = new MapWalker(in);
            while (walker.hasNext()) {
                walker.next();
                String name = walker.getCurrentName();
                if (name.equals(NsonProtocol.EXISTING_MOD_TIME)) {
                    result.setExistingModificationTime(Nson.readNsonLong(in));
                    continue;
                }
                if (name.equals(NsonProtocol.EXISTING_VERSION)) {
                    result.setExistingVersion(Version.createVersion(Nson.readNsonBinary(in)));
                    continue;
                }
                if (name.equals(NsonProtocol.EXISTING_VALUE)) {
                    result.setExistingValue((MapValue)Nson.readFieldValue(in));
                    continue;
                }
                NsonSerializerBase.skipUnknownField(walker, name);
            }
        }

        protected static void writeContinuationKey(Nson.NsonSerializer ns, byte[] key) throws IOException {
            if (key != null) {
                NsonSerializerBase.writeMapField(ns, NsonProtocol.CONTINUATION_KEY, key);
            }
        }

        protected static void writeFieldRange(Nson.NsonSerializer ns, FieldRange range) throws IOException {
            if (range != null) {
                NsonSerializerBase.startMap(ns, NsonProtocol.RANGE);
                NsonSerializerBase.writeMapField(ns, NsonProtocol.RANGE_PATH, range.getFieldPath());
                if (range.getStart() != null) {
                    NsonSerializerBase.startMap(ns, NsonProtocol.START);
                    NsonSerializerBase.writeValue(ns, range.getStart());
                    NsonSerializerBase.writeMapField(ns, NsonProtocol.INCLUSIVE, range.getStartInclusive());
                    NsonSerializerBase.endMap(ns, NsonProtocol.START);
                }
                if (range.getEnd() != null) {
                    NsonSerializerBase.startMap(ns, NsonProtocol.END);
                    NsonSerializerBase.writeValue(ns, range.getEnd());
                    NsonSerializerBase.writeMapField(ns, NsonProtocol.INCLUSIVE, range.getEndInclusive());
                    NsonSerializerBase.endMap(ns, NsonProtocol.END);
                }
                NsonSerializerBase.endMap(ns, NsonProtocol.RANGE);
            }
        }

        protected static SystemResult deserializeSystemResult(Request request, ByteInputStream in) throws IOException {
            SystemResult result = new SystemResult();
            MapWalker walker = NsonSerializerBase.getMapWalker(in);
            while (walker.hasNext()) {
                walker.next();
                String name = walker.getCurrentName();
                if (name.equals(NsonProtocol.ERROR_CODE)) {
                    NsonSerializerBase.handleErrorCode(walker);
                    continue;
                }
                if (name.equals(NsonProtocol.SYSOP_STATE)) {
                    result.setState(NsonSerializerBase.getOperationState(Nson.readNsonInt(in)));
                    continue;
                }
                if (name.equals(NsonProtocol.SYSOP_RESULT)) {
                    result.setResultString(Nson.readNsonString(in));
                    continue;
                }
                if (name.equals(NsonProtocol.STATEMENT)) {
                    result.setStatement(Nson.readNsonString(in));
                    continue;
                }
                if (name.equals(NsonProtocol.OPERATION_ID)) {
                    result.setOperationId(Nson.readNsonString(in));
                    continue;
                }
                NsonSerializerBase.skipUnknownField(walker, name);
            }
            return result;
        }

        private static SystemResult.State getOperationState(int state) {
            switch (state) {
                case 0: {
                    return SystemResult.State.COMPLETE;
                }
                case 1: {
                    return SystemResult.State.WORKING;
                }
            }
            throw new IllegalStateException("Unknown operation state " + state);
        }

        protected static TableResult deserializeTableResult(Request request, ByteInputStream in) throws IOException {
            TableResult result = new TableResult();
            in.setOffset(0);
            MapWalker walker = NsonSerializerBase.getMapWalker(in);
            while (walker.hasNext()) {
                walker.next();
                String name = walker.getCurrentName();
                if (name.equals(NsonProtocol.ERROR_CODE)) {
                    NsonSerializerBase.handleErrorCode(walker);
                    continue;
                }
                if (name.equals(NsonProtocol.COMPARTMENT_OCID)) {
                    result.setCompartmentId(Nson.readNsonString(in));
                    continue;
                }
                if (name.equals(NsonProtocol.NAMESPACE)) {
                    result.setNamespace(Nson.readNsonString(in));
                    continue;
                }
                if (name.equals(NsonProtocol.TABLE_OCID)) {
                    result.setTableId(Nson.readNsonString(in));
                    continue;
                }
                if (name.equals(NsonProtocol.TABLE_NAME)) {
                    result.setTableName(Nson.readNsonString(in));
                    continue;
                }
                if (name.equals(NsonProtocol.TABLE_STATE)) {
                    result.setState(BinaryProtocol.getTableState(Nson.readNsonInt(in)));
                    continue;
                }
                if (name.equals(NsonProtocol.TABLE_SCHEMA)) {
                    result.setSchema(Nson.readNsonString(in));
                    continue;
                }
                if (name.equals(NsonProtocol.TABLE_DDL)) {
                    result.setDdl(Nson.readNsonString(in));
                    continue;
                }
                if (name.equals(NsonProtocol.OPERATION_ID)) {
                    result.setOperationId(Nson.readNsonString(in));
                    continue;
                }
                if (name.equals(NsonProtocol.FREE_FORM_TAGS)) {
                    result.setFreeFormTags(new FreeFormTags(Nson.readNsonString(in)));
                    continue;
                }
                if (name.equals(NsonProtocol.DEFINED_TAGS)) {
                    result.setDefinedTags(new DefinedTags(Nson.readNsonString(in)));
                    continue;
                }
                if (name.equals(NsonProtocol.ETAG)) {
                    result.setMatchETag(Nson.readNsonString(in));
                    continue;
                }
                if (name.equals(NsonProtocol.LIMITS)) {
                    MapWalker lw = new MapWalker(in);
                    int ru = 0;
                    int wu = 0;
                    int sg = 0;
                    int mode = 1;
                    while (lw.hasNext()) {
                        lw.next();
                        name = lw.getCurrentName();
                        if (name.equals(NsonProtocol.READ_UNITS)) {
                            ru = Nson.readNsonInt(in);
                            continue;
                        }
                        if (name.equals(NsonProtocol.WRITE_UNITS)) {
                            wu = Nson.readNsonInt(in);
                            continue;
                        }
                        if (name.equals(NsonProtocol.STORAGE_GB)) {
                            sg = Nson.readNsonInt(in);
                            continue;
                        }
                        if (name.equals(NsonProtocol.LIMITS_MODE)) {
                            mode = Nson.readNsonInt(in);
                            continue;
                        }
                        NsonSerializerBase.skipUnknownField(lw, name);
                    }
                    result.setTableLimits(new TableLimits(ru, wu, sg, NsonSerializerBase.getCapacityMode(mode)));
                    continue;
                }
                if (name.equals(NsonProtocol.SCHEMA_FROZEN)) {
                    result.setIsFrozen(Nson.readNsonBoolean(in));
                    continue;
                }
                if (name.equals(NsonProtocol.INITIALIZED)) {
                    result.setLocalReplicaInitialized(Nson.readNsonBoolean(in));
                    continue;
                }
                if (name.equals(NsonProtocol.REPLICAS)) {
                    NsonSerializerBase.readReplicas(in, result);
                    continue;
                }
                NsonSerializerBase.skipUnknownField(walker, name);
            }
            return result;
        }

        private static void readReplicas(ByteInputStream in, TableResult result) throws IOException {
            byte t = in.readByte();
            if (t != 0) {
                throw new IllegalStateException("Replicas: bad type in table result: " + Nson.typeString(t) + ", should be ARRAY");
            }
            in.readInt();
            int numElements = in.readInt();
            TableResult.Replica[] replicas = new TableResult.Replica[numElements];
            for (int i = 0; i < numElements; ++i) {
                TableResult.Replica replica = new TableResult.Replica();
                NsonSerializerBase.readReplica(in, replica);
                replicas[i] = replica;
            }
            result.setReplicas(replicas);
        }

        private static void readReplica(ByteInputStream in, TableResult.Replica replica) throws IOException {
            MapWalker walker = new MapWalker(in);
            while (walker.hasNext()) {
                walker.next();
                String name = walker.getCurrentName();
                if (name.equals(NsonProtocol.REGION)) {
                    replica.setReplicaName(Nson.readNsonString(in));
                    continue;
                }
                if (name.equals(NsonProtocol.TABLE_OCID)) {
                    replica.setTableId(Nson.readNsonString(in));
                    continue;
                }
                if (name.equals(NsonProtocol.WRITE_UNITS)) {
                    replica.setWriteUnits(Nson.readNsonInt(in));
                    continue;
                }
                if (name.equals(NsonProtocol.LIMITS_MODE)) {
                    replica.setCapacityMode(NsonSerializerBase.getCapacityMode(Nson.readNsonInt(in)));
                    continue;
                }
                if (name.equals(NsonProtocol.TABLE_STATE)) {
                    replica.setState(BinaryProtocol.getTableState(Nson.readNsonInt(in)));
                    continue;
                }
                NsonSerializerBase.skipUnknownField(walker, name);
            }
        }

        protected static BinaryProtocol.OpCode getOpCode(PutRequest req) {
            if (req.getOption() == null) {
                return BinaryProtocol.OpCode.PUT;
            }
            switch (req.getOption()) {
                case IfAbsent: {
                    return BinaryProtocol.OpCode.PUT_IF_ABSENT;
                }
                case IfPresent: {
                    return BinaryProtocol.OpCode.PUT_IF_PRESENT;
                }
                case IfVersion: {
                    return BinaryProtocol.OpCode.PUT_IF_VERSION;
                }
            }
            throw new IllegalStateException("Unknown Options " + (Object)((Object)req.getOption()));
        }

        protected static void skipUnknownField(MapWalker walker, String name) throws IOException {
            walker.skip();
        }

        protected static TableLimits.CapacityMode getCapacityMode(int mode) {
            switch (mode) {
                case 1: {
                    return TableLimits.CapacityMode.PROVISIONED;
                }
                case 2: {
                    return TableLimits.CapacityMode.ON_DEMAND;
                }
            }
            throw new IllegalStateException("Unknown capacity mode " + mode);
        }

        protected static long timeToLong(String timestamp) {
            return new TimestampValue(timestamp).getLong();
        }

        protected static MapWalker getMapWalker(ByteInputStream in) throws IOException {
            int offset = in.getOffset();
            try {
                return new MapWalker(in);
            }
            catch (IllegalArgumentException e) {
                in.setOffset(offset);
                byte code = in.readByte();
                if (code == 24 || code == 17) {
                    throw new UnsupportedProtocolException(e.getMessage());
                }
                throw e;
            }
        }
    }
}

