/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.query;

import java.io.IOException;
import oracle.nosql.driver.ops.serde.BinaryProtocol;
import oracle.nosql.driver.query.PlanIter;
import oracle.nosql.driver.query.PlanIterState;
import oracle.nosql.driver.query.QueryFormatter;
import oracle.nosql.driver.query.RuntimeControlBlock;
import oracle.nosql.driver.util.ByteInputStream;
import oracle.nosql.driver.values.FieldValue;

public class ConstIter
extends PlanIter {
    final FieldValue theValue;

    ConstIter(ByteInputStream in, short serialVersion) throws IOException {
        super(in, serialVersion);
        this.theValue = BinaryProtocol.readFieldValue(in);
    }

    @Override
    public PlanIter.PlanIterKind getKind() {
        return PlanIter.PlanIterKind.CONST;
    }

    @Override
    public void open(RuntimeControlBlock rcb) {
        rcb.setState(this.theStatePos, new PlanIterState());
        rcb.setRegVal(this.theResultReg, this.theValue);
    }

    @Override
    public boolean next(RuntimeControlBlock rcb) {
        PlanIterState state = rcb.getState(this.theStatePos);
        if (state.isDone()) {
            return false;
        }
        state.done();
        return true;
    }

    @Override
    public void reset(RuntimeControlBlock rcb) {
        PlanIterState state = rcb.getState(this.theStatePos);
        state.reset(this);
    }

    @Override
    public void close(RuntimeControlBlock rcb) {
        PlanIterState state = rcb.getState(this.theStatePos);
        if (state == null) {
            return;
        }
        state.close();
    }

    FieldValue getValue() {
        return this.theValue;
    }

    @Override
    protected void displayContent(StringBuilder sb, QueryFormatter formatter) {
        formatter.indent(sb);
        sb.append(this.theValue.toJson());
    }
}

