/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import oracle.nosql.driver.NoSQLException;
import oracle.nosql.driver.RetryableException;
import oracle.nosql.driver.ops.QueryRequest;
import oracle.nosql.driver.ops.QueryResult;
import oracle.nosql.driver.query.Compare;
import oracle.nosql.driver.query.PlanIter;
import oracle.nosql.driver.query.PlanIterState;
import oracle.nosql.driver.query.QueryFormatter;
import oracle.nosql.driver.query.QueryStateException;
import oracle.nosql.driver.query.RuntimeControlBlock;
import oracle.nosql.driver.query.SortSpec;
import oracle.nosql.driver.query.TopologyInfo;
import oracle.nosql.driver.query.VirtualScan;
import oracle.nosql.driver.util.ByteInputStream;
import oracle.nosql.driver.util.ByteOutputStream;
import oracle.nosql.driver.util.NettyByteOutputStream;
import oracle.nosql.driver.util.SerializationUtil;
import oracle.nosql.driver.util.SizeOf;
import oracle.nosql.driver.values.BinaryValue;
import oracle.nosql.driver.values.FieldValue;
import oracle.nosql.driver.values.MapValue;
import oracle.nosql.driver.values.NumberValue;

public class ReceiveIter
extends PlanIter {
    private final DistributionKind theDistributionKind;
    private final String[] theSortFields;
    private final SortSpec[] theSortSpecs;
    private final String[] thePrimKeyFields;

    public ReceiveIter(ByteInputStream in, short serialVersion) throws IOException {
        super(in, serialVersion);
        short ordinal = in.readShort();
        this.theDistributionKind = DistributionKind.values()[ordinal];
        this.theSortFields = SerializationUtil.readStringArray(in);
        this.theSortSpecs = ReceiveIter.readSortSpecs(in);
        this.thePrimKeyFields = SerializationUtil.readStringArray(in);
    }

    @Override
    public PlanIter.PlanIterKind getKind() {
        return PlanIter.PlanIterKind.RECV;
    }

    boolean doesSort() {
        return this.theSortFields != null;
    }

    boolean doesDupElim() {
        return this.thePrimKeyFields != null;
    }

    @Override
    public void open(RuntimeControlBlock rcb) {
        ReceiveIterState state = new ReceiveIterState(rcb, this);
        rcb.setState(this.theStatePos, state);
        rcb.incMemoryConsumption(state.theMemoryConsumption);
        QueryRequest qreq = rcb.getRequest();
        assert (qreq.isPrepared());
        assert (qreq.hasDriver());
    }

    @Override
    public void reset(RuntimeControlBlock rcb) {
        throw new IllegalStateException("Should never be called");
    }

    @Override
    public void close(RuntimeControlBlock rcb) {
        ReceiveIterState state = (ReceiveIterState)rcb.getState(this.theStatePos);
        if (state == null) {
            return;
        }
        state.close();
    }

    @Override
    public boolean next(RuntimeControlBlock rcb) {
        ReceiveIterState state = (ReceiveIterState)rcb.getState(this.theStatePos);
        if (state.isDone()) {
            if (rcb.getTraceLevel() >= 1) {
                rcb.trace("ReceiveIter.next() : done");
            }
            return false;
        }
        if (!this.doesSort()) {
            return this.simpleNext(rcb, state);
        }
        return this.sortingNext(rcb, state);
    }

    private boolean simpleNext(RuntimeControlBlock rcb, ReceiveIterState state) {
        MapValue res;
        while ((res = state.theScanner.next()) != null) {
            if (rcb.getTraceLevel() >= 1) {
                rcb.trace("ReceiveIter.simpleNext() : got result :\n" + res);
            }
            if (this.checkDuplicate(rcb, state, res)) continue;
            rcb.setRegVal(this.theResultReg, res);
            return true;
        }
        if (rcb.getTraceLevel() >= 1) {
            rcb.trace("ReceiveIter.simleNext() : no result. Reached limit = " + rcb.reachedLimit());
        }
        if (!rcb.reachedLimit()) {
            state.done();
        }
        return false;
    }

    private boolean sortingNext(RuntimeControlBlock rcb, ReceiveIterState state) {
        RemoteScanner scanner;
        if (this.theDistributionKind == DistributionKind.ALL_PARTITIONS && state.theIsInSortPhase1) {
            this.initPartitionSort(rcb, state);
            return false;
        }
        while (true) {
            if ((scanner = state.theSortedScanners.pollFirst()) == null) {
                state.done();
                return false;
            }
            MapValue res = scanner.nextLocal();
            if (res != null) {
                if (rcb.getTraceLevel() >= 1) {
                    rcb.trace("ReceiveIter.sortingNext() : got result :\n" + res);
                }
                res.convertEmptyToNull();
                rcb.setRegVal(this.theResultReg, res);
                if (!scanner.isDone()) {
                    state.theSortedScanners.add(scanner);
                } else if (rcb.getTraceLevel() >= 1) {
                    rcb.trace("ReceiveIter.sortingNext() : done with partition/shard " + scanner.theShardOrPartId);
                }
                if (this.checkDuplicate(rcb, state, res)) continue;
                return true;
            }
            if (!scanner.isDone()) break;
        }
        try {
            scanner.fetch();
            this.handleVirtualScans(rcb, state, scanner);
        }
        catch (RetryableException e) {
            state.theSortedScanners.add(scanner);
            throw e;
        }
        if (!scanner.isDone()) {
            state.theSortedScanners.add(scanner);
        } else if (rcb.getTraceLevel() >= 1) {
            rcb.trace("ReceiveIter.sortingNext() : done with partition/shard " + scanner.theShardOrPartId);
        }
        rcb.setReachedLimit(true);
        return false;
    }

    private void initPartitionSort(RuntimeControlBlock rcb, ReceiveIterState state) {
        assert (state.theIsInSortPhase1);
        QueryRequest origRequest = rcb.getRequest();
        QueryRequest reqCopy = origRequest.copyInternal();
        reqCopy.setContKey(state.theContinuationKey);
        if (rcb.getTraceLevel() >= 1) {
            rcb.trace("ReceiveIter : executing remote request for sorting phase 1");
        }
        QueryResult result = this.execute(rcb, origRequest, reqCopy);
        int numPids = result.getNumPids();
        List<MapValue> results = result.getResultsInternal();
        state.theIsInSortPhase1 = result.isInPhase1();
        state.theContinuationKey = result.getContinuationKey();
        rcb.tallyReadKB(result.getReadKB());
        rcb.tallyReadUnits(result.getReadUnits());
        rcb.tallyWriteKB(result.getWriteKB());
        rcb.tallyRateLimitDelayedMs(result.getRateLimitDelayedMs());
        rcb.tallyRetryStats(result.getRetryStats());
        if (rcb.getTraceLevel() >= 1) {
            rcb.trace("ReceiveIter.initPartitionSort() : got result.\nreached limit = " + result.reachedLimit() + " in phase 1 = " + result.isInPhase1());
            origRequest.addQueryTraces(result.getQueryTraces());
        }
        int resIdx = 0;
        for (int p = 0; p < numPids; ++p) {
            int pid = result.getPid(p);
            int numResults = result.getNumPartitionResults(p);
            byte[] contKey = result.getPartitionContKey(p);
            assert (numResults > 0);
            ArrayList<MapValue> partitionResults = new ArrayList<MapValue>(numResults);
            for (int j = 0; j < numResults; ++j) {
                MapValue res = results.get(resIdx);
                partitionResults.add(res);
                if (rcb.getTraceLevel() >= 1) {
                    rcb.trace("Added result for partition " + pid + ":\n" + res);
                }
                ++resIdx;
            }
            RemoteScanner scanner = new RemoteScanner(rcb, state, false, pid, null);
            scanner.addResults(partitionResults, contKey);
            state.theSortedScanners.add(scanner);
        }
        if (rcb.getTraceLevel() >= 1) {
            rcb.trace("ReceiveIter.initPartitionSort() :  memory consumption = " + state.theMemoryConsumption);
        }
        rcb.setReachedLimit(true);
    }

    private void handleVirtualScans(RuntimeControlBlock rcb, ReceiveIterState state, RemoteScanner scanner) {
        if (this.theDistributionKind == DistributionKind.ALL_PARTITIONS || scanner.theVirtualScans == null) {
            return;
        }
        for (VirtualScan vs : scanner.theVirtualScans) {
            int vsid;
            ++state.theBaseVSID;
            state.theSortedScanners.add(new RemoteScanner(rcb, state, true, vsid, vs));
            if (rcb.getTraceLevel() < 1) continue;
            rcb.trace("ReceiveIter: added scanner for virtual scan:\n" + vs);
        }
        scanner.theVirtualScans = null;
    }

    private boolean checkDuplicate(RuntimeControlBlock rcb, ReceiveIterState state, MapValue res) {
        if (this.thePrimKeyFields == null) {
            return false;
        }
        BinaryValue binPrimKey = this.createBinaryPrimKey(res);
        boolean added = state.thePrimKeysSet.add(binPrimKey);
        if (!added) {
            if (rcb.getTraceLevel() >= 1) {
                rcb.trace("ReceiveIter.checkDuplicate() : result was duplicate");
            }
            return true;
        }
        long sz = binPrimKey.sizeof() + (long)SizeOf.HASHSET_ENTRY_OVERHEAD;
        state.theMemoryConsumption += sz;
        state.theDupElimMemory += sz;
        rcb.incMemoryConsumption(sz);
        return false;
    }

    private BinaryValue createBinaryPrimKey(MapValue result) {
        NettyByteOutputStream bos = NettyByteOutputStream.createNettyByteOutputStream();
        try {
            for (int i = 0; i < this.thePrimKeyFields.length; ++i) {
                FieldValue fval = result.get(this.thePrimKeyFields[i]);
                this.writeValue(bos, fval, i);
            }
            BinaryValue binaryValue = new BinaryValue(bos.array());
            if (bos != null) {
                bos.close();
            }
            return binaryValue;
        }
        catch (Throwable throwable) {
            try {
                if (bos != null) {
                    try {
                        bos.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new QueryStateException("Failed to create binary prim key due to IOException:\n" + e.getMessage());
            }
        }
    }

    private void writeValue(ByteOutputStream out, FieldValue val, int i) throws IOException {
        switch (val.getType()) {
            case INTEGER: {
                SerializationUtil.writePackedInt(out, val.getInt());
                break;
            }
            case LONG: {
                SerializationUtil.writePackedLong(out, val.getLong());
                break;
            }
            case DOUBLE: {
                out.writeDouble(val.getDouble());
                break;
            }
            case NUMBER: {
                NumberValue num = (NumberValue)val;
                SerializationUtil.writeString(out, num.getString());
                break;
            }
            case STRING: {
                SerializationUtil.writeString(out, val.getString());
                break;
            }
            case TIMESTAMP: {
                SerializationUtil.writeString(out, val.getString());
                break;
            }
            default: {
                throw new QueryStateException("Unexpected type for primary key column : " + (Object)((Object)val.getType()) + ", at result column " + i);
            }
        }
    }

    private QueryResult execute(RuntimeControlBlock rcb, QueryRequest origRequest, QueryRequest reqCopy) {
        NoSQLException e = null;
        QueryResult result = null;
        try {
            result = (QueryResult)rcb.getClient().execute(reqCopy);
        }
        catch (NoSQLException qe) {
            e = qe;
        }
        reqCopy.copyTo(origRequest);
        if (e != null) {
            throw e;
        }
        return result;
    }

    @Override
    protected void displayContent(StringBuilder sb, QueryFormatter formatter) {
        int i;
        formatter.indent(sb);
        sb.append("DistributionKind : ").append((Object)this.theDistributionKind);
        sb.append(",\n");
        if (this.theSortFields != null) {
            formatter.indent(sb);
            sb.append("Sort Fields : ");
            for (i = 0; i < this.theSortFields.length; ++i) {
                sb.append(this.theSortFields[i]);
                if (i >= this.theSortFields.length - 1) continue;
                sb.append(", ");
            }
            sb.append(",\n");
        }
        if (this.thePrimKeyFields != null) {
            formatter.indent(sb);
            sb.append("Primary Key Fields : ");
            for (i = 0; i < this.thePrimKeyFields.length; ++i) {
                sb.append(this.thePrimKeyFields[i]);
                if (i >= this.thePrimKeyFields.length - 1) continue;
                sb.append(", ");
            }
            sb.append(",\n");
        }
    }

    public static enum DistributionKind {
        SINGLE_PARTITION,
        ALL_PARTITIONS,
        ALL_SHARDS;

    }

    private static class ReceiveIterState
    extends PlanIterState {
        RemoteScanner theScanner;
        TreeSet<RemoteScanner> theSortedScanners;
        boolean theIsInSortPhase1 = true;
        byte[] theContinuationKey = null;
        int theBaseVSID = -1;
        HashSet<BinaryValue> thePrimKeysSet;
        long theMemoryConsumption;
        long theDupElimMemory;
        long theTotalResultsSize;
        long theTotalNumResults;

        ReceiveIterState(RuntimeControlBlock rcb, ReceiveIter iter) {
            if (iter.doesDupElim()) {
                this.thePrimKeysSet = new HashSet(1000);
            }
            if (iter.doesSort() && iter.theDistributionKind == DistributionKind.ALL_PARTITIONS) {
                this.theSortedScanners = new TreeSet();
            } else if (iter.doesSort() && iter.theDistributionKind == DistributionKind.ALL_SHARDS) {
                TopologyInfo baseTopo = rcb.getBaseTopo();
                int numShards = baseTopo.numShards();
                this.theSortedScanners = new TreeSet();
                for (int i = 0; i < numShards; ++i) {
                    ReceiveIter receiveIter = iter;
                    Objects.requireNonNull(receiveIter);
                    this.theSortedScanners.add(receiveIter.new RemoteScanner(rcb, this, true, baseTopo.getShardId(i), null));
                }
                this.theBaseVSID = baseTopo.getLastShardId() + 1;
            } else {
                ReceiveIter receiveIter = iter;
                Objects.requireNonNull(receiveIter);
                this.theScanner = receiveIter.new RemoteScanner(rcb, this, false, -1, null);
            }
        }

        @Override
        public void done() {
            super.done();
            this.clear();
        }

        @Override
        public void close() {
            super.close();
            this.thePrimKeysSet = null;
            this.theSortedScanners = null;
        }

        void clear() {
            if (this.thePrimKeysSet != null) {
                this.thePrimKeysSet.clear();
            }
            if (this.theSortedScanners != null) {
                this.theSortedScanners.clear();
            }
        }
    }

    private class RemoteScanner
    implements Comparable<RemoteScanner> {
        final RuntimeControlBlock theRCB;
        final ReceiveIterState theState;
        boolean theIsForShard;
        int theShardOrPartId = -1;
        List<MapValue> theResults;
        long theResultsSize;
        int theNextResultPos;
        byte[] theContinuationKey;
        VirtualScan[] theVirtualScans;
        VirtualScan theVirtualScan;
        boolean theMoreRemoteResults;

        public RemoteScanner(RuntimeControlBlock rcb, ReceiveIterState state, boolean isForShard, int spid, VirtualScan vs) {
            this.theRCB = rcb;
            this.theState = state;
            this.theMoreRemoteResults = true;
            this.theIsForShard = isForShard;
            this.theShardOrPartId = spid;
            this.theVirtualScan = vs;
        }

        boolean isDone() {
            return !this.theMoreRemoteResults && (this.theResults == null || this.theNextResultPos >= this.theResults.size());
        }

        boolean hasLocalResults() {
            return this.theResults != null && this.theNextResultPos < this.theResults.size();
        }

        void addResults(List<MapValue> results, byte[] contKey) {
            this.theResults = results;
            this.theContinuationKey = contKey;
            this.theMoreRemoteResults = contKey != null;
            this.addMemoryConsumption();
        }

        MapValue nextLocal() {
            if (this.theResults != null && this.theNextResultPos < this.theResults.size()) {
                MapValue res = this.theResults.get(this.theNextResultPos);
                this.theResults.set(this.theNextResultPos, null);
                ++this.theNextResultPos;
                return res;
            }
            return null;
        }

        MapValue next() {
            if (this.theResults != null && this.theNextResultPos < this.theResults.size()) {
                return this.theResults.get(this.theNextResultPos++);
            }
            this.theResults = null;
            this.theNextResultPos = 0;
            if (!this.theMoreRemoteResults || this.theRCB.reachedLimit()) {
                return null;
            }
            this.fetch();
            if (this.theResults.isEmpty()) {
                return null;
            }
            return this.theResults.get(this.theNextResultPos++);
        }

        void fetch() {
            QueryRequest origRequest = this.theRCB.getRequest();
            origRequest.incBatchCounter();
            QueryRequest reqCopy = origRequest.copyInternal();
            reqCopy.setContKey(this.theContinuationKey);
            reqCopy.setShardId(this.theIsForShard ? this.theShardOrPartId : -1);
            if (ReceiveIter.this.doesSort() && !this.theIsForShard) {
                this.theState.theMemoryConsumption -= this.theResultsSize;
                this.theRCB.decMemoryConsumption(this.theResultsSize);
                long numResults = (reqCopy.getMaxMemoryConsumption() - this.theState.theDupElimMemory) / ((long)(this.theState.theSortedScanners.size() + 1) * (this.theState.theTotalResultsSize / this.theState.theTotalNumResults));
                if (numResults > 2048L) {
                    numResults = 2048L;
                }
                reqCopy.setLimit((int)numResults);
            }
            if (this.theRCB.getTraceLevel() >= 1) {
                this.theRCB.trace("RemoteScanner : executing remote batch " + origRequest.getBatchCounter() + ". spid = " + this.theShardOrPartId);
                if (this.theVirtualScan != null) {
                    this.theRCB.trace("RemoteScanner : request is for virtual scan:\n" + this.theVirtualScan);
                }
                assert (reqCopy.hasDriver());
            }
            if (this.theVirtualScan != null) {
                assert (this.theIsForShard);
                assert (ReceiveIter.this.doesSort());
                reqCopy.setVirtualScan(this.theVirtualScan);
            }
            QueryResult result = ReceiveIter.this.execute(this.theRCB, origRequest, reqCopy);
            if (this.theVirtualScan != null && this.theVirtualScan.isFirstBatch()) {
                this.theVirtualScan.theFirstBatch = false;
            }
            this.theResults = result.getResultsInternal();
            this.theContinuationKey = result.getContinuationKey();
            this.theVirtualScans = result.getVirtualScans();
            this.theNextResultPos = 0;
            this.theMoreRemoteResults = this.theContinuationKey != null;
            this.theRCB.tallyReadKB(result.getReadKB());
            this.theRCB.tallyReadUnits(result.getReadUnits());
            this.theRCB.tallyWriteKB(result.getWriteKB());
            this.theRCB.tallyRateLimitDelayedMs(result.getRateLimitDelayedMs());
            this.theRCB.tallyRetryStats(result.getRetryStats());
            assert (result.reachedLimit() || !this.theMoreRemoteResults);
            origRequest.addQueryTraces(result.getQueryTraces());
            if (result.reachedLimit() || ReceiveIter.this.doesSort()) {
                this.theRCB.setReachedLimit(true);
            }
            if (ReceiveIter.this.doesSort() && !this.theIsForShard) {
                this.addMemoryConsumption();
            }
            if (this.theRCB.getTraceLevel() >= 1) {
                StringBuilder sb = new StringBuilder("RemoteScanner : got ");
                sb.append(this.theResults.size());
                sb.append(" remote results. More remote resuls = ");
                sb.append(this.theMoreRemoteResults);
                sb.append(" reached limit = ").append(result.reachedLimit());
                sb.append(" read KB = ").append(result.getReadKB());
                sb.append(" read Units = ").append(result.getReadUnits());
                sb.append(" write KB = ").append(result.getWriteKB());
                sb.append(" memory consumption = ").append(this.theState.theMemoryConsumption);
                if (this.theVirtualScans != null) {
                    sb.append("\nVSM = [\n");
                    for (VirtualScan vs : this.theVirtualScans) {
                        sb.append(vs).append("\n");
                    }
                    sb.append("]\n");
                }
                this.theRCB.trace(sb.toString());
            }
        }

        private void addMemoryConsumption() {
            this.theResultsSize = 0L;
            for (int i = 0; i < this.theResults.size(); ++i) {
                this.theResultsSize += this.theResults.get(i).sizeof();
            }
            this.theResultsSize += (long)(this.theResults.size() * SizeOf.OBJECT_REF_OVERHEAD);
            this.theState.theTotalNumResults += (long)this.theResults.size();
            this.theState.theTotalResultsSize += this.theResultsSize;
            this.theState.theMemoryConsumption += this.theResultsSize;
            this.theRCB.incMemoryConsumption(this.theResultsSize);
        }

        @Override
        public int compareTo(RemoteScanner other) {
            MapValue v2;
            if (!this.hasLocalResults()) {
                if (!other.hasLocalResults()) {
                    return this.theShardOrPartId < other.theShardOrPartId ? -1 : 1;
                }
                return -1;
            }
            if (!other.hasLocalResults()) {
                return 1;
            }
            MapValue v1 = this.theResults.get(this.theNextResultPos);
            int comp = Compare.sortResults(this.theRCB, v1, v2 = other.theResults.get(other.theNextResultPos), ReceiveIter.this.theSortFields, ReceiveIter.this.theSortSpecs);
            if (comp == 0) {
                comp = this.theShardOrPartId < other.theShardOrPartId ? -1 : 1;
            }
            return comp;
        }
    }
}

