/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.query;

import oracle.nosql.driver.query.PlanIter;

public class VirtualScan {
    private final int theSID;
    private final int thePID;
    private final TableResumeInfo[] theTableRIs;
    boolean theFirstBatch = true;

    public VirtualScan(int pid, int sid, TableResumeInfo[] tableRIs) {
        this.theSID = sid;
        this.thePID = pid;
        this.theTableRIs = tableRIs;
    }

    public int sid() {
        return this.theSID;
    }

    public int pid() {
        return this.thePID;
    }

    public int numTables() {
        return this.theTableRIs.length;
    }

    public int currentIndexRange(int i) {
        return this.theTableRIs[i].theCurrentIndexRange;
    }

    public byte[] secKey(int i) {
        return this.theTableRIs[i].theSecResumeKey;
    }

    public byte[] primKey(int i) {
        return this.theTableRIs[i].thePrimResumeKey;
    }

    public boolean moveAfterResumeKey(int i) {
        return this.theTableRIs[i].theMoveAfterResumeKey;
    }

    public byte[] descResumeKey(int i) {
        return this.theTableRIs[i].theDescResumeKey;
    }

    public int[] joinPathTables(int i) {
        return this.theTableRIs[i].theJoinPathTables;
    }

    public byte[] joinPathKey(int i) {
        return this.theTableRIs[i].theJoinPathKey;
    }

    public byte[] joinPathSecKey(int i) {
        return this.theTableRIs[i].theJoinPathSecKey;
    }

    public boolean joinPathMatched(int i) {
        return this.theTableRIs[i].theJoinPathMatched;
    }

    public boolean isFirstBatch() {
        return this.theFirstBatch;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("sid/pid = ").append(this.theSID).append("/").append(this.thePID);
        sb.append("\n");
        sb.append("theFirstBatch = ").append(this.theFirstBatch);
        sb.append("\n");
        for (int i = 0; i < this.theTableRIs.length; ++i) {
            sb.append("Table RI ").append(i).append(":\n");
            sb.append(this.theTableRIs[i]);
        }
        return sb.toString();
    }

    public static class TableResumeInfo {
        private final int theCurrentIndexRange;
        private final byte[] thePrimResumeKey;
        private final byte[] theSecResumeKey;
        private final boolean theMoveAfterResumeKey;
        private final byte[] theDescResumeKey;
        private final int[] theJoinPathTables;
        private final byte[] theJoinPathKey;
        private final byte[] theJoinPathSecKey;
        private final boolean theJoinPathMatched;

        public TableResumeInfo(int currentIndexRange, byte[] primKey, byte[] secKey, boolean moveAfterResumeKey, byte[] descResumeKey, int[] joinPathTables, byte[] joinPathKey, byte[] joinPathSecKey, boolean joinPathMatched) {
            this.theCurrentIndexRange = currentIndexRange;
            this.thePrimResumeKey = primKey;
            this.theSecResumeKey = secKey;
            this.theMoveAfterResumeKey = moveAfterResumeKey;
            this.theDescResumeKey = descResumeKey;
            this.theJoinPathTables = joinPathTables;
            this.theJoinPathKey = joinPathKey;
            this.theJoinPathSecKey = joinPathSecKey;
            this.theJoinPathMatched = joinPathMatched;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("theCurrentIndexRange = ").append(this.theCurrentIndexRange);
            sb.append("\n");
            if (this.thePrimResumeKey != null) {
                sb.append("thePrimResumeKey = ");
                sb.append(PlanIter.printByteArray(this.thePrimResumeKey));
                sb.append("\n");
            }
            if (this.theSecResumeKey != null) {
                sb.append("theSecResumeKey = ");
                sb.append(PlanIter.printByteArray(this.theSecResumeKey));
                sb.append("\n");
            }
            sb.append("theMoveAfterResumeKey = ").append(this.theMoveAfterResumeKey);
            sb.append("\n");
            if (this.theDescResumeKey != null) {
                sb.append("theDescResumeKey = ");
                sb.append(PlanIter.printByteArray(this.theDescResumeKey));
                sb.append("\n");
            }
            if (this.theJoinPathTables != null) {
                sb.append("theJoinPathTables = ");
                sb.append(PlanIter.printIntArray(this.theJoinPathTables));
                sb.append("\n");
            }
            if (this.theJoinPathKey != null) {
                sb.append("theJoinPathKey = ");
                sb.append(PlanIter.printByteArray(this.theJoinPathKey));
                sb.append("\n");
            }
            if (this.theJoinPathSecKey != null) {
                sb.append("theJoinPathSecKey = ");
                sb.append(PlanIter.printByteArray(this.theJoinPathSecKey));
                sb.append("\n");
            }
            sb.append("theJoinPathMatched = ").append(this.theJoinPathMatched);
            sb.append("\n");
            return sb.toString();
        }
    }
}

