/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.util;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import oracle.nosql.driver.util.ByteInputStream;

public class NettyByteInputStream
extends ByteBufInputStream
implements ByteInputStream {
    final ByteBuf buffer;

    public NettyByteInputStream(ByteBuf buffer) {
        super(buffer);
        this.buffer = buffer;
    }

    public static NettyByteInputStream createFromBytes(byte[] bytes) {
        return new NettyByteInputStream(Unpooled.wrappedBuffer((byte[])bytes));
    }

    @Override
    public int getOffset() {
        return this.buffer.readerIndex();
    }

    @Override
    public boolean isDirect() {
        return this.buffer.isDirect();
    }

    @Override
    public byte[] array() {
        return this.buffer.array();
    }

    @Override
    public void setOffset(int offset) {
        try {
            this.buffer.readerIndex(offset);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public void skip(int toSkip) {
        this.setOffset(this.getOffset() + toSkip);
    }

    public ByteBuf buffer() {
        return this.buffer;
    }

    @Override
    public void close() {
        try {
            super.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void ensureCapacity(int nbytes) {
        if (nbytes > this.buffer.readableBytes()) {
            throw new IllegalArgumentException("Operation exceeds capacity of the buffer; it requires: " + nbytes + ", available: " + this.buffer.readableBytes());
        }
    }
}

