/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.util;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import oracle.nosql.driver.RateLimiter;

public class SimpleRateLimiter
implements RateLimiter {
    protected long nanosPerUnit;
    protected long durationNanos;
    protected long lastNano;

    public SimpleRateLimiter(double rateLimitPerSec) {
        this(rateLimitPerSec, 1.0);
    }

    public SimpleRateLimiter(double rateLimitPerSec, double durationSecs) {
        this.setLimitPerSecond(rateLimitPerSec);
        this.setDuration(durationSecs);
        this.reset();
    }

    @Override
    public final synchronized void setLimitPerSecond(double rateLimitPerSec) {
        this.nanosPerUnit = rateLimitPerSec <= 0.0 ? 0L : (long)(1.0E9 / rateLimitPerSec);
        this.enforceMinimumDuration();
    }

    private void enforceMinimumDuration() {
        if (this.durationNanos < this.nanosPerUnit) {
            this.durationNanos = this.nanosPerUnit;
        }
    }

    @Override
    public double getLimitPerSecond() {
        if (this.nanosPerUnit == 0L) {
            return 0.0;
        }
        return 1.0E9 / (double)this.nanosPerUnit;
    }

    @Override
    public double getDuration() {
        return (double)this.durationNanos / 1.0E9;
    }

    @Override
    public final void setDuration(double durationSecs) {
        this.durationNanos = (long)(durationSecs * 1.0E9);
        this.enforceMinimumDuration();
    }

    @Override
    public final void reset() {
        this.lastNano = System.nanoTime();
    }

    @Override
    public void setCurrentRate(double percent) {
        long nowNanos = System.nanoTime();
        if (percent == 100.0) {
            this.lastNano = nowNanos;
            return;
        }
        this.lastNano = nowNanos + (long)((percent -= 100.0) / 100.0 * 1.0E9);
    }

    @Override
    public int consumeUnits(long units) {
        int msToSleep = this.consumeInternal(units, 0, false, System.nanoTime());
        this.uninterruptibleSleep(msToSleep);
        return msToSleep;
    }

    @Override
    public int consumeUnitsWithTimeout(long units, int timeoutMs, boolean alwaysConsume) throws TimeoutException {
        if (timeoutMs < 0) {
            throw new IllegalArgumentException("timeoutMs must be 0 or positive");
        }
        int msToSleep = this.consumeInternal(units, timeoutMs, alwaysConsume, System.nanoTime());
        if (msToSleep == 0) {
            return 0;
        }
        if (timeoutMs > 0 && msToSleep >= timeoutMs) {
            this.uninterruptibleSleep(timeoutMs);
            throw new TimeoutException("timed out waiting " + timeoutMs + "ms due to rate limiting");
        }
        this.uninterruptibleSleep(msToSleep);
        return msToSleep;
    }

    private synchronized int consumeInternal(long units, int timeoutMs, boolean alwaysConsume, long nowNanos) {
        if (this.nanosPerUnit <= 0L) {
            return 0;
        }
        long nanosNeeded = units * this.nanosPerUnit;
        long maxPast = nowNanos - this.durationNanos;
        if (this.lastNano < maxPast) {
            this.lastNano = maxPast;
        }
        long newLast = this.lastNano + nanosNeeded;
        if (units < 0L) {
            this.lastNano = newLast;
            return 0;
        }
        if (this.lastNano <= nowNanos) {
            this.lastNano = newLast;
            return 0;
        }
        int sleepMs = (int)((this.lastNano - nowNanos) / 1000000L);
        if (sleepMs == 0) {
            sleepMs = 1;
        }
        if (alwaysConsume) {
            this.lastNano = newLast;
        } else if (timeoutMs == 0) {
            this.lastNano = newLast;
        } else if (sleepMs < timeoutMs) {
            this.lastNano = newLast;
        }
        return sleepMs;
    }

    @Override
    public boolean tryConsumeUnits(long units) {
        return this.consumeInternal(units, 1, false, System.nanoTime()) == 0;
    }

    @Override
    public double getCurrentRate() {
        double limit;
        double cap = this.getCapacity();
        double rate = 100.0 - cap * 100.0 / (limit = this.getLimitPerSecond());
        if (rate < 0.0) {
            return 0.0;
        }
        return rate;
    }

    @Override
    public void consumeUnitsUnconditionally(long units) {
        this.consumeInternal(units, 0, true, System.nanoTime());
    }

    public double getCapacity() {
        long nowNanos = System.nanoTime();
        long maxPast = nowNanos - this.durationNanos;
        if (this.lastNano > maxPast) {
            maxPast = this.lastNano;
        }
        return (double)(nowNanos - maxPast) / (double)this.nanosPerUnit;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("lastNano=").append(this.lastNano).append(", nanosPerUnit=").append(this.nanosPerUnit).append(", durationNanos=").append(this.durationNanos).append(", limit=").append(this.getLimitPerSecond()).append(", capacity=").append(this.getCapacity()).append(", rate=").append(this.getCurrentRate());
        return sb.toString();
    }

    private void uninterruptibleSleep(int sleepMs) {
        if (sleepMs <= 0) {
            return;
        }
        long endTime = System.currentTimeMillis() + (long)sleepMs;
        boolean done = false;
        while (!done) {
            try {
                TimeUnit.MILLISECONDS.sleep(sleepMs);
                done = true;
            }
            catch (InterruptedException e) {
                sleepMs = (int)(endTime - System.currentTimeMillis());
                if (sleepMs > 0) continue;
                done = true;
            }
        }
    }

    public int consumeExternally(long units) {
        if (this.nanosPerUnit <= 0L) {
            return 0;
        }
        return this.consumeInternal(units, 0, true, System.nanoTime());
    }
}

