/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.util;

import java.lang.management.ManagementFactory;
import java.util.List;

public class SizeOf {
    public static final int OBJECT_REF_OVERHEAD_32 = 4;
    public static final int OBJECT_REF_OVERHEAD_64 = 8;
    public static final int OBJECT_REF_OVERHEAD_OOPS = 4;
    public static final int OBJECT_OVERHEAD_32 = 8;
    public static final int OBJECT_OVERHEAD_64 = 16;
    public static final int OBJECT_OVERHEAD_OOPS = 16;
    public static final int ARRAY_OVERHEAD_32 = 16;
    public static final int ARRAY_OVERHEAD_64 = 24;
    public static final int ARRAY_OVERHEAD_OOPS = 16;
    public static final int ARRAY_SIZE_INCLUDED_32 = 4;
    public static final int ARRAY_SIZE_INCLUDED_64 = 0;
    public static final int ARRAY_SIZE_INCLUDED_OOPS = 0;
    public static final int HASHMAP_OVERHEAD_32 = 120;
    public static final int HASHMAP_OVERHEAD_64 = 219;
    public static final int HASHMAP_OVERHEAD_OOPS = 128;
    public static final int HASHMAP_ENTRY_OVERHEAD_32 = 24;
    public static final int HASHMAP_ENTRY_OVERHEAD_64 = 52;
    public static final int HASHMAP_ENTRY_OVERHEAD_OOPS = 32;
    public static final int HASHSET_OVERHEAD_32 = 136;
    public static final int HASHSET_OVERHEAD_64 = 240;
    public static final int HASHSET_OVERHEAD_OOPS = 144;
    public static final int HASHSET_ENTRY_OVERHEAD_32 = 24;
    public static final int HASHSET_ENTRY_OVERHEAD_64 = 55;
    public static final int HASHSET_ENTRY_OVERHEAD_OOPS = 32;
    public static final int TREEMAP_OVERHEAD_32 = 48;
    public static final int TREEMAP_OVERHEAD_64 = 80;
    public static final int TREEMAP_OVERHEAD_OOPS = 48;
    public static final int TREEMAP_ENTRY_OVERHEAD_32 = 32;
    public static final int TREEMAP_ENTRY_OVERHEAD_64 = 64;
    public static final int TREEMAP_ENTRY_OVERHEAD_OOPS = 40;
    public static final int EMPTY_OBJ_ARRAY;
    public static final int ARRAYLIST_OVERHEAD_32;
    public static final int ARRAYLIST_OVERHEAD_64;
    public static final int ARRAYLIST_OVERHEAD_OOPS;
    public static final int OBJECT_REF_OVERHEAD;
    public static final int OBJECT_OVERHEAD;
    public static final int ARRAY_OVERHEAD;
    public static final int ARRAY_SIZE_INCLUDED;
    public static final int HASHMAP_OVERHEAD;
    public static final int HASHMAP_ENTRY_OVERHEAD;
    public static final int HASHSET_OVERHEAD;
    public static final int HASHSET_ENTRY_OVERHEAD;
    public static final int TREEMAP_OVERHEAD;
    public static final int TREEMAP_ENTRY_OVERHEAD;
    public static final int ARRAYLIST_OVERHEAD;
    public static final int PRIMITIVE_LONG_ARRAY_ITEM_OVERHEAD = 8;
    private static final String JVM_ARCH_PROPERTY = "sun.arch.data.model";
    private static final String FORCE_JVM_ARCH = "je.forceJVMArch";
    private static boolean COMPRESSED_OOPS_REQUESTED;
    private static boolean COMPRESSED_OOPS_KNOWN;
    private static boolean COMPRESSED_OOPS_KNOWN_ON;

    public static int byteArraySize(int arrayLen) {
        int size = ARRAY_OVERHEAD;
        if (arrayLen > ARRAY_SIZE_INCLUDED) {
            size += (arrayLen - ARRAY_SIZE_INCLUDED + 7) / 8 * 8;
        }
        return size;
    }

    public static int shortArraySize(int arrayLen) {
        return SizeOf.byteArraySize(arrayLen * 2);
    }

    public static int intArraySize(int arrayLen) {
        return SizeOf.byteArraySize(arrayLen * 4);
    }

    public static int longArraySize(int arrayLen) {
        return SizeOf.byteArraySize(arrayLen * 8);
    }

    public static int objectArraySize(int arrayLen) {
        return SizeOf.byteArraySize(arrayLen * OBJECT_REF_OVERHEAD);
    }

    public static int stringSize(String str) {
        return OBJECT_OVERHEAD + OBJECT_REF_OVERHEAD + SizeOf.byteArraySize(2 * str.length());
    }

    static {
        boolean useCompressedOops;
        EMPTY_OBJ_ARRAY = SizeOf.objectArraySize(0);
        ARRAYLIST_OVERHEAD_32 = 40 - EMPTY_OBJ_ARRAY;
        ARRAYLIST_OVERHEAD_64 = 64 - EMPTY_OBJ_ARRAY;
        ARRAYLIST_OVERHEAD_OOPS = 40 - EMPTY_OBJ_ARRAY;
        COMPRESSED_OOPS_REQUESTED = false;
        COMPRESSED_OOPS_KNOWN = false;
        COMPRESSED_OOPS_KNOWN_ON = false;
        boolean is64 = false;
        String overrideArch = System.getProperty(FORCE_JVM_ARCH);
        try {
            if (overrideArch == null) {
                String arch = System.getProperty(JVM_ARCH_PROPERTY);
                if (arch != null) {
                    is64 = Integer.parseInt(arch) == 64;
                }
            } else {
                is64 = Integer.parseInt(overrideArch) == 64;
            }
        }
        catch (NumberFormatException NFE) {
            throw new IllegalArgumentException(NFE.getMessage());
        }
        Boolean checkCompressedOops = true;
        if (checkCompressedOops != null) {
            COMPRESSED_OOPS_KNOWN = true;
            COMPRESSED_OOPS_KNOWN_ON = checkCompressedOops;
        }
        List<String> args = ManagementFactory.getRuntimeMXBean().getInputArguments();
        for (String arg : args) {
            if (!"-XX:+UseCompressedOops".equals(arg)) continue;
            COMPRESSED_OOPS_REQUESTED = true;
            break;
        }
        boolean bl = useCompressedOops = COMPRESSED_OOPS_KNOWN ? COMPRESSED_OOPS_KNOWN_ON : COMPRESSED_OOPS_REQUESTED;
        if (useCompressedOops) {
            OBJECT_REF_OVERHEAD = 4;
            OBJECT_OVERHEAD = 16;
            ARRAY_OVERHEAD = 16;
            ARRAY_SIZE_INCLUDED = 0;
            HASHMAP_OVERHEAD = 128;
            HASHMAP_ENTRY_OVERHEAD = 32;
            HASHSET_OVERHEAD = 144;
            HASHSET_ENTRY_OVERHEAD = 32;
            TREEMAP_OVERHEAD = 48;
            TREEMAP_ENTRY_OVERHEAD = 40;
            ARRAYLIST_OVERHEAD = ARRAYLIST_OVERHEAD_OOPS;
        } else if (is64) {
            OBJECT_REF_OVERHEAD = 8;
            OBJECT_OVERHEAD = 16;
            ARRAY_OVERHEAD = 24;
            ARRAY_SIZE_INCLUDED = 0;
            HASHMAP_OVERHEAD = 219;
            HASHMAP_ENTRY_OVERHEAD = 52;
            HASHSET_OVERHEAD = 240;
            HASHSET_ENTRY_OVERHEAD = 55;
            TREEMAP_OVERHEAD = 80;
            TREEMAP_ENTRY_OVERHEAD = 64;
            ARRAYLIST_OVERHEAD = ARRAYLIST_OVERHEAD_64;
        } else {
            OBJECT_REF_OVERHEAD = 4;
            OBJECT_OVERHEAD = 8;
            ARRAY_OVERHEAD = 16;
            ARRAY_SIZE_INCLUDED = 4;
            HASHMAP_OVERHEAD = 120;
            HASHMAP_ENTRY_OVERHEAD = 24;
            HASHSET_OVERHEAD = 136;
            HASHSET_ENTRY_OVERHEAD = 24;
            TREEMAP_OVERHEAD = 48;
            TREEMAP_ENTRY_OVERHEAD = 32;
            ARRAYLIST_OVERHEAD = ARRAYLIST_OVERHEAD_32;
        }
    }
}

