/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.values;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Map;
import oracle.nosql.driver.values.ArrayValue;
import oracle.nosql.driver.values.FieldValue;
import oracle.nosql.driver.values.MapValue;
import oracle.nosql.driver.values.TimestampValue;

public interface FieldValueEventHandler {
    public static final FieldValueEventHandler nullHandler = new FieldValueEventHandler(){};

    default public void startMap(int size) throws IOException {
    }

    default public void startArray(int size) throws IOException {
    }

    default public void endMap(int size) throws IOException {
    }

    default public void endArray(int size) throws IOException {
    }

    default public boolean startMapField(String key) throws IOException {
        return false;
    }

    default public void endMapField(String key) throws IOException {
    }

    default public boolean startArrayField(int index) throws IOException {
        return false;
    }

    default public void endArrayField(int index) throws IOException {
    }

    default public void booleanValue(boolean value) throws IOException {
    }

    default public void binaryValue(byte[] byteArray) throws IOException {
    }

    default public void binaryValue(byte[] byteArray, int offset, int length) throws IOException {
    }

    default public void stringValue(String value) throws IOException {
    }

    default public void integerValue(int value) throws IOException {
    }

    default public void longValue(long value) throws IOException {
    }

    default public void doubleValue(double value) throws IOException {
    }

    default public void numberValue(BigDecimal value) throws IOException {
    }

    default public void timestampValue(TimestampValue timestamp) throws IOException {
    }

    default public void jsonNullValue() throws IOException {
    }

    default public void nullValue() throws IOException {
    }

    default public void emptyValue() throws IOException {
    }

    default public boolean stop() {
        return false;
    }

    public static void generate(FieldValue value, FieldValueEventHandler handler) throws IOException {
        FieldValueEventHandler.generate(value, handler, false);
    }

    public static void generate(FieldValue value, FieldValueEventHandler handler, boolean skip) throws IOException {
        FieldValue.Type type = value.getType();
        switch (type) {
            case ARRAY: {
                FieldValueEventHandler.generateForArray(value.asArray(), handler, skip);
                break;
            }
            case BINARY: {
                if (skip) break;
                handler.binaryValue(value.getBinary());
                break;
            }
            case BOOLEAN: {
                if (skip) break;
                handler.booleanValue(value.getBoolean());
                break;
            }
            case DOUBLE: {
                if (skip) break;
                handler.doubleValue(value.getDouble());
                break;
            }
            case INTEGER: {
                if (skip) break;
                handler.integerValue(value.getInt());
                break;
            }
            case LONG: {
                if (skip) break;
                handler.longValue(value.getLong());
                break;
            }
            case MAP: {
                FieldValueEventHandler.generateForMap(value.asMap(), handler, skip);
                break;
            }
            case STRING: {
                if (skip) break;
                handler.stringValue(value.asString().getString());
                break;
            }
            case TIMESTAMP: {
                if (skip) break;
                handler.timestampValue(value.asTimestamp());
                break;
            }
            case NUMBER: {
                if (skip) break;
                handler.numberValue(value.asNumber().getValue());
                break;
            }
            case JSON_NULL: {
                if (skip) break;
                handler.jsonNullValue();
                break;
            }
            case NULL: {
                if (skip) break;
                handler.nullValue();
                break;
            }
            case EMPTY: {
                if (skip) break;
                handler.emptyValue();
                break;
            }
            default: {
                throw new IllegalStateException("FieldValueEventHandler, unknown type " + (Object)((Object)type));
            }
        }
    }

    public static void generateForMap(MapValue map, FieldValueEventHandler handler, boolean skip) throws IOException {
        if (skip) {
            return;
        }
        handler.startMap(map.size());
        for (Map.Entry<String, FieldValue> entry : map.entrySet()) {
            skip = handler.startMapField(entry.getKey());
            if (handler.stop()) {
                return;
            }
            if (!skip) {
                FieldValueEventHandler.generate(entry.getValue(), handler, skip);
                if (handler.stop()) {
                    return;
                }
            }
            handler.endMapField(entry.getKey());
            if (!handler.stop()) continue;
            return;
        }
        handler.endMap(map.size());
    }

    public static void generateForArray(ArrayValue array, FieldValueEventHandler handler, boolean skip) throws IOException {
        if (skip) {
            return;
        }
        handler.startArray(array.size());
        int index = 0;
        for (FieldValue value : array) {
            skip = handler.startArrayField(index);
            FieldValueEventHandler.generate(value, handler, skip);
            if (handler.stop()) {
                return;
            }
            handler.endArrayField(index++);
            if (!handler.stop()) continue;
            return;
        }
        handler.endArray(array.size());
    }
}

