/*
 * Decompiled with CFR 0.152.
 */
package oracle.nosql.driver.values;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import oracle.nosql.driver.Nson;
import oracle.nosql.driver.util.ByteInputStream;
import oracle.nosql.driver.values.FieldValueEventHandler;
import oracle.nosql.driver.values.TimestampValue;

public class PathFinder
implements FieldValueEventHandler {
    private String[][] paths;
    private HashSet<String> caseInsensitivePaths;
    private int[] currentIndex;
    private int depth;
    private boolean skipping;
    private PathFinderCallback cb;
    private boolean stop;
    private boolean found;
    private final FieldValueEventHandler handler;
    private ByteInputStream bis;
    private static PathFinderCallback seekCallback = (finder, path) -> {
        finder.setFound(true);
        finder.setStop();
        return true;
    };

    public static boolean seek(String pathExpr, ByteInputStream bis) throws IOException {
        PathFinder pf = new PathFinder(null, pathExpr);
        return pf.seek(bis);
    }

    public static boolean seek(ByteInputStream bis, String ... components) throws IOException {
        PathFinder pf = new PathFinder(null, components);
        return pf.seek(bis);
    }

    public PathFinder(FieldValueEventHandler handler, String path) {
        this(handler, path.split("\\."));
    }

    public PathFinder(FieldValueEventHandler handler, String ... components) {
        if (components.length == 0) {
            throw new IllegalArgumentException("PathFinder path requires at least one component");
        }
        this.handler = handler != null ? handler : nullHandler;
        this.paths = new String[1][];
        this.currentIndex = new int[1];
        this.paths[0] = components;
    }

    public PathFinder(FieldValueEventHandler handler, List<String[]> paths) {
        if (paths == null || paths.size() == 0) {
            throw new IllegalArgumentException("PathFinder requires at least one path");
        }
        this.handler = handler != null ? handler : nullHandler;
        int numPaths = paths.size();
        this.paths = new String[numPaths][];
        this.currentIndex = new int[numPaths];
        int i = 0;
        for (String[] s : paths) {
            if (s.length == 0) {
                throw new IllegalArgumentException("PathFinder paths require at least one component");
            }
            this.paths[i] = s;
            ++i;
        }
    }

    public boolean seek(ByteInputStream bis) throws IOException {
        if (this.currentIndex.length > 1) {
            throw new IllegalArgumentException("PathFinder.seek can only look for a single path");
        }
        this.bis = bis;
        this.cb = seekCallback;
        Nson.generateEventsFromNson(this, bis, false);
        return this.found;
    }

    public void find(ByteInputStream bis, PathFinderCallback cb) throws IOException {
        this.bis = bis;
        this.cb = cb;
        Nson.generateEventsFromNson(this, bis, false);
    }

    public void setCaseInsensitive(String fieldName) {
        for (String[] path : this.paths) {
            if (!path[0].equalsIgnoreCase(fieldName) || path.length != 1) continue;
            if (this.caseInsensitivePaths == null) {
                this.caseInsensitivePaths = new HashSet();
            }
            this.caseInsensitivePaths.add(fieldName.toLowerCase());
            return;
        }
        throw new IllegalArgumentException("Cannot find field in PathFinder paths: " + fieldName);
    }

    public void setStop() {
        this.stop = true;
    }

    public void setFound(boolean value) {
        this.found = value;
    }

    public ByteInputStream getStream() {
        return this.bis;
    }

    @Override
    public void startMap(int size) throws IOException {
        ++this.depth;
        this.handler.startMap(size);
    }

    @Override
    public void startArray(int size) throws IOException {
        this.handler.startArray(size);
    }

    @Override
    public void endMap(int size) throws IOException {
        --this.depth;
        this.handler.endMap(size);
    }

    @Override
    public void endArray(int size) throws IOException {
        this.handler.endArray(size);
    }

    @Override
    public boolean startMapField(String key) throws IOException {
        for (int i = 0; i < this.currentIndex.length; ++i) {
            boolean equals;
            int thisIndex = this.currentIndex[i];
            String[] thisPath = this.paths[i];
            if (thisIndex + 1 != this.depth) continue;
            String curField = thisPath[thisIndex];
            boolean bl = equals = this.isCaseInsensitive(curField) ? key.equalsIgnoreCase(curField) : key.equals(curField);
            if (!equals) continue;
            if (++thisIndex == thisPath.length && thisIndex == this.depth) {
                if (this.cb == null) continue;
                int savedOffset = this.bis.getOffset();
                this.skipping = this.cb.found(this, this.paths[i]);
                this.bis.setOffset(savedOffset);
                if (!this.skipping) continue;
                return true;
            }
            int n = i;
            this.currentIndex[n] = this.currentIndex[n] + 1;
        }
        this.handler.startMapField(key);
        return false;
    }

    private boolean isCaseInsensitive(String fieldName) {
        return this.caseInsensitivePaths != null && this.caseInsensitivePaths.contains(fieldName.toLowerCase());
    }

    @Override
    public void endMapField(String key) throws IOException {
        if (this.skipping) {
            this.skipping = false;
            return;
        }
        this.handler.endMapField(key);
    }

    @Override
    public void endArrayField(int index) throws IOException {
        this.handler.endArrayField(index);
    }

    @Override
    public void booleanValue(boolean value) throws IOException {
        this.handler.booleanValue(value);
    }

    @Override
    public void binaryValue(byte[] byteArray) throws IOException {
        this.handler.binaryValue(byteArray);
    }

    @Override
    public void binaryValue(byte[] byteArray, int offset, int length) throws IOException {
        this.handler.binaryValue(byteArray, offset, length);
    }

    @Override
    public void stringValue(String value) throws IOException {
        this.handler.stringValue(value);
    }

    @Override
    public void integerValue(int value) throws IOException {
        this.handler.integerValue(value);
    }

    @Override
    public void longValue(long value) throws IOException {
        this.handler.longValue(value);
    }

    @Override
    public void doubleValue(double value) throws IOException {
        this.handler.doubleValue(value);
    }

    @Override
    public void numberValue(BigDecimal value) throws IOException {
        this.handler.numberValue(value);
    }

    @Override
    public void timestampValue(TimestampValue timestamp) throws IOException {
        this.handler.timestampValue(timestamp);
    }

    @Override
    public void jsonNullValue() throws IOException {
        this.handler.jsonNullValue();
    }

    @Override
    public void nullValue() throws IOException {
        this.handler.nullValue();
    }

    @Override
    public void emptyValue() throws IOException {
        this.handler.emptyValue();
    }

    @Override
    public boolean stop() {
        return this.stop;
    }

    @FunctionalInterface
    public static interface PathFinderCallback {
        public boolean found(PathFinder var1, String[] var2) throws IOException;
    }
}

