/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.accessgovernancecp;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.accessgovernancecp.AccessGovernanceCPAsync;
import com.oracle.bmc.accessgovernancecp.model.GovernanceInstance;
import com.oracle.bmc.accessgovernancecp.model.GovernanceInstanceCollection;
import com.oracle.bmc.accessgovernancecp.model.GovernanceInstanceConfiguration;
import com.oracle.bmc.accessgovernancecp.requests.ChangeGovernanceInstanceCompartmentRequest;
import com.oracle.bmc.accessgovernancecp.requests.CreateGovernanceInstanceRequest;
import com.oracle.bmc.accessgovernancecp.requests.DeleteGovernanceInstanceRequest;
import com.oracle.bmc.accessgovernancecp.requests.GetGovernanceInstanceConfigurationRequest;
import com.oracle.bmc.accessgovernancecp.requests.GetGovernanceInstanceRequest;
import com.oracle.bmc.accessgovernancecp.requests.ListGovernanceInstancesRequest;
import com.oracle.bmc.accessgovernancecp.requests.UpdateGovernanceInstanceConfigurationRequest;
import com.oracle.bmc.accessgovernancecp.requests.UpdateGovernanceInstanceRequest;
import com.oracle.bmc.accessgovernancecp.responses.ChangeGovernanceInstanceCompartmentResponse;
import com.oracle.bmc.accessgovernancecp.responses.CreateGovernanceInstanceResponse;
import com.oracle.bmc.accessgovernancecp.responses.DeleteGovernanceInstanceResponse;
import com.oracle.bmc.accessgovernancecp.responses.GetGovernanceInstanceConfigurationResponse;
import com.oracle.bmc.accessgovernancecp.responses.GetGovernanceInstanceResponse;
import com.oracle.bmc.accessgovernancecp.responses.ListGovernanceInstancesResponse;
import com.oracle.bmc.accessgovernancecp.responses.UpdateGovernanceInstanceConfigurationResponse;
import com.oracle.bmc.accessgovernancecp.responses.UpdateGovernanceInstanceResponse;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessGovernanceCPAsyncClient
extends BaseAsyncClient
implements AccessGovernanceCPAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("ACCESSGOVERNANCECP").serviceEndpointPrefix("").serviceEndpointTemplate("https://cp-prod.access-governance.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(AccessGovernanceCPAsyncClient.class);

    AccessGovernanceCPAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<ChangeGovernanceInstanceCompartmentResponse> changeGovernanceInstanceCompartment(ChangeGovernanceInstanceCompartmentRequest request, AsyncHandler<ChangeGovernanceInstanceCompartmentRequest, ChangeGovernanceInstanceCompartmentResponse> handler) {
        Validate.notBlank((String)request.getGovernanceInstanceId(), (String)"governanceInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeGovernanceInstanceCompartmentDetails(), "changeGovernanceInstanceCompartmentDetails is required");
        return this.clientCall(request, ChangeGovernanceInstanceCompartmentResponse::builder).logger(LOG, "changeGovernanceInstanceCompartment").serviceDetails("AccessGovernanceCP", "ChangeGovernanceInstanceCompartment", "https://docs.oracle.com/iaas/api/#/en/access-governance-cp/20220518/GovernanceInstance/ChangeGovernanceInstanceCompartment").method(Method.POST).requestBuilder(ChangeGovernanceInstanceCompartmentRequest::builder).basePath("/20220518").appendPathParam("governanceInstances").appendPathParam(request.getGovernanceInstanceId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeGovernanceInstanceCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateGovernanceInstanceResponse> createGovernanceInstance(CreateGovernanceInstanceRequest request, AsyncHandler<CreateGovernanceInstanceRequest, CreateGovernanceInstanceResponse> handler) {
        Objects.requireNonNull(request.getCreateGovernanceInstanceDetails(), "createGovernanceInstanceDetails is required");
        return this.clientCall(request, CreateGovernanceInstanceResponse::builder).logger(LOG, "createGovernanceInstance").serviceDetails("AccessGovernanceCP", "CreateGovernanceInstance", "https://docs.oracle.com/iaas/api/#/en/access-governance-cp/20220518/GovernanceInstance/CreateGovernanceInstance").method(Method.POST).requestBuilder(CreateGovernanceInstanceRequest::builder).basePath("/20220518").appendPathParam("governanceInstances").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(GovernanceInstance.class, CreateGovernanceInstanceResponse.Builder::governanceInstance).handleResponseHeaderString("etag", CreateGovernanceInstanceResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateGovernanceInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateGovernanceInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteGovernanceInstanceResponse> deleteGovernanceInstance(DeleteGovernanceInstanceRequest request, AsyncHandler<DeleteGovernanceInstanceRequest, DeleteGovernanceInstanceResponse> handler) {
        Validate.notBlank((String)request.getGovernanceInstanceId(), (String)"governanceInstanceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteGovernanceInstanceResponse::builder).logger(LOG, "deleteGovernanceInstance").serviceDetails("AccessGovernanceCP", "DeleteGovernanceInstance", "https://docs.oracle.com/iaas/api/#/en/access-governance-cp/20220518/GovernanceInstance/DeleteGovernanceInstance").method(Method.DELETE).requestBuilder(DeleteGovernanceInstanceRequest::builder).basePath("/20220518").appendPathParam("governanceInstances").appendPathParam(request.getGovernanceInstanceId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteGovernanceInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteGovernanceInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetGovernanceInstanceResponse> getGovernanceInstance(GetGovernanceInstanceRequest request, AsyncHandler<GetGovernanceInstanceRequest, GetGovernanceInstanceResponse> handler) {
        Validate.notBlank((String)request.getGovernanceInstanceId(), (String)"governanceInstanceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetGovernanceInstanceResponse::builder).logger(LOG, "getGovernanceInstance").serviceDetails("AccessGovernanceCP", "GetGovernanceInstance", "https://docs.oracle.com/iaas/api/#/en/access-governance-cp/20220518/GovernanceInstance/GetGovernanceInstance").method(Method.GET).requestBuilder(GetGovernanceInstanceRequest::builder).basePath("/20220518").appendPathParam("governanceInstances").appendPathParam(request.getGovernanceInstanceId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(GovernanceInstance.class, GetGovernanceInstanceResponse.Builder::governanceInstance).handleResponseHeaderString("etag", GetGovernanceInstanceResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetGovernanceInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetGovernanceInstanceConfigurationResponse> getGovernanceInstanceConfiguration(GetGovernanceInstanceConfigurationRequest request, AsyncHandler<GetGovernanceInstanceConfigurationRequest, GetGovernanceInstanceConfigurationResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, GetGovernanceInstanceConfigurationResponse::builder).logger(LOG, "getGovernanceInstanceConfiguration").serviceDetails("AccessGovernanceCP", "GetGovernanceInstanceConfiguration", "https://docs.oracle.com/iaas/api/#/en/access-governance-cp/20220518/GovernanceInstanceConfiguration/GetGovernanceInstanceConfiguration").method(Method.GET).requestBuilder(GetGovernanceInstanceConfigurationRequest::builder).basePath("/20220518").appendPathParam("governanceInstances").appendPathParam("configuration").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(GovernanceInstanceConfiguration.class, GetGovernanceInstanceConfigurationResponse.Builder::governanceInstanceConfiguration).handleResponseHeaderString("etag", GetGovernanceInstanceConfigurationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetGovernanceInstanceConfigurationResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListGovernanceInstancesResponse> listGovernanceInstances(ListGovernanceInstancesRequest request, AsyncHandler<ListGovernanceInstancesRequest, ListGovernanceInstancesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListGovernanceInstancesResponse::builder).logger(LOG, "listGovernanceInstances").serviceDetails("AccessGovernanceCP", "ListGovernanceInstances", "https://docs.oracle.com/iaas/api/#/en/access-governance-cp/20220518/GovernanceInstanceCollection/ListGovernanceInstances").method(Method.GET).requestBuilder(ListGovernanceInstancesRequest::builder).basePath("/20220518").appendPathParam("governanceInstances").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("lifecycleState", (Object)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(GovernanceInstanceCollection.class, ListGovernanceInstancesResponse.Builder::governanceInstanceCollection).handleResponseHeaderString("opc-request-id", ListGovernanceInstancesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListGovernanceInstancesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<UpdateGovernanceInstanceResponse> updateGovernanceInstance(UpdateGovernanceInstanceRequest request, AsyncHandler<UpdateGovernanceInstanceRequest, UpdateGovernanceInstanceResponse> handler) {
        Objects.requireNonNull(request.getUpdateGovernanceInstanceDetails(), "updateGovernanceInstanceDetails is required");
        Validate.notBlank((String)request.getGovernanceInstanceId(), (String)"governanceInstanceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, UpdateGovernanceInstanceResponse::builder).logger(LOG, "updateGovernanceInstance").serviceDetails("AccessGovernanceCP", "UpdateGovernanceInstance", "https://docs.oracle.com/iaas/api/#/en/access-governance-cp/20220518/GovernanceInstance/UpdateGovernanceInstance").method(Method.PUT).requestBuilder(UpdateGovernanceInstanceRequest::builder).basePath("/20220518").appendPathParam("governanceInstances").appendPathParam(request.getGovernanceInstanceId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(GovernanceInstance.class, UpdateGovernanceInstanceResponse.Builder::governanceInstance).handleResponseHeaderString("etag", UpdateGovernanceInstanceResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", UpdateGovernanceInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateGovernanceInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateGovernanceInstanceConfigurationResponse> updateGovernanceInstanceConfiguration(UpdateGovernanceInstanceConfigurationRequest request, AsyncHandler<UpdateGovernanceInstanceConfigurationRequest, UpdateGovernanceInstanceConfigurationResponse> handler) {
        Objects.requireNonNull(request.getUpdateGovernanceInstanceConfigurationDetails(), "updateGovernanceInstanceConfigurationDetails is required");
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, UpdateGovernanceInstanceConfigurationResponse::builder).logger(LOG, "updateGovernanceInstanceConfiguration").serviceDetails("AccessGovernanceCP", "UpdateGovernanceInstanceConfiguration", "https://docs.oracle.com/iaas/api/#/en/access-governance-cp/20220518/GovernanceInstance/UpdateGovernanceInstanceConfiguration").method(Method.PUT).requestBuilder(UpdateGovernanceInstanceConfigurationRequest::builder).basePath("/20220518").appendPathParam("governanceInstances").appendPathParam("configuration").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(GovernanceInstanceConfiguration.class, UpdateGovernanceInstanceConfigurationResponse.Builder::governanceInstanceConfiguration).handleResponseHeaderString("etag", UpdateGovernanceInstanceConfigurationResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", UpdateGovernanceInstanceConfigurationResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateGovernanceInstanceConfigurationResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public AccessGovernanceCPAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)AccessGovernanceCPAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public AccessGovernanceCPAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(AccessGovernanceCPAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public AccessGovernanceCPAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)AccessGovernanceCPAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public AccessGovernanceCPAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)AccessGovernanceCPAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public AccessGovernanceCPAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)AccessGovernanceCPAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public AccessGovernanceCPAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)AccessGovernanceCPAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public AccessGovernanceCPAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)AccessGovernanceCPAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, AccessGovernanceCPAsyncClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "accessgovernancecp";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"accessgovernancecp");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public AccessGovernanceCPAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new AccessGovernanceCPAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

