/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.accessgovernancecp;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.accessgovernancecp.AccessGovernanceCP;
import com.oracle.bmc.accessgovernancecp.AccessGovernanceCPPaginators;
import com.oracle.bmc.accessgovernancecp.AccessGovernanceCPWaiters;
import com.oracle.bmc.accessgovernancecp.model.GovernanceInstance;
import com.oracle.bmc.accessgovernancecp.model.GovernanceInstanceCollection;
import com.oracle.bmc.accessgovernancecp.model.GovernanceInstanceConfiguration;
import com.oracle.bmc.accessgovernancecp.requests.ChangeGovernanceInstanceCompartmentRequest;
import com.oracle.bmc.accessgovernancecp.requests.CreateGovernanceInstanceRequest;
import com.oracle.bmc.accessgovernancecp.requests.DeleteGovernanceInstanceRequest;
import com.oracle.bmc.accessgovernancecp.requests.GetGovernanceInstanceConfigurationRequest;
import com.oracle.bmc.accessgovernancecp.requests.GetGovernanceInstanceRequest;
import com.oracle.bmc.accessgovernancecp.requests.ListGovernanceInstancesRequest;
import com.oracle.bmc.accessgovernancecp.requests.UpdateGovernanceInstanceConfigurationRequest;
import com.oracle.bmc.accessgovernancecp.requests.UpdateGovernanceInstanceRequest;
import com.oracle.bmc.accessgovernancecp.responses.ChangeGovernanceInstanceCompartmentResponse;
import com.oracle.bmc.accessgovernancecp.responses.CreateGovernanceInstanceResponse;
import com.oracle.bmc.accessgovernancecp.responses.DeleteGovernanceInstanceResponse;
import com.oracle.bmc.accessgovernancecp.responses.GetGovernanceInstanceConfigurationResponse;
import com.oracle.bmc.accessgovernancecp.responses.GetGovernanceInstanceResponse;
import com.oracle.bmc.accessgovernancecp.responses.ListGovernanceInstancesResponse;
import com.oracle.bmc.accessgovernancecp.responses.UpdateGovernanceInstanceConfigurationResponse;
import com.oracle.bmc.accessgovernancecp.responses.UpdateGovernanceInstanceResponse;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessGovernanceCPClient
extends BaseSyncClient
implements AccessGovernanceCP {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("ACCESSGOVERNANCECP").serviceEndpointPrefix("").serviceEndpointTemplate("https://cp-prod.access-governance.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(AccessGovernanceCPClient.class);
    private final AccessGovernanceCPWaiters waiters;
    private final AccessGovernanceCPPaginators paginators;

    AccessGovernanceCPClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("AccessGovernanceCP-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new AccessGovernanceCPWaiters(executorService, this);
        this.paginators = new AccessGovernanceCPPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public ChangeGovernanceInstanceCompartmentResponse changeGovernanceInstanceCompartment(ChangeGovernanceInstanceCompartmentRequest request) {
        Validate.notBlank((String)request.getGovernanceInstanceId(), (String)"governanceInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeGovernanceInstanceCompartmentDetails(), "changeGovernanceInstanceCompartmentDetails is required");
        return (ChangeGovernanceInstanceCompartmentResponse)this.clientCall(request, ChangeGovernanceInstanceCompartmentResponse::builder).logger(LOG, "changeGovernanceInstanceCompartment").serviceDetails("AccessGovernanceCP", "ChangeGovernanceInstanceCompartment", "https://docs.oracle.com/iaas/api/#/en/access-governance-cp/20220518/GovernanceInstance/ChangeGovernanceInstanceCompartment").method(Method.POST).requestBuilder(ChangeGovernanceInstanceCompartmentRequest::builder).basePath("/20220518").appendPathParam("governanceInstances").appendPathParam(request.getGovernanceInstanceId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-request-id", ChangeGovernanceInstanceCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateGovernanceInstanceResponse createGovernanceInstance(CreateGovernanceInstanceRequest request) {
        Objects.requireNonNull(request.getCreateGovernanceInstanceDetails(), "createGovernanceInstanceDetails is required");
        return (CreateGovernanceInstanceResponse)this.clientCall(request, CreateGovernanceInstanceResponse::builder).logger(LOG, "createGovernanceInstance").serviceDetails("AccessGovernanceCP", "CreateGovernanceInstance", "https://docs.oracle.com/iaas/api/#/en/access-governance-cp/20220518/GovernanceInstance/CreateGovernanceInstance").method(Method.POST).requestBuilder(CreateGovernanceInstanceRequest::builder).basePath("/20220518").appendPathParam("governanceInstances").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(GovernanceInstance.class, CreateGovernanceInstanceResponse.Builder::governanceInstance).handleResponseHeaderString("etag", CreateGovernanceInstanceResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateGovernanceInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateGovernanceInstanceResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteGovernanceInstanceResponse deleteGovernanceInstance(DeleteGovernanceInstanceRequest request) {
        Validate.notBlank((String)request.getGovernanceInstanceId(), (String)"governanceInstanceId must not be blank", (Object[])new Object[0]);
        return (DeleteGovernanceInstanceResponse)this.clientCall(request, DeleteGovernanceInstanceResponse::builder).logger(LOG, "deleteGovernanceInstance").serviceDetails("AccessGovernanceCP", "DeleteGovernanceInstance", "https://docs.oracle.com/iaas/api/#/en/access-governance-cp/20220518/GovernanceInstance/DeleteGovernanceInstance").method(Method.DELETE).requestBuilder(DeleteGovernanceInstanceRequest::builder).basePath("/20220518").appendPathParam("governanceInstances").appendPathParam(request.getGovernanceInstanceId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-work-request-id", DeleteGovernanceInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteGovernanceInstanceResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetGovernanceInstanceResponse getGovernanceInstance(GetGovernanceInstanceRequest request) {
        Validate.notBlank((String)request.getGovernanceInstanceId(), (String)"governanceInstanceId must not be blank", (Object[])new Object[0]);
        return (GetGovernanceInstanceResponse)this.clientCall(request, GetGovernanceInstanceResponse::builder).logger(LOG, "getGovernanceInstance").serviceDetails("AccessGovernanceCP", "GetGovernanceInstance", "https://docs.oracle.com/iaas/api/#/en/access-governance-cp/20220518/GovernanceInstance/GetGovernanceInstance").method(Method.GET).requestBuilder(GetGovernanceInstanceRequest::builder).basePath("/20220518").appendPathParam("governanceInstances").appendPathParam(request.getGovernanceInstanceId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(GovernanceInstance.class, GetGovernanceInstanceResponse.Builder::governanceInstance).handleResponseHeaderString("etag", GetGovernanceInstanceResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetGovernanceInstanceResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetGovernanceInstanceConfigurationResponse getGovernanceInstanceConfiguration(GetGovernanceInstanceConfigurationRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (GetGovernanceInstanceConfigurationResponse)this.clientCall(request, GetGovernanceInstanceConfigurationResponse::builder).logger(LOG, "getGovernanceInstanceConfiguration").serviceDetails("AccessGovernanceCP", "GetGovernanceInstanceConfiguration", "https://docs.oracle.com/iaas/api/#/en/access-governance-cp/20220518/GovernanceInstanceConfiguration/GetGovernanceInstanceConfiguration").method(Method.GET).requestBuilder(GetGovernanceInstanceConfigurationRequest::builder).basePath("/20220518").appendPathParam("governanceInstances").appendPathParam("configuration").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(GovernanceInstanceConfiguration.class, GetGovernanceInstanceConfigurationResponse.Builder::governanceInstanceConfiguration).handleResponseHeaderString("etag", GetGovernanceInstanceConfigurationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetGovernanceInstanceConfigurationResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListGovernanceInstancesResponse listGovernanceInstances(ListGovernanceInstancesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListGovernanceInstancesResponse)this.clientCall(request, ListGovernanceInstancesResponse::builder).logger(LOG, "listGovernanceInstances").serviceDetails("AccessGovernanceCP", "ListGovernanceInstances", "https://docs.oracle.com/iaas/api/#/en/access-governance-cp/20220518/GovernanceInstanceCollection/ListGovernanceInstances").method(Method.GET).requestBuilder(ListGovernanceInstancesRequest::builder).basePath("/20220518").appendPathParam("governanceInstances").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("lifecycleState", (Object)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(GovernanceInstanceCollection.class, ListGovernanceInstancesResponse.Builder::governanceInstanceCollection).handleResponseHeaderString("opc-request-id", ListGovernanceInstancesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListGovernanceInstancesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public UpdateGovernanceInstanceResponse updateGovernanceInstance(UpdateGovernanceInstanceRequest request) {
        Objects.requireNonNull(request.getUpdateGovernanceInstanceDetails(), "updateGovernanceInstanceDetails is required");
        Validate.notBlank((String)request.getGovernanceInstanceId(), (String)"governanceInstanceId must not be blank", (Object[])new Object[0]);
        return (UpdateGovernanceInstanceResponse)this.clientCall(request, UpdateGovernanceInstanceResponse::builder).logger(LOG, "updateGovernanceInstance").serviceDetails("AccessGovernanceCP", "UpdateGovernanceInstance", "https://docs.oracle.com/iaas/api/#/en/access-governance-cp/20220518/GovernanceInstance/UpdateGovernanceInstance").method(Method.PUT).requestBuilder(UpdateGovernanceInstanceRequest::builder).basePath("/20220518").appendPathParam("governanceInstances").appendPathParam(request.getGovernanceInstanceId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(GovernanceInstance.class, UpdateGovernanceInstanceResponse.Builder::governanceInstance).handleResponseHeaderString("etag", UpdateGovernanceInstanceResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", UpdateGovernanceInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateGovernanceInstanceResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateGovernanceInstanceConfigurationResponse updateGovernanceInstanceConfiguration(UpdateGovernanceInstanceConfigurationRequest request) {
        Objects.requireNonNull(request.getUpdateGovernanceInstanceConfigurationDetails(), "updateGovernanceInstanceConfigurationDetails is required");
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (UpdateGovernanceInstanceConfigurationResponse)this.clientCall(request, UpdateGovernanceInstanceConfigurationResponse::builder).logger(LOG, "updateGovernanceInstanceConfiguration").serviceDetails("AccessGovernanceCP", "UpdateGovernanceInstanceConfiguration", "https://docs.oracle.com/iaas/api/#/en/access-governance-cp/20220518/GovernanceInstance/UpdateGovernanceInstanceConfiguration").method(Method.PUT).requestBuilder(UpdateGovernanceInstanceConfigurationRequest::builder).basePath("/20220518").appendPathParam("governanceInstances").appendPathParam("configuration").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(GovernanceInstanceConfiguration.class, UpdateGovernanceInstanceConfigurationResponse.Builder::governanceInstanceConfiguration).handleResponseHeaderString("etag", UpdateGovernanceInstanceConfigurationResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", UpdateGovernanceInstanceConfigurationResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateGovernanceInstanceConfigurationResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public AccessGovernanceCPWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public AccessGovernanceCPPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public AccessGovernanceCPClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)AccessGovernanceCPClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public AccessGovernanceCPClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(AccessGovernanceCPClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public AccessGovernanceCPClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)AccessGovernanceCPClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public AccessGovernanceCPClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)AccessGovernanceCPClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public AccessGovernanceCPClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)AccessGovernanceCPClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public AccessGovernanceCPClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)AccessGovernanceCPClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public AccessGovernanceCPClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)AccessGovernanceCPClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public AccessGovernanceCPClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)AccessGovernanceCPClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, AccessGovernanceCPClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            String packageName = "accessgovernancecp";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"accessgovernancecp");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public AccessGovernanceCPClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new AccessGovernanceCPClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

