/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.accessgovernancecp;

import com.oracle.bmc.accessgovernancecp.AccessGovernanceCP;
import com.oracle.bmc.accessgovernancecp.model.GovernanceInstanceSummary;
import com.oracle.bmc.accessgovernancecp.requests.ListGovernanceInstancesRequest;
import com.oracle.bmc.accessgovernancecp.responses.ListGovernanceInstancesResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class AccessGovernanceCPPaginators {
    private final AccessGovernanceCP client;

    public AccessGovernanceCPPaginators(AccessGovernanceCP client) {
        this.client = client;
    }

    public Iterable<ListGovernanceInstancesResponse> listGovernanceInstancesResponseIterator(final ListGovernanceInstancesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListGovernanceInstancesRequest.Builder>(){

            @Override
            public ListGovernanceInstancesRequest.Builder get() {
                return ListGovernanceInstancesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListGovernanceInstancesResponse, String>(){

            @Override
            public String apply(ListGovernanceInstancesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListGovernanceInstancesRequest.Builder>, ListGovernanceInstancesRequest>(){

            @Override
            public ListGovernanceInstancesRequest apply(RequestBuilderAndToken<ListGovernanceInstancesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListGovernanceInstancesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListGovernanceInstancesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListGovernanceInstancesRequest, ListGovernanceInstancesResponse>(){

            @Override
            public ListGovernanceInstancesResponse apply(ListGovernanceInstancesRequest request) {
                return AccessGovernanceCPPaginators.this.client.listGovernanceInstances(request);
            }
        });
    }

    public Iterable<GovernanceInstanceSummary> listGovernanceInstancesRecordIterator(final ListGovernanceInstancesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListGovernanceInstancesRequest.Builder>(){

            @Override
            public ListGovernanceInstancesRequest.Builder get() {
                return ListGovernanceInstancesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListGovernanceInstancesResponse, String>(){

            @Override
            public String apply(ListGovernanceInstancesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListGovernanceInstancesRequest.Builder>, ListGovernanceInstancesRequest>(){

            @Override
            public ListGovernanceInstancesRequest apply(RequestBuilderAndToken<ListGovernanceInstancesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListGovernanceInstancesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListGovernanceInstancesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListGovernanceInstancesRequest, ListGovernanceInstancesResponse>(){

            @Override
            public ListGovernanceInstancesResponse apply(ListGovernanceInstancesRequest request) {
                return AccessGovernanceCPPaginators.this.client.listGovernanceInstances(request);
            }
        }, (Function)new Function<ListGovernanceInstancesResponse, List<GovernanceInstanceSummary>>(){

            @Override
            public List<GovernanceInstanceSummary> apply(ListGovernanceInstancesResponse response) {
                return response.getGovernanceInstanceCollection().getItems();
            }
        });
    }
}

