/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.accessgovernancecp;

import com.oracle.bmc.accessgovernancecp.AccessGovernanceCP;
import com.oracle.bmc.accessgovernancecp.model.InstanceLifecycleState;
import com.oracle.bmc.accessgovernancecp.requests.GetGovernanceInstanceRequest;
import com.oracle.bmc.accessgovernancecp.responses.GetGovernanceInstanceResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class AccessGovernanceCPWaiters {
    private final ExecutorService executorService;
    private final AccessGovernanceCP client;

    public AccessGovernanceCPWaiters(ExecutorService executorService, AccessGovernanceCP client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetGovernanceInstanceRequest, GetGovernanceInstanceResponse> forGovernanceInstance(GetGovernanceInstanceRequest request, InstanceLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forGovernanceInstance(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetGovernanceInstanceRequest, GetGovernanceInstanceResponse> forGovernanceInstance(GetGovernanceInstanceRequest request, InstanceLifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forGovernanceInstance(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetGovernanceInstanceRequest, GetGovernanceInstanceResponse> forGovernanceInstance(GetGovernanceInstanceRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, InstanceLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forGovernanceInstance(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetGovernanceInstanceRequest, GetGovernanceInstanceResponse> forGovernanceInstance(BmcGenericWaiter waiter, GetGovernanceInstanceRequest request, InstanceLifecycleState ... targetStates) {
        final HashSet<InstanceLifecycleState> targetStatesSet = new HashSet<InstanceLifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetGovernanceInstanceRequest, GetGovernanceInstanceResponse>(){

            @Override
            public GetGovernanceInstanceResponse apply(GetGovernanceInstanceRequest request) {
                return AccessGovernanceCPWaiters.this.client.getGovernanceInstance(request);
            }
        }, (Predicate)new Predicate<GetGovernanceInstanceResponse>(){

            @Override
            public boolean test(GetGovernanceInstanceResponse response) {
                return targetStatesSet.contains((Object)response.getGovernanceInstance().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)InstanceLifecycleState.Deleted)), (Object)request);
    }
}

