/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.accessgovernancecp.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SenderConfig
extends ExplicitlySetBmcModel {
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="email")
    private final String email;
    @JsonProperty(value="isVerified")
    private final Boolean isVerified;
    @JsonProperty(value="timeVerifyResponseExpiry")
    private final Date timeVerifyResponseExpiry;
    @JsonProperty(value="isInboxConfigured")
    private final Boolean isInboxConfigured;

    @Deprecated
    @ConstructorProperties(value={"displayName", "email", "isVerified", "timeVerifyResponseExpiry", "isInboxConfigured"})
    public SenderConfig(String displayName, String email, Boolean isVerified, Date timeVerifyResponseExpiry, Boolean isInboxConfigured) {
        this.displayName = displayName;
        this.email = email;
        this.isVerified = isVerified;
        this.timeVerifyResponseExpiry = timeVerifyResponseExpiry;
        this.isInboxConfigured = isInboxConfigured;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getEmail() {
        return this.email;
    }

    public Boolean getIsVerified() {
        return this.isVerified;
    }

    public Date getTimeVerifyResponseExpiry() {
        return this.timeVerifyResponseExpiry;
    }

    public Boolean getIsInboxConfigured() {
        return this.isInboxConfigured;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SenderConfig(");
        sb.append("super=").append(super.toString());
        sb.append("displayName=").append(String.valueOf(this.displayName));
        sb.append(", email=").append(String.valueOf(this.email));
        sb.append(", isVerified=").append(String.valueOf(this.isVerified));
        sb.append(", timeVerifyResponseExpiry=").append(String.valueOf(this.timeVerifyResponseExpiry));
        sb.append(", isInboxConfigured=").append(String.valueOf(this.isInboxConfigured));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SenderConfig)) {
            return false;
        }
        SenderConfig other = (SenderConfig)((Object)o);
        return Objects.equals(this.displayName, other.displayName) && Objects.equals(this.email, other.email) && Objects.equals(this.isVerified, other.isVerified) && Objects.equals(this.timeVerifyResponseExpiry, other.timeVerifyResponseExpiry) && Objects.equals(this.isInboxConfigured, other.isInboxConfigured) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.email == null ? 43 : this.email.hashCode());
        result = result * 59 + (this.isVerified == null ? 43 : this.isVerified.hashCode());
        result = result * 59 + (this.timeVerifyResponseExpiry == null ? 43 : this.timeVerifyResponseExpiry.hashCode());
        result = result * 59 + (this.isInboxConfigured == null ? 43 : this.isInboxConfigured.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="email")
        private String email;
        @JsonProperty(value="isVerified")
        private Boolean isVerified;
        @JsonProperty(value="timeVerifyResponseExpiry")
        private Date timeVerifyResponseExpiry;
        @JsonProperty(value="isInboxConfigured")
        private Boolean isInboxConfigured;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder email(String email) {
            this.email = email;
            this.__explicitlySet__.add("email");
            return this;
        }

        public Builder isVerified(Boolean isVerified) {
            this.isVerified = isVerified;
            this.__explicitlySet__.add("isVerified");
            return this;
        }

        public Builder timeVerifyResponseExpiry(Date timeVerifyResponseExpiry) {
            this.timeVerifyResponseExpiry = timeVerifyResponseExpiry;
            this.__explicitlySet__.add("timeVerifyResponseExpiry");
            return this;
        }

        public Builder isInboxConfigured(Boolean isInboxConfigured) {
            this.isInboxConfigured = isInboxConfigured;
            this.__explicitlySet__.add("isInboxConfigured");
            return this;
        }

        public SenderConfig build() {
            SenderConfig model = new SenderConfig(this.displayName, this.email, this.isVerified, this.timeVerifyResponseExpiry, this.isInboxConfigured);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SenderConfig model) {
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("email")) {
                this.email(model.getEmail());
            }
            if (model.wasPropertyExplicitlySet("isVerified")) {
                this.isVerified(model.getIsVerified());
            }
            if (model.wasPropertyExplicitlySet("timeVerifyResponseExpiry")) {
                this.timeVerifyResponseExpiry(model.getTimeVerifyResponseExpiry());
            }
            if (model.wasPropertyExplicitlySet("isInboxConfigured")) {
                this.isInboxConfigured(model.getIsInboxConfigured());
            }
            return this;
        }
    }
}

