/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.accessgovernancecp.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetGovernanceInstanceRequest
extends BmcRequest<Void> {
    private String governanceInstanceId;
    private String opcRequestId;

    public String getGovernanceInstanceId() {
        return this.governanceInstanceId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().governanceInstanceId(this.governanceInstanceId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",governanceInstanceId=").append(String.valueOf(this.governanceInstanceId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetGovernanceInstanceRequest)) {
            return false;
        }
        GetGovernanceInstanceRequest other = (GetGovernanceInstanceRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.governanceInstanceId, other.governanceInstanceId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.governanceInstanceId == null ? 43 : this.governanceInstanceId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetGovernanceInstanceRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String governanceInstanceId = null;
        private String opcRequestId = null;

        public Builder governanceInstanceId(String governanceInstanceId) {
            this.governanceInstanceId = governanceInstanceId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetGovernanceInstanceRequest o) {
            this.governanceInstanceId(o.getGovernanceInstanceId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetGovernanceInstanceRequest build() {
            GetGovernanceInstanceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetGovernanceInstanceRequest buildWithoutInvocationCallback() {
            GetGovernanceInstanceRequest request = new GetGovernanceInstanceRequest();
            request.governanceInstanceId = this.governanceInstanceId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

